/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.volume.copy;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.volume.SnapshotVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeOperationHandler;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.volume.copy.CopyOperManager;
import com.sanrad.nms.client.data.volume.copy.CopyOperationNode;
import com.sanrad.nms.client.data.volume.copy.OfflineCopyTableModelCollection;
import com.sanrad.nms.client.event.volume.copy.SrCopyOperationTableModel;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.MainFrame;
import com.sanrad.nms.client.gui.SrTransientWindowPane;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.swing.actions.OperationController;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;

public class OfflineCopyOperationHandler
extends VolumeOperationHandler {
    private VolumeTreeNode<?> myTargetNode;
    private OperationController myTransientOperationController = new OperationController(){

        @Override
        public void fail(String aMessage) {
            SrTransientWindowPane.showOfflineCopyFailed(ClientLoader.getMainFrame(), OfflineCopyOperationHandler.this.mySourceVolume.getAlias(), OfflineCopyOperationHandler.this.myTargetNode.getAlias(), this.getLinkAction());
        }

        @Override
        public void inProcess(String aMessage) {
        }

        @Override
        public void success(SrAction aAction) {
            SrTransientWindowPane.showOfflineCopyStarted(ClientLoader.getMainFrame(), OfflineCopyOperationHandler.this.mySourceVolume.getAlias(), OfflineCopyOperationHandler.this.myTargetNode.getAlias(), this.getLinkAction());
        }

        private ActionListener getLinkAction() {
            ArrayList<CopyOperationNode> selection = new ArrayList<CopyOperationNode>(1);
            for (CopyOperationNode oper : CopyOperManager.getInstance().getOfflineCopyOperations(OfflineCopyOperationHandler.this.mySourceVolume)) {
                if (!oper.getSource().equals(OfflineCopyOperationHandler.this.mySourceVolume) || !oper.getDestination().equals(OfflineCopyOperationHandler.this.myTargetNode)) continue;
                selection.add(oper);
                break;
            }
            return MainFrame.createShowConstantCopyOperationAction(selection);
        }
    };

    public OfflineCopyOperationHandler(VolumeTreeNode source) {
        super(source);
    }

    @Override
    public boolean isVolumeOperation() {
        return true;
    }

    @Override
    public Collection<SrFuture<Void>> operate(VolumeTreeNode<?> targetNode) {
        this.myTargetNode = targetNode;
        return Collections.singleton(CopyOperManager.getInstance().offlineCopy(this.mySourceVolume, targetNode));
    }

    public String isOperationLegitimate(VolumeTreeNode volumeNode) {
        SnapshotVolumeNode snapshotVolume;
        VolumeTreeNode<?> snapshotSource;
        if (this.mySourceVolume instanceof SnapshotVolumeNode && (snapshotSource = (snapshotVolume = (SnapshotVolumeNode)this.mySourceVolume).getSourceVolume()).equals(volumeNode)) {
            return "Snapshot volume " + snapshotVolume + " cannot be copied to its source volume " + volumeNode;
        }
        if (VolumeManager.getInstance().isVolumeInvolvedInReplication(volumeNode)) {
            return "Volume " + volumeNode + " is involved in replication";
        }
        if (CopyOperManager.getInstance().isOfflineCopySrc(volumeNode)) {
            return "Volume " + volumeNode + " is a source of another offline copy operation; cannot function as a destination";
        }
        if (this.mySourceVolume.equals(volumeNode)) {
            return "Cannot copy volume " + this.mySourceVolume + " to itself";
        }
        if (volumeNode instanceof SnapshotVolumeNode) {
            return "Cannot copy volumes to Snpashot volume " + volumeNode;
        }
        StringBuffer errorBuffer = new StringBuffer();
        if (!CopyOperManager.getInstance().isLegitimateForCopyOper(this.mySourceVolume, errorBuffer)) {
            return this.mySourceVolume.getAlias() + ": " + errorBuffer.toString();
        }
        errorBuffer = new StringBuffer();
        if (!CopyOperManager.getInstance().isLegitimateForCopyOper(volumeNode, errorBuffer)) {
            return volumeNode.getAlias() + ": " + errorBuffer.toString();
        }
        if (!this.mySourceVolume.getBlockSize().equals(volumeNode.getBlockSize())) {
            return "The block size of volume " + this.mySourceVolume + "(" + this.mySourceVolume.getBlockSize() + ") differs from the block size of volume " + volumeNode + "(" + volumeNode.getBlockSize() + ")";
        }
        if (this.mySourceVolume.getAccessibleSpace().longValue() > volumeNode.getAccessibleSpace().longValue()) {
            return "Destination volume " + volumeNode + " has less space than source volume " + this.mySourceVolume;
        }
        if (((SrCopyOperationTableModel)OfflineCopyTableModelCollection.getInstance().getModel((RemoteObject)SystemRootNode.getInstance().getClusterNodeOfSource(volumeNode).getStub())).doesActiveOperationExist(this.mySourceVolume, volumeNode)) {
            return "There already exists an active copy operation between volumes " + this.mySourceVolume + " and " + volumeNode;
        }
        return null;
    }

    @Override
    public String getOperationName() {
        return "Offline Copy";
    }

    @Override
    public boolean shouldBlockAction() {
        return true;
    }

    @Override
    public Icon getIconForOperation() {
        return ClientImageObject.OFFLINE_COPY_OPERATION.getImageIcon();
    }

    @Override
    public void initAction(SrAction action) {
        action.addControllerAsListener(this.myTransientOperationController);
    }
}

