/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.volume.copy;

import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.volume.copy.CopyOperManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.server.logic.volume.copy.CopyOperation;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.constants.VolumeOperationOperStatusConstant;
import java.rmi.RemoteException;
import javax.swing.ImageIcon;

public abstract class CopyOperationNode<T extends CopyOperation>
extends SrTreeNode<T, CommKeyClassId> {
    private VolumeTreeNode src;
    private VolumeTreeNode dst;
    private VSwitchNode vSwitch;
    private VolumeOperationOperStatusConstant status;
    private Integer progress;
    private String type;

    public CopyOperationNode(T stub, VolumeTreeNode source, VolumeTreeNode destination, VSwitchNode vS, VolumeOperationOperStatusConstant stat, Integer prog, String operType) throws RemoteException {
        super(stub, stub.getCommKeyClassId());
        this.src = source;
        this.dst = destination;
        this.vSwitch = vS;
        this.status = stat;
        this.progress = prog;
        this.type = operType;
    }

    @Override
    public String type() {
        return "Copy Operation";
    }

    public void setStatus(VolumeOperationOperStatusConstant stat) {
        this.status = stat;
        if (stat.isActive() && this.progress.equals(new Integer(100))) {
            this.progress = new Integer(0);
        }
    }

    public void setProgress(Integer prog) {
        this.progress = this.status.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_END_OK) ? new Integer(100) : prog;
    }

    public VSwitchNode getVSwitch() {
        return this.vSwitch;
    }

    public VolumeTreeNode getSource() {
        return this.src;
    }

    public VolumeTreeNode getDestination() {
        return this.dst;
    }

    public Integer getProgress() {
        return this.progress;
    }

    public VolumeOperationOperStatusConstant getCopyStatus() {
        return this.status;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CopyOper");
        if (this.src != null) {
            sb.append(" from ");
            sb.append(this.src.getAlias());
        }
        if (this.dst != null) {
            sb.append(" to ");
            sb.append(this.dst.getAlias());
        }
        return sb.toString();
    }

    public String getCopyTypeStr() {
        return this.type;
    }

    public abstract boolean isMirrorSync();

    @Override
    public ImageIcon getNodeIcon() {
        return this.getSource().getNodeIcon();
    }

    @Override
    public String getProblemOnDeletion() {
        if (CopyOperManager.getInstance().operationStatusActive(this.getCopyStatus())) {
            return "Can't delete an active " + this.type + " operation (destination volume: " + this.dst + ").";
        }
        return super.getProblemOnDeletion();
    }
}

