/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.volume.copy;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.LUNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.acl.PolicyManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.DRPairManager;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.StorageDeviceNode;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceNode;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.volume.JournalVolumeNode;
import com.sanrad.nms.client.data.volume.MirrorVolumeNode;
import com.sanrad.nms.client.data.volume.SnapshotVolumeNode;
import com.sanrad.nms.client.data.volume.TransparentVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.volume.copy.CopyOperationNode;
import com.sanrad.nms.client.data.volume.copy.MirrorSyncOperationNode;
import com.sanrad.nms.client.data.volume.copy.MirrorSyncTableModelCollection;
import com.sanrad.nms.client.data.volume.copy.OfflineCopyOperationNode;
import com.sanrad.nms.client.data.volume.copy.OfflineCopyTableModelCollection;
import com.sanrad.nms.client.data.volume.copy.RestoreOperationNode;
import com.sanrad.nms.client.data.volume.copy.SrMirrorSyncTableModel;
import com.sanrad.nms.client.data.volume.copy.SrOfflineCopyTableModel;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.volume.copy.CopyOperationEvent;
import com.sanrad.nms.client.event.volume.copy.CopyOperationListener;
import com.sanrad.nms.client.gui.MainFrame;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.SrTransientWindowPane;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.volume.copy.CopyOperation;
import com.sanrad.nms.server.logic.volume.copy.MirrorSyncOperation;
import com.sanrad.nms.server.logic.volume.copy.OfflineCopyOperation;
import com.sanrad.nms.server.logic.volume.copy.RestoreOperation;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.constants.VolumeOperationOperStatusConstant;
import com.sanrad.nms.server.util.types.constants.VolumeOperationType;
import com.sanrad.nms.server.util.types.constants.VolumeStateConstant;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class CopyOperManager
extends ElementManager {
    private static CopyOperManager theInstance = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer getAllCopyOperationsInformer = new SrEventListenerManager.Informer<CopyOperationListener, CopyOperationEvent>(){

        @Override
        public void inform(CopyOperationListener listener, CopyOperationEvent event) {
            listener.getAllCopyOperations(event);
        }
    };
    SrEventListenerManager.Informer copyOperationCreateInformer = new SrEventListenerManager.Informer<CopyOperationListener, CopyOperationEvent>(){

        @Override
        public void inform(CopyOperationListener listener, CopyOperationEvent event) {
            listener.copyOperationCreate(event);
        }
    };
    SrEventListenerManager.Informer copyOperationChangeInformer = new SrEventListenerManager.Informer<CopyOperationListener, CopyOperationEvent>(){

        @Override
        public void inform(CopyOperationListener listener, CopyOperationEvent event) {
            listener.copyOperationChange(event);
        }
    };
    SrEventListenerManager.Informer copyOperationRemoveInformer = new SrEventListenerManager.Informer<CopyOperationListener, CopyOperationEvent>(){

        @Override
        public void inform(CopyOperationListener listener, CopyOperationEvent event) {
            listener.copyOperationRemove(event);
        }
    };

    private CopyOperManager() {
    }

    public static synchronized CopyOperManager getInstance() {
        if (theInstance == null) {
            theInstance = new CopyOperManager();
        }
        return theInstance;
    }

    public void addCopyOperationListener(CopyOperationListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeCopyOperationListener(CopyOperationListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    public void getAllCopyOpersFromServer(ClusterNode clusterNode) {
        this.fireGetAllCopyOperations(clusterNode);
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        if (this.alreadyExist(element)) {
            return;
        }
        try {
            CopyOperation oper = (CopyOperation)element;
            CopyOperationNode node = this.createNodeFromStub(oper, this.getParameterList(e));
            this.invokeTransientWindowCopyOperation(null, node.getCopyStatus(), node);
            this.fireCopyOperationCreated(node);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.EXCEPTION, re, new Object[0]);
        }
    }

    private CopyOperationNode createNodeFromStub(CopyOperation oper, HashMap params) throws RemoteException {
        SystemRootNode rootNode = SystemRootNode.getInstance();
        RemoteObject copySrcNode = (RemoteObject)this.getObjectForParam(params, ClientParameterCode.COPY_OPERATION_SRC, true);
        RemoteObject copyDstNode = (RemoteObject)this.getObjectForParam(params, ClientParameterCode.COPY_OPERATION_DST, true);
        RemoteObject copyVSwitch = (RemoteObject)this.getObjectForParam(params, ClientParameterCode.VSWITCH_ID, true);
        Object copyPercentage = this.getObjectForParam(params, ClientParameterCode.COPY_OPERATION_PERCENTAGE_COPIED, true);
        Object copyStatus = this.getObjectForParam(params, ClientParameterCode.COPY_OPERATION_OPER_STATUS, true);
        Object copyTypeName = this.getObjectForParam(params, ClientParameterCode.COPY_OPERATION_TYPE, true);
        if (copySrcNode == null) {
            copySrcNode = oper.getCopySrcNode();
        }
        if (copyDstNode == null) {
            copyDstNode = oper.getCopyDstNode();
        }
        if (copyVSwitch == null) {
            copyVSwitch = oper.getCopyVSwitch();
        }
        if (copyPercentage == null) {
            copyPercentage = oper.getCopyPercentage();
        }
        if (copyStatus == null) {
            copyStatus = oper.getCopyStatus();
        }
        if (copyTypeName == null) {
            copyTypeName = oper.getCopyTypeName();
        }
        VolumeTreeNode src = (VolumeTreeNode)rootNode.getRefByStub(copySrcNode);
        VolumeTreeNode dst = (VolumeTreeNode)rootNode.getRefByStub(copyDstNode);
        VSwitchNode vSwitch = (VSwitchNode)rootNode.getRefByStub(copyVSwitch);
        Integer progress = (Integer)copyPercentage;
        if (copyStatus instanceof Integer) {
            copyStatus = VolumeOperationOperStatusConstant.getVolumeOperationOperStatus((Integer)copyStatus);
        }
        VolumeOperationOperStatusConstant status = (VolumeOperationOperStatusConstant)copyStatus;
        if (copyTypeName instanceof Integer) {
            copyTypeName = VolumeOperationType.getVolumeOperationTypeName((Integer)copyTypeName).toString();
        }
        String type = (String)copyTypeName;
        CopyOperationNode node = null;
        if (oper instanceof MirrorSyncOperation) {
            node = new MirrorSyncOperationNode((MirrorSyncOperation)oper, src, dst, vSwitch, status, progress, type);
        } else if (oper instanceof OfflineCopyOperation) {
            node = new OfflineCopyOperationNode((OfflineCopyOperation)oper, src, dst, vSwitch, status, progress, type);
        } else if (oper instanceof RestoreOperation) {
            theLogger.logAndAssert(SrLogCategories.ERROR, src instanceof SnapshotVolumeNode, new Object[]{"Volume " + src + " is the source of a snapshot restoring operation and is not a snapshot volume"});
            node = new RestoreOperationNode((RestoreOperation)oper, (SnapshotVolumeNode)src, dst, vSwitch, status, progress, type);
            ((SnapshotVolumeNode)src).setRestoreOperation((RestoreOperationNode)node);
        }
        SystemRootNode.getInstance().putRefAndStub(oper, node);
        return node;
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            theLogger.warn(SrLogCategories.INFORMATIVE, "Got an event while cluster is in discovery, returning. event: ", e, "; parameters: ", e.getParameterList());
            return;
        }
        CopyOperationNode copyOper = (CopyOperationNode)SystemRootNode.getInstance().getRefByStub(element);
        if (copyOper != null) {
            HashMap params = this.getParameterList(e);
            CopyOperationEvent event = new CopyOperationEvent((Object)this, element, copyOper);
            if (params.containsKey(ClientParameterCode.COPY_OPERATION_OPER_STATUS)) {
                VolumeOperationOperStatusConstant status = (VolumeOperationOperStatusConstant)params.get(ClientParameterCode.COPY_OPERATION_OPER_STATUS);
                event.setStatus(status);
                VolumeOperationOperStatusConstant oldStatus = copyOper.getCopyStatus();
                copyOper.setStatus(status);
                this.invokeTransientWindowCopyOperation(oldStatus, status, copyOper);
            }
            if (params.containsKey(ClientParameterCode.COPY_OPERATION_PERCENTAGE_COPIED)) {
                event.setProgress((Integer)params.get(ClientParameterCode.COPY_OPERATION_PERCENTAGE_COPIED));
                copyOper.setProgress((Integer)params.get(ClientParameterCode.COPY_OPERATION_PERCENTAGE_COPIED));
                theLogger.info(SrLogCategories.INFORMATIVE, "setting progress: ", params);
            }
            theLogger.info(SrLogCategories.INFORMATIVE, "Firing copy operation changed event: ", event);
            this.fireCopyOperationChanged(event);
        } else {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The element is NOT found in the ref to stub mapping. element: ", element);
        }
    }

    private void invokeTransientWindowCopyOperation(VolumeOperationOperStatusConstant oldStatus, VolumeOperationOperStatusConstant status, CopyOperationNode copyOper) {
        if (oldStatus == null || !this.operationStatusActive(status) && this.operationStatusActive(oldStatus)) {
            SrClientAction action = copyOper.isMirrorSync() ? MainFrame.createShowConstantMirrorSyncOperationsAction(Collections.singleton((MirrorSyncOperationNode)copyOper)) : (copyOper instanceof RestoreOperationNode ? MainFrame.createShowConstantRestoreOperationAction(Collections.singleton((RestoreOperationNode)copyOper)) : MainFrame.createShowConstantCopyOperationAction(Collections.singleton(copyOper)));
            if (status.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_END_OK)) {
                if (copyOper.isMirrorSync()) {
                    SrTransientWindowPane.showMirrorSyncCompleted(ClientLoader.getMainFrame(), copyOper.getSource().getAlias(), copyOper.getDestination().getAlias(), action);
                } else if (copyOper instanceof RestoreOperationNode) {
                    SrTransientWindowPane.showSnapshotRollbackCompleted(ClientLoader.getMainFrame(), copyOper.getSource().getAlias(), copyOper.getDestination().getAlias(), action);
                } else {
                    SrTransientWindowPane.showOfflineCopyCompleted(ClientLoader.getMainFrame(), copyOper.getSource().getAlias(), copyOper.getDestination().getAlias(), action);
                }
            } else if (status.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_END_ERROR) || status.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_ABORTED) || status.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_ABORTE_FAILED)) {
                if (copyOper.isMirrorSync()) {
                    SrTransientWindowPane.showMirrorSyncFailed(ClientLoader.getMainFrame(), copyOper.getSource().getAlias(), copyOper.getDestination().getAlias(), action);
                } else if (copyOper instanceof RestoreOperationNode) {
                    SrTransientWindowPane.showSnapshotRollbackFailed(ClientLoader.getMainFrame(), copyOper.getSource().getAlias(), copyOper.getDestination().getAlias(), action);
                } else {
                    SrTransientWindowPane.showOfflineCopyFailed(ClientLoader.getMainFrame(), copyOper.getSource().getAlias(), copyOper.getDestination().getAlias(), action);
                }
            } else if (status.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_FAILED)) {
                // empty if block
            }
        }
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        CopyOperationNode copyOper = (CopyOperationNode)SystemRootNode.getInstance().getRefByStub(element);
        if (copyOper instanceof RestoreOperationNode) {
            RestoreOperationNode restoreOperation = (RestoreOperationNode)copyOper;
            SnapshotVolumeNode snapshotVolume = (SnapshotVolumeNode)restoreOperation.getSource();
            snapshotVolume.reomveRestoreOperation();
        }
        if (copyOper != null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "CopyOperationManager - Copy Removed: ", copyOper);
            this.fireCopyOperationRemoved(copyOper);
            SystemRootNode.getInstance().removeRefAndIdByStub(element);
        }
    }

    public Vector getOfflineCopyOperationsFromServer(ClusterNode cluster) {
        Cluster clusterStub = (Cluster)cluster.getStub();
        if (clusterStub == null) {
            return null;
        }
        Vector opers = null;
        try {
            opers = clusterStub.getCopyOperManager().getOfflineCopyOpers();
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.EXCEPTION, re, new Object[0]);
            return null;
        }
        Vector<CopyOperationNode> operNodes = new Vector<CopyOperationNode>();
        for (int i = 0; i < opers.size(); ++i) {
            try {
                operNodes.add(this.createNodeFromStub((CopyOperation)opers.get(i), null));
                continue;
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.EXCEPTION, re, new Object[0]);
                return null;
            }
        }
        return operNodes;
    }

    public Vector getMirrSyncOperationsFromServer(ClusterNode cluster) {
        Cluster clusterStub = (Cluster)cluster.getStub();
        Vector opers = null;
        try {
            opers = clusterStub.getCopyOperManager().getMirrorSyncCopyOpers();
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.EXCEPTION, re, new Object[0]);
            return null;
        }
        Vector<CopyOperationNode> operNodes = new Vector<CopyOperationNode>();
        try {
            for (int i = 0; i < opers.size(); ++i) {
                operNodes.add(this.createNodeFromStub((CopyOperation)opers.get(i), null));
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.EXCEPTION, re, new Object[0]);
            return null;
        }
        return operNodes;
    }

    public Vector getRestoreOperationsFromServer(ClusterNode cluster) {
        Cluster clusterStub = (Cluster)cluster.getStub();
        Vector opers = null;
        try {
            opers = clusterStub.getCopyOperManager().getRestoreOpers();
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.EXCEPTION, re, new Object[0]);
            return null;
        }
        Vector<CopyOperationNode> operNodes = new Vector<CopyOperationNode>();
        for (int i = 0; i < opers.size(); ++i) {
            try {
                operNodes.add(this.createNodeFromStub((CopyOperation)opers.get(i), null));
                continue;
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.EXCEPTION, re, new Object[0]);
                return null;
            }
        }
        return operNodes;
    }

    public void fireGetAllCopyOperations(ClusterNode clusterNode) {
        CopyOperationEvent event = new CopyOperationEvent(this, (RemoteObject)clusterNode.getStub());
        this.m_listeners.fireEvent(CopyOperationListener.class, event, this.getAllCopyOperationsInformer);
    }

    public void fireCopyOperationCreated(CopyOperationNode node) {
        CopyOperationEvent event = new CopyOperationEvent((Object)this, (RemoteObject)node.getStub(), node);
        this.m_listeners.fireEvent(CopyOperationListener.class, event, this.copyOperationCreateInformer);
    }

    public void fireCopyOperationChanged(CopyOperationEvent event) {
        this.m_listeners.fireEvent(CopyOperationListener.class, event, this.copyOperationChangeInformer);
    }

    public void fireCopyOperationRemoved(CopyOperationNode node) {
        CopyOperationEvent event = new CopyOperationEvent((Object)this, (RemoteObject)node.getStub(), node);
        this.m_listeners.fireEvent(CopyOperationListener.class, event, this.copyOperationRemoveInformer);
    }

    public SrFuture<Void> abortOperations(CopyOperationNode[] copyOpers) {
        ArrayList<CommKeyClassId> copyOperIds = new ArrayList<CommKeyClassId>(copyOpers.length);
        for (int i = 0; i < copyOpers.length; ++i) {
            CopyOperationNode current = copyOpers[i];
            if (!current.getCopyStatus().isActive()) continue;
            copyOperIds.add((CommKeyClassId)current.getIdentifier());
        }
        return ClientAOImpl.getInstance().abortOperations(copyOperIds);
    }

    public SrFuture<Void> refreshOperations(ClusterNode cluster) {
        if (cluster.hasVSwitch()) {
            return ClientAOImpl.getInstance().refreshCopyTable(cluster.getCopyOperManagerID());
        }
        return new CompleteFuture<Void>(null);
    }

    public LogicObject[] getLogicObjects(Object[] copyOpers) {
        LogicObject[] stubs = new LogicObject[copyOpers.length];
        for (int i = 0; i < copyOpers.length; ++i) {
            stubs[i] = (LogicObject)((CopyOperationNode)copyOpers[i]).getStub();
        }
        return stubs;
    }

    public SrFuture<Void> offlineCopy(VolumeTreeNode<?> srcNode, VolumeTreeNode<?> dstNode) {
        return ClientAOImpl.getInstance().offlineCopy((CommKeyClassId)srcNode.getIdentifier(), (CommKeyClassId)dstNode.getIdentifier());
    }

    public StringBuffer getRollbackConfirmMsg(SnapshotVolumeNode srcNode) {
        StringBuffer msg = new StringBuffer("Warning, rollback operation on snapshot volume ");
        msg.append(srcNode.getAlias());
        msg.append(" will ovewrite production volume. This process cannot be undone.");
        msg.append("\n Are you sure you want to start the rollback?");
        return msg;
    }

    public StringBuffer getAbortRollbackConfirmMsg(SnapshotVolumeNode srcNode) {
        StringBuffer msg = new StringBuffer("Warning, aborting rollback process on ");
        msg.append(srcNode.getAlias());
        msg.append(" will corrupt the data.");
        msg.append(".\n Are you sure you want to abort?");
        return msg;
    }

    public SrFuture<Void> restore(SnapshotVolumeNode srcNode) {
        SnapshotVolumeNode[] srcNodes = new SnapshotVolumeNode[]{srcNode};
        return this.restore(srcNodes);
    }

    public SrFuture<Void> restore(SnapshotVolumeNode[] srcNodes) {
        ClusterNode currentClusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(srcNodes[0]);
        CommKeyClassId[] snapshotsIds = new CommKeyClassId[srcNodes.length];
        for (int index = 0; index < srcNodes.length; ++index) {
            snapshotsIds[index] = (CommKeyClassId)srcNodes[index].getIdentifier();
        }
        return ClientAOImpl.getInstance().restoreSnapshots(currentClusterNode.getCopyOperManagerID(), Arrays.asList(snapshotsIds));
    }

    public SrFuture<Void> replaceVolume(VolumeTreeNode<?> oldNode, VolumeTreeNode<?> newNode) {
        return ClientAOImpl.getInstance().replace((CommKeyClassId)oldNode.getIdentifier(), (CommKeyClassId)newNode.getIdentifier());
    }

    public boolean isLegitimateForCopyOper(Object node, StringBuffer reason) {
        VolumeTreeNode vol = (VolumeTreeNode)node;
        if (vol.isExposed()) {
            LUNode lu = vol.getHeadLu();
            if (lu == null) {
                reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.COPY_OPR_VALIDAION_THE_VOLUME_IS_EXPOSED_BUT_HAS_NO_PARENT_INTERMIDIATE_STATE));
                return false;
            }
            TargetNode target = lu.getTargetParent();
            PolicyManager policyMgr = SystemRootNode.getInstance().getClusterNodeOfSource(vol).getPolicyManager();
            if (!policyMgr.isReadOnlyTarget(target)) {
                reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.COPY_OPR_VALIDAION_NOT_ALL_THE_VOLUME_TARGET_IDENTITIES_ARE_READ_ONLY));
                return false;
            }
        }
        if (vol.getParent() instanceof VolumeTreeNode) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.COPY_OPR_VALIDAION_THE_VOLUME_MUST_BE_THE_HEAD_OF_VIRTUALIZATION_TREE));
            return false;
        }
        if (node instanceof JournalVolumeNode) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.COPY_OPR_VALIDAION_THE_VOLUME_IS_A_JOURNAL));
            return false;
        }
        if (VolumeManager.getInstance().isVolumeInvolvedInReplication(vol)) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.COPY_OPR_VALIDAION_THE_VOLUME_INVOLVED_IN_REPLICATION));
            return false;
        }
        if (CopyOperManager.getInstance().isInvolvedInRestore(vol)) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.COPY_OPR_VALIDAION_THE_VOLUME_INVOLVED_IN_ROLLBACK_OPERATION));
            return false;
        }
        SrOfflineCopyTableModel offlineCopyTableModel = (SrOfflineCopyTableModel)OfflineCopyTableModelCollection.getInstance().getModel((RemoteObject)vol.getStub());
        if (offlineCopyTableModel.isActiveCopyDst(vol)) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.COPY_OPR_VALIDAION_THE_DESTINATION_CANNOT_BE_SOURCE_OF_ANOTHER_OPERATION_IT_THE_SAME_TIME));
            return false;
        }
        if (vol.isInState(VolumeStateConstant.VOLUME_STATE_NONFUNCTIONAL)) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.COPY_OPR_VALIDAION_CANNOT_COPY_FROM_NON_FUNCTIONAL_SOURCE));
            return false;
        }
        if (vol instanceof SnapshotVolumeNode) {
            SnapshotVolumeNode snapShotVol = (SnapshotVolumeNode)node;
            if (VolumeManager.getInstance().isSnapshotSourceUsedByAPair(snapShotVol) && !snapShotVol.isActivated()) {
                reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.SNAPSHOT_SOURCE_USED_BY_PAIR));
                return false;
            }
            if (!snapShotVol.isActivated()) {
                reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.COPY_OPR_VALIDAION_THE_SNAPSHOT_IS_NOT_ACTIVE));
                return false;
            }
        }
        if (vol instanceof TransparentVolumeNode) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.COPY_OPR_VALIDAION_THE_TRANSPARENT_NOT_ALLOWED));
            return false;
        }
        boolean isSequentialStorage = false;
        boolean isSubDisk = false;
        boolean isDisk = false;
        boolean isProcessor = false;
        if (node instanceof StorageDeviceNode) {
            isSequentialStorage = ((StorageDeviceNode)node).isTape();
            isSubDisk = ((StorageDeviceNode)node).isSubDisk();
            isDisk = ((StorageDeviceNode)node).isDisk();
            isProcessor = ((StorageDeviceNode)node).isProcessor();
        }
        if (isSequentialStorage || isProcessor) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.COPY_OPR_VALIDAION_THE_STORAGE_IS_NOT_A_DISK_OR_SUBDISK));
            return false;
        }
        if (isSubDisk) {
            SubDirectAccessDeviceNode subDisk = (SubDirectAccessDeviceNode)node;
            DirectAccessDeviceNode disk = subDisk.getDirectAccessDeviceParent();
            if (VolumeManager.getInstance().isMissingOrInvalidDisk(disk)) {
                reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.COPY_OPR_VALIDAION_THE_PARENT_IS_MISSING_OR_INVALID));
                return false;
            }
        }
        if (isDisk && VolumeManager.getInstance().isMissingOrInvalidDisk((DirectAccessDeviceNode)node)) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.COPY_OPR_VALIDAION_THE_DISK_IS_MISSING_OR_INVALID));
            return false;
        }
        if (isDisk && ((DirectAccessDeviceNode)node).hasSubdisks()) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.COPY_OPR_VALIDAION_THE_DISK_HAS_SUBDISKS));
            return false;
        }
        return true;
    }

    public boolean isLegitimateForRestoreOper(SnapshotVolumeNode snapshotVolumeNode, StringBuffer reason) {
        VolumeTreeNode child;
        if (!snapshotVolumeNode.isActivated()) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.RESTORE_OPR_VALIDAION_THE_SNAPSHOT_IS_NOT_ACTIVATED));
            return false;
        }
        if (snapshotVolumeNode.isExposed()) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.RESTORE_OPR_VALIDAION_THE_SNAPSHOT_IS_EXPOSED));
            return false;
        }
        if (snapshotVolumeNode.isInState(VolumeStateConstant.VOLUME_STATE_OUT_OF_SYNC)) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.RESTORE_OPR_VALIDAION_THE_SNAPSHOT_IS_OUT_OF_SYNC));
            return false;
        }
        if (snapshotVolumeNode.isInvolvedInAnotherActiveRestoreOperation()) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.RESTORE_OPR_VALIDAION_THE_SNAPSHOT_IS_ALREADY_RESTORING));
            return false;
        }
        if (CopyOperManager.getInstance().isInvolvedInAnyActiveCopyOper(snapshotVolumeNode)) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.RESTORE_OPR_VALIDAION_THE_SNAPSHOT_IS_INVOLVED_IN_ANOTHER_ACTIVE_COPY_OPER));
            return false;
        }
        if (DRPairManager.getPairContainingVolume(snapshotVolumeNode) != null) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.RESTORE_OPR_VALIDAION_THE_SNAPSHOT_IS_USED_BY_PAIR));
            return false;
        }
        Enumeration<TreeNode> children = snapshotVolumeNode.children();
        while (children.hasMoreElements()) {
            VolumeTreeNode child2 = (VolumeTreeNode)children.nextElement();
            if (!child2.isNonFunctional()) continue;
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.RESTORE_OPR_VALIDAION_THE_SNAPSHOT_CHILD_IS_NON_FUNCTIONAL));
            return false;
        }
        VolumeTreeNode<?> snapshotSource = snapshotVolumeNode.getSourceVolume();
        if (snapshotSource instanceof MirrorVolumeNode) {
            children = snapshotSource.children();
            while (children.hasMoreElements()) {
                child = (VolumeTreeNode)children.nextElement();
                if (!CopyOperManager.getInstance().isInvolvedInActiveMirrorSync(child)) continue;
                reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.RESTORE_OPR_VALIDAION_THE_SNAPSHOT_SOURCE_IS_INVOLVED_IN_ANOTHER_ACTIVE_COPY_OPER));
                return false;
            }
        }
        if (CopyOperManager.getInstance().isDestinationOfOtherActiveCopyOper(snapshotSource)) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.RESTORE_OPR_VALIDAION_THE_SNAPSHOT_SOURCE_IS_INVOLVED_IN_ANOTHER_ACTIVE_COPY_OPER));
            return false;
        }
        children = snapshotSource.children();
        while (children.hasMoreElements()) {
            child = (VolumeTreeNode)children.nextElement();
            if (!CopyOperManager.getInstance().isDestinationOfOtherActiveCopyOper(child)) continue;
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.RESTORE_OPR_VALIDAION_THE_SNAPSHOT_SOURCE_IS_INVOLVED_IN_ANOTHER_ACTIVE_COPY_OPER));
            return false;
        }
        if (snapshotSource.isExposed()) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.RESTORE_OPR_VALIDAION_THE_SNAPSHOT_SOURCE_IS_EXPOSED));
            return false;
        }
        if (snapshotSource.isNonFunctional()) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.RESTORE_OPR_VALIDAION_THE_SNAPSHOT_SOURCE_IS_NON_FUNCTIONAL));
            return false;
        }
        return true;
    }

    public boolean isInvolvedInActiveMirrorSync(Object node) {
        VolumeTreeNode vol = (VolumeTreeNode)node;
        SrMirrorSyncTableModel mirrSyncTblModel = (SrMirrorSyncTableModel)MirrorSyncTableModelCollection.getInstance().getModel((RemoteObject)vol.getStub());
        if (node instanceof MirrorVolumeNode) {
            Enumeration<TreeNode> children = ((MirrorVolumeNode)node).children();
            while (children.hasMoreElements()) {
                VolumeTreeNode volumeTreeNode = (VolumeTreeNode)children.nextElement();
                if (!this.isInvolvedInActiveMirrorSync(volumeTreeNode)) continue;
                return true;
            }
        }
        return mirrSyncTblModel.isActiveCopyDst(vol) || mirrSyncTblModel.isActiveCopySrc(vol);
    }

    public boolean isInvolvedInAbortedMirrorSync(Object node) {
        VolumeTreeNode vol = (VolumeTreeNode)node;
        SrMirrorSyncTableModel mirrSyncTblModel = (SrMirrorSyncTableModel)MirrorSyncTableModelCollection.getInstance().getModel((RemoteObject)vol.getStub());
        if (node instanceof MirrorVolumeNode) {
            Enumeration<TreeNode> children = ((MirrorVolumeNode)node).children();
            while (children.hasMoreElements()) {
                VolumeTreeNode volumeTreeNode = (VolumeTreeNode)children.nextElement();
                if (!this.isInvolvedInAbortedMirrorSync(volumeTreeNode)) continue;
                return true;
            }
        }
        return mirrSyncTblModel.isAbortedCopyDst(vol) || mirrSyncTblModel.isAbortedCopySrc(vol);
    }

    public boolean isInvolvedInMirrorSync(Object node) {
        VolumeTreeNode vol = (VolumeTreeNode)node;
        SrMirrorSyncTableModel mirrSyncTblModel = (SrMirrorSyncTableModel)MirrorSyncTableModelCollection.getInstance().getModel((RemoteObject)vol.getStub());
        if (node instanceof MirrorVolumeNode) {
            Enumeration<TreeNode> iter = ((MirrorVolumeNode)node).children();
            while (iter.hasMoreElements()) {
                VolumeTreeNode volumeTreeNode = (VolumeTreeNode)iter.nextElement();
                if (!this.isInvolvedInMirrorSync(volumeTreeNode)) continue;
                return true;
            }
        }
        return mirrSyncTblModel.isCopyDst(vol) || mirrSyncTblModel.isCopySrc(vol);
    }

    public boolean isInvolvedInMirrorSyncTable(Object node) {
        VolumeTreeNode vol = (VolumeTreeNode)node;
        SrMirrorSyncTableModel mirrSyncTblModel = (SrMirrorSyncTableModel)MirrorSyncTableModelCollection.getInstance().getModel((RemoteObject)vol.getStub());
        if (node instanceof MirrorVolumeNode) {
            Enumeration<TreeNode> iter = ((MirrorVolumeNode)node).children();
            while (iter.hasMoreElements()) {
                VolumeTreeNode volumeTreeNode = (VolumeTreeNode)iter.nextElement();
                if (!this.isInvolvedInMirrorSyncTable(volumeTreeNode)) continue;
                return true;
            }
        }
        return mirrSyncTblModel.isExistedAsCopyDstInTable(vol) || mirrSyncTblModel.isExistedAsCopySrcInTable(vol);
    }

    public boolean isInvolvedInActiveOfflineCopy(Object node) {
        VolumeTreeNode vol = (VolumeTreeNode)node;
        SrOfflineCopyTableModel copyTblModel = (SrOfflineCopyTableModel)OfflineCopyTableModelCollection.getInstance().getModel((RemoteObject)vol.getStub());
        return copyTblModel.isActiveCopyDst(vol) || copyTblModel.isActiveCopySrc(vol);
    }

    public boolean isInvolvedInAbortedOfflineCopy(Object node) {
        VolumeTreeNode vol = (VolumeTreeNode)node;
        SrOfflineCopyTableModel copyTblModel = (SrOfflineCopyTableModel)OfflineCopyTableModelCollection.getInstance().getModel((RemoteObject)vol.getStub());
        return copyTblModel.isAbortedCopyDst(vol) || copyTblModel.isAbortedCopySrc(vol);
    }

    public boolean isInvolvedInOfflineCopy(VolumeTreeNode vol) {
        return !this.getOfflineCopyOperations(vol).isEmpty();
    }

    public Collection<CopyOperationNode> getOfflineCopyOperations(VolumeTreeNode vol) {
        SrOfflineCopyTableModel copyTblModel = (SrOfflineCopyTableModel)OfflineCopyTableModelCollection.getInstance().getModel((RemoteObject)vol.getStub());
        Collection<? extends CopyOperationNode> copyOperations = copyTblModel.getCopyOperations();
        ArrayList<CopyOperationNode> retVal = new ArrayList<CopyOperationNode>(copyOperations.size());
        for (CopyOperationNode copyOperationNode : copyOperations) {
            VolumeOperationOperStatusConstant status = copyOperationNode.getCopyStatus();
            if (!copyOperationNode.getDestination().equals(vol) && !copyOperationNode.getSource().equals(vol) || !status.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_ABORTED) && !status.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_OPERATING) && !status.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_WAITING)) continue;
            retVal.add(copyOperationNode);
        }
        return retVal;
    }

    public boolean isInvolvedInOfflineCopyOperTable(Object node) {
        VolumeTreeNode vol = (VolumeTreeNode)node;
        SrOfflineCopyTableModel copyTblModel = (SrOfflineCopyTableModel)OfflineCopyTableModelCollection.getInstance().getModel((RemoteObject)vol.getStub());
        return copyTblModel.isExistedAsCopyDstInTable(vol) || copyTblModel.isExistedAsCopySrcInTable(vol);
    }

    public boolean isInvolvedInActiveRestore(Object node) {
        VolumeTreeNode vol = (VolumeTreeNode)node;
        return VolumeManager.getInstance().getClusterSnapshotMap().isInvolvedInActiveRestore(vol);
    }

    public boolean isInvolvedInRestore(Object node) {
        VolumeTreeNode vol = (VolumeTreeNode)node;
        return VolumeManager.getInstance().getClusterSnapshotMap().isInvolvedInRestore(vol);
    }

    public boolean isInvolvedInAnyCopyOperTable(Object node) {
        return this.isInvolvedInOfflineCopyOperTable(node) || this.isInvolvedInMirrorSyncTable(node) || this.isInvolvedInRestore(node);
    }

    public boolean isInvolvedInAnyCopyOper(VolumeTreeNode node) {
        return this.isInvolvedInOfflineCopy(node) || this.isInvolvedInMirrorSync(node) || this.isInvolvedInRestore(node);
    }

    public boolean isInvolvedInAnyActiveCopyOper(Object node) {
        return this.isInvolvedInActiveOfflineCopy(node) || this.isInvolvedInActiveMirrorSync(node) || this.isInvolvedInActiveRestore(node);
    }

    public boolean isInvolvedInAnyAbortedCopyOper(Object node) {
        return this.isInvolvedInAbortedOfflineCopy(node) || this.isInvolvedInAbortedMirrorSync(node);
    }

    public boolean isDestinationOfOtherActiveCopyOper(VolumeTreeNode node) {
        SrOfflineCopyTableModel copyTblModel = (SrOfflineCopyTableModel)OfflineCopyTableModelCollection.getInstance().getModel((RemoteObject)node.getStub());
        if (copyTblModel.isActiveCopyDst(node)) {
            return true;
        }
        SrMirrorSyncTableModel mirrSyncTblModel = (SrMirrorSyncTableModel)MirrorSyncTableModelCollection.getInstance().getModel((RemoteObject)node.getStub());
        if (mirrSyncTblModel.isCopyDst(node)) {
            return true;
        }
        return VolumeManager.getInstance().getClusterSnapshotMap().isActiveRestoreDst(node);
    }

    public boolean isOfflineCopySrc(Object node) {
        VolumeTreeNode vol = (VolumeTreeNode)node;
        SrOfflineCopyTableModel offlineCopyTblModel = (SrOfflineCopyTableModel)OfflineCopyTableModelCollection.getInstance().getModel((RemoteObject)vol.getStub());
        return offlineCopyTblModel.isActiveCopySrc(vol);
    }

    public boolean isSrcOfActiveMirrorSync(Object node) {
        VolumeTreeNode vol = (VolumeTreeNode)node;
        SrMirrorSyncTableModel mirrSyncTblModel = (SrMirrorSyncTableModel)MirrorSyncTableModelCollection.getInstance().getModel((RemoteObject)vol.getStub());
        return mirrSyncTblModel.isActiveCopySrc(vol);
    }

    public boolean isExistActiveCopyInHeirarchy(VolumeTreeNode node) {
        return this.isExistActiveCopyDownHeirarchy(node);
    }

    public boolean isExistAbortedCopyInHeirarchy(VolumeTreeNode node) {
        return this.isExistAbortedCopyDownHeirarchy(node);
    }

    public boolean isExistActiveCopyDownHeirarchy(VolumeTreeNode treeRoot) {
        Enumeration<TreeNode> children = treeRoot.children();
        while (children.hasMoreElements()) {
            VolumeTreeNode child = (VolumeTreeNode)children.nextElement();
            if (!this.isExistActiveCopyDownHeirarchy(child)) continue;
            return true;
        }
        return this.isInvolvedInAnyActiveCopyOper(treeRoot);
    }

    public boolean isExistAbortedCopyDownHeirarchy(VolumeTreeNode treeRoot) {
        Enumeration<TreeNode> children = treeRoot.children();
        while (children.hasMoreElements()) {
            VolumeTreeNode child = (VolumeTreeNode)children.nextElement();
            if (!this.isExistAbortedCopyDownHeirarchy(child)) continue;
            return true;
        }
        return this.isInvolvedInAnyAbortedCopyOper(treeRoot);
    }

    public boolean operationStatusActive(VolumeOperationOperStatusConstant operStat) {
        return operStat.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_OPERATING) || operStat.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_WAITING);
    }

    public boolean restoreOperationStatusActive(VolumeOperationOperStatusConstant operStat) {
        return this.operationStatusActive(operStat);
    }

    public boolean operationCanBeDeleted(VolumeOperationOperStatusConstant operStat) {
        return !this.operationStatusActive(operStat);
    }
}

