/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.volume;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.LUNode;
import com.sanrad.nms.client.data.ObjectStatus;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.alarm.AlarmsManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.DRPairManager;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeNode;
import com.sanrad.nms.client.data.volume.copy.CopyOperManager;
import com.sanrad.nms.client.data.volume.snapshot.SnapshotSchedulerManager;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageDriveTypeConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageRaidLevelConstant;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.nms.server.util.types.constants.VolumeStateConstant;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.StorageSize;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import javax.swing.tree.TreeNode;

public abstract class VolumeTreeNode<T extends LogicObject>
extends SrTreeNode<T, CommKeyClassId> {
    private String alias;
    private boolean exposed;
    private BigInteger myAccessibleSpace;
    private String myAccessibleSpaceStr;
    private BigInteger allocatedSpace;
    private LUNode luNode;
    private Object configurationParent;
    protected String volState;
    private SrBITSConstant m_volumeStateBits;
    private Integer positionInParent = null;

    public VolumeTreeNode(T stub, String alias, boolean exposed) throws RemoteException {
        super(stub, stub.getCommKeyClassId());
        this.setAlias(alias);
        this.setExposed(exposed);
    }

    public void setExposed(boolean exposed) {
        this.exposed = exposed;
        if (!exposed) {
            this.luNode = null;
        }
    }

    public boolean isExposed() {
        return this.exposed;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAccessibleSpace(BigInteger aAccessibleSpace) {
        this.myAccessibleSpace = aAccessibleSpace;
        this.myAccessibleSpaceStr = StorageSize.getSizeAsString(this.myAccessibleSpace);
    }

    public BigInteger getAccessibleSpace() {
        return this.myAccessibleSpace;
    }

    public void setAllocatedSpace(BigInteger allocatedSpace) {
        this.allocatedSpace = allocatedSpace;
    }

    public BigInteger getAllocatedSpace() {
        return this.allocatedSpace;
    }

    public void setLUNode(LUNode luNode) {
        this.luNode = luNode;
    }

    public LUNode getLUNode() {
        return this.luNode;
    }

    public void setVolStateStr() {
        if (this.m_volumeStateBits == null) {
            if (this.isExposed()) {
                this.volState = VolumeStateConstant.VOLUME_STATE_EXPOSED.toDisplayString();
                return;
            }
        } else {
            boolean interanlOnly;
            ArrayList strings = VolumeStateConstant.getStringsOfStates(this.m_volumeStateBits.toString());
            if (this.m_volumeStateBits.contains(VolumeStateConstant.VOLUME_STATE_NONE)) {
                this.volState = null;
                return;
            }
            String internalStateStr = VolumeStateConstant.VOLUME_STATE_INTERNAL.toDisplayString();
            int indexOfInternal = strings.indexOf(internalStateStr);
            boolean containsInternal = indexOfInternal >= 0;
            boolean bl = interanlOnly = containsInternal && strings.size() == 1;
            if (interanlOnly) {
                this.volState = this.isExposed() ? VolumeStateConstant.VOLUME_STATE_EXPOSED.toDisplayString() : VolumeStateConstant.VOLUME_STATE_INTERNAL.toDisplayString();
                return;
            }
            if (containsInternal && this.isExposed()) {
                strings.set(indexOfInternal, VolumeStateConstant.VOLUME_STATE_EXPOSED.toDisplayString());
            }
            StringBuffer sb = new StringBuffer("{");
            for (int index = 0; index < strings.size(); ++index) {
                sb.append(strings.get(index));
                sb.append(",");
            }
            sb.deleteCharAt(sb.lastIndexOf(","));
            sb.append("}");
            this.volState = sb.toString();
            return;
        }
        this.volState = null;
    }

    public String getVolStateStr() {
        return this.volState;
    }

    public void setPositionInParent(Integer position) {
        this.positionInParent = position;
    }

    public Integer getPositionInParent() {
        return this.positionInParent;
    }

    public void setConfigurationParent(Object node) {
        this.configurationParent = node;
    }

    public Object getConfigurationParent() {
        return this.configurationParent;
    }

    @Override
    public String toString() {
        if (this.alias != null) {
            if (this.myAccessibleSpace != null) {
                return this.alias + " [" + this.myAccessibleSpaceStr + "]";
            }
            return this.alias;
        }
        return "";
    }

    public abstract Integer getBlockSize();

    public LUNode getHeadLu() {
        if (this.isExposed()) {
            TreeNode parent = this.getParent();
            TreeNode prevParent = this;
            while (parent instanceof VolumeTreeNode) {
                prevParent = parent;
                parent = ((VolumeTreeNode)parent).getParent();
            }
            if (prevParent != null) {
                return ((VolumeTreeNode)prevParent).getLUNode();
            }
        }
        return null;
    }

    public boolean isVolStateExist() {
        if (this.m_volumeStateBits != null) {
            return !((BitSet)this.m_volumeStateBits.value()).isEmpty();
        }
        return false;
    }

    public boolean isInState(VolumeStateConstant state) {
        if (this.m_volumeStateBits != null) {
            return this.m_volumeStateBits.contains(state);
        }
        return false;
    }

    public boolean isIllegal() {
        return AlarmsManager.getInstance().isAlarmExist(this, AlarmsManager.VOLUME_ILLEGAL);
    }

    public boolean isInconsistent() {
        return AlarmsManager.getInstance().isAlarmExist(this, AlarmsManager.VOLUME_INCONSISTANT);
    }

    public boolean isNotRedundant() {
        return AlarmsManager.getInstance().isAlarmExist(this, AlarmsManager.OBJECT_NOT_REDUNDANT);
    }

    public boolean isNeedSync() {
        return AlarmsManager.getInstance().isAlarmExist(this, AlarmsManager.VOLUME_NEED_SYNC);
    }

    public boolean isNonFunctional() {
        return AlarmsManager.getInstance().isAlarmExist(this, AlarmsManager.VOLUME_NON_FUNC);
    }

    public void setVolStateBits(SrBITSConstant state) {
        this.m_volumeStateBits = state;
        this.setVolStateStr();
    }

    @Override
    public void setStatus(ObjectStatus status) {
        super.setStatus(status);
    }

    public int compareByPosition(Object obj) {
        if (obj instanceof VolumeTreeNode) {
            VolumeTreeNode other = (VolumeTreeNode)obj;
            if (this.getPositionInParent() == null || other.getPositionInParent() == null) {
                return super.compareTo(obj);
            }
            return this.getPositionInParent().compareTo(other.getPositionInParent());
        }
        return 0;
    }

    public VolumeTreeNode getHeadVolume() {
        TreeNode parent = this.getParent();
        VolumeTreeNode parentVol = this;
        while (parent instanceof VolumeTreeNode) {
            parentVol = (VolumeTreeNode)parent;
            parent = ((VolumeTreeNode)parent).getParent();
        }
        return parentVol;
    }

    public boolean isChildOfAnotherVolume() {
        boolean answer = false;
        TreeNode parent = this.getParent();
        if (parent != null && parent instanceof VolumeNode) {
            answer = true;
        }
        return answer;
    }

    public boolean hasParentVolume() {
        return this.isChildOfAnotherVolume();
    }

    public abstract boolean isConfigured();

    public boolean isDevice() {
        return false;
    }

    @Override
    public String getProblemOnDeletion() {
        return this.getProblemOnDeletion(false);
    }

    public String getProblemOnDeletion(boolean aIgnoreExposedCheck) {
        if (this.isAssociatedToDisconnectedVs()) {
            return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_CANNOT_BE_DELETED_DISCONNECTED_SWITCH);
        }
        ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(this);
        if (this.getParent() instanceof VolumeTreeNode) {
            return ClientLoader.DATA_VALIDATION_BUNDLE.getString((BundleKeysInterface)SrDataValidationResourceBundleKeys.VOLUME_CANNOT_BE_DELETED_CHILD_OF_ANOTHER_VOLUME, ((VolumeTreeNode)this.getParent()).getAlias());
        }
        if (VolumeManager.getInstance().getClusterSnapshotMap().isSourceOfSnapshot(clusterNode, this)) {
            return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_CANNOT_BE_DELETED_SOURCE_OF_SNAPSHOT);
        }
        if (CopyOperManager.getInstance().isInvolvedInAnyActiveCopyOper(this)) {
            return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_CANNOT_BE_DELETED_INVOLVE_IN_COPY_OPR);
        }
        if (!aIgnoreExposedCheck && this.isExposed()) {
            return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_CANNOT_BE_DELETED_ITS_EXPOSED);
        }
        if (DRPairManager.getPairContainingVolume(this) != null) {
            return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_CANNOT_BE_DELETED_USED_BY_DR_PAIR);
        }
        if (SnapshotSchedulerManager.getInstance().getSnapshotSchedulerOfSource(this) != null) {
            return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_CANNOT_BE_DELETED_SCHEDULER_SOURCE);
        }
        return null;
    }

    public String canBeUsedToCreateVolume() {
        if (this.isNonFunctional()) {
            return this.getCanBeUsedToCreateVolumeMessage(this, " is non-functional");
        }
        if (DRPairManager.getPairContainingVolume(this) != null) {
            return this.getCanBeUsedToCreateVolumeMessage(this, " is part of pair");
        }
        if (this.getConfigurationParent() != null) {
            return this.getCanBeUsedToCreateVolumeMessage(this, " has parent ", this.getConfigurationParent());
        }
        if (this.isExposed()) {
            return this.getCanBeUsedToCreateVolumeMessage(this, " is exposed");
        }
        if (CopyOperManager.getInstance().isInvolvedInOfflineCopy(this)) {
            return this.getCanBeUsedToCreateVolumeMessage(this, " is part of offline copy");
        }
        VolumeManager volMgr = VolumeManager.getInstance();
        if (volMgr.getClusterSnapshotMap().isSourceOfSnapshot(SystemRootNode.getInstance().getClusterNodeOfSource(this), this)) {
            return this.getCanBeUsedToCreateVolumeMessage(this, " is source of snapshot");
        }
        return null;
    }

    public String canBeUsedToCreateMirrorVolume(VolumeTreeNode firstMirrorLeg) {
        String msg = this.canBeUsedToCreateVolume();
        if (msg != null) {
            return msg;
        }
        if (this.equals(firstMirrorLeg)) {
            return this.getCanBeUsedToCreateVolumeMessage(this, " is same as ", firstMirrorLeg);
        }
        if (this.getBlockSize() == null || !this.getBlockSize().equals(firstMirrorLeg.getBlockSize())) {
            return this.getCanBeUsedToCreateVolumeMessage(this, " has different block size than ", firstMirrorLeg);
        }
        if (DRPairManager.getPairContainingVolume(firstMirrorLeg) != null && firstMirrorLeg.getAccessibleSpace().longValue() < this.getAccessibleSpace().longValue()) {
            return this.getCanBeUsedToCreateVolumeMessage(firstMirrorLeg, " is part of pair and its accessible space is smaller than ", this);
        }
        VolumeManager volMgr = VolumeManager.getInstance();
        if (volMgr.isPartOfTheSameTree(firstMirrorLeg, this)) {
            return this.getCanBeUsedToCreateVolumeMessage(this, " and ", firstMirrorLeg, " are in the same tree");
        }
        return null;
    }

    protected String getCanBeUsedToCreateVolumeMessage(Object ... aMsg) {
        StringBuilder msg = new StringBuilder();
        for (Object str : aMsg) {
            msg.append(str);
            msg.append(" ");
        }
        return msg.toString().trim();
    }

    public String canBeCloned() {
        if (SnapshotSchedulerManager.getInstance().getSnapshotSchedulerOfSource(this) != null) {
            return this + "can not be cloned because it is a source of a snapshot scheduler.";
        }
        if (this.isConfigured()) {
            return this + " can not be cloned because it is configured.";
        }
        if (!this.isExposed()) {
            return this + " can not be cloned because it is not exposed.";
        }
        if (this.isPartOfPair()) {
            return this + " can not be cloned because it is part of a pair.";
        }
        if (this.hasParentVolume()) {
            return this + " can not be cloned because it is has a parent volume.";
        }
        return null;
    }

    public boolean isPartOfPair() {
        return DRPairManager.getPairContainingVolume(this) != null;
    }

    public List<DirectAccessDeviceNode> getPhysicalResources() {
        ClassID classId = ((CommKeyClassId)this.getIdentifier()).getClassID();
        ArrayList<DirectAccessDeviceNode> resources = new ArrayList<DirectAccessDeviceNode>();
        if (ClassID.DIRECT_ACCESS_DEVICE.equals(classId)) {
            resources.add((DirectAccessDeviceNode)this);
        } else if (ClassID.SUB_DIRECT_ACCESS_DEVICE.equals(classId)) {
            DirectAccessDeviceNode disk = ((SubDirectAccessDeviceNode)this).getDirectAccessDeviceParent();
            resources.add(disk);
        } else {
            List<DirectAccessDeviceNode> disks = this.findAllInSubTree(DirectAccessDeviceNode.class);
            List<SubDirectAccessDeviceNode> subdisks = this.findAllInSubTree(SubDirectAccessDeviceNode.class);
            disks.removeAll(subdisks);
            resources.addAll(disks);
            for (SubDirectAccessDeviceNode subdisk : subdisks) {
                resources.add(subdisk.getDirectAccessDeviceParent());
            }
        }
        return resources;
    }

    public PhysicalStorageDriveTypeConstant getDriveType() {
        List<DirectAccessDeviceNode> disks = this.getPhysicalResources();
        if (!disks.isEmpty()) {
            return disks.get(0).getDriveType();
        }
        return null;
    }

    public PhysicalStorageRaidLevelConstant getRaidLevel() {
        List<DirectAccessDeviceNode> disks = this.getPhysicalResources();
        if (!disks.isEmpty()) {
            return disks.get(0).getRaidLevel();
        }
        return null;
    }
}

