/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.volume;

import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.util.concurrent.SrFuture;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JFrame;

public abstract class VolumeOperationHandler {
    protected VolumeTreeNode mySourceVolume;
    protected ClusterNode myClusterToWorkWith;
    protected JFrame owner;

    public VolumeOperationHandler(VolumeTreeNode sourceNode) {
        this(sourceNode, SystemRootNode.getInstance().getClusterNodeOfSource(sourceNode));
        if (sourceNode == null) {
            throw new IllegalArgumentException("sourceNode may not be null.");
        }
    }

    public VolumeOperationHandler(VolumeTreeNode sourceNode, ClusterNode aClusterToWorkWith) {
        this.mySourceVolume = sourceNode;
        this.myClusterToWorkWith = aClusterToWorkWith;
    }

    public void setOwner(JFrame owner) {
        this.owner = owner;
    }

    public ClusterNode getWorkingCluster() {
        return this.myClusterToWorkWith;
    }

    public void setWorkingCluster(ClusterNode aCluster) {
        this.myClusterToWorkWith = aCluster;
    }

    public abstract Collection<SrFuture<Void>> operate(VolumeTreeNode<?> var1);

    public abstract boolean isVolumeOperation();

    public String isOperationLegitimate(VolumeTreeNode<?> volumeNode) {
        if (volumeNode.equals(this.mySourceVolume)) {
            return "The source of the operation cannot be its target";
        }
        return null;
    }

    public abstract String getOperationName();

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getOperationName());
        buffer.append(" (");
        buffer.append(this.mySourceVolume.toString());
        buffer.append(")");
        return buffer.toString();
    }

    public abstract boolean shouldBlockAction();

    public Icon getIconForOperation() {
        return null;
    }

    public void initAction(SrAction action) {
    }
}

