/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.volume;

import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.server.logic.volume.Volume;
import com.sanrad.nms.server.util.types.constants.VolumeStateConstant;
import java.math.BigInteger;
import java.rmi.RemoteException;

public abstract class VolumeNode<T extends Volume>
extends VolumeTreeNode<T> {
    private Integer state = null;
    private Double blockNum = null;
    private Integer blockSize = null;
    private BigInteger potentialSpace;
    private String volType;
    public static final String VOLUME_TYPE_CONCAT = "Concat";
    public static final String VOLUME_TYPE_MIRROR = "Mirror";
    public static final String VOLUME_TYPE_STRIP = "Stripe";
    public static final String VOLUME_TYPE_SNAPSHOT = "Snapshot";
    public static final String VOLUME_TYPE_CUBE = "Cube";
    public static final String VOLUME_TYPE_TRANSPARENT = "Transparent";
    public static final String VOLUME_TYPE_JOURNAL = "Journal";

    protected VolumeNode(T stub, String alias, boolean exposed, String type) throws RemoteException {
        super(stub, alias, exposed);
        this.volType = type;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public void setBlockNum(Double blockNum) {
        this.blockNum = blockNum;
    }

    public void setBlockSize(Integer blockSize) {
        this.blockSize = blockSize;
    }

    public Integer getState() {
        return this.state;
    }

    public Double getBlockNum() {
        return this.blockNum;
    }

    @Override
    public Integer getBlockSize() {
        return this.blockSize;
    }

    public String getVolType() {
        return this.volType;
    }

    @Override
    public String type() {
        return "Volume";
    }

    public void setPotentialSpace(BigInteger potentialSpace) {
        this.potentialSpace = potentialSpace;
    }

    public BigInteger getPotentialSpace() {
        return this.potentialSpace;
    }

    @Override
    public boolean isConfigured() {
        return this.isInState(VolumeStateConstant.VOLUME_STATE_NON_VALIDATE);
    }
}

