/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.volume;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.comm.Communication;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.LUNode;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.alarm.AlarmsManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.DRASyncPairNode;
import com.sanrad.nms.client.data.dr.DRPairManager;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.dr.SrPairDetailsTableModel;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceManager;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.StorageDeviceNode;
import com.sanrad.nms.client.data.storage.StorageManager;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceNode;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.volume.ConcatinationVolumeNode;
import com.sanrad.nms.client.data.volume.CubeVolumeNode;
import com.sanrad.nms.client.data.volume.ExposedVolumesTableModelCollection;
import com.sanrad.nms.client.data.volume.JournalVolumeNode;
import com.sanrad.nms.client.data.volume.MirrorVolumeNode;
import com.sanrad.nms.client.data.volume.NotExposedVolumeTreeModelCollection;
import com.sanrad.nms.client.data.volume.SnapshotVolumeNode;
import com.sanrad.nms.client.data.volume.SrExposedVolumesTableModel;
import com.sanrad.nms.client.data.volume.SrNotExposedVolumeTreeModel;
import com.sanrad.nms.client.data.volume.StripeVolumeNode;
import com.sanrad.nms.client.data.volume.TransparentVolumeNode;
import com.sanrad.nms.client.data.volume.VirtualVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.volume.copy.CopyOperManager;
import com.sanrad.nms.client.data.volume.snapshot.ClusterSnapshotMap;
import com.sanrad.nms.client.data.volume.snapshot.SnapshotSchedulerManager;
import com.sanrad.nms.client.data.volume.snapshot.SnapshotSchedulerNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.alarm.PropagatedStateEvent;
import com.sanrad.nms.client.event.volume.VolumeEvent;
import com.sanrad.nms.client.event.volume.VolumeListener;
import com.sanrad.nms.client.event.volume.snapshot.SnapshotEvent;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.dr.SrCreateJournalDlg;
import com.sanrad.nms.client.gui.volume.ExposedVolumesTableHeader;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.lu.LU;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDevice;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDevice;
import com.sanrad.nms.server.logic.storage.Storage;
import com.sanrad.nms.server.logic.volume.ConcatinationVolume;
import com.sanrad.nms.server.logic.volume.CubeVolume;
import com.sanrad.nms.server.logic.volume.JournalVolume;
import com.sanrad.nms.server.logic.volume.MirrorVolume;
import com.sanrad.nms.server.logic.volume.SnapshotVolume;
import com.sanrad.nms.server.logic.volume.StripeVolume;
import com.sanrad.nms.server.logic.volume.TransparentVolume;
import com.sanrad.nms.server.logic.volume.Volume;
import com.sanrad.nms.server.logic.volume.VolumeTree;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.constants.DRModeConstant;
import com.sanrad.nms.server.util.types.constants.DRPairTypeConstant;
import com.sanrad.nms.server.util.types.constants.DRReplicationStateConstant;
import com.sanrad.nms.server.util.types.constants.JournalErrorStatusConstant;
import com.sanrad.nms.server.util.types.constants.JournalOperStatusConstant;
import com.sanrad.nms.server.util.types.constants.JournalVolumeActivityConstants;
import com.sanrad.nms.server.util.types.constants.SnapshotActivateTypeConstants;
import com.sanrad.nms.server.util.types.constants.SnapshotConfigFlagsConstant;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.nms.server.util.types.constants.VolumeStateConstant;
import com.sanrad.swing.actions.OperationController;
import com.sanrad.swing.actions.View;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.Util;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;

public class VolumeManager
extends ElementManager {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static VolumeManager theInstance = null;
    public static final List<Character> INVALID_ALIAS_CHARS = Arrays.asList(Character.valueOf('&'), Character.valueOf('#'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('!'), Character.valueOf('*'));
    public static final String INVALID_ALIAS_CHARS_REGEX = "[\\&#\\+\\-!\\*]";
    private ClusterSnapshotMap clusterSnapshotMap = new ClusterSnapshotMap();
    private Map<String, JournalVolumeNode> m_vswitchToJournalMap = new HashMap<String, JournalVolumeNode>();
    private DROfflineLocalCopyValidator m_drLocalCopyValidator = new DROfflineLocalCopyValidator();
    public static final int JOURNAL_DEFAULT_THRESHOLD_VALUE = Integer.parseInt(ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.JOURNAL_DEFAULT_THRESHOLD));
    public static final int SNAPSHOT_DEFAULT_THRESHOLD_VALUE = Integer.parseInt(ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNAPSHOT_DEFAULT_THRESHOLD));
    public static int MAX_SNAPSHOTS_PER_VOLUME;
    SrEventListenerManager.Informer volumeStatusChangedInformer = new SrEventListenerManager.Informer<VolumeListener, VolumeEvent>(){

        @Override
        public void inform(VolumeListener listener, VolumeEvent event) {
            listener.volumeStatusChanged(event);
        }
    };
    SrEventListenerManager.Informer volumeStateChangedInformer = new SrEventListenerManager.Informer<VolumeListener, VolumeEvent>(){

        @Override
        public void inform(VolumeListener listener, VolumeEvent event) {
            listener.volumeStateChanged(event);
        }
    };
    SrEventListenerManager.Informer snapshotVolActiveStateChangedInformer = new SrEventListenerManager.Informer<VolumeListener, VolumeEvent>(){

        @Override
        public void inform(VolumeListener listener, VolumeEvent event) {
            listener.snapshotVolActiveStateChanged(event);
        }
    };
    SrEventListenerManager.Informer volumeCapacityChangedInformer = new SrEventListenerManager.Informer<VolumeListener, VolumeEvent>(){

        @Override
        public void inform(VolumeListener listener, VolumeEvent event) {
            listener.volumeCapacityChanged(event);
        }
    };
    SrEventListenerManager.Informer volumeCreateInformer = new SrEventListenerManager.Informer<VolumeListener, VolumeEvent>(){

        @Override
        public void inform(VolumeListener listener, VolumeEvent event) {
            listener.volumeCreate(event);
        }
    };
    AddVolumeNodeToParentInformer addVolumeNodeToParentInformer = new AddVolumeNodeToParentInformer();
    RemoveVolumeNodeFromParentInformer removeVolumeNodeFromParentInformer = new RemoveVolumeNodeFromParentInformer();
    SrEventListenerManager.Informer journalVolDateAndTimeChangedInformer = new SrEventListenerManager.Informer<VolumeListener, VolumeEvent>(){

        @Override
        public void inform(VolumeListener listener, VolumeEvent event) {
            listener.journalVolDateAndTimeChanged(event);
        }
    };
    SrEventListenerManager.Informer journalVolPercentageUtilizationChangedInformer = new SrEventListenerManager.Informer<VolumeListener, VolumeEvent>(){

        @Override
        public void inform(VolumeListener listener, VolumeEvent event) {
            listener.journalVolPercentageUtilizationChanged(event);
        }
    };
    SrEventListenerManager.Informer journalVolPercentageThresholdChangedInformer = new SrEventListenerManager.Informer<VolumeListener, VolumeEvent>(){

        @Override
        public void inform(VolumeListener listener, VolumeEvent event) {
            listener.journalVolPercentageThresholdChanged(event);
        }
    };
    SrEventListenerManager.Informer journalVolActivityStateChangedInformer = new SrEventListenerManager.Informer<VolumeListener, VolumeEvent>(){

        @Override
        public void inform(VolumeListener listener, VolumeEvent event) {
            listener.journalVolActivityStateChanged(event);
        }
    };
    SrEventListenerManager.Informer journalVolActivateOnVSwitchChangedInformer = new SrEventListenerManager.Informer<VolumeListener, VolumeEvent>(){

        @Override
        public void inform(VolumeListener listener, VolumeEvent event) {
            listener.journalVolActivateOnVSwitchChanged(event);
        }
    };
    SrEventListenerManager.Informer volumeRemoveInformer = new SrEventListenerManager.Informer<VolumeListener, VolumeEvent>(){

        @Override
        public void inform(VolumeListener listener, VolumeEvent event) {
            listener.volumeRemove(event);
        }
    };
    SrEventListenerManager.Informer volumeParametersChangedInformer = new SrEventListenerManager.Informer<VolumeListener, VolumeEvent>(){

        @Override
        public void inform(VolumeListener listener, VolumeEvent event) {
            listener.volumeParametersChanged(event);
        }
    };
    SrEventListenerManager.Informer snapshotSourceChangedInformer = new SrEventListenerManager.Informer<VolumeListener, VolumeEvent>(){

        @Override
        public void inform(VolumeListener listener, VolumeEvent event) {
            listener.snapshotSourceChanged(event);
        }
    };
    SrEventListenerManager.Informer volumeAliasChangedInformer = new SrEventListenerManager.Informer<VolumeListener, VolumeEvent>(){

        @Override
        public void inform(VolumeListener listener, VolumeEvent event) {
            listener.volumeAliasChanged(event);
        }
    };
    SrEventListenerManager.Informer volumeExposedInformer = new SrEventListenerManager.Informer<VolumeListener, VolumeEvent>(){

        @Override
        public void inform(VolumeListener listener, VolumeEvent event) {
            listener.volumeExposed(event);
        }
    };
    SrEventListenerManager.Informer volumeConfigChangedInformer = new SrEventListenerManager.Informer<VolumeListener, VolumeEvent>(){

        @Override
        public void inform(VolumeListener listener, VolumeEvent event) {
            listener.volumeConfigChanged(event);
        }
    };
    SrEventListenerManager.Informer volumeDeExposedInformer = new SrEventListenerManager.Informer<VolumeListener, VolumeEvent>(){

        @Override
        public void inform(VolumeListener listener, VolumeEvent event) {
            listener.volumeDeExposed(event);
        }
    };

    private VolumeManager() {
    }

    public static VolumeManager getInstance() {
        if (theInstance == null) {
            theInstance = new VolumeManager();
        }
        return theInstance;
    }

    public static void setMaxSnapshotsPerVolume(int aMaxNumber) {
        MAX_SNAPSHOTS_PER_VOLUME = aMaxNumber;
    }

    public ClusterSnapshotMap getClusterSnapshotMap() {
        return this.clusterSnapshotMap;
    }

    public DROfflineLocalCopyValidator getDROfflineLocalCopyValidator() {
        return this.m_drLocalCopyValidator;
    }

    public void addVolumeListener(VolumeListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeVolumeListener(VolumeListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    public List<TargetNode> filterTargetsForSnapshotVolume(List<TargetNode> aTargetList, SnapshotVolumeNode snapshot) {
        VolumeTreeNode<?> source = snapshot.getSourceVolume();
        if (!source.isExposed()) {
            return aTargetList;
        }
        ArrayList<TargetNode> filterTargets = new ArrayList<TargetNode>();
        TargetNode targetNode = source.getLUNode().getTargetParent();
        String vSwitch = targetNode.getExposedOnVSwitchName();
        for (TargetNode target : aTargetList) {
            if (!target.getExposedOnVSwitchName().equalsIgnoreCase(vSwitch)) continue;
            filterTargets.add(target);
        }
        return filterTargets;
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        if (this.alreadyExist(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "VolumeManager: volume created.");
        Volume volume = (Volume)element;
        HashMap params = this.getParameterList(e);
        VolumeNode node = this.createVolumeNode(volume, params);
        theLogger.trace(SrLogCategories.LEGACY, "VolumeManager: volume created: alias: ", node.getAlias());
        this.updateDirectAccessDeviceChildren(node);
        this.fireVolumeCreated(node);
    }

    private void updateDirectAccessDeviceChildren(VolumeTreeNode volumeNode) {
        try {
            Vector children = VolumeManager.getChildrenStubs(volumeNode);
            Enumeration iter = children.elements();
            while (iter.hasMoreElements()) {
                RemoteObject childStub = (RemoteObject)iter.nextElement();
                if (!(childStub instanceof DirectAccessDevice)) continue;
                DirectAccessDeviceNode childNode = (DirectAccessDeviceNode)SystemRootNode.getInstance().getRefByStub(childStub);
                childNode.setNonAllocatedSpace(((DirectAccessDevice)childStub).getNonAllocatedSpace());
                DirectAccessDeviceManager.getInstance().fireDirectAccessDeviceChanged(childNode);
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
        }
    }

    @Override
    public void alreadyKnownByVSwitch(CommunicationEvent e) {
    }

    @Override
    public void propagatedStateChanged(PropagatedStateEvent e) {
        RemoteObject element = e.getStub();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        if (element instanceof Volume) {
            VolumeTreeNode volumeNode = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(element);
            if (volumeNode == null) {
                theLogger.trace(SrLogCategories.LEGACY, "VolumeManager- propagatedStateChanged() on an unknown element !");
                return;
            }
            theLogger.trace(SrLogCategories.LEGACY, "VolumeManager: Volume propagated state changed.");
            super.propagatedStateChanged(e);
            VolumeEvent event = new VolumeEvent((Object)this, volumeNode);
            this.fireStatusChanged(event);
        }
    }

    public void fireStatusChanged(VolumeEvent event) {
        this.m_listeners.fireEvent(VolumeListener.class, event, this.volumeStatusChangedInformer);
    }

    private void fireVolumeStateChanged(VolumeTreeNode node) {
        VolumeEvent event = this.createVolumeEvent(node);
        this.m_listeners.fireEvent(VolumeListener.class, event, this.volumeStateChangedInformer);
    }

    private void fireSnapshotVolActivationStateChanged(SnapshotVolumeNode node) {
        SnapshotEvent event = new SnapshotEvent((Object)this, node);
        event.setActivatedState(node.isActivated());
        this.m_listeners.fireEvent(VolumeListener.class, event, this.snapshotVolActiveStateChangedInformer);
    }

    private void fireVolumeCapacityChanged(VolumeTreeNode node) {
        VolumeEvent event = this.createVolumeEvent(node);
        this.m_listeners.fireEvent(VolumeListener.class, event, this.volumeCapacityChangedInformer);
    }

    private void fireVolumeCreated(VolumeTreeNode node) {
        VolumeEvent event = this.createVolumeEvent(node);
        this.m_listeners.fireEvent(VolumeListener.class, event, this.volumeCreateInformer);
    }

    private void fireAddVolumeNodeToParent(VolumeTreeNode parentNode, VolumeTreeNode childNode) {
        VolumeEvent event = this.createVolumeEvent(parentNode);
        this.addVolumeNodeToParentInformer.setParentNode(parentNode);
        this.addVolumeNodeToParentInformer.setChildNode(childNode);
        this.m_listeners.fireEvent(VolumeListener.class, event, this.addVolumeNodeToParentInformer);
        this.addVolumeNodeToParentInformer.setParentNode(null);
        this.addVolumeNodeToParentInformer.setChildNode(null);
    }

    private void fireRemoveVolumeNodeToParent(VolumeTreeNode childNode) {
        VolumeEvent event = this.createVolumeEvent(childNode);
        this.removeVolumeNodeFromParentInformer.setChildNode(childNode);
        this.m_listeners.fireEvent(VolumeListener.class, event, this.removeVolumeNodeFromParentInformer);
        this.removeVolumeNodeFromParentInformer.setChildNode(null);
    }

    private void fireJournalVolDateAndTimeChanged(VolumeTreeNode childNode) {
        VolumeEvent event = this.createVolumeEvent(childNode);
        this.m_listeners.fireEvent(VolumeListener.class, event, this.journalVolDateAndTimeChangedInformer);
    }

    private void fireJournalVolPercentageUtilizationChanged(VolumeTreeNode childNode) {
        VolumeEvent event = this.createVolumeEvent(childNode);
        this.m_listeners.fireEvent(VolumeListener.class, event, this.journalVolPercentageUtilizationChangedInformer);
    }

    private void fireJournalVolPercentageThresholdChanged(VolumeTreeNode childNode) {
        VolumeEvent event = this.createVolumeEvent(childNode);
        this.m_listeners.fireEvent(VolumeListener.class, event, this.journalVolPercentageThresholdChangedInformer);
    }

    private void fireJournalVolActivityStateChanged(VolumeTreeNode childNode) {
        VolumeEvent event = this.createVolumeEvent(childNode);
        this.m_listeners.fireEvent(VolumeListener.class, event, this.journalVolActivityStateChangedInformer);
    }

    private void fireJournalVolActivateOnVSwitchChanged(VolumeTreeNode childNode) {
        VolumeEvent event = this.createVolumeEvent(childNode);
        this.m_listeners.fireEvent(VolumeListener.class, event, this.journalVolActivateOnVSwitchChangedInformer);
    }

    public static Vector getChildrenStubs(VolumeTreeNode node) {
        Vector stubs = new Vector();
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            VolumeTreeNode child = (VolumeTreeNode)e.nextElement();
            stubs.addElement(child.getStub());
        }
        return stubs;
    }

    public static Vector getChildrenNodes(VolumeTreeNode node) {
        Vector<SrTreeNode> nodes = new Vector<SrTreeNode>();
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            VolumeTreeNode child = (VolumeTreeNode)e.nextElement();
            nodes.addElement(SystemRootNode.getInstance().getRefByStub((RemoteObject)child.getStub()));
        }
        return nodes;
    }

    private void addVolumeChild(VolumeTreeNode parentNode, VolumeTreeNode childNode) {
        if (childNode.getParent() instanceof VolumeTreeNode) {
            this.fireRemoveVolumeNodeToParent(childNode);
        }
        theLogger.trace(SrLogCategories.LEGACY, "VolumeManager: adding ", childNode.getAlias(), "to ", parentNode.getAlias(), " as a child.");
        this.fireAddVolumeNodeToParent(parentNode, childNode);
        childNode.setConfigurationParent(parentNode);
        childNode.setLUNode(null);
    }

    private VolumeNode createVolumeNode(Volume stub, HashMap params) {
        VolumeNode volume = null;
        try {
            Object aliasObj = this.getObjectForParam(params, ClientParameterCode.VOLUME_ALIAS, true);
            Object isExposedObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.VOLUME_EXPOSED", true);
            Object blockSizeObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.VOLUME_BLOCK_SIZE", true);
            Object potentialSpaceObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.VOLUME_POTENTIAL_SPACE", true);
            List<? extends com.sanrad.nms.server.logic.volume.VolumeNode> childrenObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.VOLUME_CHILDREN", true);
            Volume parentObj = (Volume)this.getObjectForParam(params, "Missing code - ClientParameterCode.VOLUME_PARENT", true);
            LU parentLUObj = (LU)this.getObjectForParam(params, "Missing code - ClientParameterCode.VOLUME_PARENT_LU", true);
            Object allocatedSpaceObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.VOLUME_ALLOCATED_SPACE", true);
            Object accessibleSpaceObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.VOLUME_ACCESSIBLE_SPACE", true);
            Object volStateObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.VOLUME_STATE", true);
            Object positionInParentObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.VOLUME_POSITION_IN_PARENT", true);
            Object propagatedState = this.getObjectForParam(params, "Missing code - ClientParameterCode.PROPAGATED_STATE", true);
            if (aliasObj == null) {
                aliasObj = stub.getAlias();
            }
            if (isExposedObj == null) {
                isExposedObj = new Boolean(stub.isExposed());
            }
            if (blockSizeObj == null) {
                blockSizeObj = new Integer(stub.getBlockSize());
            }
            if (potentialSpaceObj == null) {
                potentialSpaceObj = stub.getPotentialCapacity();
            }
            if (childrenObj == null) {
                childrenObj = stub.getChildren();
            }
            if (parentObj == null) {
                parentObj = stub.getParentVolume();
            }
            if (parentLUObj == null) {
                parentLUObj = stub.getParentLU();
            }
            if (allocatedSpaceObj == null) {
                allocatedSpaceObj = stub.getAllocatedSpace();
            }
            if (accessibleSpaceObj == null) {
                accessibleSpaceObj = stub.getAccessibleSpace();
            }
            if (volStateObj == null) {
                volStateObj = stub.getVolumeState();
            }
            if (positionInParentObj == null) {
                positionInParentObj = stub.getPositionInParent();
            }
            if (propagatedState == null) {
                propagatedState = stub.getPropagatedState();
            }
            String alias = (String)aliasObj;
            boolean exposed = (Boolean)isExposedObj;
            BigInteger accessibleSpace = (BigInteger)accessibleSpaceObj;
            Integer blockSize = (Integer)blockSizeObj;
            BigInteger allocatedSpace = (BigInteger)allocatedSpaceObj;
            BigInteger potentialSpace = (BigInteger)potentialSpaceObj;
            Integer position = (Integer)positionInParentObj;
            SrTreeNode exist = SystemRootNode.getInstance().getRefByStub(stub);
            if (exist != null) {
                return this.updateExistingNode((VolumeNode)exist, stub);
            }
            volume = this.createVolume(stub, alias, exposed, blockSize, params);
            volume.setAccessibleSpace(accessibleSpace);
            volume.setPotentialSpace(potentialSpace);
            volume.setAllocatedSpace(allocatedSpace);
            volume.setVolStateBits((SrBITSConstant)volStateObj);
            volume.setPositionInParent(position);
            volume.setStatus(VolumeManager.getSeverity((AlarmSeverity)propagatedState));
            SystemRootNode.getInstance().putRefAndStub(stub, volume);
            if (volume instanceof ConcatinationVolumeNode) {
                Object isExpandableObj = this.getObjectForParam(params, ClientParameterCode.VOLUME_EXPANDABLE, true);
                Object isRetractableObj = this.getObjectForParam(params, ClientParameterCode.VOLUME_RETRACTABLE, true);
                if (isExpandableObj == null) {
                    isExpandableObj = new Boolean(((ConcatinationVolume)stub).isExpandable());
                }
                if (isRetractableObj == null) {
                    isRetractableObj = new Boolean(((ConcatinationVolume)stub).isRetractable());
                }
                ((ConcatinationVolumeNode)volume).setExpandable((Boolean)isExpandableObj);
                ((ConcatinationVolumeNode)volume).setRetractable((Boolean)isRetractableObj);
            }
            List<? extends com.sanrad.nms.server.logic.volume.VolumeNode> children = childrenObj;
            int childrenSize = children.size();
            theLogger.trace(SrLogCategories.LEGACY, "create Volume: volume ", volume.getAlias(), " has ", childrenSize, " children");
            for (int i = 0; i < childrenSize; ++i) {
                com.sanrad.nms.server.logic.volume.VolumeNode childStub = children.get(i);
                SrTreeNode child = SystemRootNode.getInstance().getRefByStub(childStub);
                if (child != null) {
                    this.addVolumeChild(volume, (VolumeTreeNode)child);
                    continue;
                }
                if (!(childStub instanceof Volume)) continue;
                this.addVolumeChild(volume, this.createVolumeNode((Volume)childStub, null));
            }
            SrTreeNode parentNode = SystemRootNode.getInstance().getRefByStub(parentObj);
            if (parentNode != null) {
                Enumeration<TreeNode> iter = ((VolumeTreeNode)parentNode).children();
                while (iter.hasMoreElements()) {
                    if (!iter.nextElement().equals(volume)) continue;
                    return volume;
                }
                theLogger.trace(SrLogCategories.LEGACY, "VolumeManager: adding ", volume.getAlias(), " to ", ((VolumeTreeNode)parentNode).getAlias(), " as a child");
                SrNotExposedVolumeTreeModel model = (SrNotExposedVolumeTreeModel)NotExposedVolumeTreeModelCollection.getInstance().getModel((RemoteObject)SystemRootNode.getInstance().getClusterNodeOfSource(volume).getStub());
                model.insertVolumeNodeToModel(volume, (VolumeTreeNode)parentNode);
            } else {
                parentNode = SystemRootNode.getInstance().getRefByStub(parentLUObj);
                if (parentNode != null) {
                    ((LUNode)parentNode).setVolumeChild(volume);
                    volume.setLUNode((LUNode)parentNode);
                    this.fireVolumeConfigChanged(volume);
                }
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            VolumeManager.onConnectionError("Failed to create the Volume.");
        }
        return volume;
    }

    public void updateVolumeDataFromServer(VolumeNode volume) {
        Volume stub = (Volume)volume.getStub();
        try {
            volume.setAlias(stub.getAlias());
            volume.setExposed(stub.isExposed());
            volume.setVolStateBits(stub.getVolumeState());
            volume.setBlockSize(new Integer(stub.getBlockSize()));
            volume.setAccessibleSpace(stub.getAccessibleSpace());
            volume.setPotentialSpace(stub.getPotentialCapacity());
            volume.setAllocatedSpace(stub.getAllocatedSpace());
            volume.setPositionInParent(stub.getPositionInParent());
            volume.setStatus(VolumeManager.getSeverity(stub.getPropagatedState()));
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            VolumeManager.onConnectionError("Failed to read Volume data from server.");
        }
    }

    public void updateVolumeCapacityFromServer(VolumeNode volume) {
        Volume stub = (Volume)volume.getStub();
        try {
            volume.setAccessibleSpace(stub.getAccessibleSpace());
            volume.setPotentialSpace(stub.getPotentialCapacity());
            volume.setAllocatedSpace(stub.getAllocatedSpace());
            volume.setPositionInParent(stub.getPositionInParent());
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            VolumeManager.onConnectionError("Failed to read Volume data from server.");
        }
    }

    private VolumeNode updateExistingNode(VolumeNode exist, Object stub) {
        return exist;
    }

    private VolumeNode createVolume(Volume stub, String alias, boolean exposed, Integer blockSize, HashMap params) {
        VolumeNode volume = null;
        try {
            if (stub instanceof CubeVolume) {
                volume = new CubeVolumeNode((CubeVolume)stub, alias, exposed);
                volume.setBlockSize(blockSize);
            } else if (stub instanceof ConcatinationVolume) {
                volume = new ConcatinationVolumeNode((ConcatinationVolume)stub, alias, exposed);
                ((ConcatinationVolumeNode)volume).setBlockSize(blockSize);
            } else if (stub instanceof MirrorVolume) {
                volume = new MirrorVolumeNode((MirrorVolume)stub, alias, exposed);
                ((MirrorVolumeNode)volume).setBlockSize(blockSize);
            } else if (stub instanceof StripeVolume) {
                volume = new StripeVolumeNode(stub, alias, exposed);
                Object stripeSizeObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.VOLUME_STRIPE_SIZE", true);
                if (stripeSizeObj == null) {
                    stripeSizeObj = ((StripeVolume)stub).getStripeSize();
                }
                BigInteger stripeSize = (BigInteger)stripeSizeObj;
                ((StripeVolumeNode)volume).setStripeSize(stripeSize);
                ((StripeVolumeNode)volume).setBlockSize(blockSize);
            } else if (stub instanceof TransparentVolume) {
                volume = new TransparentVolumeNode((TransparentVolume)stub, alias, exposed);
                ((TransparentVolumeNode)volume).setBlockSize(blockSize);
            } else if (stub instanceof SnapshotVolume) {
                volume = new SnapshotVolumeNode((SnapshotVolume)stub, alias, exposed);
                SnapshotVolumeNode snapshotVolumeNode = (SnapshotVolumeNode)volume;
                snapshotVolumeNode.setBlockSize(blockSize);
                SnapshotVolume snapshotVolume = (SnapshotVolume)stub;
                Object dateAndTimeObj = this.getObjectForParam(params, ClientParameterCode.SNAPSHOT_VOLUME_DATE_AND_TIME, true);
                Object percentLoadObj = this.getObjectForParam(params, ClientParameterCode.SNAPSHOT_VOLUME_LOAD, true);
                Object percentThreshObj = this.getObjectForParam(params, ClientParameterCode.SNAPSHOT_VOLUME_THRESHOLD, true);
                com.sanrad.nms.server.logic.volume.VolumeNode snapSourceStub = (com.sanrad.nms.server.logic.volume.VolumeNode)this.getObjectForParam(params, ClientParameterCode.SNAPSHOT_VOLUME_SOURCE, true);
                Object isActivatedObj = this.getObjectForParam(params, ClientParameterCode.SNAPSHOT_ACTIVATE, true);
                SnapshotConfigFlagsConstant snapConfigFlags = (SnapshotConfigFlagsConstant)this.getObjectForParam(params, ClientParameterCode.SNAPSHOT_VOLUME_CONFIG_FLAGS, true);
                if (dateAndTimeObj == null) {
                    dateAndTimeObj = snapshotVolume.getDateAndTime();
                }
                if (percentLoadObj == null) {
                    percentLoadObj = new Integer(snapshotVolume.getPercentageLoad());
                }
                if (percentThreshObj == null) {
                    percentThreshObj = new Integer(snapshotVolume.getPercentageThreshold());
                }
                if (snapSourceStub == null) {
                    snapSourceStub = snapshotVolume.getSourceVolume();
                }
                if (isActivatedObj == null) {
                    isActivatedObj = snapshotVolume.getActivatedState();
                }
                Long dateAndTime = (Long)dateAndTimeObj;
                int percentLoad = (Integer)percentLoadObj;
                int percentThresh = (Integer)percentThreshObj;
                SrTreeNode volumeSource = SystemRootNode.getInstance().getRefByStub(snapSourceStub);
                if (dateAndTime != null) {
                    snapshotVolumeNode.setDateAndTime(new Date(dateAndTime));
                }
                snapshotVolumeNode.setPercentageLoad(percentLoad);
                snapshotVolumeNode.setPercentageThreshold(percentThresh);
                snapshotVolumeNode.setSourceVolume((VolumeTreeNode)volumeSource);
                if (isActivatedObj instanceof Integer) {
                    isActivatedObj = SnapshotActivateTypeConstants.getSnapshotActivateTypeConstants((Integer)isActivatedObj);
                }
                if (isActivatedObj != null) {
                    snapshotVolumeNode.setActivatedState((SnapshotActivateTypeConstants)isActivatedObj);
                }
                snapshotVolumeNode.setConfigFlags(snapConfigFlags);
                ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfStub(snapshotVolume);
                this.clusterSnapshotMap.addSnapshotVolume(clusterNode, snapshotVolumeNode);
            } else if (stub instanceof JournalVolume) {
                JournalVolume journalStub = (JournalVolume)stub;
                VSwitch activeOnVSwitchIDObj = (VSwitch)this.getObjectForParam(params, ClientParameterCode.JOURNAL_VOLUME_ACTIVE_ON_VSWITCH_ID, true);
                if (activeOnVSwitchIDObj == null) {
                    activeOnVSwitchIDObj = journalStub.getActiveOnVSwitch();
                }
                volume = new JournalVolumeNode(journalStub, alias, activeOnVSwitchIDObj);
                JournalVolumeNode journalVolumeNode = (JournalVolumeNode)volume;
                journalVolumeNode.setBlockSize(blockSize);
                Long dateAndTimeObj = (Long)this.getObjectForParam(params, ClientParameterCode.JOURNAL_VOLUME_DATE_AND_TIME, true);
                Integer percentUtilizationObj = (Integer)this.getObjectForParam(params, ClientParameterCode.JOURNAL_VOLUME_PRECENT_UTILIZATION, true);
                Integer percentThreshObj = (Integer)this.getObjectForParam(params, ClientParameterCode.JOURNAL_VOLUME_PRECENT_THRESH, true);
                JournalVolumeActivityConstants activityStateObj = (JournalVolumeActivityConstants)this.getObjectForParam(params, ClientParameterCode.JOURNAL_VOLUME_ACTIVITY, true);
                JournalOperStatusConstant journalOperStatus = (JournalOperStatusConstant)this.getObjectForParam(params, ClientParameterCode.JOURNAL_VOLUME_OPER_STATUS, true);
                JournalErrorStatusConstant journalErrorStatus = (JournalErrorStatusConstant)this.getObjectForParam(params, ClientParameterCode.JOURNAL_VOLUME_ERROR_STATUS, true);
                if (dateAndTimeObj == null) {
                    dateAndTimeObj = journalStub.getDateAndTime();
                }
                if (dateAndTimeObj != null) {
                    journalVolumeNode.setDateAndTime(dateAndTimeObj);
                }
                if (percentUtilizationObj == null) {
                    percentUtilizationObj = journalStub.getPercentageUtilization();
                }
                if (percentUtilizationObj != null) {
                    journalVolumeNode.setPercentageUtilization(percentUtilizationObj);
                }
                if (percentThreshObj == null) {
                    percentThreshObj = journalStub.getPercentageThreshold();
                }
                if (percentThreshObj != null) {
                    journalVolumeNode.setPercentageThreshold(percentThreshObj);
                }
                if (activeOnVSwitchIDObj != null) {
                    if (activityStateObj == null) {
                        activityStateObj = journalStub.getActivityState(activeOnVSwitchIDObj.getCommKeyClassId());
                    }
                    VSwitchNode activeOnVSwitch = (VSwitchNode)SystemRootNode.getInstance().getRefByStub(activeOnVSwitchIDObj);
                    String vswitchIP = null;
                    vswitchIP = activeOnVSwitch != null ? activeOnVSwitch.getIPAddress() : activeOnVSwitchIDObj.getMgmIPAddr();
                    this.m_vswitchToJournalMap.put(vswitchIP, journalVolumeNode);
                    journalVolumeNode.setActivateOnVSwitch(activeOnVSwitchIDObj);
                }
                if (activityStateObj != null) {
                    journalVolumeNode.setActivityState(activityStateObj);
                }
                journalVolumeNode.setOperationalStatus(journalOperStatus);
                journalVolumeNode.setErrorStatus(journalErrorStatus);
            } else {
                if (stub instanceof GeneralSCSIDevice) {
                    throw new RuntimeException("stub instanceof GeneralSCSIDevice");
                }
                if (stub instanceof SubDirectAccessDevice) {
                    theLogger.trace(SrLogCategories.LEGACY, "stub instanceof SubDirectAccessDevice");
                }
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            VolumeManager.onConnectionError("Failed to create the volume.");
        }
        return volume;
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "VolumeManager: volume removed");
        VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(element);
        if (volume != null) {
            theLogger.trace(SrLogCategories.LEGACY, "VolumeManager: volume removed - alias- ", volume.getAlias());
            this.updateDirectAccessDeviceChildren(volume);
            VolumeEvent event = this.createVolumeEvent(volume);
            this.m_listeners.fireEvent(VolumeListener.class, event, this.volumeRemoveInformer);
        }
        if (volume instanceof SnapshotVolumeNode) {
            ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfStub(element);
            this.clusterSnapshotMap.removeSnapshotVolume(clusterNode, (SnapshotVolumeNode)volume);
        } else if (volume instanceof JournalVolumeNode && ((JournalVolumeNode)volume).getActiveOnVSwitchNode() != null) {
            this.m_vswitchToJournalMap.remove(((JournalVolumeNode)volume).getActiveOnVSwitchNode().getIPAddress());
        }
        SystemRootNode.getInstance().removeRefAndIdByStub(element);
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        HashMap params = this.getParameterList(e);
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(element);
        theLogger.trace(SrLogCategories.LEGACY, "VolumeManager: ", node, "elementChanged().");
        Object aliasChanged = this.getObjectForParam(params, ClientParameterCode.VOLUME_ALIAS, false);
        Object exposed = this.getObjectForParam(params, ClientParameterCode.VOLUME_EXPOSED, false);
        Object[] children = (Object[])this.getObjectForParam(params, ClientParameterCode.VOLUME_CHILDREN, false);
        Object state = this.getObjectForParam(params, ClientParameterCode.VOLUME_STATE, false);
        boolean capacityWasChanged = this.getObjectForParam(params, ClientParameterCode.VOLUME_SPACE, false) == null;
        Object isExpnadable = this.getObjectForParam(params, ClientParameterCode.VOLUME_EXPANDABLE, false);
        Object isRetractable = this.getObjectForParam(params, ClientParameterCode.VOLUME_RETRACTABLE, false);
        Object snapshotLoad = this.getObjectForParam(params, ClientParameterCode.SNAPSHOT_VOLUME_LOAD, false);
        Object snapshotThresh = this.getObjectForParam(params, ClientParameterCode.SNAPSHOT_VOLUME_THRESHOLD, false);
        com.sanrad.nms.server.logic.volume.VolumeNode snapshotSource = (com.sanrad.nms.server.logic.volume.VolumeNode)this.getObjectForParam(params, ClientParameterCode.SNAPSHOT_VOLUME_SOURCE, false);
        Object snapshotDateAndTime = this.getObjectForParam(params, ClientParameterCode.SNAPSHOT_VOLUME_DATE_AND_TIME, false);
        Object snapshotActivatedState = this.getObjectForParam(params, ClientParameterCode.SNAPSHOT_ACTIVATE, false);
        SnapshotConfigFlagsConstant snapshotConfigFlags = (SnapshotConfigFlagsConstant)this.getObjectForParam(params, ClientParameterCode.SNAPSHOT_VOLUME_CONFIG_FLAGS, false);
        VolumeTreeNode volNode = (VolumeTreeNode)node;
        try {
            if (node != null) {
                theLogger.trace(SrLogCategories.LEGACY, "VolumeManager: elementChanged(). the volume is ", volNode.getAlias());
                if (children != null && volNode instanceof VirtualVolumeNode) {
                    RemoteObject[] childrenStubs = new RemoteObject[children.length];
                    System.arraycopy(children, 0, childrenStubs, 0, children.length);
                    ((VirtualVolumeNode)volNode).setChildren(childrenStubs);
                    this.fireVolumeConfigChanged(volNode);
                    TreeNode root = volNode.getRoot();
                    if (root instanceof VolumeTreeNode) {
                        VolumeTreeNode volumeRoot = (VolumeTreeNode)root;
                        this.updateVolumeCapacityFromServer((VolumeNode)volumeRoot);
                        this.fireVolumeCapacityChanged(volumeRoot);
                    }
                }
                if (params.containsKey(ClientParameterCode.VOLUME_POSITION)) {
                    Integer volumePosition = (Integer)this.getObjectForParam(params, ClientParameterCode.VOLUME_POSITION, false);
                    volNode.setPositionInParent(volumePosition);
                }
                if (aliasChanged != null) {
                    theLogger.trace(SrLogCategories.LEGACY, "VolumeManager: volume ", volNode.getAlias(), "alias changed.");
                    volNode.setAlias(aliasChanged.toString());
                    this.fireVolumeAliasChanged(volNode);
                }
                if (exposed != null) {
                    boolean bothNotExposed;
                    Boolean isExposed = (Boolean)exposed;
                    theLogger.trace(SrLogCategories.LEGACY, "VolumeManager: volume state changed");
                    boolean bothExposed = volNode.isExposed() && isExposed != false;
                    boolean bl = bothNotExposed = !volNode.isExposed() && isExposed == false;
                    if (bothExposed || bothNotExposed) {
                        theLogger.trace(SrLogCategories.LEGACY, "VolumeManager: expose state already known for volume : ", volNode.getAlias());
                        return;
                    }
                    volNode.setExposed(isExposed);
                    if (isExposed.booleanValue()) {
                        theLogger.trace(SrLogCategories.LEGACY, "Volume: ", volNode.getAlias(), " exposed !");
                        this.fireVolumeExposed(volNode);
                    } else {
                        theLogger.trace(SrLogCategories.LEGACY, "Volume: ", volNode.getAlias(), " Unexposed !");
                        this.fireVolumeDeExposed(volNode);
                    }
                }
                if (state != null) {
                    volNode.setVolStateBits((SrBITSConstant)state);
                    theLogger.trace(SrLogCategories.LEGACY, "Volume: ", volNode.getAlias(), " State Changed: ", volNode.getVolStateStr());
                    this.fireVolumeStateChanged(volNode);
                }
                if (isExpnadable != null) {
                    ((ConcatinationVolumeNode)volNode).setExpandable((Boolean)isExpnadable);
                }
                if (isRetractable != null) {
                    ((ConcatinationVolumeNode)volNode).setRetractable((Boolean)isRetractable);
                }
                if (capacityWasChanged) {
                    this.updateVolumeCapacityFromServer((VolumeNode)volNode);
                    this.fireVolumeCapacityChanged(volNode);
                }
                if (snapshotActivatedState != null) {
                    SnapshotActivateTypeConstants snapshotActivatedStateType = (SnapshotActivateTypeConstants)snapshotActivatedState;
                    ((SnapshotVolumeNode)volNode).setActivatedState(snapshotActivatedStateType);
                    this.fireSnapshotVolActivationStateChanged((SnapshotVolumeNode)volNode);
                }
                if (snapshotLoad != null || snapshotThresh != null || snapshotSource != null || snapshotDateAndTime != null || snapshotConfigFlags != null) {
                    this.updateSnapshotParameters(volNode, snapshotLoad, snapshotThresh, snapshotSource, snapshotDateAndTime, snapshotConfigFlags);
                }
                if (volNode instanceof JournalVolumeNode) {
                    JournalVolumeNode jourVolume = (JournalVolumeNode)volNode;
                    if (!params.containsKey(ClientParameterCode.JOURNAL_VOLUME_ACTIVE_ON_VSWITCH_ID)) {
                        params.put(ClientParameterCode.JOURNAL_VOLUME_ACTIVE_ON_VSWITCH_ID, jourVolume.getActivateOnVSwitch());
                    }
                    Object dateAndTimeObj = this.getObjectForParam(params, ClientParameterCode.JOURNAL_VOLUME_DATE_AND_TIME, false);
                    Object percentUtilizationObj = this.getObjectForParam(params, ClientParameterCode.JOURNAL_VOLUME_PRECENT_UTILIZATION, false);
                    Object percentThreshObj = this.getObjectForParam(params, ClientParameterCode.JOURNAL_VOLUME_PRECENT_THRESH, false);
                    VSwitch activeOnVSwitchIDObj = ((JournalVolume)jourVolume.getStub()).getActiveOnVSwitch();
                    Object activityStateObj = this.getObjectForParam(params, ClientParameterCode.JOURNAL_VOLUME_ACTIVITY, false);
                    JournalOperStatusConstant journalOperStatus = (JournalOperStatusConstant)this.getObjectForParam(params, ClientParameterCode.JOURNAL_VOLUME_OPER_STATUS, false);
                    JournalErrorStatusConstant journalErrorStatus = (JournalErrorStatusConstant)this.getObjectForParam(params, ClientParameterCode.JOURNAL_VOLUME_ERROR_STATUS, false);
                    if (dateAndTimeObj != null) {
                        jourVolume.setDateAndTime((Long)dateAndTimeObj);
                        this.fireJournalVolDateAndTimeChanged(jourVolume);
                    }
                    if (percentUtilizationObj != null) {
                        jourVolume.setPercentageUtilization((Integer)percentUtilizationObj);
                        this.fireJournalVolPercentageUtilizationChanged(volNode);
                    }
                    if (percentThreshObj != null) {
                        jourVolume.setPercentageThreshold((Integer)percentThreshObj);
                        this.fireJournalVolPercentageThresholdChanged(volNode);
                    }
                    if (activityStateObj != null) {
                        jourVolume.setActivityState((JournalVolumeActivityConstants)activityStateObj);
                        this.fireJournalVolActivityStateChanged(volNode);
                    }
                    if (journalOperStatus != null) {
                        jourVolume.setOperationalStatus(journalOperStatus);
                        this.fireVolumeConfigChanged(jourVolume);
                    }
                    if (journalErrorStatus != null) {
                        jourVolume.setErrorStatus(journalErrorStatus);
                        this.fireVolumeConfigChanged(jourVolume);
                    }
                    if (activeOnVSwitchIDObj != null) {
                        JournalVolume journalStub;
                        if (activityStateObj == null && (activityStateObj = (journalStub = (JournalVolume)element).getActivityState(activeOnVSwitchIDObj.getCommKeyClassId())) != null) {
                            jourVolume.setActivityState((JournalVolumeActivityConstants)activityStateObj);
                        }
                        if (jourVolume.getActiveOnVSwitchNode() != null) {
                            this.m_vswitchToJournalMap.remove(jourVolume.getActiveOnVSwitchNode().getIPAddress());
                        }
                        jourVolume.setActivateOnVSwitch(activeOnVSwitchIDObj);
                        VSwitchNode activeOnVSwitch = (VSwitchNode)SystemRootNode.getInstance().getRefByStub(activeOnVSwitchIDObj);
                        String vswitchIP = null;
                        vswitchIP = activeOnVSwitch != null ? activeOnVSwitch.getIPAddress() : activeOnVSwitchIDObj.getMgmIPAddr();
                        this.m_vswitchToJournalMap.put(vswitchIP, jourVolume);
                        jourVolume.setActivateOnVSwitch(activeOnVSwitchIDObj);
                        this.fireJournalVolActivateOnVSwitchChanged(jourVolume);
                    }
                }
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, "Volume: ", volNode.getAlias(), " Failed to get Volume state from Server", re);
        }
    }

    private void updateSnapshotParameters(VolumeTreeNode snapshotNode, Object snapshotLoad, Object snapshotThresh, com.sanrad.nms.server.logic.volume.VolumeNode snapshotSource, Object snapshotDateAndTime, SnapshotConfigFlagsConstant aConfigFlags) {
        boolean changed = false;
        SnapshotVolumeNode snapshot = (SnapshotVolumeNode)snapshotNode;
        if (snapshotLoad != null) {
            int load = (Integer)snapshotLoad;
            snapshot.setPercentageLoad(load);
            changed = true;
        }
        if (snapshotThresh != null) {
            int thresh = (Integer)snapshotThresh;
            snapshot.setPercentageThreshold(thresh);
            changed = true;
        }
        if (snapshotDateAndTime != null) {
            Date dateAndTime = new Date((Long)snapshotDateAndTime);
            snapshot.setDateAndTime(dateAndTime);
            changed = true;
        }
        if (aConfigFlags != null) {
            snapshot.setConfigFlags(aConfigFlags);
            changed = true;
        }
        if (changed) {
            this.fireVolumeParametersChanged(snapshot);
        }
        if (snapshotSource != null) {
            VolumeTreeNode source = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(snapshotSource);
            snapshot.setSourceVolume(source);
            this.fireSnapshotSourceChanged(snapshot);
        }
    }

    private void fireVolumeParametersChanged(VolumeTreeNode node) {
        VolumeEvent event = this.createVolumeEvent(node);
        this.m_listeners.fireEvent(VolumeListener.class, event, this.volumeParametersChangedInformer);
    }

    private void fireSnapshotSourceChanged(VolumeTreeNode node) {
        VolumeEvent event = this.createVolumeEvent(node);
        this.m_listeners.fireEvent(VolumeListener.class, event, this.snapshotSourceChangedInformer);
    }

    private void fireVolumeAliasChanged(VolumeTreeNode node) {
        VolumeEvent event = this.createVolumeEvent(node);
        this.m_listeners.fireEvent(VolumeListener.class, event, this.volumeAliasChangedInformer);
    }

    public void fireVolumeExposed(VolumeTreeNode volume) {
        theLogger.trace(SrLogCategories.LEGACY, "VolumeManager: volume exposed");
        VolumeEvent event = this.createVolumeEvent(volume);
        this.m_listeners.fireEvent(VolumeListener.class, event, this.volumeExposedInformer);
    }

    public void fireVolumeConfigChanged(VolumeTreeNode volume) {
        theLogger.trace(SrLogCategories.LEGACY, "VolumeManager: volume config changed");
        VolumeEvent event = this.createVolumeEvent(volume);
        this.m_listeners.fireEvent(VolumeListener.class, event, this.volumeConfigChangedInformer);
    }

    public void fireVolumeDeExposed(VolumeTreeNode volume) {
        theLogger.trace(SrLogCategories.LEGACY, "VolumeManager: volume de-exposed");
        VolumeEvent event = this.createVolumeEvent(volume);
        this.m_listeners.fireEvent(VolumeListener.class, event, this.volumeDeExposedInformer);
    }

    private VolumeEvent createVolumeEvent(VolumeTreeNode volume) {
        VolumeEvent event = null;
        event = new VolumeEvent((Object)this, volume);
        event.setVolumeAlias(volume.getAlias());
        event.setExposed(volume.isExposed());
        return event;
    }

    public SrFuture<Void> setAlias(SrTreeNode node, HashMap params) {
        return ClientAOImpl.getInstance().changeElements(Collections.singleton(node.getIdentifier()), params);
    }

    public SrFuture<Void> createMirrorVolume(String volAlias, Vector<VolumeTreeNode> childrenNodes) {
        return ClientAOImpl.getInstance().createMirrorVolume(this.getWorkingCluster(childrenNodes).getStorageID(), volAlias, this.getIds(childrenNodes));
    }

    public SrFuture<Void> createStripeVolume(String volAlias, Vector<VolumeTreeNode> childrenNodes, BigInteger stripeSize) {
        return ClientAOImpl.getInstance().createStripeVolume(this.getWorkingCluster(childrenNodes).getStorageID(), volAlias, this.getIds(childrenNodes), stripeSize);
    }

    public SrFuture<Void> createTransparentVolume(String volAlias, Vector<VolumeTreeNode> childrenNodes) {
        CommKeyClassId[] childrenCommKeyClassId = this.getIds(childrenNodes);
        theLogger.logAndAssert(SrLogCategories.ERROR, childrenCommKeyClassId.length == 1, new Object[]{"Transparent volume  may not contain other than 1 child"});
        return ClientAOImpl.getInstance().createTransparentVolume(this.getWorkingCluster(childrenNodes).getStorageID(), volAlias, childrenCommKeyClassId[0]);
    }

    public SrFuture<Void> createConcatinationVolume(String volAlias, Vector<VolumeTreeNode> childrenNodes) {
        return ClientAOImpl.getInstance().createConcatinationVolume(this.getWorkingCluster(childrenNodes).getStorageID(), volAlias, this.getIds(childrenNodes));
    }

    public SrFuture<Void> createSnapshotVolume(String volAlias, VolumeTreeNode<?> sourceVolume, Vector<VolumeTreeNode> children, int threshold) {
        return ClientAOImpl.getInstance().createSnapshotVolume(this.getWorkingCluster(children).getStorageID(), volAlias, (CommKeyClassId)sourceVolume.getIdentifier(), this.getIds(children)[0], threshold);
    }

    public List<VolumeTreeNode> readAllVolumes(ClusterNode clusterNode) {
        ArrayList<VolumeTreeNode> nodes;
        block8: {
            nodes = new ArrayList<VolumeTreeNode>();
            try {
                Storage storageStub = Communication.getInstance().getStorageStub(clusterNode.getStub());
                if (storageStub == null) break block8;
                Vector allVolumes = storageStub.getVolumeTrees();
                int size = allVolumes.size();
                ArrayList<SnapshotVolume> snapshotsVolumesStubs = new ArrayList<SnapshotVolume>();
                for (int i = 0; i < size; ++i) {
                    VolumeTree volumeTree = (VolumeTree)allVolumes.get(i);
                    com.sanrad.nms.server.logic.volume.VolumeNode subTreeRootStub = volumeTree.getTreeRoot();
                    if (subTreeRootStub instanceof SnapshotVolume) {
                        snapshotsVolumesStubs.add((SnapshotVolume)subTreeRootStub);
                        continue;
                    }
                    if (!(subTreeRootStub instanceof Volume)) continue;
                    HashMap params = null;
                    try {
                        params = subTreeRootStub.getClientParameterList();
                    }
                    catch (RemoteException re) {
                        theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
                        re.printStackTrace();
                    }
                    catch (IllegalValueException re) {
                        theLogger.trace(SrLogCategories.LEGACY, re.getMessage());
                        re.printStackTrace();
                    }
                    VolumeNode node = this.createVolumeNode((Volume)subTreeRootStub, params);
                    theLogger.logAndAssert(SrLogCategories.ERROR, node != null, new Object[]{params});
                    nodes.add(node);
                }
                for (SnapshotVolume snapshotStub : snapshotsVolumesStubs) {
                    HashMap params;
                    VolumeNode node = this.createVolumeNode(snapshotStub, params = this.getParameterList(new CommunicationEvent(this, snapshotStub)));
                    theLogger.logAndAssert(SrLogCategories.ERROR, node != null, new Object[]{snapshotStub.getAlias()});
                    nodes.add(node);
                }
                CopyOperManager.getInstance().getRestoreOperationsFromServer(clusterNode);
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            }
        }
        return nodes;
    }

    public SrFuture<Void> exposeVolume(Integer lun, VolumeTreeNode<?> volume, CommKeyClassId targetId) {
        return this.exposeVolume(lun, null, volume, targetId);
    }

    public SrFuture<Void> exposeVolume(Integer lun, String luSerialNumber, VolumeTreeNode<?> volume, CommKeyClassId targetId) {
        theLogger.trace(SrLogCategories.LEGACY, "trying to expose Volume. ");
        return ClientAOImpl.getInstance().exposeVolume(SystemRootNode.getInstance().getClusterNodeOfSource(volume).getStorageID(), lun, (CommKeyClassId)volume.getIdentifier(), targetId, luSerialNumber);
    }

    public SrFuture<Void> refreshSnapshotTable(ClusterNode clusterNode) {
        if (clusterNode.hasVSwitch()) {
            return ClientAOImpl.getInstance().readSnapshotVolumes(clusterNode.getStorageID());
        }
        return new CompleteFuture<Void>("VolumeManager.refreshSnapshotTable");
    }

    public SrFuture<Void> replaceVolume(VolumeTreeNode<?> oldNode, VolumeTreeNode<?> newNode) {
        return ClientAOImpl.getInstance().replace((CommKeyClassId)oldNode.getIdentifier(), (CommKeyClassId)newNode.getIdentifier());
    }

    public SrFuture<Void> retract(ConcatinationVolumeNode node) {
        return ClientAOImpl.getInstance().retract(Collections.singleton(node.getIdentifier()));
    }

    public SrFuture<Void> resize(String cubeAlias, VolumeTreeNode<?> node, VolumeTreeNode<?> newChild) {
        return ClientAOImpl.getInstance().resize((CommKeyClassId)node.getIdentifier(), (CommKeyClassId)newChild.getIdentifier(), cubeAlias);
    }

    public boolean canBeExpand(VolumeTreeNode node) {
        if (node instanceof ConcatinationVolumeNode) {
            ConcatinationVolumeNode concatNode = (ConcatinationVolumeNode)node;
            return concatNode.getExpandable();
        }
        if (node instanceof MirrorVolumeNode) {
            MirrorVolumeNode mirrorNode = (MirrorVolumeNode)node;
            BigInteger currentMirrorSpace = mirrorNode.getAccessibleSpace();
            int indexOfChilds = 0;
            long minChildSpace = 0L;
            Enumeration<TreeNode> iter = mirrorNode.children();
            while (iter.hasMoreElements()) {
                VolumeTreeNode volumeTreeNode = (VolumeTreeNode)iter.nextElement();
                BigInteger space = volumeTreeNode.getAccessibleSpace();
                if (indexOfChilds == 0) {
                    minChildSpace = space.longValue();
                } else if (space.longValue() < minChildSpace) {
                    minChildSpace = space.longValue();
                }
                ++indexOfChilds;
            }
            if (currentMirrorSpace.longValue() < minChildSpace) {
                return true;
            }
        }
        return false;
    }

    public boolean canBeRetract(VolumeTreeNode node) {
        if (node instanceof ConcatinationVolumeNode) {
            return ((ConcatinationVolumeNode)node).getRetractable();
        }
        return false;
    }

    public boolean canBeExposed(VolumeTreeNode node, StringBuffer reason) {
        if (node instanceof StorageDeviceNode) {
            StorageDeviceNode storageNode = (StorageDeviceNode)node;
            if (storageNode.isTape()) {
                reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.EXPOSED_VALIDATION_CANNOT_EXPOSED_SEQUENTIAL_STORAGE_DEVICE));
                return false;
            }
            if (storageNode.isProcessor()) {
                reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.EXPOSED_VALIDATION_CANNOT_EXPOSED_PROCESSOR_STORAGE_DEVICE));
                return false;
            }
            if (CopyOperManager.getInstance().isInvolvedInActiveRestore(node)) {
                reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.EXPOSED_VALIDATION_CANNOT_EXPOSED_SOURCE_OF_SNAPSHOT_UNDER_ACTIVE_RESTORE));
                return false;
            }
        }
        if (node instanceof SnapshotVolumeNode) {
            SnapshotVolumeNode snapshotVolume = (SnapshotVolumeNode)node;
            if (!this.isSnapshotInActivState(snapshotVolume)) {
                reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.EXPOSED_VALIDATION_CANNOT_EXPOSED_INACTIVE_SNAPSHOT));
                return false;
            }
            if (!snapshotVolume.getSourceVolume().isExposed()) {
                reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.EXPOSED_VALIDATION_CANNOT_EXPOSED_SNAPSHOT_WHO_HAS_AN_INTERNAL_SOURCE));
                return false;
            }
        } else if (node instanceof JournalVolumeNode) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.EXPOSED_VALIDATION_CANNOT_EXPOSED_JOURNAL));
            return false;
        }
        if (CopyOperManager.getInstance().isInvolvedInActiveRestore(node)) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.EXPOSED_VALIDATION_CANNOT_EXPOSED_SOURCE_OF_SNAPSHOT_UNDER_ACTIVE_RESTORE));
            return false;
        }
        boolean parentIsVolume = node.getParent() instanceof VolumeTreeNode;
        if (parentIsVolume) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.EXPOSED_VALIDATION_CANNOT_EXPOSED_VOLUME_WHO_HAS_A_PARENT_VOLUME));
            return false;
        }
        boolean involvedInRestoreOperation = CopyOperManager.getInstance().isInvolvedInActiveRestore(node);
        if (involvedInRestoreOperation) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.EXPOSED_VALIDATION_CANNOT_EXPOSED_VOLUME_WHO_IS_INVOLVE_IN_RESTORE));
            return false;
        }
        boolean isInvolvedInActiveOfflineCopy = CopyOperManager.getInstance().isInvolvedInActiveOfflineCopy(node);
        if (isInvolvedInActiveOfflineCopy) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.EXPOSED_VALIDATION_CANNOT_EXPOSED_VOLUME_WHO_IS_INVOLVE_IN_OFFLINE_COPY));
            return false;
        }
        return true;
    }

    public String canBeOtherVolumeChild(VolumeTreeNode node) {
        ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(node);
        if (node.getParent() instanceof VolumeTreeNode) {
            return "Volume " + node.getAlias() + " is a child of Volume " + ((VolumeTreeNode)node.getParent()).getAlias();
        }
        if (node instanceof TransparentVolumeNode) {
            return "Volume " + node.getAlias() + " is transparent";
        }
        if (node instanceof SnapshotVolumeNode) {
            return "Volume " + node.getAlias() + " is snapshot";
        }
        if (node instanceof JournalVolumeNode) {
            return "Volume " + node.getAlias() + " is journal";
        }
        if (CopyOperManager.getInstance().isInvolvedInAnyCopyOperTable(node)) {
            return "Volume " + node.getAlias() + " is involved in a copy operation";
        }
        if (this.clusterSnapshotMap.isSourceOfSnapshot(clusterNode, node)) {
            return "Volume " + node.getAlias() + " is a source of a snapshot";
        }
        return null;
    }

    public boolean canBeSnapshotSource(VolumeTreeNode node, StringBuffer reason) {
        ClusterNode clusterNode;
        StorageDeviceNode storageNode;
        boolean isParentAVolume = node.getParent() != null && node.getParent() instanceof VolumeTreeNode;
        boolean isSnapShotVolume = node instanceof SnapshotVolumeNode;
        boolean isTransparentVolume = node instanceof TransparentVolumeNode;
        boolean isJournalVolume = node instanceof JournalVolumeNode;
        boolean isVolumeNonFunctional = node.isInState(VolumeStateConstant.VOLUME_STATE_NONFUNCTIONAL);
        boolean isVolumeInvolvedInOfflineCopy = CopyOperManager.getInstance().isInvolvedInOfflineCopy(node);
        boolean isExposedOnDisconnected = false;
        if (node instanceof StorageDeviceNode && ((storageNode = (StorageDeviceNode)node).isTape() || storageNode.isProcessor())) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.SNAPSHOT_SOURCE_VALIDAION_THE_SOURCE_IS_NOT_A_DISK_OR_A_SUBDISK));
            return false;
        }
        if (node.isExposed() && (clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(node)).isUnderTakeover() && !isParentAVolume) {
            String exposedOnVSwitch = node.getLUNode().getTargetParent().getExposedOnVSwitchName();
            VSwitchNode vSwitchNode = clusterNode.getVSwitchByName(exposedOnVSwitch);
        }
        if (isParentAVolume) {
            String parentAlias = ((VolumeTreeNode)node.getParent()).getAlias();
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString((BundleKeysInterface)SrDataValidationResourceBundleKeys.SNAPSHOT_SOURCE_VALIDAION_THE_VOLUME_HAS_A_PARENT_VOLUME, parentAlias));
        } else if (isSnapShotVolume) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.SNAPSHOT_SOURCE_VALIDAION_THE_VOLUME_IS_A_SNAPSHOT));
        } else if (isTransparentVolume) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.SNAPSHOT_SOURCE_VALIDAION_THE_VOLUME_IS_A_TRANSPARENT));
        } else if (isJournalVolume) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.SNAPSHOT_SOURCE_VALIDAION_THE_VOLUME_IS_A_JOURNAL));
        } else if (isVolumeNonFunctional) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.SNAPSHOT_SOURCE_VALIDAION_THE_VOLUME_IS_A_NONFUNCTIONAL));
        } else if (isVolumeInvolvedInOfflineCopy) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.SNAPSHOT_SOURCE_VALIDAION_THE_VOLUME_IS_AN_OFFLINE_COPY_SRC_OR_DEST));
        } else if (isExposedOnDisconnected) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.SNAPSHOT_SOURCE_VALIDAION_THE_VOLUME_IS_EXPOSED_ON_DISCONNECTED_VSWITCH));
        }
        return !isParentAVolume && !isSnapShotVolume && !isTransparentVolume && !isJournalVolume && !isVolumeNonFunctional && !isExposedOnDisconnected && !isVolumeInvolvedInOfflineCopy;
    }

    public boolean canBeDeleted(VolumeTreeNode node, StringBuffer reason) {
        return this.canBeDeleted(node, reason, false);
    }

    public boolean canBeDeleted(VolumeTreeNode node, StringBuffer reason, boolean aIgnoreExposedCheck) {
        if (node instanceof StorageDeviceNode) {
            StorageDeviceNode storageNode = (StorageDeviceNode)node;
            if (storageNode.isNonFunctional()) {
                reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.STORAGE_CANNOT_BE_DELETED_ITS_A_NON_FUNCTIONAL));
                return false;
            }
            if ((storageNode.isDisk() || storageNode.isTape()) && !AlarmsManager.getInstance().isRemovableDisk(storageNode)) {
                reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_CANNOT_BE_DELETED_ITS_A_DISK_OR_TAPE));
                return false;
            }
        }
        ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(node);
        if (node.getParent() instanceof VolumeTreeNode) {
            VolumeTreeNode parent = (VolumeTreeNode)node.getParent();
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString((BundleKeysInterface)SrDataValidationResourceBundleKeys.VOLUME_CANNOT_BE_DELETED_CHILD_OF_ANOTHER_VOLUME, parent.getAlias()));
            return false;
        }
        if (this.getClusterSnapshotMap().isSourceOfSnapshot(clusterNode, node)) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_CANNOT_BE_DELETED_SOURCE_OF_SNAPSHOT));
            return false;
        }
        if (CopyOperManager.getInstance().isInvolvedInAnyActiveCopyOper(node)) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_CANNOT_BE_DELETED_INVOLVE_IN_COPY_OPR));
            return false;
        }
        if (!aIgnoreExposedCheck && node.isExposed()) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_CANNOT_BE_DELETED_ITS_EXPOSED));
            return false;
        }
        if (node instanceof SnapshotVolumeNode) {
            String canSnapshotBeDeleted = this.canSnapshotBeDeleted((SnapshotVolumeNode)node);
            if (canSnapshotBeDeleted == null) {
                return true;
            }
            reason.append(canSnapshotBeDeleted);
            return false;
        }
        if (node instanceof JournalVolumeNode && this.isJournalVolumeUsedByAPair((JournalVolumeNode)node)) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.JOURNAL_USED_BY_PAIR));
            return false;
        }
        if (DRPairManager.getPairContainingVolume(node) != null) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_CANNOT_BE_DELETED_USED_BY_DR_PAIR));
            return false;
        }
        if (SnapshotSchedulerManager.getInstance().getSnapshotSchedulerOfSource(node) != null) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_CANNOT_BE_DELETED_SCHEDULER_SOURCE));
            return false;
        }
        return true;
    }

    public boolean isMissingOrInvalidDisk(StorageDeviceNode node) {
        return AlarmsManager.getInstance().isMissingInvalidOrConfiguredDisk(node);
    }

    public boolean isPartOfTheSameTree(VolumeTreeNode<?> node1, VolumeTreeNode<?> node2) {
        return node1.getHeadVolume().equals(node2.getHeadVolume());
    }

    public boolean canSnapshotBeActivated(VolumeTreeNode node, StringBuffer reason) {
        return this.canSnapshotBeActivatedOrDeleted(false, node, reason);
    }

    public String canSnapshotBeDeleted(SnapshotVolumeNode node) {
        StringBuffer reason = new StringBuffer();
        if (!this.canSnapshotBeActivatedOrDeleted(true, node, reason)) {
            return reason.toString();
        }
        return null;
    }

    private boolean canSnapshotBeActivatedOrDeleted(boolean isForDeleteOperation, VolumeTreeNode node, StringBuffer reason) {
        if (node instanceof SnapshotVolumeNode) {
            SnapshotVolumeNode snapshotVol = (SnapshotVolumeNode)node;
            if (snapshotVol.isExposed()) {
                reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.SNAPSHOT_IS_EXPOSED));
                return false;
            }
            if (this.isSnapshotChildInvolvedInActiveMirrorSync(snapshotVol)) {
                reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.SNAPSHOT_CHILD_INVOLVED_IN_A_MIRROR_SYNC));
                return false;
            }
            if (this.isSnapshotInvolvedInActiveOfflineCopy(snapshotVol)) {
                reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.SNAPSHOT_INVOLVED_IN_A_COPY_OPERATION));
                return false;
            }
            if (this.isSnapshotChildInvolvedInCopyOperation(snapshotVol)) {
                reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.SNAPSHOT_CHILD_INVOLVED_IN_A_COPY_OPERATION));
                return false;
            }
            if (this.isSnapshotSourceUsedByAPair(snapshotVol)) {
                reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.SNAPSHOT_SOURCE_USED_BY_PAIR));
                return false;
            }
            if (this.isSnapshotUnderRestoringOperation(snapshotVol)) {
                reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.SNAPSHOT_IS_UNDER_RESTORE_OPERATION));
                return false;
            }
            SnapshotSchedulerNode scheduler = SnapshotSchedulerManager.getInstance().getSchedulerOfSnapshot(snapshotVol);
            if (scheduler != null && scheduler.isRunning()) {
                reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.SNAPSHOT_BELONGS_RUNNING_SCHEDULER));
                return false;
            }
            if (isForDeleteOperation) {
                return true;
            }
            if (this.isSnapshotSourceNonFunctional(snapshotVol)) {
                reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.SNAPSHOT_SOURCE_VALIDAION_THE_VOLUME_IS_A_NONFUNCTIONAL));
                return false;
            }
            if (((VolumeTreeNode)snapshotVol.getChildAt(0)).isNonFunctional()) {
                reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.SNAPSHOT_CHILD_VALIDAION_THE_VOLUME_IS_A_NONFUNCTIONAL));
                return false;
            }
            VolumeTreeNode<?> sourceVolume = snapshotVol.getSourceVolume();
            DRPairNode pair = DRPairManager.getPairContainingVolume(sourceVolume);
            if (pair != null && DRPairTypeConstant.ASYNC.equals(pair.getPairType()) && (pair.getPairSecondaryVolume() != null && pair.getPairSecondaryVolume().equals(sourceVolume) && DRModeConstant.NORMAL.equals(pair.getMode()) || pair.getPairPrimaryVolume() != null && pair.getPairPrimaryVolume().equals(sourceVolume) && DRModeConstant.SWITCHED.equals(pair.getMode()))) {
                DRASyncPairNode asyncPair = (DRASyncPairNode)pair;
            }
            return true;
        }
        return false;
    }

    private boolean isSnapshotChildInvolvedInActiveMirrorSync(SnapshotVolumeNode snapshotVol) {
        Enumeration<TreeNode> iter = snapshotVol.children();
        while (iter.hasMoreElements()) {
            VolumeTreeNode volumeTreeNode = (VolumeTreeNode)iter.nextElement();
            if (!(volumeTreeNode instanceof MirrorVolumeNode)) continue;
            MirrorVolumeNode mirrorVol = (MirrorVolumeNode)volumeTreeNode;
            if (!CopyOperManager.getInstance().isInvolvedInActiveMirrorSync(mirrorVol)) continue;
            return true;
        }
        return false;
    }

    private boolean isSnapshotInvolvedInActiveOfflineCopy(SnapshotVolumeNode snapshotVol) {
        return CopyOperManager.getInstance().isInvolvedInActiveOfflineCopy(snapshotVol);
    }

    private boolean isSnapshotChildInvolvedInCopyOperation(SnapshotVolumeNode snapshotVol) {
        Enumeration<TreeNode> iter = snapshotVol.children();
        while (iter.hasMoreElements()) {
            VolumeTreeNode volumeTreeNode = (VolumeTreeNode)iter.nextElement();
            if (!CopyOperManager.getInstance().isInvolvedInOfflineCopy(volumeTreeNode)) continue;
            return true;
        }
        return false;
    }

    public boolean isSnapshotSourceUsedByAPair(SnapshotVolumeNode snapshotVol) {
        VolumeTreeNode<?> snapshotSource = snapshotVol.getSourceVolume();
        DRPairNode pairNode = DRPairManager.getPairContainingVolume(snapshotSource);
        if (pairNode != null && pairNode instanceof DRASyncPairNode) {
            DRASyncPairNode aSyncPairNode = (DRASyncPairNode)pairNode;
            SnapshotVolumeNode primarySnapshot = aSyncPairNode.getPrimarySnapshot();
            SnapshotVolumeNode secondarySnapshot = aSyncPairNode.getSecondarySnapshot();
            if (primarySnapshot != null && ((SnapshotVolume)primarySnapshot.getStub()).equals(snapshotVol.getStub()) || secondarySnapshot != null && ((SnapshotVolume)secondarySnapshot.getStub()).equals(snapshotVol.getStub())) {
                return true;
            }
        }
        return false;
    }

    public boolean isSnapshotUnderRestoringOperation(SnapshotVolumeNode snapshotVol) {
        return snapshotVol.isInvolvedInAnotherActiveRestoreOperation();
    }

    public boolean isJournalVolumeUsedByAPair(JournalVolumeNode journalVol) {
        DRPairNode pairNode = DRPairManager.getJournalVolumeUsedByPair(journalVol);
        return pairNode != null;
    }

    public boolean isSnapshotInActivState(SnapshotVolumeNode snapshotVol) {
        return snapshotVol.isActivated();
    }

    public boolean isSnapshotSourceNonFunctional(SnapshotVolumeNode snapshotVol) {
        VolumeTreeNode<?> snapshotSource = snapshotVol.getSourceVolume();
        if (snapshotSource != null) {
            return snapshotSource.isNonFunctional();
        }
        return true;
    }

    public boolean isSnapshotVolume(VolumeTreeNode node) {
        return node instanceof SnapshotVolumeNode;
    }

    public SrFuture<Void> createJournalVolume(String volAlias, Integer threshold, VolumeTreeNode<?> sourceVolumeNode, VSwitchNode activeOnVswitchNode) {
        ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(sourceVolumeNode);
        return ClientAOImpl.getInstance().createJournalVolume(clusterNode.getStorageID(), volAlias, threshold, (CommKeyClassId)sourceVolumeNode.getIdentifier(), (CommKeyClassId)activeOnVswitchNode.getIdentifier());
    }

    public boolean isCreateJournalAllowed(VolumeTreeNode node, StringBuffer reason) {
        ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(node);
        boolean createAnotherJournalAllowed = this.isCreateAnotherJournalAllowed(clusterNode);
        if (!createAnotherJournalAllowed) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString((BundleKeysInterface)SrDataValidationResourceBundleKeys.DR_CREATE_JOURNAL_THERE_ARE_JOURNALS_CREATED_FOR_THE_CURRENT_CLUSTER, clusterNode.getAlias()));
        }
        return createAnotherJournalAllowed && this.isVolumeLegalForJournalCreation(node, reason);
    }

    public boolean isCreatePairAllowed(VolumeTreeNode node, StringBuffer reason) {
        if (!this.isSitesConfigurationAllwedForPairCreation(reason)) {
            return false;
        }
        if (DRPairManager.getPairContainingVolume(node) != null) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.DR_PAIR_VALIDAION_THE_SOURCE_IS_USED_BY_GDR));
            return false;
        }
        if (node instanceof VolumeNode) {
            if (!this.canBePairSource((VolumeNode)node, reason)) {
                return false;
            }
        } else {
            boolean isParentAVolume;
            boolean bl = isParentAVolume = node.getParent() != null && node.getParent() instanceof VolumeNode;
            if (isParentAVolume) {
                reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.DR_PAIR_VALIDAION_THE_SOURCE_PARENT_IS_A_VOLUME));
                return false;
            }
            if (!(node instanceof SubDirectAccessDeviceNode)) {
                reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.DR_CREATE_PAIR_THE_STORAGE_DEVICE_IS_NOT_LEGITIMATE_FOR_PAIR));
                return false;
            }
        }
        return true;
    }

    private boolean isSitesConfigurationAllwedForPairCreation(StringBuffer reason) {
        SiteNode[] sites = SystemRootNode.getInstance().getSiteNodes();
        if (sites.length <= 1) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.DR_CREATE_PAIR_MUST_HAVE_2_SITES));
            return false;
        }
        for (int index1 = 0; index1 < sites.length; ++index1) {
            SiteNode siteNodeIteration = sites[index1];
            ClusterNode[] siteClusters = siteNodeIteration.getSiteClusters();
            if (siteClusters.length == 0) {
                reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.DR_CREATE_PAIR_MUST_HAVE_VSWITCH_IN_CLUSTER));
                return false;
            }
            for (int index2 = 0; index2 < siteClusters.length; ++index2) {
                List<VSwitchNode> clusterVSwitches = siteClusters[index2].getClusterVSwitches();
                if (clusterVSwitches != null && clusterVSwitches.size() != 0) continue;
                reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.DR_CREATE_PAIR_MUST_HAVE_VSWITCH_IN_CLUSTER));
                return false;
            }
        }
        return true;
    }

    private boolean isVolumeLegalForJournalCreation(VolumeTreeNode node, StringBuffer reason) {
        if (node instanceof VolumeNode) {
            if (!this.canBeJournalSource(node, reason)) {
                return false;
            }
        } else {
            boolean isParentInstanceofVolume;
            StorageDeviceNode storageNode = (StorageDeviceNode)node;
            boolean bl = isParentInstanceofVolume = node.getParent() != null && node.getParent() instanceof VolumeNode;
            if (isParentInstanceofVolume) {
                reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.DR_PAIR_VALIDAION_THE_SOURCE_PARENT_IS_A_VOLUME));
                return false;
            }
            if (storageNode.isSubDisk()) {
                SubDirectAccessDeviceNode subDiskNode = (SubDirectAccessDeviceNode)storageNode;
                DirectAccessDeviceNode parentDisk = subDiskNode.getDirectAccessDeviceParent();
                if (subDiskNode.hasVolumeParent()) {
                    reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.DR_CREATE_JOURNAL_THE_SUBDISK_OR_TAPE_HAS_A_PARENT_VOLUME));
                    return false;
                }
            }
            if (storageNode.isDisk()) {
                DirectAccessDeviceNode diskNode = (DirectAccessDeviceNode)node;
                SubDirectAccessDeviceNode[] subDisks = StorageManager.getInstance().getSubdisksNodes(diskNode.getSplits(), diskNode);
                if (!(subDisks != null && subDisks.length != 0 || diskNode.hasVolumeParent())) {
                    return true;
                }
                if (subDisks != null && subDisks.length != 0) {
                    reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.DR_CREATE_JOURNAL_THE_DISK_HAS_SUBDISKS));
                    return false;
                }
                if (diskNode.hasVolumeParent()) {
                    reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.DR_CREATE_JOURNAL_THE_DISK_HAS_A_PARENT_VOLUME));
                    return false;
                }
            }
            if (storageNode.isTape() || storageNode.isProcessor()) {
                reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.DR_CREATE_JOURNAL_THE_STORAGE_DEVICE_IS_NOT_LEGITIMATE_FOR_JOURNAL_VOLUME));
                return false;
            }
        }
        return true;
    }

    public boolean canBeJournalSource(VolumeTreeNode node, StringBuffer reason) {
        boolean isParerentAVolume;
        boolean isExposed = node.isExposed();
        boolean isTransparentVolume = node instanceof TransparentVolumeNode;
        boolean isSnapShotVolume = node instanceof SnapshotVolumeNode;
        boolean isJournalVolume = node instanceof JournalVolumeNode;
        boolean bl = isParerentAVolume = node.getParent() != null && node.getParent() instanceof VolumeNode;
        if (isExposed) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.DR_JOURNAL_VALIDAION_THE_SOURCE_IS_EXPOSED));
        } else if (isParerentAVolume) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.DR_JOURNAL_VALIDAION_THE_SOURCE_PARENT_IS_A_VOLUME));
        } else if (isSnapShotVolume) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.DR_JOURNAL_VALIDAION_THE_SOURCE_IS_A_SNAPSHOT));
        } else if (isTransparentVolume) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.DR_JOURNAL_VALIDAION_THE_SOURCE_IS_A_TRANSPARENT));
        } else if (isJournalVolume) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.DR_JOURNAL_VALIDAION_THE_SOURCE_IS_A_JOURNAL));
        }
        return !isExposed && !isSnapShotVolume && !isTransparentVolume && !isJournalVolume && !isParerentAVolume;
    }

    public boolean canBePairSource(VolumeNode node, StringBuffer reason) {
        boolean isTransparentVolume = node instanceof TransparentVolumeNode;
        boolean isSnapShotVolume = node instanceof SnapshotVolumeNode;
        boolean isJournalVolume = node instanceof JournalVolumeNode;
        boolean isChildVolume = node.getParent() instanceof VolumeTreeNode;
        if (isChildVolume) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.DR_PAIR_VALIDAION_THE_SOURCE_PARENT_IS_A_VOLUME));
        } else if (isSnapShotVolume) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.DR_PAIR_VALIDAION_THE_SOURCE_IS_A_SNAPSHOT));
        } else if (isTransparentVolume) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.DR_PAIR_VALIDAION_THE_SOURCE_IS_A_TRANSPARENT));
        } else if (isJournalVolume) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.DR_PAIR_VALIDAION_THE_SOURCE_IS_A_JOURNAL));
        }
        return !isSnapShotVolume && !isTransparentVolume && !isJournalVolume && !isChildVolume;
    }

    public boolean isCreateAnotherJournalAllowed(ClusterNode cluster) {
        if (cluster == null) {
            theLogger.error(SrLogCategories.ILLEGAL_STATE, "The given cluster should not be null");
            return false;
        }
        boolean showCreateJournal = false;
        List<VSwitchNode> vswitches = cluster.getClusterVSwitches();
        for (VSwitchNode vswitch : vswitches) {
            if (!vswitch.isConnected() || this.hasJournalOnVSwitch(vswitch)) continue;
            showCreateJournal = true;
            break;
        }
        return showCreateJournal;
    }

    public boolean isCreateAnotherJournalAllowed() {
        SiteNode[] sites = SystemRootNode.getInstance().getSiteNodes();
        int i = sites.length;
        while (i-- > 0) {
            ClusterNode[] clusters = sites[i].getSiteClusters();
            int j = clusters.length;
            while (j-- > 0) {
                if (!this.isCreateAnotherJournalAllowed(clusters[j])) continue;
                return true;
            }
        }
        return false;
    }

    public int getJournalCreateAllowedCount(ClusterNode cluster) {
        int count = 0;
        List<VSwitchNode> vswitches = cluster.getClusterVSwitches();
        for (VSwitchNode vswitch : vswitches) {
            if (!vswitch.isConnected() || this.hasJournalOnVSwitch(vswitch)) continue;
            ++count;
        }
        return count;
    }

    public int getJournalCreateAllowedCount() {
        int count = 0;
        SiteNode[] sites = SystemRootNode.getInstance().getSiteNodes();
        int i = sites.length;
        while (i-- > 0) {
            ClusterNode[] clusters = sites[i].getSiteClusters();
            int j = clusters.length;
            while (j-- > 0) {
                count += this.getJournalCreateAllowedCount(clusters[j]);
            }
        }
        return count;
    }

    public boolean hasJournalOnVSwitch(VSwitchNode vswitch) {
        return this.m_vswitchToJournalMap.containsKey(vswitch.getIPAddress());
    }

    public JournalVolumeNode getJournalOnVSwitch(VSwitchNode vswitch) {
        return this.m_vswitchToJournalMap.get(vswitch.getIPAddress());
    }

    public void openCreatePairWizard(VolumeTreeNode primaryVolume) {
    }

    public void clearClusterJournals(ClusterNode cluster) {
        List<VSwitchNode> vswitches = cluster.getClusterVSwitches();
        for (VSwitchNode vswitch : vswitches) {
            this.clearVSwitchJournals(vswitch);
        }
    }

    public void clearVSwitchJournals(VSwitchNode aVswitchNode) {
        this.m_vswitchToJournalMap.remove(aVswitchNode.getIPAddress());
    }

    public boolean isVolumeInvolvedInReplication(VolumeTreeNode node) {
        DRPairNode pairNode = DRPairManager.getPairContainingVolume(node);
        if (pairNode != null) {
            boolean isInactive = DRReplicationStateConstant.INACTIVE.equals(pairNode.getReplicationState());
            return !isInactive;
        }
        return false;
    }

    public SrFuture<Void> refreshJournalUtilization(JournalVolumeNode journal) {
        return ClientAOImpl.getInstance().refreshPercentUtilization((CommKeyClassId)journal.getIdentifier());
    }

    public String getDefaultSnapshotAlias(VolumeTreeNode snapshotSource) {
        String defaultAliasPrefix = "S" + Util.replaceInvalidCharacters(snapshotSource.getAlias(), INVALID_ALIAS_CHARS_REGEX) + "_";
        List clusterSnapshots = this.getClusterSnapshotMap().getAllSnapshotsVolumes(SystemRootNode.getInstance().getClusterNodeOfSource(snapshotSource));
        int numberOfAliasesStartWithPrefix = 0;
        if (clusterSnapshots != null) {
            for (int index = 0; index < clusterSnapshots.size(); ++index) {
                SnapshotVolumeNode snapshotVolume = (SnapshotVolumeNode)clusterSnapshots.get(index);
                if (!snapshotVolume.getAlias().startsWith(defaultAliasPrefix)) continue;
                ++numberOfAliasesStartWithPrefix;
            }
        }
        return defaultAliasPrefix + (numberOfAliasesStartWithPrefix + 1);
    }

    private ClusterNode getWorkingCluster(Vector<VolumeTreeNode> aChildrenNodes) {
        return SystemRootNode.getInstance().getClusterNodeOfSource(aChildrenNodes.elementAt(0));
    }

    private CommKeyClassId[] getIds(Vector<VolumeTreeNode> aChildrenNodes) {
        int size = aChildrenNodes.size();
        CommKeyClassId[] childrenCommKeyClassId = new CommKeyClassId[size];
        for (int i = 0; i < size; ++i) {
            VolumeTreeNode child = aChildrenNodes.elementAt(i);
            childrenCommKeyClassId[i] = (CommKeyClassId)child.getIdentifier();
        }
        return childrenCommKeyClassId;
    }

    public List<VolumeTreeNode> getAllVolumes(ClusterNode aCluster) {
        ArrayList<VolumeTreeNode> allVolumes = new ArrayList<VolumeTreeNode>();
        SrNotExposedVolumeTreeModel notExposedVolumesModel = (SrNotExposedVolumeTreeModel)NotExposedVolumeTreeModelCollection.getInstance().getModel((RemoteObject)aCluster.getStub());
        allVolumes.addAll(notExposedVolumesModel.getAllVolumes());
        SrExposedVolumesTableModel exposedVolumesModel = (SrExposedVolumesTableModel)ExposedVolumesTableModelCollection.getInstance().getModel((RemoteObject)aCluster.getStub());
        int volColIndex = exposedVolumesModel.getColumnIndex(ExposedVolumesTableHeader.VOLUME_NAME.getColumnName());
        for (int i = 0; i < exposedVolumesModel.getRowCount(); ++i) {
            allVolumes.add((VolumeTreeNode)exposedVolumesModel.getValueAt(i, volColIndex));
        }
        return allVolumes;
    }

    public List<String> getAllVolumeAliases(ClusterNode aCluster) {
        ArrayList<String> allAliases = new ArrayList<String>();
        for (VolumeTreeNode volume : this.getAllVolumes(aCluster)) {
            this.collectAllVolumeSubTreeAliases(volume, allAliases);
        }
        return allAliases;
    }

    private void collectAllVolumeSubTreeAliases(VolumeTreeNode aVolume, List<String> aCollectAliases) {
        aCollectAliases.add(aVolume.getAlias());
        if (aVolume instanceof VolumeNode) {
            for (Object childObj : aVolume.getChildren()) {
                this.collectAllVolumeSubTreeAliases((VolumeTreeNode)childObj, aCollectAliases);
            }
        } else if (aVolume.isDevice()) {
            StorageDeviceNode device = (StorageDeviceNode)aVolume;
            aCollectAliases.add(device.getAlias());
        }
    }

    public static class DROfflineLocalCopyValidator {
        public boolean isValidForOfflineLocalCopy(VolumeTreeNode volume, SiteNode secondarySite) {
            ArrayList searchedDisks = new ArrayList();
            ArrayList involvedDisks = this.getChildrenDiskList(volume);
            int i = involvedDisks.size();
            while (i-- > 0) {
                DirectAccessDeviceNode disk = (DirectAccessDeviceNode)involvedDisks.get(i);
                if (this.areAllVolumesOfflineLocals(disk, searchedDisks, secondarySite)) continue;
                return false;
            }
            return true;
        }

        public boolean isDiskChildUsedByOfflineLocalCopy(VolumeTreeNode volume, VolumeTreeNode candidateForLocalCopy) {
            ArrayList<VolumeTreeNode> offlineLocalVolumesList = null;
            ArrayList diskList = this.getChildrenDiskList(volume);
            int i = diskList.size();
            while (i-- > 0) {
                DirectAccessDeviceNode disk = (DirectAccessDeviceNode)diskList.get(i);
                VolumeTreeNode[] otherVolumes = this.getParentVolumes(disk);
                int j = otherVolumes.length;
                while (j-- > 0) {
                    if (otherVolumes[j] == volume) continue;
                    if (offlineLocalVolumesList == null) {
                        offlineLocalVolumesList = new ArrayList<VolumeTreeNode>();
                        if (candidateForLocalCopy != null) {
                            offlineLocalVolumesList.add(candidateForLocalCopy);
                        }
                        ClusterNode cluster = SystemRootNode.getInstance().getClusterNodeOfSource(volume);
                        SiteNode site = (SiteNode)cluster.getParent();
                        DRPairNode[] pairs = SrPairDetailsTableModel.getInstance().getPairsPrimaryOnSite(site);
                        int k = pairs.length;
                        while (k-- > 0) {
                            VolumeTreeNode offlineLocalCopy;
                            if (!pairs[k].getClass().equals(DRASyncPairNode.class) || (offlineLocalCopy = ((DRASyncPairNode)pairs[k]).getOfflineLocalCopy()) == null) continue;
                            offlineLocalVolumesList.add(offlineLocalCopy);
                            if (!offlineLocalCopy.equals(volume)) continue;
                            return true;
                        }
                        continue;
                    }
                    if (!offlineLocalVolumesList.contains(otherVolumes[j])) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isDiskChildUsedByOfflineLocalCopy(VolumeTreeNode volume) {
            return this.isDiskChildUsedByOfflineLocalCopy(volume, null);
        }

        private boolean areAllVolumesOfflineLocals(DirectAccessDeviceNode disk, ArrayList searchedDisks, SiteNode secSite) {
            searchedDisks.add(disk);
            VolumeTreeNode[] diskVolumes = this.getParentVolumes(disk);
            int i = diskVolumes.length;
            while (i-- > 0) {
                if (!this.isOfflineLocalVolume(diskVolumes[i], secSite)) {
                    return false;
                }
                ArrayList involvedDisks = this.getChildrenDiskList(diskVolumes[i]);
                involvedDisks.removeAll(searchedDisks);
                int j = involvedDisks.size();
                while (j-- > 0) {
                    DirectAccessDeviceNode disk1 = (DirectAccessDeviceNode)involvedDisks.get(j);
                    if (this.areAllVolumesOfflineLocals(disk1, searchedDisks, secSite)) continue;
                    return false;
                }
            }
            return true;
        }

        private ArrayList getChildrenDiskList(VolumeTreeNode volume) {
            ArrayList disks = new ArrayList();
            this.loadChildrenDisk(volume, disks);
            return disks;
        }

        private void loadChildrenDisk(VolumeTreeNode volume, ArrayList childrenDisks) {
            if (volume.getClass().equals(DirectAccessDeviceNode.class)) {
                return;
            }
            if (volume.getClass().equals(SubDirectAccessDeviceNode.class)) {
                childrenDisks.add(((SubDirectAccessDeviceNode)volume).getDirectAccessDeviceParent());
            }
            Enumeration<TreeNode> e = volume.children();
            while (e.hasMoreElements()) {
                VolumeTreeNode child = (VolumeTreeNode)e.nextElement();
                if (child.getClass().equals(DirectAccessDeviceNode.class)) {
                    childrenDisks.add(child);
                    continue;
                }
                if (child.getClass().equals(SubDirectAccessDeviceNode.class)) {
                    childrenDisks.add(((SubDirectAccessDeviceNode)child).getDirectAccessDeviceParent());
                    continue;
                }
                this.loadChildrenDisk(child, childrenDisks);
            }
        }

        private VolumeTreeNode[] getParentVolumes(DirectAccessDeviceNode disk) {
            HashSet<VolumeTreeNode> volSet = new HashSet<VolumeTreeNode>();
            if (!disk.hasSubdisks()) {
                VolumeTreeNode volumeParent = disk;
                while (volumeParent.isChildOfAnotherVolume()) {
                    volumeParent = (VolumeTreeNode)volumeParent.getParent();
                }
                volSet.add(volumeParent);
            } else {
                List<RemoteObject> splits = disk.getSplits();
                int i = splits.size();
                while (i-- > 0) {
                    VolumeTreeNode subDisk;
                    SrTreeNode split = SystemRootNode.getInstance().getRefByStub(splits.get(i));
                    if (!(split instanceof VolumeTreeNode)) continue;
                    VolumeTreeNode volumeParent = subDisk = (VolumeTreeNode)split;
                    if (subDisk == null) continue;
                    while (volumeParent.isChildOfAnotherVolume()) {
                        volumeParent = (VolumeTreeNode)volumeParent.getParent();
                    }
                    volSet.add(volumeParent);
                }
            }
            return volSet.toArray(new VolumeTreeNode[volSet.size()]);
        }

        private boolean isOfflineLocalVolume(VolumeTreeNode volume, SiteNode secSite) {
            DRPairNode[] pairs = SrPairDetailsTableModel.getInstance().getPairsSecondaryOnSite(secSite);
            int i = pairs.length;
            while (i-- > 0) {
                VolumeTreeNode offlineLocalCopy;
                if (!pairs[i].getClass().equals(DRASyncPairNode.class) || (offlineLocalCopy = ((DRASyncPairNode)pairs[i]).getOfflineLocalCopy()) == null || !offlineLocalCopy.equals(volume)) continue;
                return true;
            }
            return false;
        }
    }

    public static class OpenCreateJournalDialog<T extends VolumeTreeNode>
    extends SrClientAction<T, Void> {
        public OpenCreateJournalDialog(View<T> view) {
            super(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_POPUP_MENU_CREATE_JOURNAL_LABEL), true, true, view, SrLicenseTreePath.GENERAL_PATH, true);
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<T> arg) {
            final VolumeTreeNode node = (VolumeTreeNode)arg.iterator().next();
            final ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(node);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SrCreateJournalDlg dlg = new SrCreateJournalDlg((JFrame)ClientLoader.getMainFrame(), ((SiteNode)clusterNode.getParent()).getAlias(), clusterNode, node);
                    dlg.show();
                }
            });
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            VolumeTreeNode node = (VolumeTreeNode)this.myView.getValue().iterator().next();
            StringBuffer reason = new StringBuffer("");
            if (!VolumeManager.getInstance().isCreateJournalAllowed(node, reason)) {
                return reason.toString();
            }
            return null;
        }

        @Override
        public String getMultipleSelectionTooltip() {
            return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VALIDAION_MORE_THAN_ONE_SOURCE_WAS_SELECTED);
        }
    }

    public static class ActivateDeactivateSnapshot<T extends VolumeTreeNode>
    extends SrClientAction<T, Void> {
        private boolean myActive;

        public ActivateDeactivateSnapshot(boolean active, View<T> myView, OperationController controller) {
            super(true, true, myView, SrLicenseTreePath.VOLUME_PATH);
            this.myActive = active;
            this.addControllerAsListener(controller);
            this.setName(this.myActive ? "Activate" : "Deactivate");
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<T> arg) {
            CommKeyClassId[] snapshotIds = new CommKeyClassId[arg.size()];
            int i = 0;
            ClusterNode cluster = null;
            for (VolumeTreeNode snapshot : arg) {
                snapshotIds[i++] = (CommKeyClassId)snapshot.getIdentifier();
                cluster = SystemRootNode.getInstance().getClusterNodeOfSource(snapshot);
            }
            SnapshotActivateTypeConstants sat = this.myActive ? SnapshotActivateTypeConstants.SNAPSHOT_ACTIVE : SnapshotActivateTypeConstants.SNAPSHOT_INACTIVE;
            return Collections.singleton(ClientAOImpl.getInstance().activateDeactivateSnapshots(cluster.getStorageID(), snapshotIds, sat));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            Collection value = this.myView.getValue();
            for (VolumeTreeNode volumeNode : value) {
                SnapshotVolumeNode snapshotVolume = (SnapshotVolumeNode)volumeNode;
                boolean isSnapshotVolumeInActiveState = snapshotVolume.isActivated();
                if (isSnapshotVolumeInActiveState == this.myActive) {
                    if (this.myActive) {
                        return "Selection contains an active volume.";
                    }
                    return "Selection contains an inactive volume.";
                }
                StringBuffer reason = new StringBuffer("");
                boolean canSnapshotVolumeBeActived = VolumeManager.getInstance().canSnapshotBeActivated(snapshotVolume, reason);
                if (canSnapshotVolumeBeActived) continue;
                return reason.toString();
            }
            return null;
        }

        @Override
        protected boolean shouldClientActionBeVisible() {
            for (VolumeTreeNode volumeNode : this.myView.getValue()) {
                if (VolumeManager.getInstance().isSnapshotVolume(volumeNode)) continue;
                return false;
            }
            return true;
        }
    }

    private class RemoveVolumeNodeFromParentInformer
    implements SrEventListenerManager.Informer<VolumeListener, VolumeEvent> {
        private VolumeTreeNode childNode;

        private RemoveVolumeNodeFromParentInformer() {
        }

        public void setChildNode(VolumeTreeNode childNode) {
            this.childNode = childNode;
        }

        @Override
        public void inform(VolumeListener listener, VolumeEvent event) {
            listener.removeVolumeNodeFromParent(event, this.childNode);
        }
    }

    private class AddVolumeNodeToParentInformer
    implements SrEventListenerManager.Informer<VolumeListener, VolumeEvent> {
        private VolumeTreeNode parentNode;
        private VolumeTreeNode childNode;

        private AddVolumeNodeToParentInformer() {
        }

        public void setParentNode(VolumeTreeNode parentNode) {
            this.parentNode = parentNode;
        }

        public void setChildNode(VolumeTreeNode childNode) {
            this.childNode = childNode;
        }

        @Override
        public void inform(VolumeListener listener, VolumeEvent event) {
            listener.addVolumeNodeToParent(event, this.parentNode, this.childNode);
        }
    }
}

