/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.volume;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.DRPairManager;
import com.sanrad.nms.client.data.volume.VolumeOperationHandler;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.volume.copy.CopyOperManager;
import com.sanrad.util.concurrent.SrFuture;
import java.util.Collection;
import java.util.Collections;

public class VolumeCreationHandler
extends VolumeOperationHandler {
    private static final SrLogger theLogger = SrLogger.getLogger();

    public VolumeCreationHandler(ClusterNode aClusterToWorkWith) {
        super(null, aClusterToWorkWith);
    }

    @Override
    public Collection<SrFuture<Void>> operate(VolumeTreeNode<?> targetVolume) {
        theLogger.logAndAssert(SrLogCategories.ERROR, "Running operate() on VolumeCreationHandler");
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean isVolumeOperation() {
        return false;
    }

    public String isOperationLegitimate(VolumeTreeNode volumeNode) {
        String superResult = super.isOperationLegitimate(volumeNode);
        if (superResult != null) {
            return superResult;
        }
        if (CopyOperManager.getInstance().isInvolvedInOfflineCopy(volumeNode)) {
            return "The selected volume is involved in an offline copy";
        }
        if (DRPairManager.getPairContainingVolume(volumeNode) != null) {
            return "The selected volume is a part of a pair";
        }
        return null;
    }

    @Override
    public String getOperationName() {
        return "Advanced Volume Operations";
    }

    @Override
    public String toString() {
        return this.getOperationName();
    }

    @Override
    public boolean shouldBlockAction() {
        return false;
    }
}

