/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.volume;

import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.license.SrFeatureNameConstant;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.volume.Volume;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;

public abstract class VirtualVolumeNode<T extends Volume>
extends VolumeNode<T> {
    private static SrLicenseTreePath licensePath = new SrLicenseTreePath(SrLicenseTreePath.VOLUME_PATH, SrFeatureNameConstant.VIRTUAL);

    protected VirtualVolumeNode(T stub, String alias, boolean exposed, String type) throws RemoteException {
        super(stub, alias, exposed, type);
    }

    public void setChildren(RemoteObject[] childrenStubs) {
        Vector childrenToRemove = new Vector();
        Vector<SrTreeNode> newChildren = new Vector<SrTreeNode>();
        for (int i = 0; i < childrenStubs.length; ++i) {
            newChildren.add(SystemRootNode.getInstance().getRefByStub(childrenStubs[i]));
        }
        if (this.children == null) {
            this.children = new Vector();
        }
        if (this.children.containsAll(newChildren) && newChildren.containsAll(this.children)) {
            return;
        }
        for (Object e : this.children) {
            if (newChildren.contains(e)) continue;
            childrenToRemove.add(e);
        }
        for (VolumeTreeNode volumeTreeNode : newChildren) {
            if (volumeTreeNode == null || this.children.contains(volumeTreeNode)) continue;
            int newChildIndex = this.getTreePositionForNewVolumeChild(volumeTreeNode);
            this.insert(volumeTreeNode, newChildIndex);
            volumeTreeNode.setConfigurationParent(this);
        }
        for (VolumeTreeNode volumeTreeNode : childrenToRemove) {
            this.remove(volumeTreeNode);
            if (!this.equals(volumeTreeNode.getConfigurationParent())) continue;
            volumeTreeNode.setConfigurationParent(null);
            if (!(volumeTreeNode instanceof VolumeNode)) continue;
            VolumeManager.getInstance().fireVolumeDeExposed(volumeTreeNode);
        }
        VolumeManager.getInstance().updateVolumeDataFromServer(this);
    }

    public int getTreePositionForNewVolumeChild(VolumeTreeNode aNewChild) {
        int newChildIndex = 0;
        List<VolumeTreeNode> currVolumeChildren = this.getChildrenOfType(VolumeTreeNode.class);
        for (VolumeTreeNode currChild : currVolumeChildren) {
            if (currChild.compareByPosition(aNewChild) >= 0) break;
            ++newChildIndex;
        }
        return newChildIndex;
    }

    @Override
    public SrLicenseTreePath getLicensePath() {
        return licensePath;
    }
}

