/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.volume;

import com.sanrad.nms.client.data.volume.VirtualVolumeNode;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.server.logic.volume.Volume;
import com.sanrad.util.StorageSize;
import java.math.BigInteger;
import java.rmi.RemoteException;

public class StripeVolumeNode
extends VirtualVolumeNode<Volume> {
    private BigInteger myStripeSize;
    private String myStripeSizeStr;

    public StripeVolumeNode(Volume stub, String alias, boolean exposed) throws RemoteException {
        super(stub, alias, exposed, "Stripe");
        this.setNodeIcon(ClientImageObject.STRIPE_VOLUME);
    }

    public void setStripeSize(BigInteger aStripeSize) {
        this.myStripeSize = aStripeSize;
        this.myStripeSizeStr = StorageSize.getSizeAsString(this.myStripeSize);
    }

    public BigInteger getStripeSize() {
        return this.myStripeSize;
    }

    @Override
    public String toString() {
        if (this.myStripeSize != null) {
            return super.toString() + " (" + this.myStripeSizeStr + ")";
        }
        return super.toString();
    }

    @Override
    public String type() {
        return "Volume: Stripe ";
    }
}

