/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.volume;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.AliasObject;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.event.DirectAccessDeviceEvent;
import com.sanrad.nms.client.event.DirectAccessDeviceListener;
import com.sanrad.nms.client.event.SubDirectAccessDeviceEvent;
import com.sanrad.nms.client.event.SubDirectAccessDeviceListener;
import com.sanrad.nms.client.event.volume.VolumeEvent;
import com.sanrad.nms.client.event.volume.VolumeListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.swing.SrKeyObjectSelectionTableModel;
import com.sanrad.swing.SrTableColumns;
import com.sanrad.util.StorageSize;
import java.math.BigInteger;
import java.util.List;

public abstract class SrVolumesTableModel
extends SrKeyObjectSelectionTableModel
implements DirectAccessDeviceListener,
SubDirectAccessDeviceListener,
VolumeListener {
    private static SrLogger theLogger = SrLogger.getLogger();

    protected SrVolumesTableModel(SrTableColumns cols) {
        super(cols);
        VolumeManager.getInstance().addVolumeListener(this);
    }

    public void clear() {
        this.removeAllRows();
    }

    public abstract void rename(RemoteObject var1, String var2);

    @Override
    public void directAccessDeviceAliasChanged(DirectAccessDeviceEvent e) {
        this.rename(e.getStub(), e.getAlias());
    }

    @Override
    public void directAccessDeviceChanged(DirectAccessDeviceEvent e) {
    }

    @Override
    public void directAccessDeviceRemoved(DirectAccessDeviceEvent event) {
    }

    @Override
    public void directAccessDeviceInfoChanged(DirectAccessDeviceEvent event) {
    }

    @Override
    public void directAccessDeviceStatusChanged(DirectAccessDeviceEvent event) {
        this.fireTableRowsUpdated(0, this.getLastRowIndex());
    }

    @Override
    public void directAccessDeviceBlinkStateChange(DirectAccessDeviceEvent event) {
        this.fireTableRowsUpdated(0, this.getLastRowIndex());
    }

    @Override
    public void subDirecetAccessDeviceCreated(SubDirectAccessDeviceEvent event) {
    }

    @Override
    public void subDirecetAccessDeviceRemoved(SubDirectAccessDeviceEvent event) {
    }

    @Override
    public void subDirecetAccessDeviceAliasChanged(SubDirectAccessDeviceEvent event) {
        this.rename(event.getStub(), event.getAlias());
    }

    @Override
    public void subDirecetAccessDeviceStatusChanged(SubDirectAccessDeviceEvent event) {
        this.fireTableRowsUpdated(0, this.getLastRowIndex());
    }

    @Override
    public void subDirecetAccessDeviceInfoChanged(SubDirectAccessDeviceEvent event) {
    }

    @Override
    public void subDirectAccessDeviceExposed(SubDirectAccessDeviceEvent event) {
    }

    @Override
    public void subDirectAccessDeviceDeExposed(SubDirectAccessDeviceEvent event) {
    }

    @Override
    public void directAccessDeviceExposed(DirectAccessDeviceEvent event) {
    }

    @Override
    public void directAccessDeviceDeExposed(DirectAccessDeviceEvent event) {
    }

    private boolean isSelected(int[] selected, int row) {
        for (int i = 0; i < selected.length; ++i) {
            if (selected[i] != row) continue;
            return true;
        }
        return false;
    }

    protected abstract void updateRow(VolumeTreeNode var1);

    protected void updateRow(VolumeTreeNode volume, int nameCol, int accessibleCol, int allocatedCol) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            List<Object> rowData = this.getRow(i);
            VolumeTreeNode volumeObj = (VolumeTreeNode)rowData.get(nameCol);
            if (volumeObj.getStub() != null) {
                if (!volumeObj.getStub().equals(volume.getStub())) continue;
                BigInteger accessibleSpace = volume.getAccessibleSpace();
                BigInteger allocatedSpace = volume.getAllocatedSpace();
                AliasObject accSpace = new AliasObject(StorageSize.getSizeAsString(accessibleSpace), accessibleSpace);
                AliasObject allocSpace = new AliasObject(StorageSize.getSizeAsString(allocatedSpace), allocatedSpace);
                this.setValueAt(accSpace, i, accessibleCol);
                this.setValueAt(allocSpace, i, allocatedCol);
                continue;
            }
            theLogger.info(SrLogCategories.INFORMATIVE, new IllegalStateException("This exception was not thrown. SrTreeNode.getStub() return null, probably memory leak of a VolumeTreeNode after rediscover. volumeObj = " + volumeObj));
        }
    }

    @Override
    public void volumeCapacityChanged(VolumeEvent e) {
        VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(e.getStub());
        this.updateRow(volume);
    }

    @Override
    public void volumeCreate(VolumeEvent e) {
    }

    @Override
    public void volumeRemove(VolumeEvent e) {
    }

    @Override
    public void volumeExposed(VolumeEvent e) {
    }

    @Override
    public void volumeDeExposed(VolumeEvent e) {
    }

    @Override
    public void volumeAliasChanged(VolumeEvent e) {
    }

    @Override
    public void volumeStatusChanged(VolumeEvent e) {
    }

    @Override
    public void volumeConfigChanged(VolumeEvent e) {
    }

    @Override
    public void volumeStateChanged(VolumeEvent e) {
    }

    @Override
    public void volumeParametersChanged(VolumeEvent e) {
    }

    @Override
    public void snapshotSourceChanged(VolumeEvent e) {
    }

    @Override
    public void addVolumeNodeToParent(VolumeEvent event, VolumeTreeNode parentNode, VolumeTreeNode childNode) {
    }

    @Override
    public void removeVolumeNodeFromParent(VolumeEvent event, VolumeTreeNode childNode) {
    }

    @Override
    public void journalVolActivateOnVSwitchChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolActivityStateChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolDateAndTimeChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolPercentageThresholdChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolPercentageUtilizationChanged(VolumeEvent event) {
    }

    @Override
    public void snapshotVolActiveStateChanged(VolumeEvent event) {
    }
}

