/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.volume;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceManager;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceManager;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceNode;
import com.sanrad.nms.client.data.volume.VirtualVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.event.volume.VolumeEvent;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.swing.SrTreeModel;
import com.sanrad.swing.StatusPanel;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public abstract class SrVolumeTreeModel
extends SrTreeModel {
    private static SrLogger theLogger = SrLogger.getLogger();

    public SrVolumeTreeModel(DefaultMutableTreeNode root) {
        super(root);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        theLogger.trace(SrLogCategories.LEGACY, "VolumeTreeModel - valueForPathChanged() ! new alias- ", newValue);
        theLogger.trace(SrLogCategories.LEGACY, "======================================================");
        SrTreeNode aNode = (SrTreeNode)path.getLastPathComponent();
        aNode.setNewAlias(newValue.toString());
        String newAlias = newValue.toString();
        if (newAlias.equals("") || newAlias.equals(((VolumeTreeNode)aNode).getAlias())) {
            this.nodeChanged(aNode);
            return;
        }
        HashMap<ClientParameterCode, String> params = new HashMap<ClientParameterCode, String>();
        if (aNode instanceof SubDirectAccessDeviceNode) {
            params.put(ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_ALIAS, newAlias);
            SrClientAction.blockActions(Collections.singleton(SubDirectAccessDeviceManager.getInstance().editSubDirectAccessDevice((SubDirectAccessDeviceNode)aNode, params)), StatusPanel.getInstance());
        } else if (aNode instanceof DirectAccessDeviceNode) {
            params.put(ClientParameterCode.PHYSICAL_STORAGE_DEVICE_ALIAS, newAlias);
            SrClientAction.blockActions(Collections.singleton(DirectAccessDeviceManager.getInstance().renameStorageDevice((DirectAccessDeviceNode)aNode, params)), StatusPanel.getInstance());
        } else if (aNode instanceof VolumeTreeNode) {
            params.put(ClientParameterCode.VOLUME_ALIAS, newAlias);
            SrClientAction.blockActions(Collections.singleton(VolumeManager.getInstance().setAlias(aNode, params)), StatusPanel.getInstance());
        }
        this.fireTreeStructureChanged(this, this.getPathToRoot(aNode), null, null);
    }

    public void notifyVolumeRemoved(VolumeTreeNode removedVolume, List removedVolumeChildren) {
        Vector<VolumeTreeNode> leafChildren = new Vector<VolumeTreeNode>();
        Vector<VolumeTreeNode> nodesChildren = new Vector<VolumeTreeNode>();
        for (VolumeTreeNode child : removedVolumeChildren) {
            if (child.isLeaf()) {
                leafChildren.addElement(child);
                continue;
            }
            nodesChildren.addElement(child);
        }
        if (!nodesChildren.isEmpty()) {
            this.insertVolumesToTree(nodesChildren);
        }
    }

    private void insertVolumesToTree(Vector nodes) {
        for (int i = 0; i < nodes.size(); ++i) {
            VolumeTreeNode node = (VolumeTreeNode)nodes.get(i);
            this.insertOrderedByName((DefaultMutableTreeNode)this.getRoot(), node);
        }
    }

    public void snapshotVolActiveStateChanged(VolumeEvent event, boolean isActivated) {
    }

    public void insertVolumeNodeToModel(VolumeTreeNode newVolume, DefaultMutableTreeNode parent) {
        if (parent instanceof VirtualVolumeNode) {
            int childPosInParent = ((VirtualVolumeNode)parent).getTreePositionForNewVolumeChild(newVolume);
            super.insertNodeInto(newVolume, parent, childPosInParent);
        } else {
            super.insertOrderedByName(parent, newVolume);
        }
    }
}

