/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.volume;

import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.volume.SrVolumesTableModel;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.event.DirectAccessDeviceEvent;
import com.sanrad.nms.client.event.volume.VolumeEvent;
import com.sanrad.nms.client.gui.volume.UnExposedVolumesTableHeader;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.util.StorageSize;
import java.util.ArrayList;
import java.util.Vector;

public class SrUnExposedVolumesTableModel
extends SrVolumesTableModel {
    public SrUnExposedVolumesTableModel() {
        super(new SrDefaultTableColumns(UnExposedVolumesTableHeader.getColumnNames()));
    }

    public void addVolumeNode(VolumeTreeNode node, boolean isExposed) {
        if (node.getParent() instanceof VolumeTreeNode) {
            return;
        }
        if (!isExposed) {
            this.addRow(node);
            this.fireTableRowsInserted(this.getLastRowIndex(), this.getLastRowIndex());
        }
    }

    protected void addRow(VolumeTreeNode node) {
        Vector<Object> rowData = new Vector<Object>();
        rowData.add(node);
        rowData.add(StorageSize.getSizeAsString(node.getAccessibleSpace()));
        rowData.add(StorageSize.getSizeAsString(node.getAllocatedSpace()));
        this.addRowQuetly(rowData.toArray(), -1);
    }

    @Override
    public void rename(RemoteObject stub, String newAlias) {
    }

    protected void removeVolume(VolumeTreeNode volumeNode) {
        int rowsCount = this.getRowCount();
        int volNameCol = this.getColumnIndex(UnExposedVolumesTableHeader.VOLUME_NAME.getColumnName());
        for (int i = 0; i < rowsCount; ++i) {
            Object volume = this.getValueAt(i, volNameCol);
            if (!volume.equals(volumeNode)) continue;
            this.removeRow(i);
            return;
        }
    }

    protected void addVolume(VolumeTreeNode volumeNode) {
        if (!volumeNode.isExposed()) {
            this.addVolumeNode(volumeNode, volumeNode.isExposed());
        }
    }

    @Override
    public void volumeExposed(VolumeEvent e) {
        SrTreeNode volumeNode = SystemRootNode.getInstance().getRefByStub(e.getStub());
        this.removeVolume((VolumeTreeNode)volumeNode);
    }

    @Override
    public void volumeDeExposed(VolumeEvent e) {
        SrTreeNode volumeNode = SystemRootNode.getInstance().getRefByStub(e.getStub());
        this.addVolume((VolumeTreeNode)volumeNode);
    }

    @Override
    public void volumeCreate(VolumeEvent e) {
        SrTreeNode volumeNode = SystemRootNode.getInstance().getRefByStub(e.getStub());
        this.addVolume((VolumeTreeNode)volumeNode);
    }

    @Override
    public void volumeRemove(VolumeEvent e) {
        SrTreeNode volumeNode = SystemRootNode.getInstance().getRefByStub(e.getStub());
        this.removeVolume((VolumeTreeNode)volumeNode);
    }

    @Override
    public void volumeAliasChanged(VolumeEvent e) {
        this.fireTableRowsUpdated(0, this.getLastRowIndex());
    }

    @Override
    public void volumeStatusChanged(VolumeEvent e) {
        this.fireTableRowsUpdated(0, this.getLastRowIndex());
    }

    @Override
    public void volumeConfigChanged(VolumeEvent e) {
        this.fireTableRowsUpdated(0, this.getLastRowIndex());
    }

    @Override
    public void volumeStateChanged(VolumeEvent e) {
        this.fireTableRowsUpdated(0, this.getLastRowIndex());
    }

    @Override
    public void volumeParametersChanged(VolumeEvent e) {
        this.fireTableRowsUpdated(0, this.getLastRowIndex());
    }

    @Override
    public void snapshotSourceChanged(VolumeEvent e) {
        this.fireTableRowsUpdated(0, this.getLastRowIndex());
    }

    @Override
    protected void updateRow(VolumeTreeNode volume) {
        int col = this.getColumnIndex(UnExposedVolumesTableHeader.VOLUME_NAME.getColumnName());
        int accCol = this.getColumnIndex(UnExposedVolumesTableHeader.ACCESSIBLE_SPACE.getColumnName());
        int allocCol = this.getColumnIndex(UnExposedVolumesTableHeader.ALLOCATED_SPACE.getColumnName());
        this.updateRow(volume, col, accCol, allocCol);
    }

    @Override
    public void addVolumeNodeToParent(VolumeEvent event, VolumeTreeNode parentNode, VolumeTreeNode childNode) {
    }

    @Override
    public void removeVolumeNodeFromParent(VolumeEvent event, VolumeTreeNode childNode) {
    }

    @Override
    public void snapshotVolActiveStateChanged(VolumeEvent event) {
    }

    @Override
    public void directAccessDeviceCreated(DirectAccessDeviceEvent event) {
    }

    @Override
    public void journalVolActivateOnVSwitchChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolActivityStateChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolDateAndTimeChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolPercentageThresholdChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolPercentageUtilizationChanged(VolumeEvent event) {
    }

    @Override
    public void removeListeners() {
    }

    @Override
    public void addListeners() {
    }

    public VolumeTreeNode getVolume(String aAlias) {
        for (ArrayList row : this.m_data) {
            Object vol = row.get(0);
            if (vol instanceof VolumeTreeNode) {
                if (!((VolumeTreeNode)vol).getAlias().equals(aAlias)) continue;
                return (VolumeTreeNode)vol;
            }
            System.out.println("vol is instance of " + vol.getClass());
        }
        return null;
    }
}

