/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.volume;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceNode;
import com.sanrad.nms.client.data.volume.SrVolumeTreeModel;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.event.DirectAccessDeviceEvent;
import com.sanrad.nms.client.event.SubDirectAccessDeviceEvent;
import com.sanrad.nms.client.event.volume.VolumeEvent;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.swing.tree.SrRootTreeNode;
import com.sanrad.swing.tree.event.TreeNodeEvent;
import com.sanrad.swing.tree.event.TreeNodeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class SrNotExposedVolumeTreeModel
extends SrVolumeTreeModel {
    protected boolean DEBUG = true;
    private static SrLogger theLogger = SrLogger.getLogger();
    private TreeNodesEventHandler m_treeNodeHandler = new TreeNodesEventHandler();

    public SrNotExposedVolumeTreeModel() {
        super(new SrRootTreeNode("Volumes"));
        this.addTreeModelListener(this.m_treeNodeHandler);
        ((SrRootTreeNode)this.getRoot()).addTreeNodeListener(this.m_treeNodeHandler);
    }

    public void clear() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
        root.removeAllChildren();
        this.reload();
    }

    private void fireTreeNodesChanged(SrTreeNode node) {
        Object[] path = this.getPathToRoot(node);
        if (path != null) {
            this.fireTreeNodesChanged(this, path, null, null);
        }
    }

    public void directAccessDeviceAliasChanged(DirectAccessDeviceEvent e) {
        theLogger.trace(SrLogCategories.LEGACY, "NotExposedVolumeTreeModel:: directAccessDeviceAliasChanged()");
        VolumeTreeNode node = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(e.getStub());
        this.fireTreeNodesChanged(node);
    }

    public void directAccessDeviceChanged(DirectAccessDeviceEvent e) {
    }

    public void directAccessDeviceRemoved(DirectAccessDeviceEvent event) {
    }

    public void directAccessDeviceInfoChanged(DirectAccessDeviceEvent event) {
        theLogger.trace(SrLogCategories.LEGACY, "NotExposedVolumeTreeModel:: directAccessDeviceInfoChanged()");
        VolumeTreeNode node = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(event.getStub());
        this.fireTreeNodesChanged(node);
    }

    public void directAccessDeviceStatusChanged(DirectAccessDeviceEvent event) {
        theLogger.trace(SrLogCategories.LEGACY, "NotExposedVolumeTreeModel:: directAccessDeviceStatusChanged()");
        VolumeTreeNode node = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(event.getStub());
        this.fireTreeNodesChanged(node);
    }

    public void subDirecetAccessDeviceCreated(SubDirectAccessDeviceEvent event) {
        VolumeTreeNode volNode;
        theLogger.trace(SrLogCategories.LEGACY, "NotExposedVolumeTreeModel::: subdiskCreate()");
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(event.getStub());
        if (node != null && !(volNode = (VolumeTreeNode)node).isExposed()) {
            theLogger.trace(SrLogCategories.LEGACY, "NotExposedVolumeTreeModel::: adding the new volume.");
            this.addVolumeNode(volNode, event.isExposed());
        }
    }

    public void subDirecetAccessDeviceRemoved(SubDirectAccessDeviceEvent event) {
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(event.getStub());
        if (node != null) {
            this.removeVolumeNode((VolumeTreeNode)node);
        }
    }

    public void subDirecetAccessDeviceAliasChanged(SubDirectAccessDeviceEvent event) {
        theLogger.trace(SrLogCategories.LEGACY, "NotExposedVolumeTreeModel:: subDirecetAccessDeviceAliasChanged()");
        VolumeTreeNode node = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(event.getStub());
        this.fireTreeNodesChanged(node);
    }

    public void subDirecetAccessDeviceStatusChanged(SubDirectAccessDeviceEvent event) {
        theLogger.trace(SrLogCategories.LEGACY, "NotExposedVolumeTreeModel:: subDirecetAccessDeviceStatusChanged()");
        VolumeTreeNode node = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(event.getStub());
        this.fireTreeNodesChanged(node);
    }

    public void volumeExposed(VolumeEvent e) {
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(e.getStub());
        if (node != null) {
            this.removeVolumeNode((VolumeTreeNode)node);
        }
    }

    private boolean removeVolumeNode(VolumeTreeNode node) {
        TreeNode par = node.getParent();
        if (par != null && par.equals(this.getRoot())) {
            try {
                this.removeNodeFromParent(node);
                return true;
            }
            catch (Exception e) {
                theLogger.error(SrLogCategories.LEGACY, "could not remove node: ", node.getAlias(), " properly. Try Cluster rediscovery.", e);
            }
        }
        return false;
    }

    public void volumeDeExposed(VolumeEvent e) {
        VolumeTreeNode volNode;
        theLogger.trace(SrLogCategories.LEGACY, "NotExposedVolumeTreeModel:: volumeDeExposed()");
        RemoteObject stub = e.getStub();
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(stub);
        if (node != null && !((volNode = (VolumeTreeNode)node).getParent() instanceof VolumeTreeNode) && !volNode.isExposed()) {
            this.addVolumeNode(volNode, false);
        }
    }

    public void volumeCreate(VolumeEvent e) {
        VolumeTreeNode volNode;
        theLogger.trace(SrLogCategories.LEGACY, "NotExposedVolumeTreeModel::: volumeCreate()");
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(e.getStub());
        if (node != null && !(volNode = (VolumeTreeNode)node).isExposed()) {
            theLogger.trace(SrLogCategories.LEGACY, "NotExposedVolumeTreeModel::: adding the new volume.");
            this.addVolumeNode(volNode, e.isExposed());
        }
    }

    public void addVolumeNode(VolumeTreeNode node, boolean isExposed) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
        if (node.isExposed() || node.getParent() instanceof VolumeTreeNode) {
            return;
        }
        this.insertVolumeInPosition(root, node);
        this.printChildren(root);
    }

    public void insertVolumeInPosition(DefaultMutableTreeNode parent, VolumeTreeNode newNode) {
        this.insertOrderedByName(parent, newNode);
    }

    private void printChildren(DefaultMutableTreeNode root) {
        if (!this.DEBUG) {
            return;
        }
        Enumeration<TreeNode> children = root.children();
        while (children.hasMoreElements()) {
            VolumeTreeNode child = (VolumeTreeNode)children.nextElement();
            theLogger.trace(SrLogCategories.LEGACY, "child of ", root, " - ", child.getAlias(), " , index: ", root.getIndex(child));
        }
        theLogger.trace(SrLogCategories.LEGACY, root);
        this.printTree(root, "  ");
    }

    private void printTree(DefaultMutableTreeNode root, String ident) {
        int size = this.getChildCount(root);
        for (int i = 0; i < size; ++i) {
            VolumeTreeNode node = (VolumeTreeNode)this.getChild(root, i);
            theLogger.trace(SrLogCategories.LEGACY, ident, i, ". ", node.getAlias());
            this.printTree(node, ident + "  ");
        }
    }

    public void subDirectAccessDeviceExposed(SubDirectAccessDeviceEvent event) {
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(event.getStub());
        if (node != null) {
            this.removeVolumeNode((VolumeTreeNode)node);
        }
    }

    public void subDirectAccessDeviceDeExposed(SubDirectAccessDeviceEvent event) {
        VolumeTreeNode volNode;
        theLogger.trace(SrLogCategories.LEGACY, "NotExposedVolumeTreeModel::: subDirectAccessDeviceDeExposed()");
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(event.getStub());
        if (node != null && !(volNode = (VolumeTreeNode)node).isExposed()) {
            theLogger.trace(SrLogCategories.LEGACY, "subDirectAccessDeviceDeExposed::: adding the new volume.");
            this.addVolumeNode(volNode, event.isExposed());
        }
    }

    public void directAccessDeviceExposed(DirectAccessDeviceEvent event) {
    }

    public void subDirecetAccessDeviceInfoChanged(SubDirectAccessDeviceEvent event) {
    }

    public void directAccessDeviceDeExposed(DirectAccessDeviceEvent event) {
    }

    public void volumeRemove(VolumeEvent e) {
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(e.getStub());
        if (node != null) {
            ArrayList<TreeNode> children = new ArrayList<TreeNode>();
            Enumeration<TreeNode> iter = ((VolumeTreeNode)node).children();
            while (iter.hasMoreElements()) {
                children.add(iter.nextElement());
            }
            for (VolumeTreeNode volumeTreeNode : children) {
                if (!node.equals(volumeTreeNode.getParent())) continue;
                SrRootTreeNode parent = (SrRootTreeNode)volumeTreeNode.getParent();
                if (parent != null) {
                    parent.remove(volumeTreeNode);
                }
                volumeTreeNode.setConfigurationParent(null);
                if (!(volumeTreeNode instanceof SubDirectAccessDeviceNode) || volumeTreeNode.getParent() != null) continue;
                this.addVolumeNode(volumeTreeNode, false);
            }
            boolean isRemoved = this.removeVolumeNode((VolumeTreeNode)node);
            if (isRemoved) {
                super.notifyVolumeRemoved((VolumeTreeNode)node, children);
            }
        }
    }

    public void volumeAliasChanged(VolumeEvent e) {
        theLogger.trace(SrLogCategories.LEGACY, "NotExposedVolumeTreeModel:: volumeAliasChanged()");
        VolumeTreeNode node = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(e.getStub());
        this.fireTreeNodesChanged(node);
    }

    public void volumeStatusChanged(VolumeEvent e) {
        theLogger.trace(SrLogCategories.LEGACY, "NotExposedVolumeTreeModel:: volume status changed. updating the view of NotExposed tree.");
        VolumeTreeNode node = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(e.getStub());
        this.fireTreeNodesChanged(node);
    }

    public void volumeConfigChanged(VolumeEvent e) {
        theLogger.trace(SrLogCategories.LEGACY, "NotExposedVolumeTreeModel:: volume Configuration changed. updating the view of NotExposed tree.");
        VolumeTreeNode node = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(e.getStub());
        this.fireTreeNodesChanged(node);
    }

    @Override
    public void insertNodeInto(MutableTreeNode newChild, MutableTreeNode parent, int index) {
        ((SrRootTreeNode)parent).removeTreeNodeListener(this.m_treeNodeHandler);
        super.insertNodeInto(newChild, parent, index);
        ((SrRootTreeNode)parent).addTreeNodeListener(this.m_treeNodeHandler);
    }

    @Override
    public void removeNodeFromParent(MutableTreeNode node) {
        SrRootTreeNode parent = (SrRootTreeNode)node.getParent();
        parent.removeTreeNodeListener(this.m_treeNodeHandler);
        super.removeNodeFromParent(node);
        parent.addTreeNodeListener(this.m_treeNodeHandler);
    }

    public VolumeTreeNode getVolume(String aAlias) {
        Enumeration<TreeNode> child = ((SrRootTreeNode)this.getRoot()).children();
        while (child.hasMoreElements()) {
            VolumeTreeNode volNode = (VolumeTreeNode)child.nextElement();
            if (!volNode.getAlias().equals(aAlias)) continue;
            return volNode;
        }
        return null;
    }

    public List<VolumeTreeNode> getAllVolumes() {
        ArrayList<VolumeTreeNode> retVal = new ArrayList<VolumeTreeNode>();
        Enumeration<TreeNode> child = ((SrRootTreeNode)this.getRoot()).children();
        while (child.hasMoreElements()) {
            VolumeTreeNode volNode = (VolumeTreeNode)child.nextElement();
            if (volNode instanceof SubDirectAccessDeviceNode) continue;
            retVal.add(volNode);
        }
        return retVal;
    }

    public List<SubDirectAccessDeviceNode> getAllSubdisks() {
        ArrayList<SubDirectAccessDeviceNode> retVal = new ArrayList<SubDirectAccessDeviceNode>();
        Enumeration<TreeNode> child = ((SrRootTreeNode)this.getRoot()).children();
        while (child.hasMoreElements()) {
            TreeNode volNode = child.nextElement();
            if (!(volNode instanceof SubDirectAccessDeviceNode)) continue;
            retVal.add((SubDirectAccessDeviceNode)volNode);
        }
        return retVal;
    }

    private class TreeNodesEventHandler
    implements TreeModelListener,
    TreeNodeListener {
        private TreeNodesEventHandler() {
        }

        @Override
        public void treeNodeRemoving(TreeNodeEvent e) {
        }

        @Override
        public void treeNodeRemoved(TreeNodeEvent e) {
            SrNotExposedVolumeTreeModel.this.nodesWereRemoved((MutableTreeNode)e.getSource(), new int[]{e.getChangedNodeIndex()}, new Object[]{e.getChangedNode()});
        }

        @Override
        public void treeNodeInserted(TreeNodeEvent e) {
            SrNotExposedVolumeTreeModel.this.nodesWereInserted((MutableTreeNode)e.getSource(), new int[]{e.getChangedNodeIndex()});
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            Object[] insertedChildren = e.getChildren();
            if (insertedChildren != null) {
                int i = insertedChildren.length;
                while (i-- > 0) {
                    this.addTreeNodeListenerToAll((SrTreeNode)insertedChildren[i]);
                }
            }
        }

        private void addTreeNodeListenerToAll(SrTreeNode node) {
            node.addTreeNodeListener(this);
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                this.addTreeNodeListenerToAll((SrTreeNode)e.nextElement());
            }
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            Object[] deletedChildren = e.getChildren();
            if (deletedChildren != null) {
                int i = deletedChildren.length;
                while (i-- > 0) {
                    this.removeTreeNodeListenerFromAll((SrTreeNode)deletedChildren[i]);
                }
            }
        }

        private void removeTreeNodeListenerFromAll(SrTreeNode node) {
            node.removeTreeNodeListener(this);
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                this.removeTreeNodeListenerFromAll((SrTreeNode)e.nextElement());
            }
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
        }
    }
}

