/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.volume;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.AliasObject;
import com.sanrad.nms.client.data.LUNode;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.dr.DRASyncPairManager;
import com.sanrad.nms.client.data.dr.DRASyncPairNode;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.dr.DRSyncPairManager;
import com.sanrad.nms.client.data.dr.DRSyncPairNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.StorageDeviceNode;
import com.sanrad.nms.client.data.volume.NonVirtualVolumeNode;
import com.sanrad.nms.client.data.volume.SrVolumesTableModel;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.event.DirectAccessDeviceEvent;
import com.sanrad.nms.client.event.dr.DRAsyncPairEvent;
import com.sanrad.nms.client.event.dr.DRAsyncPairListener;
import com.sanrad.nms.client.event.dr.DRSyncPairEvent;
import com.sanrad.nms.client.event.dr.DRSyncPairListener;
import com.sanrad.nms.client.event.lu.LUEvent;
import com.sanrad.nms.client.event.target.TargetEvent;
import com.sanrad.nms.client.event.volume.VolumeEvent;
import com.sanrad.nms.client.gui.volume.ExposedVolumesTableHeader;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.lu.LU;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.util.StorageSize;
import com.sanrad.util.Util;
import java.math.BigInteger;
import java.util.List;
import javax.swing.tree.TreeNode;

public class SrExposedVolumesTableModel
extends SrVolumesTableModel
implements DRAsyncPairListener,
DRSyncPairListener {
    private static SrLogger theLogger = SrLogger.getLogger();

    public SrExposedVolumesTableModel() {
        super(new SrDefaultTableColumns(ExposedVolumesTableHeader.getColumnNames()));
    }

    @Override
    public void rename(RemoteObject stub, String newAlias) {
        int size = this.getRowCount();
        int ind = this.getColumnIndex(ExposedVolumesTableHeader.VOLUME_NAME.getColumnName());
        for (int i = 0; i < size; ++i) {
            List<Object> rowData = this.getRow(i);
            SrTreeNode sourceObject = (SrTreeNode)rowData.get(ind);
            if (!sourceObject.getStub().equals(stub)) continue;
            this.fireTableCellUpdated(i, ind);
            return;
        }
    }

    public void targetRemove(TargetEvent e) {
        RemoteObject stub = e.getStub();
        int targetCol = this.getColumnIndex(ExposedVolumesTableHeader.TARGET.getColumnName());
        int i = this.getRowCount();
        while (i-- > 0) {
            List<Object> rowData = this.getRow(i);
            AliasObject tarObj = (AliasObject)this.getValueAt(i, targetCol);
            if (!stub.equals(tarObj.getAdditionalValue())) continue;
            this.removeRow(i);
            return;
        }
    }

    public void targetUserNameChanged(TargetEvent e) {
    }

    public void newTargetCreate(TargetEvent e) {
    }

    public void targetVSwitchNameChanged(TargetEvent e) {
    }

    public void targetStatusCanged(TargetEvent e) {
        this.fireTableRowsUpdated(0, this.getLastRowIndex());
    }

    public void targetAliasChanged(TargetEvent e) {
        int size = this.getRowCount();
        int col = this.getColumnIndex(ExposedVolumesTableHeader.TARGET.getColumnName());
        for (int i = 0; i < size; ++i) {
            List<Object> rowData = this.getRow(i);
            AliasObject targetObj = (AliasObject)rowData.get(col);
            if (!targetObj.getAdditionalValue().equals(e.getStub())) continue;
            targetObj.setValue(e.getAlias());
            this.fireTableCellUpdated(i, col);
        }
    }

    public void targetNameChanged(TargetEvent e) {
    }

    public void luStatusChanged(LUEvent event) {
        theLogger.trace(SrLogCategories.LEGACY, "Volume Table changed: LU status is changed. updating table view.");
        this.fireTableRowsUpdated(0, this.getLastRowIndex());
    }

    public void luRemoved(LUEvent event) {
        int colInd = this.getColumnIndex(ExposedVolumesTableHeader.LUN.getColumnName());
        RemoteObject stub = event.getStub();
        int size = this.getRowCount();
        int i = this.getRowCount();
        while (i-- > 0) {
            List<Object> rowData = this.getRow(i);
            LUNode lu = (LUNode)this.getValueAt(i, colInd);
            if (!stub.equals(lu.getStub())) continue;
            this.removeRow(i);
            return;
        }
    }

    public void luChanged(LUEvent event) {
        int luColIndex = this.getColumnIndex(ExposedVolumesTableHeader.LUN.getColumnName());
        LUNode lu = (LUNode)SystemRootNode.getInstance().getRefByStub(event.getStub());
        if (lu != null) {
            int rowCount = this.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                LUNode luNode = (LUNode)this.getValueAt(i, luColIndex);
                if (!((LU)luNode.getStub()).equals(lu.getStub())) continue;
                this.editRow(i, this.buildRow(luNode));
                return;
            }
        }
    }

    public void luCreated(LUEvent event) {
        LUNode luNode = (LUNode)SystemRootNode.getInstance().getRefByStub(event.getStub());
        Object[] rowData = this.buildRow(luNode);
        this.addRow(rowData);
    }

    private Object[] buildRow(LUNode aLuNode) {
        Object[] rowData = new Object[ExposedVolumesTableHeader.getColumnNames().size()];
        VolumeTreeNode volume = aLuNode.getVolumeChild();
        AliasObject targetObj = new AliasObject(aLuNode.getTargetParent().getAlias(), aLuNode.getTargetParent());
        BigInteger accessibleSpace = null;
        BigInteger allocatedSpace = null;
        TreeNode storageNode = null;
        if (volume != null) {
            if (volume instanceof DirectAccessDeviceNode) {
                accessibleSpace = ((DirectAccessDeviceNode)volume).getTotalSpace();
                allocatedSpace = ((DirectAccessDeviceNode)volume).getAllocatedSpace();
            } else {
                accessibleSpace = volume.getAccessibleSpace();
                allocatedSpace = volume.getAllocatedSpace();
            }
            if (volume instanceof DirectAccessDeviceNode) {
                DirectAccessDeviceNode disk = (DirectAccessDeviceNode)volume;
                if (disk.isDisk()) {
                    storageNode = disk;
                }
            } else if (volume instanceof NonVirtualVolumeNode) {
                storageNode = ((NonVirtualVolumeNode)volume).findNodeInSubTree(StorageDeviceNode.class);
            }
        }
        AliasObject accSpace = new AliasObject(StorageSize.getSizeAsString(accessibleSpace), accessibleSpace);
        AliasObject allSpace = new AliasObject(StorageSize.getSizeAsString(allocatedSpace), allocatedSpace);
        rowData[this.getColumnIndex((String)ExposedVolumesTableHeader.VOLUME_NAME.toString())] = volume;
        rowData[this.getColumnIndex((String)ExposedVolumesTableHeader.STORAGE_NAME.toString())] = storageNode;
        rowData[this.getColumnIndex((String)ExposedVolumesTableHeader.TARGET.toString())] = targetObj;
        rowData[this.getColumnIndex((String)ExposedVolumesTableHeader.LUN.toString())] = aLuNode;
        rowData[this.getColumnIndex((String)ExposedVolumesTableHeader.ACCESSIBLE_SPACE.toString())] = accSpace;
        rowData[this.getColumnIndex((String)ExposedVolumesTableHeader.ALLOCATED_SPACE.toString())] = allSpace;
        rowData[this.getColumnIndex((String)ExposedVolumesTableHeader.DR_VOLUME_ROLE.toString())] = null;
        return rowData;
    }

    @Override
    protected void updateRow(VolumeTreeNode volume) {
        int col = this.getColumnIndex(ExposedVolumesTableHeader.VOLUME_NAME.getColumnName());
        int accCol = this.getColumnIndex(ExposedVolumesTableHeader.ACCESSIBLE_SPACE.getColumnName());
        int allocCol = this.getColumnIndex(ExposedVolumesTableHeader.ALLOCATED_SPACE.getColumnName());
        this.updateRow(volume, col, accCol, allocCol);
    }

    @Override
    public void snapshotVolActiveStateChanged(VolumeEvent event) {
    }

    @Override
    public void directAccessDeviceCreated(DirectAccessDeviceEvent event) {
    }

    private void setDRVolumeRole(DRPairNode pair, VolumeTreeNode volume) {
        int volumeCol = this.getColumnIndex(ExposedVolumesTableHeader.VOLUME_NAME.getColumnName());
        int drRoleCol = this.getColumnIndex(ExposedVolumesTableHeader.DR_VOLUME_ROLE.getColumnName());
        int row = this.getRowCount();
        while (row-- > 0) {
            List<Object> rowData = this.getRow(row);
            if (!Util.equalsWithNull(volume, rowData.get(volumeCol))) continue;
            this.setValueAt(pair.getVolumeDRRole(volume), row, drRoleCol);
            return;
        }
    }

    private void clearDRVolumeRole(VolumeTreeNode volume) {
        int volumeCol = this.getColumnIndex(ExposedVolumesTableHeader.VOLUME_NAME.getColumnName());
        int drRoleCol = this.getColumnIndex(ExposedVolumesTableHeader.DR_VOLUME_ROLE.getColumnName());
        int row = this.getRowCount();
        while (row-- > 0) {
            List<Object> rowData = this.getRow(row);
            if (!Util.equalsWithNull(volume, rowData.get(volumeCol))) continue;
            this.setValueAt(null, row, drRoleCol);
            return;
        }
    }

    @Override
    public void asyncPairChanged(DRAsyncPairEvent e) {
        DRASyncPairNode pair = e.getPair();
        if (pair.getPairPrimaryVolume() != null) {
            this.setDRVolumeRole(pair, pair.getPairPrimaryVolume());
        }
        if (pair.getPairSecondaryVolume() != null) {
            this.setDRVolumeRole(pair, pair.getPairSecondaryVolume());
        }
    }

    @Override
    public void asyncPairCreated(DRAsyncPairEvent e) {
        DRASyncPairNode pair = e.getPair();
        if (pair.getPairPrimaryVolume() != null) {
            this.setDRVolumeRole(pair, pair.getPairPrimaryVolume());
        }
        if (pair.getPairSecondaryVolume() != null) {
            this.setDRVolumeRole(pair, pair.getPairSecondaryVolume());
        }
    }

    @Override
    public void asyncPairRemoved(DRAsyncPairEvent e) {
        DRASyncPairNode pair = e.getPair();
        if (pair.getPairPrimaryVolume() != null) {
            this.clearDRVolumeRole(pair.getPairPrimaryVolume());
        }
        if (pair.getPairSecondaryVolume() != null) {
            this.clearDRVolumeRole(pair.getPairSecondaryVolume());
        }
    }

    @Override
    public void syncPairChanged(DRSyncPairEvent e) {
        DRSyncPairNode pair = e.getPair();
        if (pair.getPairPrimaryVolume() != null) {
            this.setDRVolumeRole(pair, pair.getPairPrimaryVolume());
        }
        if (pair.getPairSecondaryVolume() != null) {
            this.setDRVolumeRole(pair, pair.getPairSecondaryVolume());
        }
    }

    @Override
    public void syncPairCreated(DRSyncPairEvent e) {
        DRSyncPairNode pair = e.getPair();
        if (pair.getPairPrimaryVolume() != null) {
            this.setDRVolumeRole(pair, pair.getPairPrimaryVolume());
        }
        if (pair.getPairSecondaryVolume() != null) {
            this.setDRVolumeRole(pair, pair.getPairSecondaryVolume());
        }
    }

    @Override
    public void syncPairRemoved(DRSyncPairEvent e) {
        DRSyncPairNode pair = e.getPair();
        if (pair.getPairPrimaryVolume() != null) {
            this.clearDRVolumeRole(pair.getPairPrimaryVolume());
        }
        if (pair.getPairSecondaryVolume() != null) {
            this.clearDRVolumeRole(pair.getPairSecondaryVolume());
        }
    }

    @Override
    public void removeListeners() {
        DRASyncPairManager.getInstance().removeDRAsyncPairListener(this);
        DRSyncPairManager.getInstance().removeDRSyncPairListener(this);
    }

    @Override
    public void addListeners() {
        DRASyncPairManager.getInstance().addDRAsyncPairListener(this);
        DRSyncPairManager.getInstance().addDRSyncPairListener(this);
    }
}

