/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.volume;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.LUManager;
import com.sanrad.nms.client.data.LUNode;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceManager;
import com.sanrad.nms.client.data.storage.StorageDeviceNode;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceManager;
import com.sanrad.nms.client.data.volume.SrVolumeTreeModel;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.event.DirectAccessDeviceAdapter;
import com.sanrad.nms.client.event.DirectAccessDeviceEvent;
import com.sanrad.nms.client.event.SubDirectAccessDeviceAdapter;
import com.sanrad.nms.client.event.SubDirectAccessDeviceEvent;
import com.sanrad.nms.client.event.lu.LUEvent;
import com.sanrad.nms.client.event.lu.LUListener;
import com.sanrad.nms.client.event.volume.VolumeAdapter;
import com.sanrad.nms.client.event.volume.VolumeEvent;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import javax.swing.tree.DefaultMutableTreeNode;

public class SrExposedVolumeTreeModel
extends SrVolumeTreeModel
implements LUListener {
    private DiskControl m_diskAliasControl = new DiskControl();
    private SubdiskAliasControl m_subdiskAliasControl = new SubdiskAliasControl();
    private VolumeControl m_volumeAliasControl = new VolumeControl();
    private static SrLogger theLogger = SrLogger.getLogger();

    public SrExposedVolumeTreeModel() {
        super(new SrTreeNode(){

            @Override
            public String type() {
                return null;
            }
        });
        VolumeManager.getInstance().addVolumeListener(this.m_volumeAliasControl);
        LUManager.getInstance().addLUListener(this);
        DirectAccessDeviceManager.getInstance().addDirectAccessDeviceListener(this.m_diskAliasControl);
        SubDirectAccessDeviceManager.getInstance().addSubDirectDeviceListener(this.m_subdiskAliasControl);
    }

    @Override
    public void luStatusChanged(LUEvent event) {
        VolumeNode stub = event.getVolumeStub();
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(stub);
        if (node != null) {
            theLogger.trace(SrLogCategories.LEGACY, "updating the exposed volume in tree: ", ((VolumeTreeNode)node).getAlias());
            this.nodeChanged(node);
        } else {
            theLogger.trace(SrLogCategories.LEGACY, "could not update the exposed volume in tree.");
        }
    }

    @Override
    public void luRemoved(LUEvent event) {
        SrTreeNode volumeNode = SystemRootNode.getInstance().getRefByStub(event.getVolumeStub());
        if (volumeNode.getParent() == this.root) {
            this.removeNodeFromParent(volumeNode);
        }
    }

    private void changedAlias(RemoteObject stub) {
        Object[] path;
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(stub);
        if (node != null && (path = this.getPathToRoot((VolumeTreeNode)node)) != null) {
            this.fireTreeStructureChanged(this, path, null, null);
        }
    }

    @Override
    public void luCreated(LUEvent event) {
    }

    @Override
    public void luChanged(LUEvent event) {
        LUNode lu = (LUNode)SystemRootNode.getInstance().getRefByStub(event.getStub());
        VolumeTreeNode node = lu.getVolumeChild();
        this.fireTreeStructureChanged(this, this.getPathToRoot(node), null, null);
    }

    class SubdiskAliasControl
    extends SubDirectAccessDeviceAdapter {
        SubdiskAliasControl() {
        }

        @Override
        public void subDirecetAccessDeviceAliasChanged(SubDirectAccessDeviceEvent event) {
            RemoteObject stub = event.getStub();
            SrExposedVolumeTreeModel.this.changedAlias(stub);
        }
    }

    class DiskControl
    extends DirectAccessDeviceAdapter {
        DiskControl() {
        }

        @Override
        public void directAccessDeviceAliasChanged(DirectAccessDeviceEvent event) {
            RemoteObject stub = event.getStub();
            SrExposedVolumeTreeModel.this.changedAlias(stub);
        }

        @Override
        public void directAccessDeviceStatusChanged(DirectAccessDeviceEvent event) {
            RemoteObject stub = event.getStub();
            SrTreeNode node = SystemRootNode.getInstance().getRefByStub(stub);
            Object[] path = SrExposedVolumeTreeModel.this.getPathToRoot((StorageDeviceNode)node, 0);
            if (path != null) {
                SrExposedVolumeTreeModel.this.fireTreeStructureChanged(this, path, null, null);
            }
        }
    }

    class VolumeControl
    extends VolumeAdapter {
        VolumeControl() {
        }

        @Override
        public void volumeAliasChanged(VolumeEvent e) {
            RemoteObject stub = e.getStub();
            SrExposedVolumeTreeModel.this.changedAlias(stub);
        }

        @Override
        public void volumeConfigChanged(VolumeEvent e) {
            VolumeTreeNode node = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(e.getStub());
            SrExposedVolumeTreeModel.this.fireTreeStructureChanged(this, SrExposedVolumeTreeModel.this.getPathToRoot(node), null, null);
        }

        @Override
        public void volumeStatusChanged(VolumeEvent e) {
            RemoteObject stub = e.getStub();
            SrTreeNode node = SystemRootNode.getInstance().getRefByStub(stub);
            if (node != null) {
                VolumeTreeNode treeNode = (VolumeTreeNode)node;
                if (!treeNode.isExposed()) {
                    return;
                }
                theLogger.trace(SrLogCategories.LEGACY, "ExposedVolumeTreeModel:: updating the exposed volume tree: status of the volume ", ((VolumeTreeNode)node).getAlias());
                Object[] path = SrExposedVolumeTreeModel.this.getPathToRoot(node);
                if (path != null) {
                    SrExposedVolumeTreeModel.this.fireTreeStructureChanged(this, path, null, null);
                } else {
                    SrExposedVolumeTreeModel.this.fireTreeStructureChanged(this, SrExposedVolumeTreeModel.this.getPathToRoot((DefaultMutableTreeNode)SrExposedVolumeTreeModel.this.getRoot()), null, null);
                }
            } else {
                theLogger.trace(SrLogCategories.LEGACY, "Could not update exposed volume tree : status of volume changed.");
            }
        }

        @Override
        public void removeVolumeNodeFromParent(VolumeEvent event, VolumeTreeNode childNode) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)SrExposedVolumeTreeModel.this.getRoot();
            if (root == childNode.getRoot()) {
                SrExposedVolumeTreeModel.this.removeNodeFromParent(childNode);
                SrExposedVolumeTreeModel.this.nodeStructureChanged(root);
            }
        }
    }
}

