/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.volume;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.volume.VirtualVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.volume.copy.RestoreOperationNode;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.server.logic.volume.SnapshotVolume;
import com.sanrad.nms.server.util.types.constants.SnapshotActivateTypeConstants;
import com.sanrad.nms.server.util.types.constants.SnapshotConfigFlagsConstant;
import com.sanrad.nms.server.util.types.constants.VolumeOperationOperStatusConstant;
import com.sanrad.util.Util;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Date;

public class SnapshotVolumeNode
extends VirtualVolumeNode<SnapshotVolume> {
    private int percentageLoad;
    private Date dateAndTime;
    private int percentageThreshold;
    private VolumeTreeNode sourceVolume;
    private boolean m_isActivated;
    private SnapshotConfigFlagsConstant myConfigFlags;
    private RestoreOperationNode m_restoreOperationNode = null;

    public SnapshotVolumeNode(SnapshotVolume stub, String alias, boolean exposed) throws RemoteException {
        super(stub, alias, exposed, "Snapshot");
        this.setNodeIcon(ClientImageObject.SNAPSHOT);
    }

    public void setDateAndTime(Date date) {
        this.dateAndTime = date;
    }

    public Object getDateAndTime() {
        if (this.isActivated()) {
            return this.dateAndTime;
        }
        return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_DIALOG_NOT_AVAILABLE_VALUE);
    }

    @Override
    public String type() {
        return "Volume: Snapshot";
    }

    public int getPercentageLoad() {
        return this.percentageLoad;
    }

    public String getPercentageLoadAsString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.percentageLoad);
        sb.append(" %");
        return sb.toString();
    }

    public int getPercentageThreshold() {
        return this.percentageThreshold;
    }

    public void setPercentageLoad(int percentageLoad) {
        this.percentageLoad = percentageLoad;
    }

    public void setPercentageThreshold(int percentageThreshold) {
        this.percentageThreshold = percentageThreshold;
    }

    public VolumeTreeNode<?> getSourceVolume() {
        return this.sourceVolume;
    }

    public void setSourceVolume(VolumeTreeNode sourceVolume) {
        this.sourceVolume = sourceVolume;
    }

    public void setActivatedState(SnapshotActivateTypeConstants activatedState) {
        this.m_isActivated = activatedState.equals(SnapshotActivateTypeConstants.SNAPSHOT_ACTIVE);
    }

    public boolean isActivated() {
        return this.m_isActivated;
    }

    public void setRestoreOperation(RestoreOperationNode restoreOperationNode) {
        this.m_restoreOperationNode = restoreOperationNode;
    }

    public RestoreOperationNode getRestoreOperation() {
        return this.m_restoreOperationNode;
    }

    public void reomveRestoreOperation() {
        this.setRestoreOperation(null);
    }

    public boolean isInvolvedInAnotherRestoreOperation() {
        return this.m_restoreOperationNode != null;
    }

    public boolean isInvolvedInAnotherActiveRestoreOperation() {
        if (this.m_restoreOperationNode != null) {
            VolumeOperationOperStatusConstant status = this.m_restoreOperationNode.getCopyStatus();
            return status.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_OPERATING) || status.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_WAITING);
        }
        return false;
    }

    public boolean isInvolvedInAbortedRestoreOperation() {
        if (this.m_restoreOperationNode != null) {
            VolumeOperationOperStatusConstant status = this.m_restoreOperationNode.getCopyStatus();
            return status.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_ABORTED);
        }
        return false;
    }

    @Override
    public String getProblemOnDeletion() {
        String superRetVal = super.getProblemOnDeletion();
        if (superRetVal != null) {
            return superRetVal;
        }
        return VolumeManager.getInstance().canSnapshotBeDeleted(this);
    }

    @Override
    public void setAccessibleSpace(BigInteger aAccessibleSpace) {
        if (aAccessibleSpace == null) {
            return;
        }
        super.setAccessibleSpace(aAccessibleSpace);
    }

    @Override
    public BigInteger getAccessibleSpace() {
        BigInteger space = super.getAccessibleSpace();
        return space != null ? space : BigInteger.ZERO;
    }

    public void setConfigFlags(SnapshotConfigFlagsConstant aConfigFlags) {
        this.myConfigFlags = aConfigFlags;
    }

    public boolean isScheduled() {
        return this.myConfigFlags != null && (this.myConfigFlags.contains(SnapshotConfigFlagsConstant.SCHEDULED_BASED) || this.myConfigFlags.contains(SnapshotConfigFlagsConstant.EXTERNAL_SCHEDULER));
    }

    public static BigInteger getSnapshotHeaderSizeInBlocks(VolumeTreeNode aSource) {
        Util.validateInputNotNull(aSource, "Source volume");
        BigInteger volSize = aSource.getAccessibleSpace();
        Integer blockSize = aSource.getBlockSize();
        BigInteger volSizeInBlocks = Util.bytesToBlocks(volSize, blockSize);
        BigInteger numerator = volSizeInBlocks.divide(new BigInteger("256")).add(BigInteger.ONE);
        Integer denominator = blockSize / 4;
        BigInteger denominatorBigInt = new BigInteger(String.valueOf(denominator));
        BigInteger retVal = new BigInteger("4").add(numerator.divide(denominatorBigInt));
        return retVal;
    }

    public static BigInteger getSnapshotHeaderSizeInBytes(VolumeTreeNode aSource) {
        Util.validateInputNotNull(aSource, "Source volume");
        Integer blockSize = aSource.getBlockSize();
        BigInteger inBlocks = SnapshotVolumeNode.getSnapshotHeaderSizeInBlocks(aSource);
        return Util.blocksToBytes(inBlocks, blockSize);
    }

    public SnapshotConfigFlagsConstant getConfigFlags() {
        return this.myConfigFlags;
    }
}

