/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.volume;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.dr.DRPairManager;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.StorageDeviceNode;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceNode;
import com.sanrad.nms.client.data.volume.ConcatinationVolumeNode;
import com.sanrad.nms.client.data.volume.CubeVolumeNode;
import com.sanrad.nms.client.data.volume.SnapshotVolumeNode;
import com.sanrad.nms.client.data.volume.TransparentVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeOperationHandler;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.volume.copy.CopyOperManager;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.volume.dialogs.NewCubeDialog;
import com.sanrad.nms.server.util.types.constants.VolumeStateConstant;
import com.sanrad.util.concurrent.SrFuture;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;

public class ResizeVolumeOperationHandler
extends VolumeOperationHandler {
    public ResizeVolumeOperationHandler(VolumeTreeNode source) {
        super(source);
    }

    @Override
    public boolean isVolumeOperation() {
        return true;
    }

    public Collection<SrFuture<Void>> operate(VolumeTreeNode targetNode) {
        String alias = null;
        if (this.mySourceVolume instanceof DirectAccessDeviceNode && !(this.mySourceVolume.getParent() instanceof ConcatinationVolumeNode)) {
            NewCubeDialog cubeDialog = new NewCubeDialog(this.owner, this.mySourceVolume.getAlias(), SystemRootNode.getInstance().getClusterNodeOfSource(this.mySourceVolume));
            if (cubeDialog.endWithCancel) {
                return Collections.EMPTY_LIST;
            }
            alias = cubeDialog.getAlias();
        }
        return Collections.singleton(VolumeManager.getInstance().resize(alias, this.mySourceVolume, targetNode));
    }

    public String isOperationLegitimate(VolumeTreeNode volumeNode) {
        String superResult = super.isOperationLegitimate(volumeNode);
        if (superResult != null) {
            return superResult;
        }
        if (volumeNode.isInState(VolumeStateConstant.VOLUME_STATE_NONFUNCTIONAL)) {
            return "The selected item is non functional";
        }
        if (this.mySourceVolume instanceof CubeVolumeNode && !(volumeNode instanceof StorageDeviceNode)) {
            return "A cube volume cannot be resized with a virtual volume";
        }
        if (volumeNode instanceof SnapshotVolumeNode) {
            return "A volume cannot be resized with a snapshot volume";
        }
        if (volumeNode instanceof TransparentVolumeNode) {
            return "A volume cannot be resized with a transparent volume";
        }
        if (VolumeManager.getInstance().getClusterSnapshotMap().isSourceOfSnapshot(SystemRootNode.getInstance().getClusterNodeOfSource(volumeNode), volumeNode)) {
            return "A volume cannot be resized with the source of a snapshot volume";
        }
        if (CopyOperManager.getInstance().isInvolvedInAnyActiveCopyOper(volumeNode)) {
            return "Cannot resize a disk that is involved in a copy operation";
        }
        VolumeManager volMgr = VolumeManager.getInstance();
        if (volMgr.isPartOfTheSameTree(this.mySourceVolume, volumeNode)) {
            return "The source volume and the selected volume cannot belong to the same tree";
        }
        if (volumeNode instanceof StorageDeviceNode) {
            SubDirectAccessDeviceNode subDiskNode;
            DirectAccessDeviceNode parentDisk;
            StorageDeviceNode storageNode = (StorageDeviceNode)volumeNode;
            if (storageNode.isTape() || storageNode.isProcessor()) {
                return "Cannot resize with a tape or processor storage device";
            }
            if (storageNode.isDisk() && (((DirectAccessDeviceNode)storageNode).isMissing() || ((DirectAccessDeviceNode)storageNode).isNonFunctional())) {
                return "Selected disk is missing or non-functional";
            }
            if (storageNode.isSubDisk() && (parentDisk = (subDiskNode = (SubDirectAccessDeviceNode)storageNode).getDirectAccessDeviceParent()).isMissing()) {
                return "The source disk of the selected subdisk is missing";
            }
            if (DRPairManager.getPairContainingVolume(storageNode) != null) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_THE_SOURCE_IS_USED_BY_PAIR);
            }
        }
        if (this.mySourceVolume instanceof DirectAccessDeviceNode) {
            if (!(this.mySourceVolume.getParent() instanceof ConcatinationVolumeNode) && !(volumeNode instanceof DirectAccessDeviceNode)) {
                return "Cannot resize a disk with anything besides another disk unless it's a child of a Concatenated volume";
            }
            if (volumeNode.isInState(VolumeStateConstant.VOLUME_STATE_NONFUNCTIONAL)) {
                return "The selected volume is non-functional";
            }
        }
        if (this.mySourceVolume instanceof CubeVolumeNode && !(volumeNode instanceof StorageDeviceNode)) {
            return null;
        }
        if (volMgr.getClusterSnapshotMap().isSourceOfSnapshot(SystemRootNode.getInstance().getClusterNodeOfSource(volumeNode), volumeNode)) {
            return "The selected volume is the source of a snapshot";
        }
        if (CopyOperManager.getInstance().isInvolvedInActiveOfflineCopy(volumeNode)) {
            return "The selected volume is involved in a copy operation";
        }
        if (volumeNode instanceof SnapshotVolumeNode) {
            return "The selected volume is snapshot";
        }
        if (volumeNode instanceof TransparentVolumeNode) {
            return "The selected volume is transparent";
        }
        if (this.mySourceVolume.getBlockSize().longValue() != volumeNode.getBlockSize().longValue()) {
            return "The block sizes of the source and selected volumes differ";
        }
        return null;
    }

    @Override
    public String getOperationName() {
        return "Resize Volume";
    }

    @Override
    public boolean shouldBlockAction() {
        return false;
    }

    @Override
    public Icon getIconForOperation() {
        return ClientImageObject.RESIZE_VOLUME_OPERATION.getImageIcon();
    }
}

