/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.volume;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.StorageDeviceNode;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceNode;
import com.sanrad.nms.client.data.volume.CubeVolumeNode;
import com.sanrad.nms.client.data.volume.JournalVolumeNode;
import com.sanrad.nms.client.data.volume.SnapshotVolumeNode;
import com.sanrad.nms.client.data.volume.TransparentVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeOperationHandler;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.volume.copy.CopyOperManager;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.server.util.types.constants.VolumeStateConstant;
import com.sanrad.util.concurrent.SrFuture;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;

public class ReplaceVolumeOperationHandler
extends VolumeOperationHandler {
    public ReplaceVolumeOperationHandler(VolumeTreeNode source) {
        super(source);
    }

    @Override
    public boolean isVolumeOperation() {
        return true;
    }

    public String isOperationLegitimate(VolumeTreeNode volumeNode) {
        String superResult = super.isOperationLegitimate(volumeNode);
        if (superResult != null) {
            return superResult;
        }
        VolumeManager volMgr = VolumeManager.getInstance();
        if (volMgr.isPartOfTheSameTree(this.mySourceVolume, volumeNode)) {
            return "The source volume and the selected volume cannot belong to the same tree";
        }
        if (this.mySourceVolume.getParent() instanceof CubeVolumeNode && !(volumeNode instanceof DirectAccessDeviceNode)) {
            return "Only disk volumes can be children of cube volumes";
        }
        if (volumeNode instanceof StorageDeviceNode) {
            SubDirectAccessDeviceNode subDiskNode;
            DirectAccessDeviceNode parentDisk;
            StorageDeviceNode storageNode = (StorageDeviceNode)volumeNode;
            if (storageNode.isTape() || storageNode.isProcessor()) {
                return "Cannot replace a volume with a tape or processor storage device";
            }
            if (storageNode.isDisk()) {
                if (((DirectAccessDeviceNode)storageNode).isMissing()) {
                    return "Selected disk is missing";
                }
                if (storageNode.isNonFunctional()) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_VOLUME_IS_NON_FUNCTIONAL);
                }
            }
            if (storageNode.isSubDisk() && (parentDisk = (subDiskNode = (SubDirectAccessDeviceNode)storageNode).getDirectAccessDeviceParent()).isMissing()) {
                return "The source disk of the selected subdisk is missing";
            }
        }
        if (volumeNode.isInState(VolumeStateConstant.VOLUME_STATE_NONFUNCTIONAL)) {
            return "The source disk of the selected subdisk is non-functional";
        }
        if (volMgr.getClusterSnapshotMap().isSourceOfSnapshot(SystemRootNode.getInstance().getClusterNodeOfSource(volumeNode), volumeNode)) {
            return "The selected volume is the source of a snapshot";
        }
        if (CopyOperManager.getInstance().isInvolvedInAnyActiveCopyOper(volumeNode)) {
            return "The selected volume is involved in an active copy operation";
        }
        if (volumeNode instanceof SnapshotVolumeNode) {
            return "The selected volume is a snapshot";
        }
        if (volumeNode instanceof TransparentVolumeNode) {
            return "The selected volume is transparent";
        }
        if (volumeNode instanceof JournalVolumeNode) {
            return "The selected volume is a journal volume";
        }
        if (volumeNode.getAccessibleSpace().compareTo(this.mySourceVolume.getAccessibleSpace()) < 0) {
            return "The selected volume must be bigger than or equal to the source volume";
        }
        return null;
    }

    public Collection<SrFuture<Void>> operate(VolumeTreeNode targetNode) {
        return Collections.singleton(VolumeManager.getInstance().replaceVolume(this.mySourceVolume, targetNode));
    }

    @Override
    public String getOperationName() {
        return "Replace Volume";
    }

    @Override
    public boolean shouldBlockAction() {
        return true;
    }

    @Override
    public Icon getIconForOperation() {
        return ClientImageObject.REPLACE_VOLUME_OPERATION.getImageIcon();
    }
}

