/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.volume;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.volume.VirtualVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.server.logic.volume.JournalVolume;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.types.constants.JournalErrorStatusConstant;
import com.sanrad.nms.server.util.types.constants.JournalOperStatusConstant;
import com.sanrad.nms.server.util.types.constants.JournalVolumeActivityConstants;
import java.rmi.RemoteException;

public class JournalVolumeNode
extends VirtualVolumeNode<JournalVolume> {
    private VSwitch m_vSwitchStub = null;
    private long m_dateAndTime;
    private int m_percentageUtilization;
    private int m_percentageThreshold;
    private JournalVolumeActivityConstants m_activeState;
    private JournalOperStatusConstant myOperationalStatus;
    private JournalErrorStatusConstant myErrorStatus;

    public JournalVolumeNode(JournalVolume stub, String alias, Object activeVSwitchStub) throws RemoteException {
        super(stub, alias, false, "Journal");
        this.setNodeIcon(ClientImageObject.JOURNAL_NODE);
        this.m_vSwitchStub = (VSwitch)activeVSwitchStub;
    }

    public JournalVolumeActivityConstants getActivityState() {
        return this.m_activeState;
    }

    public void setActivityState(JournalVolumeActivityConstants activeState) {
        this.m_activeState = activeState;
    }

    public long getDateAndTime() {
        return this.m_dateAndTime;
    }

    public void setDateAndTime(long dateAndTime) {
        this.m_dateAndTime = dateAndTime;
    }

    public String getActivateOnVSwitch() {
        if (this.m_vSwitchStub != null) {
            VSwitchNode vswitchNode = (VSwitchNode)SystemRootNode.getInstance().getRefByStub(this.m_vSwitchStub);
            return vswitchNode != null ? vswitchNode.getName() : ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_DIALOG_NOT_AVAILABLE_VALUE);
        }
        return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_DIALOG_NOT_AVAILABLE_VALUE);
    }

    public void setActivateOnVSwitch(VSwitch vsStub) {
        this.m_vSwitchStub = vsStub;
    }

    public VSwitchNode getActiveOnVSwitchNode() {
        return (VSwitchNode)SystemRootNode.getInstance().getRefByStub(this.m_vSwitchStub);
    }

    public int getPercentageThreshold() {
        return this.m_percentageThreshold;
    }

    public void setPercentageThreshold(int percentageThreshold) {
        this.m_percentageThreshold = percentageThreshold;
    }

    public int getPercentageUtilization() {
        return this.m_percentageUtilization;
    }

    public void setPercentageUtilization(int percentageUtilization) {
        this.m_percentageUtilization = percentageUtilization;
    }

    @Override
    public String type() {
        return "Volume: Journal";
    }

    @Override
    public String getProblemOnDeletion() {
        String superRetVal = super.getProblemOnDeletion();
        if (superRetVal != null) {
            return superRetVal;
        }
        if (VolumeManager.getInstance().isJournalVolumeUsedByAPair(this)) {
            return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.JOURNAL_USED_BY_PAIR);
        }
        return null;
    }

    public JournalOperStatusConstant getOperationalStatus() {
        return this.myOperationalStatus;
    }

    public void setOperationalStatus(JournalOperStatusConstant operationalStatus) {
        this.myOperationalStatus = operationalStatus;
    }

    public JournalErrorStatusConstant getErrorStatus() {
        return this.myErrorStatus;
    }

    public void setErrorStatus(JournalErrorStatusConstant errorStatus) {
        this.myErrorStatus = errorStatus;
    }
}

