/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.volume;

import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.wizards.SrResourceTableModel;
import com.sanrad.nms.client.data.storage.StorageManager;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceNode;
import com.sanrad.nms.client.data.volume.NotExposedVolumeTreeModelCollection;
import com.sanrad.nms.client.data.volume.SrNotExposedVolumeTreeModel;
import com.sanrad.nms.client.data.volume.UnExposedVolumesTableModelCollection;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.util.SrEventListenerManager;
import java.util.Enumeration;
import java.util.List;

public class ExposedVolumesManager {
    private static ExposedVolumesManager instance;
    private SrEventListenerManager m_listeners = new SrEventListenerManager();

    private ExposedVolumesManager() {
        this.init();
    }

    public void clear(ClusterNode clusterNode) {
        if (clusterNode.isCurrentCluster()) {
            // empty if block
        }
        NotExposedVolumeTreeModelCollection.getInstance().clearModelOf(clusterNode);
    }

    public void clear() {
        Enumeration<ClusterNode> e = SystemRootNode.getInstance().getClusterNodes().elements();
        while (e.hasMoreElements()) {
            ClusterNode clusterNode = e.nextElement();
            this.clear(clusterNode);
        }
    }

    public void init(ClusterNode clusterNode) {
        NotExposedVolumeTreeModelCollection.getInstance();
        UnExposedVolumesTableModelCollection.getInstance();
        List<VolumeTreeNode> nodes = VolumeManager.getInstance().readAllVolumes(clusterNode);
        for (VolumeTreeNode node : nodes) {
            if (node.isExposed()) continue;
            NotExposedVolumeTreeModelCollection.getInstance().addVolumeNode(node);
            UnExposedVolumesTableModelCollection.getInstance().addVolumeNode(node);
        }
        for (SubDirectAccessDeviceNode subdiskNode : StorageManager.getSubdisks(clusterNode)) {
            if (!SrResourceTableModel.isSubDiskValidForSource(subdiskNode)) continue;
            NotExposedVolumeTreeModelCollection.getInstance().addVolumeNode(subdiskNode);
        }
    }

    private void init() {
        Enumeration<ClusterNode> e = SystemRootNode.getInstance().getClusterNodes().elements();
        while (e.hasMoreElements()) {
            ClusterNode clusterNode = e.nextElement();
            this.init(clusterNode);
        }
    }

    public static synchronized ExposedVolumesManager getInstance() {
        if (instance == null) {
            instance = new ExposedVolumesManager();
        }
        return instance;
    }

    public SrNotExposedVolumeTreeModel getNotExposedCurrentModel() {
        return (SrNotExposedVolumeTreeModel)NotExposedVolumeTreeModelCollection.getInstance().getCurrentModel();
    }
}

