/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.topology;

import com.sanrad.log.SrLogCategories;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.topology.TpBaseElement;
import com.sanrad.nms.client.data.topology.jaxb.VolumeElement;
import com.sanrad.nms.client.data.volume.VolumeNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import java.util.List;

public class TpVolume
extends TpBaseElement<VolumeElement> {
    public TpVolume() {
        super(theFactory.createVolumeElement());
    }

    public TpVolume(VolumeTreeNode aVolume) {
        this();
        if (aVolume == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Tried to create a Volume from an Existing one, but the one we got is nulled");
            this.setName("Error: nulled Object");
            return;
        }
        this.setName(aVolume.getAlias());
        this.setState(aVolume.getVolStateStr());
        this.setBlockSize(aVolume.getBlockSize());
        if (aVolume instanceof VolumeNode) {
            this.setType(((VolumeNode)aVolume).getVolType());
            Double blockNum = ((VolumeNode)aVolume).getBlockNum();
            if (blockNum == null) {
                this.setNumberOfBlocks(0.0);
            } else {
                this.setNumberOfBlocks(blockNum);
            }
        } else {
            this.setType("Simple");
            this.setNumberOfBlocks(aVolume.getAllocatedSpace().intValue());
        }
        ClusterNode theVolumeCluster = SystemRootNode.getInstance().getClusterNodeOfSource(aVolume);
        this.setIsRedundant(theVolumeCluster.getConnectedVSwitches().length == aVolume.getVswitchesCount());
        this.setChildren(aVolume.getChildren());
    }

    @Override
    protected void initTables() {
    }

    public void setName(String aName) {
        ((VolumeElement)this.getJaxObj()).setName(aName);
    }

    public String getName() {
        return ((VolumeElement)this.getJaxObj()).getName();
    }

    public void setState(String aState) {
        ((VolumeElement)this.getJaxObj()).setState(aState);
    }

    public String getState() {
        return ((VolumeElement)this.getJaxObj()).getState();
    }

    public void setType(String aType) {
        ((VolumeElement)this.getJaxObj()).setType(aType);
    }

    public String getType() {
        return ((VolumeElement)this.getJaxObj()).getType();
    }

    public void setNumberOfBlocks(double aNumberOfBlocks) {
        ((VolumeElement)this.getJaxObj()).setNumberOfBlocks(aNumberOfBlocks);
    }

    public double getNumberOfBlocks() {
        return ((VolumeElement)this.getJaxObj()).getNumberOfBlocks();
    }

    public void setBlockSize(int aBlockSize) {
        ((VolumeElement)this.getJaxObj()).setBlockSize(aBlockSize);
    }

    public int getBlockSize() {
        return ((VolumeElement)this.getJaxObj()).getBlockSize();
    }

    public void setIsRedundant(boolean aIsReduandant) {
        ((VolumeElement)this.getJaxObj()).setRedundant(aIsReduandant);
    }

    public boolean getIsRedundant() {
        return ((VolumeElement)this.getJaxObj()).isRedundant();
    }

    public void setChildren(List<VolumeTreeNode> aChildsList) {
        if (aChildsList == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Got Nulled Children List for TpVolume");
            return;
        }
        for (VolumeTreeNode child : aChildsList) {
            this.setChild(child);
        }
    }

    public void setChild(VolumeTreeNode aChild) {
        ((VolumeElement)this.getJaxObj()).getChildren().add((VolumeElement)new TpVolume(aChild).getJaxObj());
    }
}

