/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.topology;

import com.sanrad.log.SrLogCategories;
import com.sanrad.nms.client.data.topology.TpBaseElement;
import com.sanrad.nms.client.data.topology.TpIP;
import com.sanrad.nms.client.data.topology.TpPortal;
import com.sanrad.nms.client.data.topology.jaxb.IpElement;
import com.sanrad.nms.client.data.topology.jaxb.PortalElement;
import com.sanrad.nms.client.data.topology.jaxb.VSwitchElement;
import com.sanrad.nms.client.data.vswitch.IPTableRow;
import com.sanrad.nms.client.data.vswitch.PortalTableRow;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import java.util.List;

public class TpVSwitch
extends TpBaseElement<VSwitchElement> {
    public TpVSwitch() {
        super(theFactory.createVSwitchElement());
    }

    public TpVSwitch(VSwitchNode aVS) {
        this();
        if (aVS == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Tried to create a VS from an Existing one, but the one we got is nulled");
            this.setName("Error: nulled Object");
            return;
        }
        this.setName(aVS.getName());
        this.setManagementIP(aVS.getManagedIPAddress());
        this.setIPs(aVS.getIPTable());
        this.setPortals(aVS.getPortalTable());
    }

    @Override
    protected void initTables() {
        if (((VSwitchElement)this.getJaxObj()).getIPsTbl() == null) {
            ((VSwitchElement)this.getJaxObj()).setIPsTbl(theFactory.createIPsTable());
        }
        if (((VSwitchElement)this.getJaxObj()).getPortalsTbl() == null) {
            ((VSwitchElement)this.getJaxObj()).setPortalsTbl(theFactory.createPortalsTable());
        }
    }

    public void setIPs(List<IPTableRow> aIPsList) {
        if (aIPsList == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Got Nulled Ip List for TpVSwitch");
            return;
        }
        for (IPTableRow curIP : aIPsList) {
            this.setIP(curIP);
        }
    }

    public void setName(String aVsName) {
        ((VSwitchElement)this.getJaxObj()).setName(aVsName);
    }

    public String getName() {
        return ((VSwitchElement)this.getJaxObj()).getName();
    }

    public void setManagementIP(String aMngIp) {
        ((VSwitchElement)this.getJaxObj()).setManagementIP(aMngIp);
    }

    public String getManagementIP() {
        return ((VSwitchElement)this.getJaxObj()).getManagementIP();
    }

    public void setIP(IPTableRow aIP) {
        ((VSwitchElement)this.getJaxObj()).getIPsTbl().getIps().add((IpElement)new TpIP(aIP).getJaxObj());
    }

    public void setPortals(List<PortalTableRow> aPortalsList) {
        if (aPortalsList == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Got Nulled Portals List for TpVSwitch");
            return;
        }
        for (PortalTableRow curPortal : aPortalsList) {
            this.setPortal(curPortal);
        }
    }

    public void setPortal(PortalTableRow aPortal) {
        ((VSwitchElement)this.getJaxObj()).getPortalsTbl().getPortals().add((PortalElement)new TpPortal(aPortal).getJaxObj());
    }
}

