/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.topology;

import com.sanrad.log.SrLogCategories;
import com.sanrad.nms.client.data.LUNode;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.topology.TpBaseElement;
import com.sanrad.nms.client.data.topology.TpLU;
import com.sanrad.nms.client.data.topology.jaxb.LuElement;
import com.sanrad.nms.client.data.topology.jaxb.TargetElement;
import java.util.List;

public class TpTarget
extends TpBaseElement<TargetElement> {
    public TpTarget() {
        super(theFactory.createTargetElement());
    }

    public TpTarget(TargetNode aTarget) {
        this();
        if (aTarget == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Tried to create a Target from an Existing one, but the one we got is nulled");
            this.setName("Error: nulled Object");
            return;
        }
        this.setName(aTarget.getAlias());
        this.setExposedOn(aTarget.getExposedOnVSwitchName());
        this.setLUs(aTarget.getLuNodes());
    }

    @Override
    protected void initTables() {
        if (((TargetElement)this.getJaxObj()).getLUsTbl() == null) {
            ((TargetElement)this.getJaxObj()).setLUsTbl(theFactory.createLUsTable());
        }
    }

    public void setName(String aName) {
        ((TargetElement)this.getJaxObj()).setName(aName);
    }

    public String getName() {
        return ((TargetElement)this.getJaxObj()).getName();
    }

    public void setExposedOn(String aVs) {
        ((TargetElement)this.getJaxObj()).setExposedOn(aVs);
    }

    public String getExposedOn() {
        return ((TargetElement)this.getJaxObj()).getExposedOn();
    }

    public void setLUs(List<LUNode> aLUsList) {
        if (aLUsList == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Got Nulled LUs List for TpTarget");
            return;
        }
        for (LUNode lu : aLUsList) {
            this.setLU(lu);
        }
    }

    public void setLU(LUNode aLU) {
        ((TargetElement)this.getJaxObj()).getLUsTbl().getLus().add((LuElement)new TpLU(aLU).getJaxObj());
    }
}

