/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.topology;

import com.sanrad.log.SrLogCategories;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.ConsistencyGroupNode;
import com.sanrad.nms.client.data.dr.DRASyncPairNode;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.dr.ExtendedElementNode;
import com.sanrad.nms.client.data.dr.SrConsistencyGroupsTableModel;
import com.sanrad.nms.client.data.dr.SrPairDetailsTableModel;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.data.topology.TpBaseElement;
import com.sanrad.nms.client.data.topology.TpCG;
import com.sanrad.nms.client.data.topology.TpCluster;
import com.sanrad.nms.client.data.topology.TpPair;
import com.sanrad.nms.client.data.topology.TpSite;
import com.sanrad.nms.client.data.topology.jaxb.CgElement;
import com.sanrad.nms.client.data.topology.jaxb.ClusterElement;
import com.sanrad.nms.client.data.topology.jaxb.PairElement;
import com.sanrad.nms.client.data.topology.jaxb.SiteElement;
import com.sanrad.nms.client.data.topology.jaxb.StorageProElement;
import java.util.Arrays;
import java.util.List;

public class TpStorageProRoot
extends TpBaseElement<StorageProElement> {
    public TpStorageProRoot() {
        super(theFactory.createStorageProElement());
    }

    public TpStorageProRoot(SystemRootNode aRoot) {
        this();
        if (aRoot == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Tried to create a Site from a System Root Node, but the one we got is nulled");
            return;
        }
        this.setSites(Arrays.asList(aRoot.getSiteNodes()));
        this.setClusters(Arrays.asList(aRoot.getSiteClusters()));
        this.setDisasterRecovery();
    }

    public TpStorageProRoot(StorageProElement aSPRootElement) {
        super(aSPRootElement);
    }

    @Override
    protected void initTables() {
        if (((StorageProElement)this.getJaxObj()).getClustersTbl() == null) {
            ((StorageProElement)this.getJaxObj()).setClustersTbl(theFactory.createClustersTable());
        }
        if (((StorageProElement)this.getJaxObj()).getSitesTbl() == null) {
            ((StorageProElement)this.getJaxObj()).setSitesTbl(theFactory.createSitesTable());
        }
        if (((StorageProElement)this.getJaxObj()).getDisasterRecoveryTbl() == null) {
            ((StorageProElement)this.getJaxObj()).setDisasterRecoveryTbl(theFactory.createDisasterRecoveryTable());
        }
        if (((StorageProElement)this.getJaxObj()).getDisasterRecoveryTbl().getPairsTbl() == null) {
            ((StorageProElement)this.getJaxObj()).getDisasterRecoveryTbl().setPairsTbl(theFactory.createPairsTable());
        }
        if (((StorageProElement)this.getJaxObj()).getDisasterRecoveryTbl().getCgTbl() == null) {
            ((StorageProElement)this.getJaxObj()).getDisasterRecoveryTbl().setCgTbl(theFactory.createCGsTable());
        }
    }

    public void setSites(List<SiteNode> aSiteList) {
        if (aSiteList == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Got Nulled Sites List for TpStorageProRoot");
            return;
        }
        for (SiteNode site : aSiteList) {
            this.setSite(site);
        }
    }

    public void setSite(SiteNode aSite) {
        ((StorageProElement)this.getJaxObj()).getSitesTbl().getSites().add((SiteElement)new TpSite(aSite).getJaxObj());
    }

    public void setClusters(List<ClusterNode> aClusterList) {
        if (aClusterList == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Got Nulled Clusters List for TpStorageProRoot");
            return;
        }
        for (ClusterNode cluster : aClusterList) {
            this.setCluster(cluster);
        }
    }

    public void setCluster(ClusterNode aCluster) {
        ((StorageProElement)this.getJaxObj()).getClustersTbl().getClusters().add((ClusterElement)new TpCluster(aCluster).getJaxObj());
    }

    public void setDisasterRecovery() {
        for (DRPairNode dRPairNode : SrPairDetailsTableModel.getInstance().getListOfPairs()) {
            ExtendedElementNode potentialCG = ((DRASyncPairNode)dRPairNode).getConsistencyGroup();
            if (dRPairNode instanceof DRASyncPairNode && potentialCG instanceof ConsistencyGroupNode) continue;
            ((StorageProElement)this.getJaxObj()).getDisasterRecoveryTbl().getPairsTbl().getPairs().add((PairElement)new TpPair(dRPairNode).getJaxObj());
        }
        for (SrTreeNode srTreeNode : SrConsistencyGroupsTableModel.getInstance().getAllExtendedElementNodes()) {
            if (!(srTreeNode instanceof ConsistencyGroupNode)) continue;
            ((StorageProElement)this.getJaxObj()).getDisasterRecoveryTbl().getCgTbl().getCg().add((CgElement)new TpCG((ConsistencyGroupNode)srTreeNode).getJaxObj());
        }
    }
}

