/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.topology;

import com.sanrad.log.SrLogCategories;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.data.topology.TpBaseElement;
import com.sanrad.nms.client.data.topology.TpCluster;
import com.sanrad.nms.client.data.topology.jaxb.ClusterElement;
import com.sanrad.nms.client.data.topology.jaxb.SiteElement;
import java.util.Arrays;
import java.util.List;

public class TpSite
extends TpBaseElement<SiteElement> {
    public TpSite() {
        super(theFactory.createSiteElement());
    }

    public TpSite(SiteNode aSite) {
        this();
        if (aSite == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Tried to create a Site from an Existing one, but the one we got is nulled");
            this.setName("Error: nulled Object");
            return;
        }
        this.setName(aSite.getAlias());
        this.setClusters(Arrays.asList(aSite.getSiteClusters()));
    }

    @Override
    protected void initTables() {
        if (((SiteElement)this.getJaxObj()).getClustersTbl() == null) {
            ((SiteElement)this.getJaxObj()).setClustersTbl(theFactory.createClustersTable());
        }
    }

    public void setName(String aName) {
        ((SiteElement)this.getJaxObj()).setName(aName);
    }

    public String getName() {
        return ((SiteElement)this.getJaxObj()).getName();
    }

    public void setCluster(ClusterNode aCluster) {
        ((SiteElement)this.getJaxObj()).getClustersTbl().getClusters().add((ClusterElement)new TpCluster(aCluster).getJaxObj());
    }

    public void setClusters(List<ClusterNode> aClustersList) {
        if (aClustersList == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Got Nulled Clusters List for TpSite");
            return;
        }
        for (ClusterNode cluster : aClustersList) {
            this.setCluster(cluster);
        }
    }
}

