/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.topology;

import com.sanrad.log.SrLogCategories;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.DRASyncPairNode;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.data.topology.TpBaseElement;
import com.sanrad.nms.client.data.topology.TpExtAsyncPair;
import com.sanrad.nms.client.data.topology.jaxb.ExtAsyncPair;
import com.sanrad.nms.client.data.topology.jaxb.PairElement;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.server.util.types.constants.DRInitialSyncStateConstant;
import com.sanrad.nms.server.util.types.constants.DRModeConstant;
import com.sanrad.nms.server.util.types.constants.DRPairInitialSyncTypeConstant;
import com.sanrad.nms.server.util.types.constants.DRPairTypeConstant;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;

public class TpPair
extends TpBaseElement<PairElement> {
    public TpPair() {
        super(theFactory.createPairElement());
    }

    public TpPair(DRPairNode aPair) {
        this();
        if (aPair == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Tried to create a Pair from an Existing one, but the one we got is nulled");
            return;
        }
        this.setType(aPair.getPairType());
        this.setPrimarySite(aPair.getPairPrimarySite());
        this.setSecondarySite(aPair.getPairSecondarySite());
        this.setPrimaryVolume(aPair.getPairPrimaryVolume());
        this.setSecondaryVolume(aPair.getPairSecondaryVolume());
        this.setLocalCluster(aPair.getLocalCluster());
        this.setRemoteCluster(aPair.getRemoteCluster());
        this.setMode(aPair.getMode());
        this.setInitialSyncType(aPair.getInitialSyncType());
        this.setInitialSyncState(aPair.getInitialSyncState());
        this.setReplicationState(aPair.getReplicationState());
        if (aPair instanceof DRASyncPairNode) {
            this.setExtendedAsyncPairDetails((DRASyncPairNode)aPair);
        }
    }

    @Override
    protected void initTables() {
    }

    public void setType(DRPairTypeConstant aType) {
        if (aType == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Got nulled type when trying to set Pair Type");
            return;
        }
        ((PairElement)this.getJaxObj()).setType(aType.toDisplayString());
    }

    public String getType() {
        return ((PairElement)this.getJaxObj()).getType();
    }

    public void setPrimarySite(SiteNode aSite) {
        if (aSite == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Got nulled Site when trying to set Pair Primary Site");
            return;
        }
        ((PairElement)this.getJaxObj()).setPrimarySite(aSite.getAlias());
    }

    public String getPrimarySite() {
        return ((PairElement)this.getJaxObj()).getPrimarySite();
    }

    public void setSecondarySite(SiteNode aSite) {
        if (aSite == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Got nulled Site when trying to set Pair Secondary Site");
            return;
        }
        ((PairElement)this.getJaxObj()).setSecondarySite(aSite.getAlias());
    }

    public String getSecondarySite() {
        return ((PairElement)this.getJaxObj()).getSecondarySite();
    }

    public void setPrimaryVolume(VolumeTreeNode aVolume) {
        if (aVolume == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Got nulled Volume when trying to set Pair Primary Volume");
            return;
        }
        ((PairElement)this.getJaxObj()).setPrimaryVolume(aVolume.getAlias());
    }

    public String getPrimaryVolume() {
        return ((PairElement)this.getJaxObj()).getPrimaryVolume();
    }

    public void setSecondaryVolume(VolumeTreeNode aVolume) {
        if (aVolume == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Got nulled Volume when trying to set Pair Secondary Volume");
            return;
        }
        ((PairElement)this.getJaxObj()).setSecondaryVolume(aVolume.getAlias());
    }

    public String getSecondaryVolume() {
        return ((PairElement)this.getJaxObj()).getSecondaryVolume();
    }

    public void setLocalCluster(ClusterNode aCluster) {
        if (aCluster == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Got nulled Cluster when trying to set Pair Local Cluster");
            return;
        }
        ((PairElement)this.getJaxObj()).setLocalCluster(aCluster.getAlias());
    }

    public String getLocalCluster() {
        return ((PairElement)this.getJaxObj()).getLocalCluster();
    }

    public void setRemoteCluster(ClusterNode aCluster) {
        if (aCluster == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Got nulled Cluster when trying to set Pair Remote Cluster");
            return;
        }
        ((PairElement)this.getJaxObj()).setRemoteCluster(aCluster.getAlias());
    }

    public String getRemoteCluster() {
        return ((PairElement)this.getJaxObj()).getRemoteCluster();
    }

    public void setMode(DRModeConstant aMode) {
        if (aMode == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Got nulled Mode when trying to set Pair Mode");
            return;
        }
        ((PairElement)this.getJaxObj()).setMode(aMode.toDisplayString());
    }

    public String getMode() {
        return ((PairElement)this.getJaxObj()).getMode();
    }

    public void setInitialSyncType(DRPairInitialSyncTypeConstant aInitialSyncType) {
        if (aInitialSyncType == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Got nulled type when trying to set Pair Initial Sync Type");
            return;
        }
        ((PairElement)this.getJaxObj()).setInitialSyncType(aInitialSyncType.toDisplayString());
    }

    public String getInitialSyncType() {
        return ((PairElement)this.getJaxObj()).getInitialSyncType();
    }

    public void setInitialSyncState(DRInitialSyncStateConstant aInitialSyncState) {
        if (aInitialSyncState == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Got nulled state when trying to set Pair Initial Sync state");
            return;
        }
        ((PairElement)this.getJaxObj()).setInitialSyncState(aInitialSyncState.toDisplayString());
    }

    public String getInitialSyncState() {
        return ((PairElement)this.getJaxObj()).getInitialSyncState();
    }

    public void setReplicationState(SrBITSConstant aReplicationState) {
        if (aReplicationState == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Got nulled state when trying to set Pair Replication State");
            return;
        }
        ((PairElement)this.getJaxObj()).setReplicationState(aReplicationState.toDisplayString());
    }

    public String getReplicationState() {
        return ((PairElement)this.getJaxObj()).getReplicationState();
    }

    public void setExtendedAsyncPairDetails(DRASyncPairNode aAsyncPair) {
        if (aAsyncPair == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Got nulled Pair when trying to set Pair's Extended Details");
            return;
        }
        ((PairElement)this.getJaxObj()).setExtendedAsyncPairDetails((ExtAsyncPair)new TpExtAsyncPair(aAsyncPair).getJaxObj());
    }
}

