/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.topology;

import com.sanrad.log.SrLogCategories;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.StorageManager;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceNode;
import com.sanrad.nms.client.data.topology.TpBaseElement;
import com.sanrad.nms.client.data.topology.TpSubdisk;
import com.sanrad.nms.client.data.topology.jaxb.DiskElement;
import com.sanrad.nms.client.data.topology.jaxb.SubdiskElement;
import com.sanrad.util.StorageSize;
import java.util.Arrays;
import java.util.List;

public class TpDisk
extends TpBaseElement<DiskElement> {
    public TpDisk() {
        super(theFactory.createDiskElement());
    }

    public TpDisk(DirectAccessDeviceNode aDisk) {
        this();
        if (aDisk == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Tried to create a Disk from an Existing one, but the one we got is nulled");
            this.setAlias("Error: nulled Object");
            return;
        }
        this.setAlias(aDisk.getAlias());
        this.setTotalCapacity(StorageSize.getSizeAsString(aDisk.getTotalSpace()));
        this.setFreeCapacity(StorageSize.getSizeAsString(aDisk.getNonAllocatedSpace()));
        this.setBlockSize(aDisk.getBlockSize());
        SubDirectAccessDeviceNode[] subDisks = StorageManager.getInstance().getSubdisksNodes(aDisk.getSplits(), aDisk);
        this.setSubdisks(Arrays.asList(subDisks));
    }

    @Override
    protected void initTables() {
        if (((DiskElement)this.getJaxObj()).getSubdisksTbl() == null) {
            ((DiskElement)this.getJaxObj()).setSubdisksTbl(theFactory.createSubdisksTable());
        }
    }

    public void setAlias(String aAlias) {
        ((DiskElement)this.getJaxObj()).setAlias(aAlias);
    }

    public String getAlias() {
        return ((DiskElement)this.getJaxObj()).getAlias();
    }

    public void setTotalCapacity(String aTotalCapacity) {
        ((DiskElement)this.getJaxObj()).setTotalCapacity(aTotalCapacity);
    }

    public String getTotalCapacity() {
        return ((DiskElement)this.getJaxObj()).getTotalCapacity();
    }

    public void setFreeCapacity(String aFreeCapacity) {
        ((DiskElement)this.getJaxObj()).setFreeCapacity(aFreeCapacity);
    }

    public String getFreeCapacity() {
        return ((DiskElement)this.getJaxObj()).getFreeCapacity();
    }

    public void setBlockSize(int aBlockSize) {
        ((DiskElement)this.getJaxObj()).setBlockSize(aBlockSize);
    }

    public int getBlockSize() {
        return ((DiskElement)this.getJaxObj()).getBlockSize();
    }

    public void setSubdisks(List<SubDirectAccessDeviceNode> aSubdisksList) {
        if (aSubdisksList == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Got Nulled Subdisks List for TpDisk");
            return;
        }
        for (SubDirectAccessDeviceNode subdisk : aSubdisksList) {
            this.setSubdisk(subdisk);
        }
    }

    public void setSubdisk(SubDirectAccessDeviceNode aSubdisk) {
        ((DiskElement)this.getJaxObj()).getSubdisksTbl().getSubdisks().add((SubdiskElement)new TpSubdisk(aSubdisk).getJaxObj());
    }
}

