/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.topology;

import com.sanrad.log.SrLogCategories;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.StorageDeviceNode;
import com.sanrad.nms.client.data.storage.StorageManager;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.topology.TpBaseElement;
import com.sanrad.nms.client.data.topology.TpDisk;
import com.sanrad.nms.client.data.topology.TpTarget;
import com.sanrad.nms.client.data.topology.TpVSwitch;
import com.sanrad.nms.client.data.topology.TpVolume;
import com.sanrad.nms.client.data.topology.jaxb.ClusterElement;
import com.sanrad.nms.client.data.topology.jaxb.DiskElement;
import com.sanrad.nms.client.data.topology.jaxb.TargetElement;
import com.sanrad.nms.client.data.topology.jaxb.VSwitchElement;
import com.sanrad.nms.client.data.topology.jaxb.VolumeElement;
import com.sanrad.nms.client.data.volume.ExposedVolumesTableModelCollection;
import com.sanrad.nms.client.data.volume.NotExposedVolumeTreeModelCollection;
import com.sanrad.nms.client.data.volume.SrExposedVolumesTableModel;
import com.sanrad.nms.client.data.volume.SrNotExposedVolumeTreeModel;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.gui.volume.ExposedVolumesTableHeader;
import com.sanrad.nms.server.RemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TpCluster
extends TpBaseElement<ClusterElement> {
    public TpCluster() {
        super(theFactory.createClusterElement());
    }

    public TpCluster(ClusterNode aCluster) {
        this();
        if (aCluster == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Tried to create a Cluster from an Existing one, but the one we got is nulled");
            this.setName("Error: nulled Object");
            return;
        }
        this.setName(aCluster.getAlias());
        this.setVSwitches(Arrays.asList(aCluster.getVSwitches()));
        this.setTargets(aCluster.findAllInSubTree(TargetNode.class));
        ArrayList<VolumeTreeNode> volsList = new ArrayList<VolumeTreeNode>();
        SrNotExposedVolumeTreeModel notExposedVolumesModel = (SrNotExposedVolumeTreeModel)NotExposedVolumeTreeModelCollection.getInstance().getModel((RemoteObject)aCluster.getStub());
        volsList.addAll(notExposedVolumesModel.getAllVolumes());
        SrExposedVolumesTableModel exposedVolumesModel = (SrExposedVolumesTableModel)ExposedVolumesTableModelCollection.getInstance().getModel((RemoteObject)aCluster.getStub());
        int volColIndex = exposedVolumesModel.getColumnIndex(ExposedVolumesTableHeader.VOLUME_NAME.getColumnName());
        for (int i = 0; i < exposedVolumesModel.getRowCount(); ++i) {
            VolumeTreeNode volTreeNode = (VolumeTreeNode)exposedVolumesModel.getValueAt(i, volColIndex);
            volsList.add((VolumeTreeNode)exposedVolumesModel.getValueAt(i, volColIndex));
        }
        this.setVolumes(volsList);
        this.setStorages(StorageManager.getInstance().getStorages(aCluster));
    }

    @Override
    protected void initTables() {
        if (((ClusterElement)this.getJaxObj()).getTargetsTbl() == null) {
            ((ClusterElement)this.getJaxObj()).setTargetsTbl(theFactory.createTargetsTable());
        }
        if (((ClusterElement)this.getJaxObj()).getVswitchesTbl() == null) {
            ((ClusterElement)this.getJaxObj()).setVswitchesTbl(theFactory.createVSwitchesTable());
        }
        if (((ClusterElement)this.getJaxObj()).getVolumesTbl() == null) {
            ((ClusterElement)this.getJaxObj()).setVolumesTbl(theFactory.createVolumesTable());
        }
        if (((ClusterElement)this.getJaxObj()).getStorageTbl() == null) {
            ((ClusterElement)this.getJaxObj()).setStorageTbl(theFactory.createStorageTable());
        }
        if (((ClusterElement)this.getJaxObj()).getStorageTbl().getDisksTbl() == null) {
            ((ClusterElement)this.getJaxObj()).getStorageTbl().setDisksTbl(theFactory.createDisksTable());
        }
    }

    public void setName(String aName) {
        ((ClusterElement)this.getJaxObj()).setName(aName);
    }

    public String getName() {
        return ((ClusterElement)this.getJaxObj()).getName();
    }

    public void setVSwitches(List<VSwitchNode> aVSList) {
        for (VSwitchNode vs : aVSList) {
            this.setVSwitch(vs);
        }
    }

    public void setVSwitch(VSwitchNode aVS) {
        ((ClusterElement)this.getJaxObj()).getVswitchesTbl().getVswitches().add((VSwitchElement)new TpVSwitch(aVS).getJaxObj());
    }

    public void setTargets(List<TargetNode> aTargetsList) {
        for (TargetNode target : aTargetsList) {
            this.setTarget(target);
        }
    }

    public void setTarget(TargetNode aTarget) {
        ((ClusterElement)this.getJaxObj()).getTargetsTbl().getTargets().add((TargetElement)new TpTarget(aTarget).getJaxObj());
    }

    public void setVolumes(List<VolumeTreeNode> aVolumesList) {
        for (VolumeTreeNode volume : aVolumesList) {
            this.setVolume(volume);
        }
    }

    public void setVolume(VolumeTreeNode aVolume) {
        ((ClusterElement)this.getJaxObj()).getVolumesTbl().getVolumes().add((VolumeElement)new TpVolume(aVolume).getJaxObj());
    }

    public void setStorages(List<StorageDeviceNode> aStorageList) {
        if (aStorageList == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Got Nulled Storages List for TpCluster");
            return;
        }
        for (StorageDeviceNode storage : aStorageList) {
            this.setStorage(storage);
        }
    }

    public void setStorage(StorageDeviceNode aStorage) {
        if (aStorage.isDisk()) {
            ((ClusterElement)this.getJaxObj()).getStorageTbl().getDisksTbl().getDisks().add((DiskElement)new TpDisk((DirectAccessDeviceNode)aStorage).getJaxObj());
            return;
        }
        theLogger.logAndAssert(SrLogCategories.ILLEGAL_STATE, "The storage type ", aStorage.getStorageType(), " is not supported for topology.");
    }
}

