/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.topology;

import com.sanrad.log.SrLogCategories;
import com.sanrad.nms.client.data.dr.ConsistencyGroupNode;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.dr.MergePolicyNode;
import com.sanrad.nms.client.data.dr.ReplicationPolicyNode;
import com.sanrad.nms.client.data.dr.TransferPolicyNode;
import com.sanrad.nms.client.data.topology.TpBaseElement;
import com.sanrad.nms.client.data.topology.TpPair;
import com.sanrad.nms.client.data.topology.jaxb.CgElement;
import com.sanrad.nms.client.data.topology.jaxb.PairElement;
import java.util.Arrays;
import java.util.List;

public class TpCG
extends TpBaseElement<CgElement> {
    public TpCG() {
        super(theFactory.createCgElement());
    }

    public TpCG(ConsistencyGroupNode aCG) {
        this();
        if (aCG == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Tried to create a CG from an Existing one, but the one we got is nulled");
            this.setAlias("Error: nulled Object");
            return;
        }
        this.setAlias(aCG.getAlias());
        this.setReplicationPolicy(aCG.getReplicationPolicy());
        this.setTransferPolicy(aCG.getTransferPolicy());
        this.setMergePolicy(aCG.getMergePolicy());
        this.setPairs(Arrays.asList(aCG.getPairs()));
    }

    @Override
    protected void initTables() {
        if (((CgElement)this.getJaxObj()).getPairsTbl() == null) {
            ((CgElement)this.getJaxObj()).setPairsTbl(theFactory.createPairsTable());
        }
    }

    public void setAlias(String aAlias) {
        ((CgElement)this.getJaxObj()).setAlias(aAlias);
    }

    public String getAlias() {
        return ((CgElement)this.getJaxObj()).getAlias();
    }

    public void setReplicationPolicy(ReplicationPolicyNode aPolicy) {
        if (aPolicy == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Got nulled Policy when trying to set CG Replication Policy");
            return;
        }
        ((CgElement)this.getJaxObj()).setReplicationPolicy(aPolicy.toString());
    }

    public String getReplicationPolicy() {
        return ((CgElement)this.getJaxObj()).getReplicationPolicy();
    }

    public void setTransferPolicy(TransferPolicyNode aPolicy) {
        if (aPolicy == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Got nulled Policy when trying to set CG Transfer Policy");
            return;
        }
        ((CgElement)this.getJaxObj()).setTransferPolicy(aPolicy.toString());
    }

    public String getTransferPolicy() {
        return ((CgElement)this.getJaxObj()).getTransferPolicy();
    }

    public void setMergePolicy(MergePolicyNode aPolicy) {
        if (aPolicy == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Got nulled Policy when trying to set CG Merge Policy");
            return;
        }
        ((CgElement)this.getJaxObj()).setMergePolicy(aPolicy.toString());
    }

    public String getMergePolicy() {
        return ((CgElement)this.getJaxObj()).getMergePolicy();
    }

    public void setPair(DRPairNode aPair) {
        if (aPair == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Got nulled Pair to add");
            return;
        }
        ((CgElement)this.getJaxObj()).getPairsTbl().getPairs().add((PairElement)new TpPair(aPair).getJaxObj());
    }

    public void setPairs(List<? extends DRPairNode> aPairs) {
        if (aPairs == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Got Nulled Pairs List for TpCG");
            return;
        }
        for (DRPairNode dRPairNode : aPairs) {
            this.setPair(dRPairNode);
        }
    }
}

