/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.topology;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.topology.TpStorageProRoot;
import com.sanrad.nms.client.data.topology.jaxb.ObjectFactory;
import com.sanrad.nms.client.data.topology.jaxb.StorageProElement;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class ExportTopology {
    private static final ObjectFactory theObjFactory = new ObjectFactory();
    private static final TransformerFactory theFactory = TransformerFactory.newInstance();
    private static JAXBContext theJaxbContext = null;
    private static SrLogger theLogger = SrLogger.getLogger();

    private void marshToXMLFile(TpStorageProRoot aStorageProRoot, String aOutputFilePathAndName) throws JAXBException {
        assert (theJaxbContext != null);
        Marshaller marshaller = theJaxbContext.createMarshaller();
        JAXBElement<StorageProElement> spElement = theObjFactory.createStoragePro((StorageProElement)aStorageProRoot.getJaxObj());
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        File outXMLFile = new File(aOutputFilePathAndName);
        try {
            FileWriter writer = new FileWriter(outXMLFile);
            marshaller.marshal(spElement, (Writer)writer);
        }
        catch (IOException exp) {
            theLogger.error(SrLogCategories.EXCEPTION, exp, "Could not open a writer to the file: ", aOutputFilePathAndName);
        }
    }

    private TpStorageProRoot unmarshFromXMLFile(String aInputFilePathAndName) throws JAXBException {
        assert (theJaxbContext != null);
        Unmarshaller unmarshaller = theJaxbContext.createUnmarshaller();
        File inpXMLFile = new File(aInputFilePathAndName);
        JAXBElement spElement = (JAXBElement)unmarshaller.unmarshal(inpXMLFile);
        return new TpStorageProRoot((StorageProElement)spElement.getValue());
    }

    public void exportToXML(String aOutputFilePathAndName) throws JAXBException {
        TpStorageProRoot root = new TpStorageProRoot(SystemRootNode.getInstance());
        this.marshToXMLFile(root, aOutputFilePathAndName);
    }

    public TpStorageProRoot importFromXML(String aInpXMLFilePathAndName) throws JAXBException {
        return this.unmarshFromXMLFile(aInpXMLFilePathAndName);
    }

    public void transformXML2HTML(String aInputXMLFilePathAndName, String aXSLFilePathAndName) throws FileNotFoundException, TransformerException {
        String systemID = null;
        try {
            systemID = new File(aInputXMLFilePathAndName).toURI().toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            theLogger.error(SrLogCategories.EXCEPTION, e, "Can't generate systemID");
        }
        StreamSource xsltSource = new StreamSource(new File(aXSLFilePathAndName));
        StreamSource xmlSource = new StreamSource(aInputXMLFilePathAndName);
        xmlSource.setSystemId(systemID);
        Transformer transformer = theFactory.newTransformer(xsltSource);
        transformer.transform(xmlSource, new StreamResult(new FileOutputStream(aInputXMLFilePathAndName.replaceAll(".xml", ".html"))));
    }

    static {
        try {
            theJaxbContext = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
        }
        catch (JAXBException exp) {
            theLogger.error(SrLogCategories.EXCEPTION, exp, "Error initializing static JAXB context");
        }
    }
}

