/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.target.qos;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.Manager;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.target.qos.TargetQosGroupNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.target.qos.QosGroupEvent;
import com.sanrad.nms.client.event.target.qos.QosGroupListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.target.TargetQosGroup;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.util.SrEventListenerManager;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TargetQosGroupsManager
extends ElementManager {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static TargetQosGroupsManager theInstance = new TargetQosGroupsManager();
    private HashMap<ClusterNode, ArrayList<TargetQosGroupNode>> myClusterToGroupsMap = new HashMap();
    SrEventListenerManager.Informer myQosGroupRemovedInformer = new SrEventListenerManager.Informer<QosGroupListener, QosGroupEvent>(){

        @Override
        public void inform(QosGroupListener listener, QosGroupEvent aEvent) {
            listener.qosGroupDeleted(aEvent);
        }
    };
    SrEventListenerManager.Informer myQosGroupCreatedInformer = new SrEventListenerManager.Informer<QosGroupListener, QosGroupEvent>(){

        @Override
        public void inform(QosGroupListener listener, QosGroupEvent aEvent) {
            listener.qosGroupCreated(aEvent);
        }
    };
    SrEventListenerManager.Informer myQosGroupChangedInformer = new SrEventListenerManager.Informer<QosGroupListener, QosGroupEvent>(){

        @Override
        public void inform(QosGroupListener listener, QosGroupEvent aEvent) {
            listener.qosGroupChanged(aEvent);
        }
    };

    private TargetQosGroupsManager() {
    }

    public static TargetQosGroupsManager getInstance() {
        return theInstance;
    }

    public void addQosGroupListener(QosGroupListener aListener) {
        this.m_listeners.add(aListener);
    }

    public void removeQosGroupListener(QosGroupListener aListener) {
        this.m_listeners.remove(aListener);
    }

    private boolean isGroupExists(ClusterNode aCluster, TargetQosGroupNode group) {
        if (aCluster == null) {
            throw new IllegalArgumentException("Cluster should not be null");
        }
        List<TargetQosGroupNode> groups = this.getQosGroups(aCluster);
        return groups != null && groups.contains(group);
    }

    private void addQosGroup(ClusterNode aCluster, TargetQosGroupNode aQosGroupNode) {
        if (aCluster == null) {
            throw new IllegalArgumentException("Cluster should not be null");
        }
        if (aQosGroupNode == null) {
            throw new IllegalArgumentException("QoS Group should not be null");
        }
        if (this.isGroupExists(aCluster, aQosGroupNode)) {
            throw new IllegalArgumentException("QoS Group " + aQosGroupNode + " already exists");
        }
        ArrayList<TargetQosGroupNode> groups = this.myClusterToGroupsMap.get(aCluster);
        if (groups == null) {
            groups = new ArrayList();
            this.myClusterToGroupsMap.put(aCluster, groups);
        }
        SystemRootNode.getInstance().putRefAndStub((RemoteObject)aQosGroupNode.getStub(), aQosGroupNode);
        groups.add(aQosGroupNode);
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        super.elementRemove(e);
        TargetQosGroup qosGroupStub = (TargetQosGroup)e.getElement();
        theLogger.trace(SrLogCategories.INFORMATIVE, "QosGroupsManager: QoS group removed");
        TargetQosGroupNode qosGroupNode = (TargetQosGroupNode)SystemRootNode.getInstance().getRefByStub(qosGroupStub);
        if (qosGroupNode == null) {
            return;
        }
        ClusterNode cluster = this.getQosGroupCluster(qosGroupNode);
        this.removeQosGroup(qosGroupNode);
        this.fireQosGroupRemoved(qosGroupNode, cluster);
    }

    private void removeQosGroup(TargetQosGroupNode aQosGroup) {
        if (aQosGroup == null) {
            throw new IllegalArgumentException("Group should not be null");
        }
        SystemRootNode.getInstance().removeRefAndIdByStub((RemoteObject)aQosGroup.getStub());
        Manager.removeStubAndId(aQosGroup);
        for (ClusterNode cluster : this.myClusterToGroupsMap.keySet()) {
            ArrayList<TargetQosGroupNode> groups = this.myClusterToGroupsMap.get(cluster);
            if (groups == null) {
                throw new IllegalStateException("The given group: " + aQosGroup + " is not mapped to any cluster.");
            }
            boolean isRemoved = groups.remove(aQosGroup);
            if (groups.isEmpty()) {
                this.myClusterToGroupsMap.remove(cluster);
            }
            if (!isRemoved) continue;
            return;
        }
    }

    private ClusterNode getQosGroupCluster(TargetQosGroupNode aQosGroupNode) {
        for (ClusterNode cluster : this.myClusterToGroupsMap.keySet()) {
            ArrayList<TargetQosGroupNode> groups = this.myClusterToGroupsMap.get(cluster);
            if (groups == null) {
                throw new IllegalStateException("The mapping contains null for cluster: " + cluster);
            }
            if (!groups.contains(aQosGroupNode)) continue;
            return cluster;
        }
        return null;
    }

    public List<TargetQosGroupNode> getQosGroups(ClusterNode aCluster) {
        if (aCluster == null) {
            throw new IllegalArgumentException("Cluster should not be null");
        }
        ArrayList<TargetQosGroupNode> retGroups = new ArrayList<TargetQosGroupNode>();
        ArrayList<TargetQosGroupNode> groups = this.myClusterToGroupsMap.get(aCluster);
        if (groups != null) {
            retGroups.addAll(groups);
        }
        return retGroups;
    }

    public TargetQosGroupNode getQosGroup(ClusterNode aCluster) {
        if (aCluster == null) {
            throw new IllegalArgumentException("Cluster should not be null");
        }
        ArrayList<TargetQosGroupNode> groups = this.myClusterToGroupsMap.get(aCluster);
        if (groups != null && !groups.isEmpty()) {
            return groups.get(0);
        }
        return null;
    }

    public TargetQosGroupNode getQosGroup(VSwitchNode aVSwitch) {
        if (aVSwitch == null) {
            throw new IllegalArgumentException("V-Switch should not be null");
        }
        ClusterNode cluster = aVSwitch.getParentCluster();
        List<TargetQosGroupNode> clusterGroups = this.getQosGroups(cluster);
        if (clusterGroups != null) {
            for (TargetQosGroupNode qosGroup : clusterGroups) {
                if (!aVSwitch.equals(qosGroup.getVswitch())) continue;
                return qosGroup;
            }
        }
        return null;
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        TargetQosGroup stub = (TargetQosGroup)e.getElement();
        TargetQosGroupNode group = (TargetQosGroupNode)SystemRootNode.getInstance().getRefByStub(stub);
        if (group == null) {
            return;
        }
        HashMap params = this.getParameterList(e);
        String alias = (String)params.get(ClientParameterCode.TARGET_QOS_GROUP_ALIAS);
        BigInteger rateLimit = (BigInteger)params.get(ClientParameterCode.TARGET_QOS_GROUP_RATE_LIMIT);
        if (alias != null) {
            group.setAlias(alias);
        }
        if (rateLimit != null) {
            group.setMaxRate(rateLimit);
        }
        ClusterNode cluster = e.getClusterNode();
        this.fireQosGroupChanged(group, cluster);
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        TargetQosGroupNode qosGroupNode;
        TargetQosGroup stub = (TargetQosGroup)e.getElement();
        HashMap params = this.getParameterList(e);
        try {
            qosGroupNode = this.createQosGroupNode(stub, params);
        }
        catch (RemoteException e1) {
            theLogger.error(SrLogCategories.CLIENT_SERVER_INTERFACE, e1, new Object[0]);
            return;
        }
        ClusterNode cluster = e.getClusterNode();
        if (qosGroupNode != null && cluster != null) {
            this.addQosGroup(cluster, qosGroupNode);
            this.fireQosGroupCreated(qosGroupNode, cluster);
        }
    }

    private void fireQosGroupCreated(TargetQosGroupNode aGroup, ClusterNode aCluster) {
        QosGroupEvent event = new QosGroupEvent((Object)this, aGroup, aCluster);
        this.m_listeners.fireEvent(QosGroupListener.class, event, this.myQosGroupCreatedInformer);
    }

    private void fireQosGroupRemoved(TargetQosGroupNode aGroup, ClusterNode aCluster) {
        QosGroupEvent event = new QosGroupEvent((Object)this, aGroup, aCluster);
        this.m_listeners.fireEvent(QosGroupListener.class, event, this.myQosGroupRemovedInformer);
    }

    private void fireQosGroupChanged(TargetQosGroupNode aGroup, ClusterNode aCluster) {
        QosGroupEvent event = new QosGroupEvent((Object)this, aGroup, aCluster);
        this.m_listeners.fireEvent(QosGroupListener.class, event, this.myQosGroupChangedInformer);
    }

    private TargetQosGroupNode createQosGroupNode(TargetQosGroup aStub, HashMap aParams) throws RemoteException {
        String alias = (String)aParams.get(ClientParameterCode.TARGET_QOS_GROUP_ALIAS);
        BigInteger rateLimit = (BigInteger)aParams.get(ClientParameterCode.TARGET_QOS_GROUP_RATE_LIMIT);
        CommKeyClassId vswitchId = (CommKeyClassId)aParams.get(ClientParameterCode.VSWITCH_ID);
        if (vswitchId == null || rateLimit == null || alias == null) {
            theLogger.error(SrLogCategories.ILLEGAL_ARGUMENT, new IllegalStateException(), "The Qos Group stub = ", aStub, " with params ", aParams, " received with empty or missing elements.");
            return null;
        }
        return new TargetQosGroupNode(aStub, alias, rateLimit, vswitchId);
    }

    public void readDataFromServer(ClusterNode aCluster) {
        try {
            for (TargetQosGroup g : ((Cluster)aCluster.getStub()).getIscsiTargetQosGroups()) {
                HashMap params = g.getClientParameterList();
                this.addQosGroup(aCluster, this.createQosGroupNode(g, params));
            }
        }
        catch (RemoteException e) {
            theLogger.error(SrLogCategories.CLIENT_SERVER_INTERFACE, e.getMessage());
        }
        catch (IllegalValueException e) {
            theLogger.error(SrLogCategories.CLIENT_SERVER_INTERFACE, e.getMessage());
        }
    }

    public void readDataFromServer() {
        for (ClusterNode cluster : SystemRootNode.getInstance().getClusterNodes()) {
            this.readDataFromServer(cluster);
        }
    }

    public void removeQosGroups(ClusterNode aCluster) {
        ArrayList<TargetQosGroupNode> qosGroups = this.myClusterToGroupsMap.remove(aCluster);
        if (qosGroups == null) {
            return;
        }
        for (TargetQosGroupNode node : qosGroups) {
            this.removeQosGroup(node);
        }
    }
}

