/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.target;

import com.sanrad.nms.client.data.LUNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.iscsi.remoteinitiator.show.ISCSIRemoteInitiatorNode;
import com.sanrad.nms.client.data.scsi.SrDeviceNode;
import com.sanrad.nms.client.data.target.SCSITargetPortNode;
import com.sanrad.nms.client.data.target.qos.TargetQosGroupNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.constants.ISCSITargetLoginFailureTypeConstant;
import com.sanrad.nms.server.util.types.constants.SCSITargetDeviceStatusConstant;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;

public class TargetNode
extends SrDeviceNode<Target, CommKeyClassId>
implements Comparable {
    private Vector<LUNode> myLuNodeList;
    private int m_luCount;
    private boolean m_isEmpty;
    private String m_exposedOnVSwitch;
    private String m_userName;
    private ArrayList m_iscsiRemoteInitiators = new ArrayList();
    private SCSITargetDeviceStatusConstant targetStatus;
    private int m_numberOfLoginFailures;
    private Date m_lastLoginFailureTime;
    private ISCSITargetLoginFailureTypeConstant m_lastLoginFailureType;
    private String m_lastLoginFailureInitiatorName;
    private String m_lastLoginFailureInitiatorIP;
    private TargetQosGroupNode myQosGroup;

    public TargetNode(Target stub, String alias) throws RemoteException {
        super(stub, stub.getCommKeyClassId(), alias, ClientImageObject.TARGET);
        this.myLuNodeList = new Vector();
    }

    @Override
    public String type() {
        StringBuffer sb = new StringBuffer("Target ");
        sb.append(super.type());
        return sb.toString();
    }

    @Override
    public String getToolTipText() {
        StringBuffer toolTip = new StringBuffer(this.getName());
        toolTip.append(" [exposed on ");
        toolTip.append(this.getExposedOnVSwitchName());
        toolTip.append("]");
        return toolTip.toString();
    }

    @Override
    public int compareTo(Object o) {
        int answer = Integer.MIN_VALUE;
        if (o instanceof TargetNode) {
            TargetNode comp2 = (TargetNode)o;
            String val1 = this.getAlias();
            answer = val1.compareTo(comp2.getAlias());
        }
        return answer;
    }

    public void setExposedOnVswitchName(String exposedOn) {
        this.m_exposedOnVSwitch = exposedOn;
    }

    public String getExposedOnVSwitchName() {
        return this.m_exposedOnVSwitch;
    }

    public VSwitchNode getExposedOnVSwitchNode() {
        if (this.m_exposedOnVSwitch != null) {
            ClusterNode cluster = SystemRootNode.getInstance().getClusterNodeOfSource(this);
            return cluster.getVSwitchByName(this.m_exposedOnVSwitch);
        }
        return null;
    }

    public Vector<LUNode> getLuNodes() {
        return this.myLuNodeList;
    }

    public void setLuCount(int luCount) {
        this.m_luCount = luCount;
    }

    public int getLuCount() {
        return this.m_luCount;
    }

    public void setEmpty(boolean isEmpty) {
        this.m_isEmpty = isEmpty;
    }

    public boolean isEmpty() {
        return this.m_isEmpty;
    }

    public void setUserName(String userName) {
        this.m_userName = userName;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public void setTargetStatus(SCSITargetDeviceStatusConstant targetStatus) {
        this.targetStatus = targetStatus;
    }

    public SCSITargetDeviceStatusConstant getTargetStatus() {
        return this.targetStatus;
    }

    public int getNumberOfLoginFailure() {
        return this.m_numberOfLoginFailures;
    }

    public void setNumberOfLoginFailure(int num) {
        this.m_numberOfLoginFailures = num;
    }

    public String getLastLoginFailureTime() {
        return this.m_lastLoginFailureTime.toString();
    }

    public void setLastLoginFailureTime(Date time) {
        this.m_lastLoginFailureTime = time;
    }

    public ISCSITargetLoginFailureTypeConstant getLastLoginFailureType() {
        return this.m_lastLoginFailureType;
    }

    public void setLastLoginFailureType(ISCSITargetLoginFailureTypeConstant type) {
        this.m_lastLoginFailureType = type;
    }

    public String getLastLoginFailureInitiatorName() {
        return this.m_lastLoginFailureInitiatorName;
    }

    public void setLastLoginFailureInitiatorName(String name) {
        this.m_lastLoginFailureInitiatorName = name;
    }

    public String getLastLoginFailureInitiatorIP() {
        return this.m_lastLoginFailureInitiatorIP;
    }

    public void setLastLoginFailureInitiatorIP(String ip) {
        this.m_lastLoginFailureInitiatorIP = ip;
    }

    public void setConnectedInitiators(ArrayList iscsiRemoteInitiators) {
        this.m_iscsiRemoteInitiators.clear();
        this.m_iscsiRemoteInitiators.addAll(iscsiRemoteInitiators);
    }

    public ISCSIRemoteInitiatorNode[] getConnectedInitiators() {
        ISCSIRemoteInitiatorNode[] array = new ISCSIRemoteInitiatorNode[this.m_iscsiRemoteInitiators.size()];
        return this.m_iscsiRemoteInitiators.toArray(array);
    }

    public void addConnectedInitiator(ISCSIRemoteInitiatorNode initiatorNode) {
        if (!this.m_iscsiRemoteInitiators.contains(initiatorNode)) {
            this.m_iscsiRemoteInitiators.add(initiatorNode);
        }
    }

    public void removeConnectedInitiator(ISCSIRemoteInitiatorNode initiatorNode) {
        this.m_iscsiRemoteInitiators.remove(initiatorNode);
    }

    public SCSITargetPortNode getSCSIPort() {
        ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(this);
        String vswitch = this.getExposedOnVSwitchName();
        VSwitchNode vswitchNode = clusterNode.getVSwitchByName(vswitch);
        if (clusterNode.isUnderTakeover() || !vswitchNode.isConnected()) {
            vswitchNode = clusterNode.getOtherVSwitchInCluster(vswitchNode);
        }
        for (int index = 0; index < super.getSCSIPorts().length; ++index) {
            SCSITargetPortNode portNode = (SCSITargetPortNode)super.getSCSIPorts()[index];
            if (!portNode.getParentStub().equals(vswitchNode.getStub())) continue;
            return portNode;
        }
        return null;
    }

    public LUNode getLUNode(int lun) {
        for (LUNode luNode : this.myLuNodeList) {
            if (luNode == null || luNode.getLUN() != lun) continue;
            return luNode;
        }
        return null;
    }

    @Override
    public String getProblemOnDeletion() {
        if (this.getLuCount() != 0) {
            return "Target " + this + " contains LU's";
        }
        return super.getProblemOnDeletion();
    }

    public TargetQosGroupNode getQosGroup() {
        return this.myQosGroup;
    }

    public void setQosGroup(TargetQosGroupNode aQosGroup) {
        this.myQosGroup = aQosGroup;
    }
}

