/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.target;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.comm.Communication;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.LUManager;
import com.sanrad.nms.client.data.LUNode;
import com.sanrad.nms.client.data.Manager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.acl.PolicyManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.iscsi.remoteinitiator.show.ISCSIRemoteInitiatorNode;
import com.sanrad.nms.client.data.iscsi.remoteinitiator.show.ISCSIRemoteInitiatorsManager;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetNode;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetsManager;
import com.sanrad.nms.client.data.iscsi.session.show.ISCSISessionNode;
import com.sanrad.nms.client.data.iscsi.session.show.ISCSISessionsManager;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.target.SCSITargetPortNode;
import com.sanrad.nms.client.data.target.SCSITargetsPortsManager;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.target.qos.TargetQosGroupNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.event.alarm.PropagatedStateEvent;
import com.sanrad.nms.client.event.target.TargetEvent;
import com.sanrad.nms.client.event.target.TargetListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.acl.Permission;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiator;
import com.sanrad.nms.server.logic.iscsi.ISCSISession;
import com.sanrad.nms.server.logic.lu.LU;
import com.sanrad.nms.server.logic.scsi.SCSIPort;
import com.sanrad.nms.server.logic.storage.Storage;
import com.sanrad.nms.server.logic.target.ISCSITarget;
import com.sanrad.nms.server.logic.target.SCSITargetPort;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.logic.target.TargetQosGroup;
import com.sanrad.nms.server.util.types.constants.ISCSITargetLoginFailureTypeConstant;
import com.sanrad.nms.server.util.types.constants.SCSITargetDeviceStatusConstant;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.concurrent.SrFuture;
import com.sanrad.util.virtualization.ResourceAliasUtil;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class TargetManager
extends ElementManager {
    private static TargetManager theInstance = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer targetRemoveInformer = new SrEventListenerManager.Informer<TargetListener, TargetEvent>(){

        @Override
        public void inform(TargetListener listener, TargetEvent event) {
            listener.targetRemove(event);
        }
    };
    SrEventListenerManager.Informer newTargetCreateInformer = new SrEventListenerManager.Informer<TargetListener, TargetEvent>(){

        @Override
        public void inform(TargetListener listener, TargetEvent event) {
            listener.newTargetCreate(event);
        }
    };
    SrEventListenerManager.Informer targetStatusCangedInformer = new SrEventListenerManager.Informer<TargetListener, TargetEvent>(){

        @Override
        public void inform(TargetListener listener, TargetEvent event) {
            listener.targetStatusCanged(event);
        }
    };
    SrEventListenerManager.Informer targetVSwitchNameChangedInformer = new SrEventListenerManager.Informer<TargetListener, TargetEvent>(){

        @Override
        public void inform(TargetListener listener, TargetEvent event) {
            listener.targetVSwitchNameChanged(event);
        }
    };
    SrEventListenerManager.Informer targetUserNameChangedInformer = new SrEventListenerManager.Informer<TargetListener, TargetEvent>(){

        @Override
        public void inform(TargetListener listener, TargetEvent event) {
            listener.targetUserNameChanged(event);
        }
    };
    SrEventListenerManager.Informer targetAliasChangedInformer = new SrEventListenerManager.Informer<TargetListener, TargetEvent>(){

        @Override
        public void inform(TargetListener listener, TargetEvent event) {
            listener.targetAliasChanged(event);
        }
    };
    SrEventListenerManager.Informer targetNameChangedInformer = new SrEventListenerManager.Informer<TargetListener, TargetEvent>(){

        @Override
        public void inform(TargetListener listener, TargetEvent event) {
            listener.targetNameChanged(event);
        }
    };

    private TargetManager() {
    }

    public static synchronized TargetManager getInstance() {
        if (theInstance == null) {
            theInstance = new TargetManager();
        }
        return theInstance;
    }

    public void addTargetListener(TargetListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeTargetListener(TargetListener listener) {
        this.m_listeners.remove(listener);
    }

    public SrFuture<Void> createISCSITarget(String name, String alias, String vSwitch, Permission defaultAccess, ClusterNode cluster) {
        theLogger.trace(SrLogCategories.LEGACY, "TargetManager: trying to create new Target:  ", alias);
        return ClientAOImpl.getInstance().createISCSITarget(cluster.getStorageID(), name, alias, defaultAccess, vSwitch);
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    protected Object discoverElement(ClusterNode clusterNode) {
        Storage storageStub = Communication.getInstance().getStorageStub(clusterNode.getStub());
        if (storageStub != null) {
            try {
                Vector<? extends ISCSITarget> targetList = storageStub.getTargetList();
                Vector<TargetNode> targetNodes = new Vector<TargetNode>(targetList.size());
                theLogger.trace(SrLogCategories.LEGACY, "client got ", targetList.size(), " targets from the server.");
                Enumeration<? extends ISCSITarget> e = targetList.elements();
                while (e.hasMoreElements()) {
                    ISCSITarget target = e.nextElement();
                    TargetNode targetNode = this.discoverTarget(target);
                    targetNodes.addElement(targetNode);
                }
                return targetNodes;
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
                TargetManager.onConnectionError("Failed to discover Targets.");
            }
        }
        return null;
    }

    public TargetNode discoverTarget(ISCSITarget target) {
        try {
            TargetNode targetNode = (TargetNode)SystemRootNode.getInstance().getRefByStub(target);
            if (targetNode != null) {
                return targetNode;
            }
            HashMap params = target.getClientParameterList();
            String alias = (String)params.get(ClientParameterCode.TARGET_ALIAS);
            String name = (String)params.get(ClientParameterCode.TARGET_NAME);
            TargetQosGroup qosGroup = (TargetQosGroup)params.get(ClientParameterCode.ISCSI_TARGET_QOS_GROUP_ID);
            TargetQosGroupNode qosNode = null;
            if (qosGroup != null) {
                qosNode = (TargetQosGroupNode)Manager.getRefById(qosGroup.getCommKeyClassId());
            }
            targetNode = new TargetNode(target, alias);
            targetNode.setName(name);
            targetNode.setQosGroup(qosNode);
            String userName = target.getUserName();
            if (userName != null) {
                targetNode.setUserName(userName);
            }
            targetNode.setExposedOnVswitchName(target.getExposedOnVSwitch());
            targetNode.setTargetStatus(target.getStatus());
            ArrayList targetSessions = this.getTargetSessions(target);
            targetNode.setISCSISessions(targetSessions);
            ArrayList connectedInitiators = this.getConnectedInitiators(target);
            targetNode.setConnectedInitiators(connectedInitiators);
            ArrayList targetPortsNodes = this.getSCSITargetPorts(target);
            targetNode.setSCSIPorts(targetPortsNodes);
            targetNode.setNumberOfLoginFailure(target.getNumberOfLoginFailure().intValue());
            targetNode.setLastLoginFailureTime(new Date(target.getLastLoginFailureTime()));
            targetNode.setLastLoginFailureType(target.getLastLoginFailureType());
            targetNode.setLastLoginFailureInitiatorName(target.getLastLoginFailureInitiatorName());
            targetNode.setLastLoginFailureInitiatorIP(target.getLastLoginFailureInitiatorIP());
            targetNode.setStatus(TargetManager.getSeverity(target.getPropagatedState()));
            SystemRootNode.getInstance().putRefAndStub(target, targetNode);
            Vector<? extends LU> lus = target.getLUs();
            int lusSize = lus.size();
            theLogger.trace(SrLogCategories.LEGACY, "client got ", lusSize, " LUs for the target ", targetNode.getAlias(), " from the server.");
            for (int i = 0; i < lusSize; ++i) {
                LU lu = lus.get(i);
                LUNode luNode = (LUNode)SystemRootNode.getInstance().getRefByStub(lu);
                if (luNode != null) continue;
                LUManager.getInstance().createLU(lu, lu.getClientParameterList(), targetNode);
            }
            return targetNode;
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            TargetManager.onConnectionError("Failed to discover Targets and LUs.");
        }
        catch (IllegalValueException re) {
            theLogger.trace(SrLogCategories.LEGACY, re.getMessage());
        }
        return null;
    }

    public List readTargetsDataFromServer(ClusterNode clusterNode) {
        List targetNodes = (List)this.discoverElement(clusterNode);
        return targetNodes;
    }

    private ArrayList getTargetSessions(ISCSITarget target) {
        ArrayList<ISCSISessionNode> sessionsNodes = new ArrayList<ISCSISessionNode>();
        try {
            ISCSISession[] sessionsStubs = target.getISCSISessions();
            if (sessionsStubs != null && sessionsStubs.length > 0) {
                for (int index = 0; index < sessionsStubs.length; ++index) {
                    ISCSISession iscsiSession = sessionsStubs[index];
                    ISCSISessionNode sessionNode = (ISCSISessionNode)SystemRootNode.getInstance().getRefByStub(iscsiSession);
                    if (sessionNode == null) {
                        sessionNode = ISCSISessionsManager.getInstance().discoverSession(iscsiSession);
                        SystemRootNode.getInstance().putRefAndStub(iscsiSession, sessionNode);
                    }
                    sessionsNodes.add(sessionNode);
                }
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            TargetManager.onConnectionError("Failed to get target sessions from the Server.");
        }
        return sessionsNodes;
    }

    private ArrayList getConnectedInitiators(ISCSITarget target) {
        ArrayList<ISCSIRemoteInitiatorNode> connectedInitiatorsNodes = new ArrayList<ISCSIRemoteInitiatorNode>();
        try {
            ISCSIRemoteInitiator[] cennectedInitiatorsStubs = target.getISCSIRemoteInitiators();
            if (cennectedInitiatorsStubs != null && cennectedInitiatorsStubs.length > 0) {
                for (int index = 0; index < cennectedInitiatorsStubs.length; ++index) {
                    ISCSIRemoteInitiator iscsiRemoteInitiator = cennectedInitiatorsStubs[index];
                    ISCSIRemoteInitiatorNode remoteInitiatorNode = (ISCSIRemoteInitiatorNode)SystemRootNode.getInstance().getRefByStub(iscsiRemoteInitiator);
                    if (remoteInitiatorNode == null) {
                        remoteInitiatorNode = ISCSIRemoteInitiatorsManager.getInstance().discoverRemoteInitiator(iscsiRemoteInitiator);
                    }
                    connectedInitiatorsNodes.add(remoteInitiatorNode);
                }
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            TargetManager.onConnectionError("Failed to get target cennected initiators from the Server.");
        }
        return connectedInitiatorsNodes;
    }

    private ArrayList getSCSITargetPorts(ISCSITarget target) {
        ArrayList<SCSITargetPortNode> portNodes = new ArrayList<SCSITargetPortNode>();
        try {
            SCSIPort[] ports = target.getPorts();
            if (ports != null && ports.length > 0) {
                for (int index = 0; index < ports.length; ++index) {
                    SCSITargetPort port = (SCSITargetPort)ports[index];
                    SCSITargetPortNode portNode = (SCSITargetPortNode)SystemRootNode.getInstance().getRefByStub(port);
                    if (portNode == null) {
                        portNode = SCSITargetsPortsManager.getInstance().discoverPort(port);
                    }
                    if (portNode == null) continue;
                    portNodes.add(portNode);
                }
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            TargetManager.onConnectionError("Failed to get target ports table from the Server.");
        }
        return portNodes;
    }

    public BigInteger calculateTotalStorageAccess(TargetNode targetNode) {
        BigInteger total = new BigInteger("0");
        for (LUNode luNode : targetNode.getLuNodes()) {
            VolumeTreeNode volume = luNode.getVolumeChild();
            BigInteger acceessibleSpace = null;
            acceessibleSpace = volume instanceof DirectAccessDeviceNode ? ((DirectAccessDeviceNode)volume).getTotalSpace() : volume.getAccessibleSpace();
            total = total.add(acceessibleSpace);
        }
        return total;
    }

    public boolean isTargetNameLegal(String targetName, StringBuffer msg) {
        char[] name = targetName.toCharArray();
        for (int i = 0; i < name.length; ++i) {
            if (Character.isLowerCase(name[i]) && Character.isLetter(name[i]) || Character.isDigit(name[i]) || name[i] == '-' || name[i] == '.' || name[i] == ':') continue;
            if (msg != null) {
                msg.append(targetName);
                msg.append(" is not in compliance with the iSCSI RFC.");
                msg.append("\n");
                msg.append("It should include only the following characters:");
                msg.append("\n");
                msg.append("'-' '.' ':' 'a'..'z' '0'..'9'");
                msg.append("\n");
            }
            return false;
        }
        return true;
    }

    @Override
    public void alreadyKnownByVSwitch(CommunicationEvent e) {
    }

    @Override
    public void propagatedStateChanged(PropagatedStateEvent e) {
        RemoteObject element = e.getStub();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        if (element instanceof Target) {
            TargetNode targetNode = (TargetNode)SystemRootNode.getInstance().getRefByStub(element);
            if (targetNode == null) {
                theLogger.trace(SrLogCategories.LEGACY, "TargetManager- propagatedStateChanged() on an unknown element !");
                return;
            }
            theLogger.trace(SrLogCategories.LEGACY, "TargetManager: propagatedStateChanged().");
            super.propagatedStateChanged(e);
            TargetEvent event = new TargetEvent(this, element);
            event.setValue(targetNode);
            this.fireStatusChanged(event);
        }
    }

    private void fireTargetRemoved(TargetEvent event) {
        this.m_listeners.fireEvent(TargetListener.class, event, this.targetRemoveInformer);
    }

    private void fireTargetCreated(TargetEvent event) {
        this.m_listeners.fireEvent(TargetListener.class, event, this.newTargetCreateInformer);
    }

    private void fireStatusChanged(TargetEvent event) {
        theLogger.trace(SrLogCategories.LEGACY, "TargetManager: fireStatusChanged().");
        this.m_listeners.fireEvent(TargetListener.class, event, this.targetStatusCangedInformer);
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        super.elementRemove(e);
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        TargetNode targetNode = (TargetNode)SystemRootNode.getInstance().getRefByStub(element);
        theLogger.trace(SrLogCategories.LEGACY, "TargetManager: target removed");
        Target target = (Target)element;
        TargetEvent event = new TargetEvent(this, target);
        event.setValue(targetNode);
        this.fireTargetRemoved(event);
        if (targetNode != null) {
            ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(targetNode);
            PolicyManager policyMgr = clusterNode.getPolicyManager();
            policyMgr.removeAclForTarget(targetNode);
            targetNode.removeSCSIPorts();
        }
        SystemRootNode.getInstance().removeRefAndIdByStub(element);
    }

    private void fireTargetVSwitchNameChanged(TargetNode targetNode) {
        TargetEvent event = this.createEvent(targetNode);
        this.m_listeners.fireEvent(TargetListener.class, event, this.targetVSwitchNameChangedInformer);
    }

    private void fireTargetUserNameChanged(TargetNode targetNode) {
        TargetEvent event = this.createEvent(targetNode);
        this.m_listeners.fireEvent(TargetListener.class, event, this.targetUserNameChangedInformer);
    }

    private void fireAliasChanged(TargetNode target) {
        TargetEvent event = this.createEvent(target);
        theLogger.trace(SrLogCategories.LEGACY, "changing alias to target: ", event.getAlias());
        this.m_listeners.fireEvent(TargetListener.class, event, this.targetAliasChangedInformer);
    }

    private void fireTargetNameChanged(TargetNode target) {
        TargetEvent event = this.createEvent(target);
        theLogger.trace(SrLogCategories.LEGACY, "changing name to target: ", event.getName());
        this.m_listeners.fireEvent(TargetListener.class, event, this.targetNameChangedInformer);
    }

    private TargetEvent createEvent(TargetNode target) {
        TargetEvent event = null;
        event = new TargetEvent(this, (RemoteObject)target.getStub());
        event.setValue(target);
        event.setAlias(target.getAlias());
        event.setLUCount(target.getLuCount());
        Vector<LU> lus = new Vector<LU>(target.getLuCount());
        for (LUNode luNode : target.getLuNodes()) {
            lus.add((LU)luNode.getStub());
        }
        event.setName(target.getName());
        event.setEmpty(target.isEmpty());
        return event;
    }

    public void setAlias(Object node, String newAlias) {
        try {
            Object stub = ((TargetNode)node).getStub();
            HashMap<ClientParameterCode, String> hash = new HashMap<ClientParameterCode, String>(1);
            if (stub instanceof Target) {
                hash.put(ClientParameterCode.TARGET_ALIAS, newAlias);
                ((Target)stub).changeElement(hash);
            }
        }
        catch (Exception e) {
            theLogger.error(SrLogCategories.LEGACY, e, new Object[0]);
        }
    }

    public SrFuture<Void> editTarget(TargetNode targetNode, HashMap params) {
        theLogger.trace(SrLogCategories.LEGACY, "TargetManager : trying to edit target properties: ", targetNode.getAlias());
        return ClientAOImpl.getInstance().changeElements(Collections.singleton(targetNode.getIdentifier()), params);
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        HashMap params = this.getParameterList(e);
        SrTreeNode target = SystemRootNode.getInstance().getRefByStub(element);
        if (target != null) {
            TargetNode targetNode = (TargetNode)target;
            this.initializeNode(params, element, targetNode, false);
        }
        theLogger.trace(SrLogCategories.LEGACY, "TargetManager: target changed");
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        try {
            theLogger.info(SrLogCategories.INFORMATIVE, "TargetManager received notification");
            RemoteObject element = e.getElement();
            if (this.isClusterInDiscovery(element)) {
                return;
            }
            if (this.alreadyExist(element)) {
                return;
            }
            theLogger.trace(SrLogCategories.LEGACY, "TargetManager: target created");
            ISCSITarget target = (ISCSITarget)element;
            HashMap params = this.getParameterList(e);
            TargetNode targetNode = new TargetNode(target, null);
            this.initializeNode(params, element, targetNode, true);
            theLogger.info(SrLogCategories.INFORMATIVE, "Node created and initialized");
            ClusterNode clusterNode = this.getClusterNode(target);
            PolicyManager policyMgr = clusterNode.getPolicyManager();
            policyMgr.createACLForTarget(targetNode);
            SystemRootNode.getInstance().putRefAndStub(target, targetNode);
            theLogger.info(SrLogCategories.INFORMATIVE, "ACL created and set");
            TargetEvent event = new TargetEvent(this, target, targetNode.getAlias());
            event.setValue(targetNode);
            this.fireTargetCreated(event);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            TargetManager.onConnectionError();
        }
    }

    private void initializeNode(HashMap params, Object element, SrTreeNode node, boolean isCreate) {
        Object alias = this.getObjectForParam(params, ClientParameterCode.TARGET_ALIAS, isCreate);
        Object vswitchName = this.getObjectForParam(params, ClientParameterCode.TARGET_EXPOSED_ON, isCreate);
        Object targetName = this.getObjectForParam(params, ClientParameterCode.TARGET_NAME, isCreate);
        Object targetUserName = this.getObjectForParam(params, ClientParameterCode.TARGET_USER_NAME, isCreate);
        Object isEmpty = this.getObjectForParam(params, "Missing code - ClientParameterCode.TARGET_IS_EMPTY", isCreate);
        Object luCount = this.getObjectForParam(params, "Missing code - ClientParameterCode.TARGET_LU_COUNT", isCreate);
        Object propagatedState = this.getObjectForParam(params, "Missing code - ClientParameterCode.PROPAGATED_STATE", isCreate);
        ISCSISession[] iscsiSessions = this.getObjectForParam(params, ClientParameterCode.TARGET_SESSIONS, isCreate);
        Object targetStatus = this.getObjectForParam(params, ClientParameterCode.SCSI_TARGET_STATUS, isCreate);
        ISCSIRemoteInitiator[] remoteInitiatorsObj = this.getObjectForParam(params, ClientParameterCode.ISCSI_TARGET_REMOTE_INITIATORS, isCreate);
        Object numOfLoginFailureObj = this.getObjectForParam(params, ClientParameterCode.ISCSI_TARGET_NUM_OF_LOGIN_FAILURE, isCreate);
        Object lastLoginFailureTimeObj = this.getObjectForParam(params, ClientParameterCode.ISCSI_TARGET_LAST_FAILURE_TIME, isCreate);
        Object lastLoginFailureTypeObj = this.getObjectForParam(params, ClientParameterCode.ISCSI_TARGET_LAST_FAILURE_TYPE, isCreate);
        Object lastLoginFailureInitiatorNameObj = this.getObjectForParam(params, ClientParameterCode.ISCSI_TARGET_LAST_INITIATOR_FAILURE_NAME, isCreate);
        Object lastLoginFailureInitiatorIPObj = this.getObjectForParam(params, ClientParameterCode.ISCSI_TARGET_LAST_FAILED_INITIATOR_IP, isCreate);
        TargetQosGroup qosGroup = (TargetQosGroup)params.get(ClientParameterCode.ISCSI_TARGET_QOS_GROUP_ID);
        TargetQosGroupNode qosNode = null;
        if (qosGroup != null) {
            try {
                qosNode = (TargetQosGroupNode)Manager.getRefById(qosGroup.getCommKeyClassId());
            }
            catch (RemoteException e) {
                theLogger.error(SrLogCategories.EXCEPTION, e, new Object[0]);
            }
        }
        ISCSITarget target = (ISCSITarget)element;
        if (isCreate) {
            try {
                if (alias == null) {
                    alias = target.getAlias();
                }
                if (vswitchName == null) {
                    vswitchName = target.getExposedOnVSwitch();
                }
                if (targetName == null) {
                    targetName = target.getName();
                }
                if (targetUserName == null) {
                    targetUserName = target.getUserName();
                }
                if (isEmpty == null) {
                    isEmpty = new Boolean(target.isEmpty());
                }
                if (luCount == null) {
                    luCount = new Integer(target.getLUCount());
                }
                if (propagatedState == null) {
                    propagatedState = target.getPropagatedState();
                }
                if (iscsiSessions == null) {
                    iscsiSessions = target.getISCSISessions();
                }
                if (targetStatus == null) {
                    targetStatus = target.getStatus();
                }
                if (remoteInitiatorsObj == null) {
                    remoteInitiatorsObj = target.getISCSIRemoteInitiators();
                }
                if (numOfLoginFailureObj == null) {
                    numOfLoginFailureObj = target.getNumberOfLoginFailure();
                }
                if (lastLoginFailureTimeObj == null) {
                    lastLoginFailureTimeObj = target.getLastLoginFailureTime();
                }
                if (lastLoginFailureTypeObj == null) {
                    lastLoginFailureTypeObj = target.getLastLoginFailureType();
                }
                if (lastLoginFailureInitiatorNameObj == null) {
                    lastLoginFailureInitiatorNameObj = target.getLastLoginFailureInitiatorName();
                }
                if (lastLoginFailureInitiatorIPObj == null) {
                    lastLoginFailureInitiatorIPObj = target.getLastLoginFailureInitiatorIP();
                }
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
                TargetManager.onConnectionError("Failed to create the Target.");
            }
        }
        TargetNode targetNode = (TargetNode)node;
        if (alias != null) {
            targetNode.setAlias(alias.toString());
            if (!isCreate) {
                theLogger.trace(SrLogCategories.LEGACY, "event: target alias is changed !");
                this.fireAliasChanged(targetNode);
            }
        }
        if (targetName != null) {
            targetNode.setName(targetName.toString());
            if (!isCreate) {
                theLogger.trace(SrLogCategories.LEGACY, "event: target name changed");
                this.fireTargetNameChanged(targetNode);
            }
        }
        if (vswitchName != null) {
            targetNode.setExposedOnVswitchName(vswitchName.toString());
            if (!isCreate) {
                theLogger.trace(SrLogCategories.LEGACY, "event: target vswitch name changed");
                this.fireTargetVSwitchNameChanged(targetNode);
            }
        }
        if (targetUserName != null) {
            targetNode.setUserName(targetUserName.toString());
            if (!isCreate) {
                theLogger.trace(SrLogCategories.LEGACY, "event: target User Name changed");
                this.fireTargetUserNameChanged(targetNode);
            }
        }
        if (!isCreate && params.containsKey(ClientParameterCode.ISCSI_TARGET_QOS_GROUP_ID)) {
            targetNode.setQosGroup(qosNode);
            this.fireTargetNameChanged(targetNode);
        }
        if (isCreate) {
            targetNode.setStatus(TargetManager.getSeverity((AlarmSeverity)propagatedState));
            targetNode.setTargetStatus((SCSITargetDeviceStatusConstant)targetStatus);
            targetNode.setNumberOfLoginFailure(((BigInteger)numOfLoginFailureObj).intValue());
            targetNode.setLastLoginFailureTime(new Date((Long)lastLoginFailureTimeObj));
            targetNode.setLastLoginFailureType((ISCSITargetLoginFailureTypeConstant)lastLoginFailureTypeObj);
            targetNode.setLastLoginFailureInitiatorName((String)lastLoginFailureInitiatorNameObj);
            targetNode.setLastLoginFailureInitiatorIP((String)lastLoginFailureInitiatorIPObj);
            ISCSIRemoteInitiator[] remoteInitiators = remoteInitiatorsObj;
            ArrayList remoteInitiatorsNodes = ISCSIRemoteInitiatorsManager.getInstance().getRemoteInitiatorsNodes(remoteInitiators);
            targetNode.setConnectedInitiators(remoteInitiatorsNodes);
            targetNode.setISCSISessions(iscsiSessions);
            targetNode.setQosGroup(qosNode);
        }
    }

    public TargetNode getTargetByName(ClusterNode cluster, String targetName) {
        Enumeration<TreeNode> e = cluster.getExposedVolumesNode().children();
        while (e.hasMoreElements()) {
            TargetNode target = (TargetNode)e.nextElement();
            if (!targetName.equals(target.getName())) continue;
            return target;
        }
        return null;
    }

    public TargetNode getTargetByName(String targetName) {
        Vector<ClusterNode> clusterNodesList = SystemRootNode.getInstance().getClusterNodes();
        int i = clusterNodesList.size();
        while (i-- > 0) {
            TargetNode target = this.getTargetByName(clusterNodesList.get(i), targetName);
            if (target == null) continue;
            return target;
        }
        return null;
    }

    public String getAutoTargetNameForVolume(String aVolumeAlias) {
        ArrayList<String> allAliases = new ArrayList<String>();
        List<TargetNode> allSystemTargets = SystemRootNode.getInstance().findAllInSubTree(TargetNode.class);
        for (TargetNode target : allSystemTargets) {
            allAliases.add(target.getAlias());
            allAliases.add(target.getName());
        }
        List<SrISCSIRemoteTargetNode> allSystemRemoteTargets = SrISCSIRemoteTargetsManager.getInstance().getAllRemoteTargetNodes();
        for (SrISCSIRemoteTargetNode rTarget : allSystemRemoteTargets) {
            allAliases.add(rTarget.getAlias());
            allAliases.add(rTarget.getName());
        }
        String adaptedVolumeAlias = aVolumeAlias.toLowerCase();
        adaptedVolumeAlias = adaptedVolumeAlias.replace('_', '-');
        adaptedVolumeAlias = adaptedVolumeAlias.replaceAll("[^a-z0-9\\.:-]", ".");
        return ResourceAliasUtil.getRecommendedAlias(adaptedVolumeAlias, allAliases);
    }
}

