/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.target;

import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.acl.PolicyManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.identity.IdentityManager;
import com.sanrad.nms.client.data.identity.IdentityNode;
import com.sanrad.nms.client.data.target.TargetManager;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.event.acl.PolicyManagerEvent;
import com.sanrad.nms.client.event.acl.PolicyManagerListener;
import com.sanrad.nms.client.event.identity.IdentityEvent;
import com.sanrad.nms.client.event.identity.IdentityListener;
import com.sanrad.nms.client.event.identity.IdentitySelectionEvent;
import com.sanrad.nms.client.event.identity.IdentitySelectionListener;
import com.sanrad.nms.client.event.target.TargetEvent;
import com.sanrad.nms.client.event.target.TargetListener;
import com.sanrad.nms.client.gui.target.TargetsListHeader;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.swing.SrTableModel;
import java.util.List;
import java.util.Vector;

public class SrTargetsListModel
extends SrTableModel
implements IdentitySelectionListener,
TargetListener,
IdentityListener,
PolicyManagerListener {
    private IdentityNode m_identityNode;

    public SrTargetsListModel() {
        super(new SrDefaultTableColumns(TargetsListHeader.getColumnNames()));
    }

    @Override
    public void addListeners() {
        TargetManager.getInstance().addTargetListener(this);
        IdentityManager.getInstance().addIdentityListener(this);
    }

    @Override
    public void removeListeners() {
        TargetManager.getInstance().removeTargetListener(this);
        IdentityManager.getInstance().removeIdentityListener(this);
    }

    protected void initModel(IdentityNode identityNode) {
        this.removeAllRows();
        this.m_identityNode = identityNode;
        ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(identityNode);
        PolicyManager policyMgr = clusterNode.getPolicyManager();
        policyMgr.addPolicyManagerListener(this);
        List targets = policyMgr.getTargetsForIdentity(identityNode);
        for (int i = 0; i < targets.size(); ++i) {
            Object target = targets.get(i);
            if (target instanceof Target) {
                target = SystemRootNode.getInstance().getRefByStub((Target)target);
            }
            this.addTargetRow((TargetNode)target);
        }
        this.fireTableRowsInserted(0, this.getLastRowIndex());
    }

    protected void addTargetRow(TargetNode target) {
        Vector<TargetNode> rowData = new Vector<TargetNode>(1);
        rowData.addElement(target);
        this.addRowQuetly(rowData.toArray(), -1);
    }

    @Override
    public void newTargetCreate(TargetEvent e) {
    }

    @Override
    public void targetRemove(TargetEvent e) {
        int rows = this.getRowCount();
        int col = this.getColumnIndex(TargetsListHeader.ALIAS.getColumnName());
        for (int i = 0; i < rows; ++i) {
            SrTreeNode deletedTarget;
            Object target = this.getValueAt(i, col);
            if (!target.equals(deletedTarget = SystemRootNode.getInstance().getRefByStub(e.getStub()))) continue;
            this.removeRow(i);
            break;
        }
    }

    @Override
    public void targetAliasChanged(TargetEvent e) {
    }

    @Override
    public void targetNameChanged(TargetEvent e) {
        this.fireTableRowsUpdated(0, this.getLastRowIndex());
    }

    @Override
    public void targetVSwitchNameChanged(TargetEvent e) {
    }

    @Override
    public void targetStatusCanged(TargetEvent e) {
        this.fireTableRowsUpdated(0, this.getLastRowIndex());
    }

    @Override
    public void targetUserNameChanged(TargetEvent e) {
    }

    @Override
    public void identitySelected(IdentitySelectionEvent event) {
        IdentityNode node = event.getIdentityNode();
        if (node != null) {
            this.initModel(node);
        }
    }

    public void clear() {
        this.removeAllRows();
    }

    @Override
    public void identityCreated(IdentityEvent e) {
    }

    @Override
    public void identityRemoved(IdentityEvent e) {
        RemoteObject stub = e.getStub();
        SrTreeNode identity = SystemRootNode.getInstance().getRefByStub(stub);
        if (identity != null && identity.equals(this.m_identityNode)) {
            this.initModel((IdentityNode)identity);
        }
    }

    @Override
    public void identityChanged(IdentityEvent e) {
    }

    @Override
    public void identityStatusChanged(IdentityEvent e) {
    }

    @Override
    public void aclEntryCreated(PolicyManagerEvent e) {
        IdentityNode identity = e.getAclEntryNode().getIdentity();
        if (identity.equals(this.m_identityNode)) {
            this.initModel(identity);
        }
    }

    @Override
    public void aclEntryRemoved(PolicyManagerEvent e) {
    }

    @Override
    public void aclMapRefreshed(PolicyManagerEvent e) {
    }

    @Override
    public void aclEntryChanged(PolicyManagerEvent e) {
    }
}

