/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.target;

import com.sanrad.nms.client.data.AliasObject;
import com.sanrad.nms.client.data.LUNode;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.dr.DRASyncPairManager;
import com.sanrad.nms.client.data.dr.DRASyncPairNode;
import com.sanrad.nms.client.data.dr.DRPairManager;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.dr.DRSyncPairManager;
import com.sanrad.nms.client.data.dr.DRSyncPairNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.StorageDeviceNode;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.volume.NonVirtualVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.event.DirectAccessDeviceEvent;
import com.sanrad.nms.client.event.SubDirectAccessDeviceEvent;
import com.sanrad.nms.client.event.dr.DRAsyncPairEvent;
import com.sanrad.nms.client.event.dr.DRAsyncPairListener;
import com.sanrad.nms.client.event.dr.DRSyncPairEvent;
import com.sanrad.nms.client.event.dr.DRSyncPairListener;
import com.sanrad.nms.client.event.lu.LUEvent;
import com.sanrad.nms.client.event.volume.VolumeEvent;
import com.sanrad.nms.client.gui.target.TargetTableHeader;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.lu.LU;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.swing.SrKeyObjectSelectionTableModel;
import com.sanrad.util.StorageSize;
import com.sanrad.util.Util;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.util.List;
import javax.swing.tree.TreeNode;

public class SrTargetTableModel
extends SrKeyObjectSelectionTableModel
implements DRAsyncPairListener,
DRSyncPairListener {
    private WeakReference<TargetNode> mySelectedTargetNode = null;

    public SrTargetTableModel() {
        super(new SrDefaultTableColumns(TargetTableHeader.getColumnNames()));
    }

    @Override
    public void addListeners() {
        DRASyncPairManager.getInstance().addDRAsyncPairListener(this);
        DRSyncPairManager.getInstance().addDRSyncPairListener(this);
    }

    @Override
    public void removeListeners() {
        DRASyncPairManager.getInstance().removeDRAsyncPairListener(this);
        DRSyncPairManager.getInstance().removeDRSyncPairListener(this);
    }

    public void clear() {
        this.mySelectedTargetNode = null;
        this.removeAllRows();
    }

    public void directAccessDeviceAliasChanged(DirectAccessDeviceEvent event) {
        this.rename(event.getStub(), event.getAlias());
    }

    public void directAccessDeviceChanged(DirectAccessDeviceEvent event) {
    }

    public void directAccessDeviceRemoved(DirectAccessDeviceEvent event) {
    }

    public void directAccessDeviceCreated(DirectAccessDeviceEvent event) {
    }

    public void directAccessDeviceInfoChanged(DirectAccessDeviceEvent event) {
    }

    public void directAccessDeviceStatusChanged(DirectAccessDeviceEvent event) {
        this.fireTableRowsUpdated(0, this.getLastRowIndex());
    }

    public void directAccessDeviceBlinkStateChange(DirectAccessDeviceEvent event) {
        this.fireTableRowsUpdated(0, this.getLastRowIndex());
    }

    public void directAccessDeviceExposed(DirectAccessDeviceEvent event) {
    }

    public void directAccessDeviceDeExposed(DirectAccessDeviceEvent event) {
    }

    public void subDirecetAccessDeviceCreated(SubDirectAccessDeviceEvent event) {
    }

    public void subDirecetAccessDeviceRemoved(SubDirectAccessDeviceEvent event) {
    }

    public void subDirectAccessDeviceExposed(SubDirectAccessDeviceEvent event) {
    }

    public void subDirectAccessDeviceDeExposed(SubDirectAccessDeviceEvent event) {
    }

    public void subDirecetAccessDeviceAliasChanged(SubDirectAccessDeviceEvent event) {
        this.rename(event.getStub(), event.getAlias());
    }

    public void subDirecetAccessDeviceStatusChanged(SubDirectAccessDeviceEvent event) {
        this.fireTableRowsUpdated(0, this.getLastRowIndex());
    }

    public void subDirecetAccessDeviceInfoChanged(SubDirectAccessDeviceEvent event) {
    }

    public void rename(Object stub, String alias) {
        int size = this.getRowCount();
        int ind = this.getColumnIndex(TargetTableHeader.VOLUME_NAME.getColumnName());
        for (int i = 0; i < size; ++i) {
            List<Object> rowData = this.getRow(i);
            Object obj = rowData.get(ind);
            if (obj == null || !((SrTreeNode)obj).getStub().equals(stub)) continue;
            this.fireTableCellUpdated(i, ind);
            return;
        }
    }

    public void setTargetNode(TargetNode aTargetNode) {
        this.removeAllRows();
        WeakReference<TargetNode> weakReference = this.mySelectedTargetNode = aTargetNode == null ? null : new WeakReference<TargetNode>(aTargetNode);
        if (aTargetNode == null) {
            return;
        }
        for (LUNode luNode : aTargetNode.getLuNodes()) {
            Object[] insertData = this.buildRow(luNode);
            this.addRow(insertData);
        }
    }

    public void removedLU(LUEvent event) {
        RemoteObject stub = event.getStub();
        int colInd = this.getColumnIndex(TargetTableHeader.LUN.getColumnName());
        int i = this.getRowCount();
        while (i-- > 0) {
            LUNode lu = (LUNode)this.getValueAt(i, colInd);
            if (!stub.equals(lu.getStub())) continue;
            this.removeRow(i);
        }
    }

    public void statusChanged(LUEvent event) {
        this.fireTableRowsUpdated(0, this.getLastRowIndex());
    }

    public void createdLU(LUEvent event) {
        TargetNode targetNode = this.getModelTargetNode();
        if (targetNode != null && targetNode.getStub() == null) {
            targetNode = (TargetNode)SystemRootNode.getInstance().getRefByStub(event.getTargetStub());
        }
        if (targetNode == null || !((Target)targetNode.getStub()).equals(event.getTargetStub())) {
            return;
        }
        LUNode luObj = (LUNode)SystemRootNode.getInstance().getRefByStub(event.getStub());
        Object[] rowData = this.buildRow(luObj);
        this.addRow(rowData);
    }

    private Object[] buildRow(LUNode luObj) {
        Object[] rowData = new Object[TargetTableHeader.getColumnNames().size()];
        VolumeTreeNode volumeObj = luObj.getVolumeChild();
        BigInteger accessibleSpace = null;
        BigInteger allocatedSpace = volumeObj.getAllocatedSpace();
        TreeNode storageNode = null;
        if (volumeObj != null) {
            if (volumeObj instanceof DirectAccessDeviceNode) {
                DirectAccessDeviceNode disk = (DirectAccessDeviceNode)volumeObj;
                accessibleSpace = disk.getTotalSpace();
                if (disk.isDisk()) {
                    storageNode = disk;
                }
            } else {
                accessibleSpace = volumeObj.getAccessibleSpace();
                if (volumeObj instanceof NonVirtualVolumeNode) {
                    storageNode = volumeObj.findNodeInSubTree(StorageDeviceNode.class);
                }
            }
        }
        AliasObject accSpace = new AliasObject(StorageSize.getSizeAsString(accessibleSpace), accessibleSpace);
        AliasObject allSpace = new AliasObject(StorageSize.getSizeAsString(allocatedSpace), allocatedSpace);
        rowData[this.getColumnIndex((String)TargetTableHeader.LUN.toString())] = luObj;
        rowData[this.getColumnIndex((String)TargetTableHeader.VOLUME_NAME.toString())] = volumeObj;
        rowData[this.getColumnIndex((String)TargetTableHeader.STORAGE_NAME.toString())] = storageNode;
        rowData[this.getColumnIndex((String)TargetTableHeader.ACCESSIBLE_SPACE.toString())] = accSpace;
        rowData[this.getColumnIndex((String)TargetTableHeader.ALLOCATED_SPACE.toString())] = allSpace;
        DRPairNode pair = DRPairManager.getPairContainingVolume(volumeObj);
        rowData[this.getColumnIndex((String)TargetTableHeader.DR_VOLUME_ROLE.toString())] = pair != null ? pair.getVolumeDRRole(volumeObj) : null;
        return rowData;
    }

    public void changeLU(LUEvent event) {
        TargetNode targetNode = this.getModelTargetNode();
        if (targetNode != null && targetNode.getStub() == null) {
            targetNode = (TargetNode)SystemRootNode.getInstance().getRefByStub(event.getTargetStub());
        }
        if (targetNode == null || !((Target)targetNode.getStub()).equals(event.getTargetStub())) {
            return;
        }
        int luColIndex = this.getColumnIndex(TargetTableHeader.LUN.getColumnName());
        for (int i = 0; i < this.getRowCount(); ++i) {
            LUNode luInTable = (LUNode)this.getValueAt(i, luColIndex);
            if (!((LU)luInTable.getStub()).equals(event.getStub())) continue;
            this.editRow(i, this.buildRow(luInTable));
            return;
        }
    }

    public void volumeCapacityChanged(VolumeEvent event) {
        VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(event.getStub());
        this.updateRow(volume);
    }

    protected void updateRow(VolumeTreeNode volume) {
        int col = this.getColumnIndex(TargetTableHeader.VOLUME_NAME.getColumnName());
        int accCol = this.getColumnIndex(TargetTableHeader.ACCESSIBLE_SPACE.getColumnName());
        int allocCol = this.getColumnIndex(TargetTableHeader.ALLOCATED_SPACE.getColumnName());
        for (int i = 0; i < this.getRowCount(); ++i) {
            List<Object> rowData = this.getRow(i);
            VolumeTreeNode volumeObj = (VolumeTreeNode)rowData.get(col);
            if (!volumeObj.getStub().equals(volume.getStub())) continue;
            BigInteger accessibleSpace = volume.getAccessibleSpace();
            BigInteger allocatedSpace = volume.getAllocatedSpace();
            AliasObject accSpace = new AliasObject(StorageSize.getSizeAsString(accessibleSpace), accessibleSpace);
            AliasObject allocSpace = new AliasObject(StorageSize.getSizeAsString(allocatedSpace), allocatedSpace);
            this.setValueAt(accSpace, i, accCol);
            this.setValueAt(allocSpace, i, allocCol);
        }
    }

    private TargetNode getModelTargetNode() {
        return this.mySelectedTargetNode == null ? null : (TargetNode)this.mySelectedTargetNode.get();
    }

    private void setDRVolumeRole(DRPairNode pair, VolumeTreeNode volume) {
        int volumeCol = this.getColumnIndex(TargetTableHeader.VOLUME_NAME.getColumnName());
        int drRoleCol = this.getColumnIndex(TargetTableHeader.DR_VOLUME_ROLE.getColumnName());
        int row = this.getRowCount();
        while (row-- > 0) {
            List<Object> rowData = this.getRow(row);
            if (!Util.equalsWithNull(volume, rowData.get(volumeCol))) continue;
            this.setValueAt(pair.getVolumeDRRole(volume), row, drRoleCol);
            return;
        }
    }

    private void clearDRVolumeRole(VolumeTreeNode volume) {
        int volumeCol = this.getColumnIndex(TargetTableHeader.VOLUME_NAME.getColumnName());
        int drRoleCol = this.getColumnIndex(TargetTableHeader.DR_VOLUME_ROLE.getColumnName());
        int row = this.getRowCount();
        while (row-- > 0) {
            List<Object> rowData = this.getRow(row);
            if (!Util.equalsWithNull(volume, rowData.get(volumeCol))) continue;
            this.setValueAt(null, row, drRoleCol);
            return;
        }
    }

    @Override
    public void asyncPairChanged(DRAsyncPairEvent e) {
        DRASyncPairNode pair = e.getPair();
        if (pair.getPairPrimaryVolume() != null) {
            this.setDRVolumeRole(pair, pair.getPairPrimaryVolume());
        }
        if (pair.getPairSecondaryVolume() != null) {
            this.setDRVolumeRole(pair, pair.getPairSecondaryVolume());
        }
    }

    @Override
    public void asyncPairCreated(DRAsyncPairEvent e) {
        DRASyncPairNode pair = e.getPair();
        if (pair.getPairPrimaryVolume() != null) {
            this.setDRVolumeRole(pair, pair.getPairPrimaryVolume());
        }
        if (pair.getPairSecondaryVolume() != null) {
            this.setDRVolumeRole(pair, pair.getPairSecondaryVolume());
        }
    }

    @Override
    public void asyncPairRemoved(DRAsyncPairEvent e) {
        DRASyncPairNode pair = e.getPair();
        if (pair.getPairPrimaryVolume() != null) {
            this.clearDRVolumeRole(pair.getPairPrimaryVolume());
        }
        if (pair.getPairSecondaryVolume() != null) {
            this.clearDRVolumeRole(pair.getPairSecondaryVolume());
        }
    }

    @Override
    public void syncPairChanged(DRSyncPairEvent e) {
        DRSyncPairNode pair = e.getPair();
        if (pair.getPairPrimaryVolume() != null) {
            this.setDRVolumeRole(pair, pair.getPairPrimaryVolume());
        }
        if (pair.getPairSecondaryVolume() != null) {
            this.setDRVolumeRole(pair, pair.getPairSecondaryVolume());
        }
    }

    @Override
    public void syncPairCreated(DRSyncPairEvent e) {
        DRSyncPairNode pair = e.getPair();
        if (pair.getPairPrimaryVolume() != null) {
            this.setDRVolumeRole(pair, pair.getPairPrimaryVolume());
        }
        if (pair.getPairSecondaryVolume() != null) {
            this.setDRVolumeRole(pair, pair.getPairSecondaryVolume());
        }
    }

    @Override
    public void syncPairRemoved(DRSyncPairEvent e) {
        DRSyncPairNode pair = e.getPair();
        if (pair.getPairPrimaryVolume() != null) {
            this.clearDRVolumeRole(pair.getPairPrimaryVolume());
        }
        if (pair.getPairSecondaryVolume() != null) {
            this.clearDRVolumeRole(pair.getPairSecondaryVolume());
        }
    }
}

