/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.target;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.scsi.SrDeviceNode;
import com.sanrad.nms.client.data.target.SCSITargetPortNode;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.event.statistics.StatisticsEvent;
import com.sanrad.nms.client.event.target.SCSITargetsPortsStatisticsListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.iscsi.ISCSIDevice;
import com.sanrad.nms.server.logic.target.SCSITargetPort;
import com.sanrad.util.SrEventListenerManager;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.HashMap;

public class SCSITargetsPortsManager
extends ElementManager {
    private static SCSITargetsPortsManager m_instance = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer statisticsElementChangedInformer = new SrEventListenerManager.Informer<SCSITargetsPortsStatisticsListener, StatisticsEvent>(){

        @Override
        public void inform(SCSITargetsPortsStatisticsListener listener, StatisticsEvent event) {
            listener.statisticsElementChanged(event);
        }
    };

    private SCSITargetsPortsManager() {
    }

    public static synchronized SCSITargetsPortsManager getInstance() {
        if (m_instance == null) {
            m_instance = new SCSITargetsPortsManager();
        }
        return m_instance;
    }

    public void addSCSITargetsPortsStatisticsListener(SCSITargetsPortsStatisticsListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeSCSITargetsPortsStatisticsListener(SCSITargetsPortsStatisticsListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    public SCSITargetPortNode createTargetPortNode(SCSITargetPort targetPort) {
        return this.discoverPort(targetPort);
    }

    protected SCSITargetPortNode discoverPort(SCSITargetPort targetPort) {
        SCSITargetPortNode portNode = (SCSITargetPortNode)SystemRootNode.getInstance().getRefByStub(targetPort);
        if (portNode == null) {
            try {
                portNode = new SCSITargetPortNode(targetPort, targetPort.getParentVSwitch(), (ISCSIDevice)targetPort.getTarget());
                portNode.setName(targetPort.getName());
                portNode.setInCommands(targetPort.getInCommands());
                portNode.setReadMBs(targetPort.getReadMB());
                portNode.setWrittenMBs(targetPort.getWrittenMB());
                SystemRootNode.getInstance().putRefAndStub(targetPort, portNode);
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
                SCSITargetsPortsManager.onConnectionError("Failed to discover target port.");
            }
        }
        return portNode;
    }

    protected SCSITargetPortNode initializePortNode(SCSITargetPort targetPort, HashMap values) {
        try {
            SrDeviceNode node;
            Object nameObj = this.getObjectForParam(values, ClientParameterCode.SCSI_TARGET_PORT_NAME, true);
            Object inCommandsObj = this.getObjectForParam(values, ClientParameterCode.SCSI_TARGET_PORT_IN_COMMANDS, true);
            Object readMBsObj = this.getObjectForParam(values, ClientParameterCode.SCSI_TARGET_PORT_READ_MB, true);
            Object writtenMBsObj = this.getObjectForParam(values, ClientParameterCode.SCSI_TARGET_PORT_WRITTEN_MB, true);
            if (nameObj == null) {
                nameObj = targetPort.getName();
            }
            if (inCommandsObj == null) {
                inCommandsObj = targetPort.getInCommands();
            }
            if (readMBsObj == null) {
                readMBsObj = targetPort.getReadMB();
            }
            if (writtenMBsObj == null) {
                writtenMBsObj = targetPort.getWrittenMB();
            }
            if ((node = (SrDeviceNode)SystemRootNode.getInstance().getRefByStub(targetPort.getTarget())) == null) {
                return null;
            }
            SCSITargetPortNode targetPortNode = new SCSITargetPortNode(targetPort, targetPort.getParentVSwitch(), (ISCSIDevice)targetPort.getTarget());
            targetPortNode.setName((String)nameObj);
            targetPortNode.setInCommands((BigInteger)inCommandsObj);
            targetPortNode.setReadMBs((BigInteger)readMBsObj);
            targetPortNode.setWrittenMBs((BigInteger)writtenMBsObj);
            SystemRootNode.getInstance().putRefAndStub(targetPort, targetPortNode);
            return targetPortNode;
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, "ISCSISessionsManager: failed to create an SCSI target node.");
            SCSITargetsPortsManager.onConnectionError();
            return null;
        }
    }

    private void fireTargetPortStatisticsChanged(SCSITargetPortNode targetPortStatistics) {
        StatisticsEvent event = new StatisticsEvent(this, targetPortStatistics);
        this.m_listeners.fireEvent(SCSITargetsPortsStatisticsListener.class, event, this.statisticsElementChangedInformer);
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        SCSITargetPortNode targetPortStatistics;
        RemoteObject element = e.getElement();
        HashMap map = e.getParameterList();
        SrTreeNode obj = SystemRootNode.getInstance().getRefByStub(element);
        if (obj != null && (targetPortStatistics = (SCSITargetPortNode)obj) != null) {
            targetPortStatistics.setChangedValues(map);
            this.fireTargetPortStatisticsChanged(targetPortStatistics);
        }
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        if (this.alreadyExist(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "TargetManager: target port created");
        SCSITargetPort port = (SCSITargetPort)element;
        HashMap params = this.getParameterList(e);
        SCSITargetPortNode portNode = this.initializePortNode(port, params);
        if (portNode != null) {
            TargetNode targetNode = (TargetNode)portNode.getDeviceNode();
            targetNode.addSCSIPort(portNode);
        }
    }
}

