/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.storage.traps;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.storage.traps.StorageNotificationNode;
import com.sanrad.nms.client.event.storage.notification.StorageNotificationEvent;
import com.sanrad.nms.client.event.storage.notification.StorageNotificationListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.SystemRoot;
import com.sanrad.nms.server.logic.storage.SrStorageNotification;
import com.sanrad.nms.server.logic.storage.SrStorageNotificationMgr;
import com.sanrad.nms.server.util.CommKeyClassId;
import java.net.Inet4Address;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StorageNotificationManager
extends ElementManager {
    private static SrLogger theLogger = SrLogger.getLogger();
    private HashMap<CommKeyClassId, ArrayList<StorageNotificationNode>> myAllStorageNotificationNodes = new HashMap();
    private static StorageNotificationManager theInstance = new StorageNotificationManager();
    private ArrayList<StorageNotificationListener> myListeners = new ArrayList();
    private static boolean theIsInitializationExceptionOccured = false;
    private static boolean theInitializationStatusSet = false;

    private StorageNotificationManager() {
    }

    public static StorageNotificationManager getInstance() {
        return theInstance;
    }

    public void addStorageNotificationListener(StorageNotificationListener aListener) {
        if (!this.myListeners.contains(aListener)) {
            this.myListeners.add(aListener);
        }
    }

    public void removeStorageNotificationListener(StorageNotificationListener aListener) {
        this.myListeners.remove(aListener);
    }

    private void handleNodeAdded(CommKeyClassId aVswitchId, StorageNotificationNode aNode) {
        ArrayList<StorageNotificationNode> nodeList = this.myAllStorageNotificationNodes.get(aVswitchId);
        if (nodeList == null) {
            nodeList = new ArrayList();
            this.myAllStorageNotificationNodes.put(aVswitchId, nodeList);
        }
        nodeList.add(aNode);
        this.fireStorageNotificationCreated(aNode);
    }

    private void handleNodeRemoved(CommKeyClassId aVswitchId, StorageNotificationNode aNode) {
        ArrayList<StorageNotificationNode> nodeList = this.myAllStorageNotificationNodes.get(aVswitchId);
        if (nodeList != null) {
            if (nodeList.remove(aNode)) {
                this.fireStorageNotificationRemoved(aNode);
            }
            if (nodeList.isEmpty()) {
                this.myAllStorageNotificationNodes.remove(aVswitchId);
            }
        }
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    public List<StorageNotificationNode> refreshAllStorageNotifications() {
        SystemRoot root = (SystemRoot)SystemRootNode.getInstance().getStub();
        theLogger.info(SrLogCategories.INFORMATIVE, "Refresh all storage notifications - clearing all");
        for (CommKeyClassId vsKey : this.myAllStorageNotificationNodes.keySet()) {
            ArrayList<StorageNotificationNode> nodeList = this.myAllStorageNotificationNodes.get(vsKey);
            theLogger.logAndAssert(SrLogCategories.BUG, nodeList != null, new Object[]{"Refresh all storage notifications - encountered null notifications list in client on V-Switch ", vsKey});
            for (StorageNotificationNode node : nodeList) {
                this.handleNodeRemoved(vsKey, node);
            }
        }
        try {
            SrStorageNotificationMgr mgr = root.getStorageNotificationManager();
            Map<CommKeyClassId, ? extends List<? extends SrStorageNotification>> allServerNotifications = mgr.getAllNotifications();
            for (CommKeyClassId vsKey : allServerNotifications.keySet()) {
                List<? extends SrStorageNotification> list = allServerNotifications.get(vsKey);
                theLogger.logAndAssert(SrLogCategories.BUG, list != null, new Object[]{"Refresh all storage notifications - encountered null notifications list from server on V-Switch ", vsKey});
                for (SrStorageNotification srStorageNotification : list) {
                    StorageNotificationNode node;
                    HashMap clientParams = srStorageNotification.getClientParameterList();
                    if (clientParams == null || (node = this.createStorageNotificationNode(srStorageNotification, clientParams)) == null) continue;
                    this.handleNodeAdded(vsKey, node);
                }
            }
        }
        catch (RemoteException exp) {
            theLogger.error(SrLogCategories.CLIENT_SERVER_INTERFACE, exp, new Object[0]);
            StorageNotificationManager.onConnectionError();
        }
        catch (IllegalValueException exp) {
            theLogger.error(SrLogCategories.CLIENT_SERVER_INTERFACE, exp, new Object[0]);
        }
        ArrayList<StorageNotificationNode> retValue = new ArrayList<StorageNotificationNode>();
        for (ArrayList<StorageNotificationNode> nodeList : this.myAllStorageNotificationNodes.values()) {
            retValue.addAll(nodeList);
        }
        return retValue;
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        HashMap params;
        SrStorageNotification notificationStub = (SrStorageNotification)e.getElement();
        StorageNotificationNode node = this.createStorageNotificationNode(notificationStub, params = e.getParameterList());
        if (node != null) {
            CommKeyClassId vswitchId = (CommKeyClassId)params.get(ClientParameterCode.RAID_TRAP_VSWITCH_ID);
            this.handleNodeAdded(vswitchId, node);
        }
    }

    private StorageNotificationNode createStorageNotificationNode(SrStorageNotification notificationStub, HashMap params) {
        Inet4Address deviceHostIpAddr = (Inet4Address)params.get(ClientParameterCode.RAID_TRAP_DEVICE_HOST_IP);
        if (deviceHostIpAddr == null) {
            theLogger.error(SrLogCategories.RAID, new IllegalStateException("VSW-8389 - the exception was not thrown"), "The Storage Trap stub = ", notificationStub, " Received is empty or doesn't contain deviceHostIpAddr.");
            return null;
        }
        String deviceHostIp = deviceHostIpAddr.getHostAddress();
        String deviceHostName = (String)params.get(ClientParameterCode.RAID_TRAP_DEVICE_HOST_NAME);
        String deviceUserLabel = (String)params.get(ClientParameterCode.RAID_TRAP_DEVICE_USER_LABEL);
        String deviceErrorCode = (String)params.get(ClientParameterCode.RAID_TRAP_DEVICE_ERROR_CODE);
        String eventTime = (String)params.get(ClientParameterCode.RAID_TRAP_EVENT_TIME);
        String description = (String)params.get(ClientParameterCode.RAID_TRAP_DESCRIPTION);
        String componentType = (String)params.get(ClientParameterCode.RAID_TRAP_COMPONENT_TYPE);
        String componentLocation = (String)params.get(ClientParameterCode.RAID_TRAP_COMPONENT_LOCATION);
        CommKeyClassId vswitchId = (CommKeyClassId)params.get(ClientParameterCode.RAID_TRAP_VSWITCH_ID);
        try {
            StorageNotificationNode node = new StorageNotificationNode(notificationStub, deviceHostIp, deviceHostName, deviceUserLabel, deviceErrorCode, eventTime, description, componentType, componentLocation, vswitchId);
            return node;
        }
        catch (RemoteException exp) {
            theLogger.error(SrLogCategories.CLIENT_SERVER_INTERFACE, exp, new Object[0]);
            StorageNotificationManager.onConnectionError();
            return null;
        }
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        super.elementRemove(e);
    }

    private void fireStorageNotificationCreated(StorageNotificationNode node) {
        StorageNotificationEvent event = new StorageNotificationEvent((Object)this, (RemoteObject)node.getStub(), node);
        ArrayList<StorageNotificationListener> listeners = new ArrayList<StorageNotificationListener>(this.myListeners);
        for (StorageNotificationListener listener : listeners) {
            listener.storageNotificationCreated(event);
        }
    }

    private void fireStorageNotificationRemoved(StorageNotificationNode node) {
        StorageNotificationEvent event = new StorageNotificationEvent((Object)this, (RemoteObject)node.getStub(), node);
        ArrayList<StorageNotificationListener> listeners = new ArrayList<StorageNotificationListener>(this.myListeners);
        for (StorageNotificationListener listener : listeners) {
            listener.storageNotificationRemoved(event);
        }
    }

    public boolean isRaidRegistered() {
        return this.myAllStorageNotificationNodes.size() == 0;
    }

    public static synchronized boolean isInitializationExceptionOccured() {
        if (!theInitializationStatusSet) {
            theInitializationStatusSet = true;
            SystemRoot root = (SystemRoot)SystemRootNode.getInstance().getStub();
            try {
                theIsInitializationExceptionOccured = root.getStorageNotificationManager().isInitializationExceptionOccured();
            }
            catch (RemoteException exp) {
                theIsInitializationExceptionOccured = true;
            }
        }
        return theIsInitializationExceptionOccured;
    }
}

