/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.storage.traps;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.storage.traps.SrStorageNotificationTableColumns;
import com.sanrad.nms.client.data.storage.traps.SrStorageNotificationTableHeader;
import com.sanrad.nms.client.data.storage.traps.StorageNotificationManager;
import com.sanrad.nms.client.data.storage.traps.StorageNotificationNode;
import com.sanrad.nms.client.event.storage.notification.StorageNotificationEvent;
import com.sanrad.nms.client.event.storage.notification.StorageNotificationListener;
import com.sanrad.swing.SrTableModel;
import com.sanrad.util.Util;
import java.util.List;

public class SrStorageNotificationTableModel
extends SrTableModel {
    private static final long serialVersionUID = -974642060420691595L;
    protected static SrLogger theLogger = SrLogger.getLogger();
    private StorageNotificationListener myStorageNotificationListener = new StorageNotificationListener(){

        @Override
        public void storageNotificationCreated(StorageNotificationEvent event) {
            SrStorageNotificationTableModel.this.addRow(SrStorageNotificationTableModel.this.buildTableRow((StorageNotificationNode)event.getValue()));
        }

        @Override
        public void storageNotificationRemoved(StorageNotificationEvent event) {
            int foundRow = SrStorageNotificationTableModel.this.findRow((StorageNotificationNode)event.getValue());
            if (foundRow > -1) {
                SrStorageNotificationTableModel.this.removeRow(foundRow);
            }
        }
    };

    public SrStorageNotificationTableModel() {
        super(new SrStorageNotificationTableColumns());
        this.initModel();
    }

    protected void initModel() {
        List<StorageNotificationNode> nodes = StorageNotificationManager.getInstance().refreshAllStorageNotifications();
        for (StorageNotificationNode node : nodes) {
            this.addRow(this.buildTableRow(node));
        }
    }

    private Object[] buildTableRow(StorageNotificationNode aNode) {
        Object[] row = new Object[SrStorageNotificationTableHeader.getColumnNames().size()];
        row[this.getColumnIndex((String)SrStorageNotificationTableHeader.EVENT_TIME.toString())] = aNode.getEventTime();
        row[this.getColumnIndex((String)SrStorageNotificationTableHeader.DEVICE_HOST_NAME.toString())] = aNode.getDeviceHostName();
        row[this.getColumnIndex((String)SrStorageNotificationTableHeader.DEVICE_HOST_IP.toString())] = aNode.getDeviceHostIp();
        row[this.getColumnIndex((String)SrStorageNotificationTableHeader.DESCRIPTION.toString())] = aNode.getDescription();
        row[this.getColumnIndex((String)SrStorageNotificationTableHeader.DEVICE_ERROR_CODE.toString())] = aNode.getDeviceErrorCode();
        row[this.getColumnIndex((String)SrStorageNotificationTableHeader.DEVICE_USER_LABEL.toString())] = aNode.getDeviceUserLabel();
        row[this.getColumnIndex((String)SrStorageNotificationTableHeader.COMPONENT_TYPE.toString())] = aNode.getComponentType();
        row[this.getColumnIndex((String)SrStorageNotificationTableHeader.COMPONENT_LOCATION.toString())] = aNode.getComponentLocation();
        return row;
    }

    private int findRow(StorageNotificationNode aNode) {
        int hostIpCol = this.getColumnIndex(SrStorageNotificationTableHeader.DEVICE_HOST_IP.toString());
        int hostNameCol = this.getColumnIndex(SrStorageNotificationTableHeader.DEVICE_HOST_NAME.toString());
        int userLabelCol = this.getColumnIndex(SrStorageNotificationTableHeader.DEVICE_USER_LABEL.toString());
        int errCodeCol = this.getColumnIndex(SrStorageNotificationTableHeader.DEVICE_ERROR_CODE.toString());
        int eventTimeCol = this.getColumnIndex(SrStorageNotificationTableHeader.EVENT_TIME.toString());
        int descCol = this.getColumnIndex(SrStorageNotificationTableHeader.DESCRIPTION.toString());
        int compTypeCol = this.getColumnIndex(SrStorageNotificationTableHeader.COMPONENT_TYPE.toString());
        int compLocCol = this.getColumnIndex(SrStorageNotificationTableHeader.COMPONENT_LOCATION.toString());
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!Util.equalsWithNull(this.getValueAt(i, hostIpCol), aNode.getDeviceHostIp()) || !Util.equalsWithNull(this.getValueAt(i, hostNameCol), aNode.getDeviceHostName()) || !Util.equalsWithNull(this.getValueAt(i, userLabelCol), aNode.getDeviceUserLabel()) || !Util.equalsWithNull(this.getValueAt(i, errCodeCol), aNode.getDeviceErrorCode()) || !Util.equalsWithNull(this.getValueAt(i, eventTimeCol), aNode.getEventTime()) || !Util.equalsWithNull(this.getValueAt(i, descCol), aNode.getDescription()) || !Util.equalsWithNull(this.getValueAt(i, compTypeCol), aNode.getComponentType()) || !Util.equalsWithNull(this.getValueAt(i, compLocCol), aNode.getComponentLocation())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void removeListeners() {
        StorageNotificationManager.getInstance().removeStorageNotificationListener(this.myStorageNotificationListener);
    }

    @Override
    public void addListeners() {
        StorageNotificationManager.getInstance().addStorageNotificationListener(this.myStorageNotificationListener);
    }
}

