/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.storage.dialogs;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceManager;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.event.SubDirectAccessDeviceEvent;
import com.sanrad.nms.client.event.SubDirectAccessDeviceListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDevice;
import java.util.List;
import javax.swing.DefaultListModel;

public class SubDirectAccessDevicesListModel
extends DefaultListModel
implements SubDirectAccessDeviceListener {
    private static SrLogger theLogger = SrLogger.getLogger();
    private DirectAccessDeviceNode m_disk;

    public SubDirectAccessDevicesListModel(List list, DirectAccessDeviceNode disk) {
        this.m_disk = disk;
        this.init(list);
        SubDirectAccessDeviceManager.getInstance().addSubDirectDeviceListener(this);
    }

    public void removeListeners() {
        SubDirectAccessDeviceManager.getInstance().removeSubDirectDeviceListener(this);
    }

    protected void finalize() throws Throwable {
        this.removeListeners();
        super.finalize();
    }

    public DirectAccessDeviceNode getParentDirectAccessDeviceNode() {
        return this.m_disk;
    }

    private void init(List list) {
        for (int i = 0; i < list.size(); ++i) {
            this.addElement(list.get(i));
        }
    }

    @Override
    public void subDirecetAccessDeviceCreated(SubDirectAccessDeviceEvent event) {
        DirectAccessDevice parentStub = event.getParentStub();
        boolean sameDisk = this.verifySameDisk(parentStub);
        if (sameDisk) {
            RemoteObject stub = event.getStub();
            SrTreeNode obj = SystemRootNode.getInstance().getRefByStub(stub);
            if (obj != null) {
                this.addElement(obj);
            }
            this.fireContentsChanged(this, 0, 0);
        }
    }

    @Override
    public void subDirecetAccessDeviceRemoved(SubDirectAccessDeviceEvent event) {
        theLogger.trace(SrLogCategories.LEGACY, "SubDirectAccessDevicesListModel:: subDirecetAccessDeviceRemoved()");
        DirectAccessDevice parentStub = event.getParentStub();
        boolean sameDisk = this.verifySameDisk(parentStub);
        if (sameDisk) {
            RemoteObject stub = event.getStub();
            SrTreeNode obj = SystemRootNode.getInstance().getRefByStub(stub);
            if (obj != null) {
                theLogger.trace(SrLogCategories.LEGACY, " SubDirectAccessDevicesListModel:: removing - ", obj);
                this.removeElement(obj);
            }
            this.fireContentsChanged(this, 0, 0);
        }
    }

    @Override
    public void subDirecetAccessDeviceAliasChanged(SubDirectAccessDeviceEvent event) {
        DirectAccessDevice parentStub = event.getParentStub();
        boolean sameDisk = this.verifySameDisk(parentStub);
        if (sameDisk) {
            this.fireContentsChanged(this, 0, 0);
        }
    }

    @Override
    public void subDirecetAccessDeviceStatusChanged(SubDirectAccessDeviceEvent event) {
        DirectAccessDevice parentStub = event.getParentStub();
        boolean sameDisk = this.verifySameDisk(parentStub);
        if (sameDisk) {
            this.fireContentsChanged(this, 0, 0);
        }
    }

    @Override
    public void subDirecetAccessDeviceInfoChanged(SubDirectAccessDeviceEvent event) {
        DirectAccessDevice parentStub = event.getParentStub();
        boolean sameDisk = this.verifySameDisk(parentStub);
        if (sameDisk) {
            this.fireContentsChanged(this, 0, 0);
        }
    }

    @Override
    public void subDirectAccessDeviceExposed(SubDirectAccessDeviceEvent event) {
        DirectAccessDevice parentStub = event.getParentStub();
        boolean sameDisk = this.verifySameDisk(parentStub);
        if (sameDisk) {
            this.fireContentsChanged(this, 0, 0);
        }
    }

    @Override
    public void subDirectAccessDeviceDeExposed(SubDirectAccessDeviceEvent event) {
        DirectAccessDevice parentStub = event.getParentStub();
        boolean sameDisk = this.verifySameDisk(parentStub);
        if (sameDisk) {
            this.fireContentsChanged(this, 0, 0);
        }
    }

    private boolean verifySameDisk(Object parentStub) {
        return this.m_disk.getStub().equals(parentStub);
    }

    public boolean isFree(Object obj) {
        SubDirectAccessDeviceNode node = (SubDirectAccessDeviceNode)obj;
        if (node.isExposed()) {
            return false;
        }
        return !(node.getParent() instanceof VolumeTreeNode);
    }
}

