/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.storage;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDevice;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageDriveTypeConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageOperStatusConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageRaidLevelConstant;
import com.sanrad.nms.server.util.types.constants.SubDirectAccessDeviceOperStatusConstant;
import com.sanrad.util.StorageSize;
import java.math.BigInteger;
import java.rmi.RemoteException;

public class SubDirectAccessDeviceNode
extends DirectAccessDeviceNode<SubDirectAccessDevice> {
    private static final String SUB_DIRECT_ACCESS_DEVICE_TYPE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.SUB_DIRECT_ACCESS_DEVICE_NODE_TYPE);
    private DirectAccessDeviceNode parentDirectAccessDevice;
    private BigInteger startAddress;
    private BigInteger endAddress;
    private String info;
    private SubDirectAccessDeviceOperStatusConstant m_operStatus;

    public SubDirectAccessDeviceNode(SubDirectAccessDevice stub, String alias, boolean isExposed) throws RemoteException {
        super(stub, alias, isExposed, "");
        this.setStorageType(STORAGE_TYPE_SUB_DISK);
        this.setNodeIcon(ClientImageObject.SUB_DISK);
    }

    public void setDirectAccessDeviceParent(Object parent) {
        this.parentDirectAccessDevice = (DirectAccessDeviceNode)parent;
    }

    public DirectAccessDeviceNode getDirectAccessDeviceParent() {
        return this.parentDirectAccessDevice;
    }

    public void setStartAddress(BigInteger startAddress) {
        this.startAddress = startAddress;
    }

    public BigInteger getStartAddress() {
        return this.startAddress;
    }

    public void setEndAddress(BigInteger endAddress) {
        this.endAddress = endAddress;
    }

    public BigInteger getEndAddress() {
        return this.endAddress;
    }

    @Override
    public void setInfo(String info) {
        this.info = info;
    }

    @Override
    public String getInfo() {
        return this.info;
    }

    @Override
    public String type() {
        return SUB_DIRECT_ACCESS_DEVICE_TYPE;
    }

    public SubDirectAccessDeviceOperStatusConstant getSubdiskOperStatus() {
        return this.m_operStatus;
    }

    public void setSubdiskOperStatus(SubDirectAccessDeviceOperStatusConstant operStatus) {
        this.m_operStatus = operStatus;
    }

    @Override
    public boolean isConfigured() {
        return SubDirectAccessDeviceOperStatusConstant.NON_VALIDATE.equals(this.m_operStatus);
    }

    @Override
    public SrLicenseTreePath getLicensePath() {
        return SrLicenseTreePath.SUBDISK_PATH;
    }

    @Override
    public PhysicalStorageOperStatusConstant getStorageOperStatus() {
        return this.parentDirectAccessDevice.getStorageOperStatus();
    }

    @Override
    public String toString() {
        return this.getAlias() + " [" + StorageSize.getSizeAsString(this.getTotalSpace()) + "]";
    }

    @Override
    public PhysicalStorageDriveTypeConstant getDriveType() {
        return this.getDirectAccessDeviceParent().getDriveType();
    }

    @Override
    public PhysicalStorageRaidLevelConstant getRaidLevel() {
        return this.getDirectAccessDeviceParent().getRaidLevel();
    }
}

