/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.storage;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceNode;
import com.sanrad.nms.client.event.SubDirectAccessDeviceEvent;
import com.sanrad.nms.client.event.SubDirectAccessDeviceListener;
import com.sanrad.nms.client.event.alarm.PropagatedStateEvent;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDevice;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.nms.server.util.types.constants.SubDirectAccessDeviceOperStatusConstant;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.concurrent.SrFuture;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;

public class SubDirectAccessDeviceManager
extends ElementManager {
    private static SubDirectAccessDeviceManager instance;
    private static SrLogger theLogger;
    SrEventListenerManager.Informer subDirecetAccessDeviceCreatedInformer = new SrEventListenerManager.Informer<SubDirectAccessDeviceListener, SubDirectAccessDeviceEvent>(){

        @Override
        public void inform(SubDirectAccessDeviceListener listener, SubDirectAccessDeviceEvent event) {
            listener.subDirecetAccessDeviceCreated(event);
        }
    };
    SrEventListenerManager.Informer subDirecetAccessDeviceStatusChangedInformer = new SrEventListenerManager.Informer<SubDirectAccessDeviceListener, SubDirectAccessDeviceEvent>(){

        @Override
        public void inform(SubDirectAccessDeviceListener listener, SubDirectAccessDeviceEvent event) {
            listener.subDirecetAccessDeviceStatusChanged(event);
        }
    };
    SrEventListenerManager.Informer subDirecetAccessDeviceRemovedInformer = new SrEventListenerManager.Informer<SubDirectAccessDeviceListener, SubDirectAccessDeviceEvent>(){

        @Override
        public void inform(SubDirectAccessDeviceListener listener, SubDirectAccessDeviceEvent event) {
            listener.subDirecetAccessDeviceRemoved(event);
        }
    };
    SrEventListenerManager.Informer subDirecetAccessDeviceAliasChangedInformer = new SrEventListenerManager.Informer<SubDirectAccessDeviceListener, SubDirectAccessDeviceEvent>(){

        @Override
        public void inform(SubDirectAccessDeviceListener listener, SubDirectAccessDeviceEvent event) {
            listener.subDirecetAccessDeviceAliasChanged(event);
        }
    };
    SrEventListenerManager.Informer subDirecetAccessDeviceInfoChangedInformer = new SrEventListenerManager.Informer<SubDirectAccessDeviceListener, SubDirectAccessDeviceEvent>(){

        @Override
        public void inform(SubDirectAccessDeviceListener listener, SubDirectAccessDeviceEvent event) {
            listener.subDirecetAccessDeviceInfoChanged(event);
        }
    };
    SrEventListenerManager.Informer subDirectAccessDeviceExposedInformer = new SrEventListenerManager.Informer<SubDirectAccessDeviceListener, SubDirectAccessDeviceEvent>(){

        @Override
        public void inform(SubDirectAccessDeviceListener listener, SubDirectAccessDeviceEvent event) {
            listener.subDirectAccessDeviceExposed(event);
        }
    };
    SrEventListenerManager.Informer subDirectAccessDeviceDeExposedInformer = new SrEventListenerManager.Informer<SubDirectAccessDeviceListener, SubDirectAccessDeviceEvent>(){

        @Override
        public void inform(SubDirectAccessDeviceListener listener, SubDirectAccessDeviceEvent event) {
            listener.subDirectAccessDeviceDeExposed(event);
        }
    };
    SrEventListenerManager.Informer subDirectAccessDeviceStatusInformer = new SrEventListenerManager.Informer<SubDirectAccessDeviceListener, SubDirectAccessDeviceEvent>(){

        @Override
        public void inform(SubDirectAccessDeviceListener listener, SubDirectAccessDeviceEvent event) {
            listener.subDirecetAccessDeviceStatusChanged(event);
        }
    };

    private SubDirectAccessDeviceManager() {
    }

    public static synchronized SubDirectAccessDeviceManager getInstance() {
        if (instance == null) {
            instance = new SubDirectAccessDeviceManager();
        }
        return instance;
    }

    public void addSubDirectDeviceListener(SubDirectAccessDeviceListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeSubDirectDeviceListener(SubDirectAccessDeviceListener listener) {
        this.m_listeners.remove(listener);
    }

    public SrFuture<Void> createSubDirectAccessDevice(DirectAccessDeviceNode<?> disk, String alias, BigInteger startAddress, BigInteger size) {
        return ClientAOImpl.getInstance().createSubDirectAccessDevice((CommKeyClassId)disk.getIdentifier(), alias, startAddress, size);
    }

    public SrFuture<Void> editSubDirectAccessDevice(SubDirectAccessDeviceNode node, HashMap params) {
        theLogger.trace(SrLogCategories.LEGACY, "SubDirectAccessDeviceManager: Trying to edit properties of Subdisk: ", node.getAlias());
        return ClientAOImpl.getInstance().changeElements(Collections.singleton(node.getIdentifier()), params);
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        if (this.alreadyExist(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "Subdisk created");
        try {
            SubDirectAccessDevice device = (SubDirectAccessDevice)e.getElement();
            HashMap params = this.getParameterList(e);
            Object aliasObj = this.getObjectForParam(params, ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_ALIAS, true);
            Object isExposedObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.VOLUME_EXPOSED", true);
            Object blockSizeObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.VOLUME_BLOCK_SIZE", true);
            Object entityNameObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_ENTITY_NAME", true);
            Object isfreeObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.VOLUME_IS_FREE", true);
            Object sizeObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_SIZE", true);
            Object startAddressObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_START_ADDRESS", true);
            Object infoObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_INFO", true);
            Object endAddressObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_END_ADDRESS", true);
            Object allocatedSpaceObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.VOLUME_ALLOCATED_SPACE", true);
            Object accessibleSpaceObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.VOLUME_ACCESSIBLE_SPACE", true);
            Object volStateObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.VOLUME_STATE", true);
            Object positionInParentObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.VOLUME_POSITION_IN_PARENT", true);
            Object connectedVSwitchCounterObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.PHYSICAL_STORAGE_DEVICE_POSITION_IN_PARENT", true);
            Object propagatedState = this.getObjectForParam(params, "Missing code - ClientParameterCode.PROPAGATED_STATE", true);
            DirectAccessDevice directAccessDeviceParent = (DirectAccessDevice)this.getObjectForParam(params, "Missing code - ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_PARENT", true);
            Object operStatusObj = this.getObjectForParam(params, ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_OPER_STATUS, true);
            if (aliasObj == null) {
                aliasObj = device.getAlias();
            }
            if (isExposedObj == null) {
                isExposedObj = new Boolean(device.isExposed());
            }
            if (blockSizeObj == null) {
                blockSizeObj = new Integer(device.getBlockSize());
            }
            if (entityNameObj == null) {
                entityNameObj = device.getEntityName();
            }
            if (isfreeObj == null) {
                isfreeObj = new Boolean(device.isFree());
            }
            if (sizeObj == null) {
                sizeObj = device.getSize();
            }
            if (startAddressObj == null) {
                startAddressObj = device.getStartAddress();
            }
            if (infoObj == null) {
                infoObj = device.getInfo();
            }
            if (endAddressObj == null) {
                endAddressObj = device.getEndAddress();
            }
            if (allocatedSpaceObj == null) {
                allocatedSpaceObj = device.getAllocatedSpace();
            }
            if (accessibleSpaceObj == null) {
                accessibleSpaceObj = device.getAccessibleSpace();
            }
            if (volStateObj == null) {
                volStateObj = device.getVolumeState();
            }
            if (positionInParentObj == null) {
                positionInParentObj = device.getPositionInParent();
            }
            if (connectedVSwitchCounterObj == null) {
                connectedVSwitchCounterObj = new Integer(device.getConnectedVSwitchCounter());
            }
            if (propagatedState == null) {
                propagatedState = device.getPropagatedState();
            }
            if (directAccessDeviceParent == null) {
                directAccessDeviceParent = device.getDirectAccessDeviceParent();
            }
            if (operStatusObj == null) {
                operStatusObj = device.getOperStatus();
            }
            SubDirectAccessDeviceNode node = new SubDirectAccessDeviceNode(device, (String)aliasObj, (boolean)((Boolean)isExposedObj));
            node.setBlockSize((Integer)blockSizeObj);
            node.setEntityName((String)entityNameObj);
            node.setFree((Boolean)isfreeObj);
            node.setTotalSpace((BigInteger)sizeObj);
            node.setStartAddress((BigInteger)startAddressObj);
            node.setInfo(device.getInfo());
            node.setEndAddress((BigInteger)endAddressObj);
            node.setAllocatedSpace((BigInteger)allocatedSpaceObj);
            node.setAccessibleSpace((BigInteger)accessibleSpaceObj);
            node.setVolStateBits((SrBITSConstant)volStateObj);
            node.setPositionInParent((Integer)positionInParentObj);
            node.setSubdiskOperStatus((SubDirectAccessDeviceOperStatusConstant)operStatusObj);
            node.setStatus(SubDirectAccessDeviceManager.getSeverity((AlarmSeverity)propagatedState));
            SrTreeNode parNode = SystemRootNode.getInstance().getRefByStub(directAccessDeviceParent);
            if (parNode != null) {
                node.setDirectAccessDeviceParent(parNode);
            }
            SystemRootNode.getInstance().putRefAndStub(device, node);
            SubDirectAccessDeviceEvent event = this.createEvent(node, device);
            this.updateSplits(device);
            theLogger.trace(SrLogCategories.LEGACY, "Subdisk created: alias - " + node.getAlias());
            this.m_listeners.fireEvent(SubDirectAccessDeviceListener.class, event, this.subDirecetAccessDeviceCreatedInformer);
        }
        catch (RemoteException ex) {
            theLogger.error(SrLogCategories.LEGACY, ex, new Object[0]);
        }
    }

    @Override
    public void alreadyKnownByVSwitch(CommunicationEvent e) {
    }

    @Override
    public void propagatedStateChanged(PropagatedStateEvent e) {
        RemoteObject element = e.getStub();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        if (element instanceof SubDirectAccessDevice) {
            if (SystemRootNode.getInstance().getRefByStub(element) == null) {
                theLogger.trace(SrLogCategories.LEGACY, "SubDirectAccessDeviceManager- propagatedStateChanged() on an unknown element !");
                return;
            }
            theLogger.trace(SrLogCategories.LEGACY, "SubDirectAccessDeviceManager: propagatedStateChanged().");
            super.propagatedStateChanged(e);
            SrTreeNode node = SystemRootNode.getInstance().getRefByStub(element);
            if (node != null) {
                SubDirectAccessDeviceNode device = (SubDirectAccessDeviceNode)node;
                SubDirectAccessDeviceEvent event = this.createEvent(device, (SubDirectAccessDevice)element);
                this.fireStatusChanged(event);
            }
        }
    }

    private void fireStatusChanged(SubDirectAccessDeviceEvent event) {
        theLogger.trace(SrLogCategories.LEGACY, "SubDirectAccessDeviceManager: fireStatusChanged: ", event.getAlias());
        this.m_listeners.fireEvent(SubDirectAccessDeviceListener.class, event, this.subDirecetAccessDeviceStatusChangedInformer);
    }

    private void updateSplits(SubDirectAccessDevice device) {
        try {
            DirectAccessDevice parent = device.getDirectAccessDeviceParent();
            SrTreeNode par = SystemRootNode.getInstance().getRefByStub(parent);
            if (par != null) {
                DirectAccessDeviceNode parentNode = (DirectAccessDeviceNode)par;
                parentNode.setSplits(parent.getStorageSpaceStatus());
                DirectAccessDevice disk = (DirectAccessDevice)parentNode.getStub();
                parentNode.setAccessibleSpace(disk.getAccessibleSpace());
                parentNode.setAllocatedSpace(disk.getAllocatedSpace());
                parentNode.setNonAllocatedSpace(disk.getNonAllocatedSpace());
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            SubDirectAccessDeviceManager.onConnectionError("Failed to update sub-disk parameters.");
        }
    }

    private SubDirectAccessDeviceEvent createEvent(SubDirectAccessDeviceNode node, SubDirectAccessDevice stub) {
        SubDirectAccessDeviceEvent event = new SubDirectAccessDeviceEvent((Object)this, node, stub);
        event.setExposed(node.isExposed());
        event.setAlias(node.getAlias());
        event.setBlockSize(node.getBlockSize());
        event.setSize(node.getTotalSpace());
        event.setParentStub((DirectAccessDevice)node.getDirectAccessDeviceParent().getStub());
        event.setStartAddress(node.getStartAddress());
        event.setEndAddress(node.getEndAddress());
        event.setInfo(node.getInfo());
        return event;
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "SubDirectAccessDeviceManager:: elementRemove()");
        try {
            SubDirectAccessDevice device = (SubDirectAccessDevice)element;
            SrTreeNode obj = SystemRootNode.getInstance().getRefByStub(device);
            if (obj != null) {
                SubDirectAccessDeviceEvent event = this.createEvent((SubDirectAccessDeviceNode)obj, device);
                this.updateSplits(device);
                this.m_listeners.fireEvent(SubDirectAccessDeviceListener.class, event, this.subDirecetAccessDeviceRemovedInformer);
            }
        }
        catch (Exception ex) {
            theLogger.error(SrLogCategories.LEGACY, ex, new Object[0]);
        }
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        HashMap params = this.getParameterList(e);
        SubDirectAccessDeviceNode subDiskNode = (SubDirectAccessDeviceNode)SystemRootNode.getInstance().getRefByStub(element);
        Object aliasChanged = this.getObjectForParam(params, ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_ALIAS, false);
        Object infoChanged = this.getObjectForParam(params, ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_INFO, false);
        Object isExposed = this.getObjectForParam(params, ClientParameterCode.VOLUME_EXPOSED, false);
        Object state = this.getObjectForParam(params, ClientParameterCode.VOLUME_STATE, false);
        Object operStatusObj = this.getObjectForParam(params, ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_OPER_STATUS, false);
        if (subDiskNode != null) {
            if (aliasChanged != null) {
                subDiskNode.setAlias(aliasChanged.toString());
                this.fireAliasChanged(subDiskNode);
            }
            if (params.containsKey(ClientParameterCode.VOLUME_POSITION)) {
                Integer volumePosition = (Integer)this.getObjectForParam(params, ClientParameterCode.VOLUME_POSITION, false);
                subDiskNode.setPositionInParent(volumePosition);
            }
            if (infoChanged != null) {
                subDiskNode.setInfo(infoChanged.toString());
                this.fireInfoChanged(subDiskNode);
                theLogger.trace(SrLogCategories.LEGACY, "INFO changed: ", infoChanged);
            }
            if (isExposed != null) {
                Boolean bool = (Boolean)isExposed;
                subDiskNode.setExposed(bool);
                subDiskNode.setFree(bool == false);
                if (bool.booleanValue()) {
                    this.fireSubDirectAccessDeviceExposed(subDiskNode);
                } else {
                    this.fireSubDirectAccessDeviceDeExposed(subDiskNode);
                }
            }
            boolean isStatusChanged = false;
            if (state != null) {
                subDiskNode.setVolStateBits((SrBITSConstant)state);
                isStatusChanged = true;
                theLogger.trace(SrLogCategories.LEGACY, "Subdisk: ", subDiskNode.getAlias(), " State Changed: ", subDiskNode.getVolStateStr());
            } else if (params.containsKey(ClientParameterCode.VOLUME_STATE)) {
                subDiskNode.setVolStateBits(null);
                isStatusChanged = true;
                theLogger.trace(SrLogCategories.LEGACY, "Subdisk: ", subDiskNode.getAlias(), " State Changed: null");
            }
            if (operStatusObj != null) {
                subDiskNode.setSubdiskOperStatus((SubDirectAccessDeviceOperStatusConstant)operStatusObj);
                isStatusChanged = true;
            }
            if (isStatusChanged) {
                this.fireSubDirectAccessDeviceStatusChanged(subDiskNode);
            }
        }
    }

    private void fireAliasChanged(SubDirectAccessDeviceNode device) {
        try {
            SubDirectAccessDeviceEvent event = this.createEvent(device, (SubDirectAccessDevice)device.getStub());
            this.m_listeners.fireEvent(SubDirectAccessDeviceListener.class, event, this.subDirecetAccessDeviceAliasChangedInformer);
        }
        catch (Exception e) {
            theLogger.error(SrLogCategories.LEGACY, e, new Object[0]);
        }
    }

    private void fireInfoChanged(SubDirectAccessDeviceNode device) {
        try {
            SubDirectAccessDeviceEvent event = this.createEvent(device, (SubDirectAccessDevice)device.getStub());
            this.m_listeners.fireEvent(SubDirectAccessDeviceListener.class, event, this.subDirecetAccessDeviceInfoChangedInformer);
        }
        catch (Exception e) {
            theLogger.error(SrLogCategories.LEGACY, e, new Object[0]);
        }
    }

    private void fireSubDirectAccessDeviceExposed(SubDirectAccessDeviceNode device) {
        SubDirectAccessDeviceEvent event = this.createEvent(device, (SubDirectAccessDevice)device.getStub());
        this.m_listeners.fireEvent(SubDirectAccessDeviceListener.class, event, this.subDirectAccessDeviceExposedInformer);
    }

    public void fireSubDirectAccessDeviceStatusChanged(SubDirectAccessDeviceNode device) {
        SubDirectAccessDeviceEvent event = this.createEvent(device, (SubDirectAccessDevice)device.getStub());
        this.m_listeners.fireEvent(SubDirectAccessDeviceListener.class, event, this.subDirectAccessDeviceStatusInformer);
    }

    private void fireSubDirectAccessDeviceDeExposed(SubDirectAccessDeviceNode device) {
        SubDirectAccessDeviceEvent event = this.createEvent(device, (SubDirectAccessDevice)device.getStub());
        this.m_listeners.fireEvent(SubDirectAccessDeviceListener.class, event, this.subDirectAccessDeviceDeExposedInformer);
    }

    static {
        theLogger = SrLogger.getLogger();
    }
}

