/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.storage;

import com.sanrad.nms.client.data.LUManager;
import com.sanrad.nms.client.data.ModelCollection;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceManager;
import com.sanrad.nms.client.data.storage.SrStorageTableColumns;
import com.sanrad.nms.client.data.storage.SrStorageTableModel;
import com.sanrad.nms.client.data.storage.StorageDeviceNode;
import com.sanrad.nms.client.data.storage.StorageManager;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceManager;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.volume.copy.CopyOperManager;
import com.sanrad.nms.client.event.DirectAccessDeviceEvent;
import com.sanrad.nms.client.event.DirectAccessDeviceListener;
import com.sanrad.nms.client.event.SubDirectAccessDeviceEvent;
import com.sanrad.nms.client.event.SubDirectAccessDeviceListener;
import com.sanrad.nms.client.event.lu.LUEvent;
import com.sanrad.nms.client.event.lu.LUListener;
import com.sanrad.nms.client.event.storage.StorageManagerEvent;
import com.sanrad.nms.client.event.storage.StorageManagerListener;
import com.sanrad.nms.client.event.volume.VolumeEvent;
import com.sanrad.nms.client.event.volume.VolumeListener;
import com.sanrad.nms.client.event.volume.copy.CopyOperationEvent;
import com.sanrad.nms.client.event.volume.copy.CopyOperationListener;
import com.sanrad.util.Util;
import java.util.List;

public class StorageTableModelCollection
extends ModelCollection<SrStorageTableModel>
implements StorageManagerListener,
VolumeListener,
LUListener,
SubDirectAccessDeviceListener,
DirectAccessDeviceListener,
CopyOperationListener {
    private static StorageTableModelCollection theInstance = new StorageTableModelCollection();
    private static SrStorageTableModel theModel;

    private StorageTableModelCollection() {
        StorageManager.getInstance().addStorageManagerListener(this);
        VolumeManager.getInstance().addVolumeListener(this);
        LUManager.getInstance().addLUListener(this);
        SubDirectAccessDeviceManager.getInstance().addSubDirectDeviceListener(this);
        DirectAccessDeviceManager.getInstance().addDirectAccessDeviceListener(this);
        CopyOperManager.getInstance().addCopyOperationListener(this);
        theModel = new SrStorageTableModel(new SrStorageTableColumns());
        theModel.addListeners();
    }

    public static StorageTableModelCollection getInstance() {
        return theInstance;
    }

    @Override
    protected SrStorageTableModel creatNewModel(ClusterNode aClusterNode) {
        return theModel;
    }

    @Override
    protected void clearModel(SrStorageTableModel model) {
        theModel.removeAllRows();
    }

    @Override
    public void clearModelOf(ClusterNode clusterNode) {
        if (Util.equalsWithNull(clusterNode, theModel.getCluster())) {
            theModel.removeAllRows();
        }
    }

    @Override
    public SrStorageTableModel getModel(ClusterNode cluster) {
        return theModel;
    }

    public static SrStorageTableModel getModel() {
        return theModel;
    }

    @Override
    public void addStorageData(StorageManagerEvent event) {
        StorageDeviceNode[] data = (StorageDeviceNode[])event.getStorageData();
        if (data != null && data.length > 0) {
            theModel.addStorageData(event);
        }
    }

    public void addStorages(List<StorageDeviceNode> aStorages) {
        for (StorageDeviceNode strg : aStorages) {
            theModel.addStorageData(strg);
        }
    }

    @Override
    public void volumeCreate(VolumeEvent event) {
        theModel.volumeCreate(event);
    }

    @Override
    public void volumeExposed(VolumeEvent event) {
        theModel.volumeExposed(event);
    }

    @Override
    public void volumeStatusChanged(VolumeEvent event) {
        theModel.volumeStatusChanged(event);
    }

    @Override
    public void volumeDeExposed(VolumeEvent event) {
        theModel.volumeDeExposed(event);
    }

    @Override
    public void volumeRemove(VolumeEvent event) {
        theModel.volumeRemove(event);
    }

    @Override
    public void volumeAliasChanged(VolumeEvent event) {
        theModel.volumeAliasChanged(event);
    }

    @Override
    public void volumeConfigChanged(VolumeEvent event) {
        theModel.volumeConfigChanged(event);
    }

    @Override
    public void luRemoved(LUEvent event) {
        theModel.luRemoved(event);
    }

    @Override
    public void luStatusChanged(LUEvent event) {
        theModel.luStatusChanged(event);
    }

    @Override
    public void luCreated(LUEvent event) {
        theModel.luCreated(event);
    }

    @Override
    public void luChanged(LUEvent event) {
        theModel.luChanged(event);
    }

    @Override
    public void subDirecetAccessDeviceCreated(SubDirectAccessDeviceEvent event) {
        theModel.subDirecetAccessDeviceCreated(event);
    }

    @Override
    public void subDirecetAccessDeviceAliasChanged(SubDirectAccessDeviceEvent event) {
        theModel.subDirecetAccessDeviceAliasChanged(event);
    }

    @Override
    public void subDirectAccessDeviceExposed(SubDirectAccessDeviceEvent event) {
        theModel.subDirectAccessDeviceExposed(event);
    }

    @Override
    public void subDirectAccessDeviceDeExposed(SubDirectAccessDeviceEvent event) {
        theModel.subDirectAccessDeviceDeExposed(event);
    }

    @Override
    public void subDirecetAccessDeviceStatusChanged(SubDirectAccessDeviceEvent event) {
        theModel.subDirecetAccessDeviceStatusChanged(event);
    }

    @Override
    public void subDirecetAccessDeviceInfoChanged(SubDirectAccessDeviceEvent event) {
        theModel.subDirecetAccessDeviceInfoChanged(event);
    }

    @Override
    public void subDirecetAccessDeviceRemoved(SubDirectAccessDeviceEvent event) {
        theModel.subDirecetAccessDeviceRemoved(event);
    }

    @Override
    public void directAccessDeviceInfoChanged(DirectAccessDeviceEvent event) {
        theModel.directAccessDeviceInfoChanged(event);
    }

    @Override
    public void directAccessDeviceStatusChanged(DirectAccessDeviceEvent event) {
        theModel.directAccessDeviceStatusChanged(event);
    }

    @Override
    public void directAccessDeviceBlinkStateChange(DirectAccessDeviceEvent event) {
        theModel.directAccessDeviceBlinkStateChange(event);
    }

    @Override
    public void directAccessDeviceAliasChanged(DirectAccessDeviceEvent event) {
        theModel.directAccessDeviceAliasChanged(event);
    }

    @Override
    public void directAccessDeviceChanged(DirectAccessDeviceEvent event) {
        theModel.directAccessDeviceChanged(event);
    }

    @Override
    public void directAccessDeviceCreated(DirectAccessDeviceEvent event) {
    }

    @Override
    public void directAccessDeviceRemoved(DirectAccessDeviceEvent event) {
        theModel.directAccessDeviceRemoved(event);
    }

    @Override
    public void directAccessDeviceDeExposed(DirectAccessDeviceEvent event) {
        theModel.directAccessDeviceDeExposed(event);
    }

    @Override
    public void directAccessDeviceExposed(DirectAccessDeviceEvent event) {
        theModel.directAccessDeviceExposed(event);
    }

    @Override
    public void volumeStateChanged(VolumeEvent e) {
    }

    @Override
    public void volumeParametersChanged(VolumeEvent e) {
    }

    @Override
    public void snapshotSourceChanged(VolumeEvent e) {
    }

    @Override
    public void volumeCapacityChanged(VolumeEvent e) {
    }

    @Override
    public void addVolumeNodeToParent(VolumeEvent event, VolumeTreeNode parentNode, VolumeTreeNode childNode) {
    }

    @Override
    public void removeVolumeNodeFromParent(VolumeEvent event, VolumeTreeNode childNode) {
    }

    @Override
    public void snapshotVolActiveStateChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolActivateOnVSwitchChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolActivityStateChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolDateAndTimeChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolPercentageThresholdChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolPercentageUtilizationChanged(VolumeEvent event) {
    }

    @Override
    public void copyOperationCreate(CopyOperationEvent aEvent) {
        theModel.fireAllRowsUpdated();
    }

    @Override
    public void copyOperationRemove(CopyOperationEvent aEvent) {
        theModel.fireAllRowsUpdated();
    }

    @Override
    public void copyOperationChange(CopyOperationEvent aEvent) {
        theModel.fireAllRowsUpdated();
    }

    @Override
    public void getAllCopyOperations(CopyOperationEvent aEvent) {
        theModel.fireAllRowsUpdated();
    }
}

