/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.storage;

import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.StorageManager;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageDriveTypeConstant;
import com.sanrad.util.filter.SrFilterDynamicRule;
import com.sanrad.util.filter.SrFilterSimpleRule;
import com.sanrad.util.filter.SrFilteredArrayList;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class StorageRaidSelector {
    String myWWN = null;
    BigInteger myCapacity = BigInteger.ZERO;
    BigInteger myFreeSpace = BigInteger.ZERO;
    boolean myHasChangedSinceLastAccessed = false;
    SrFilteredArrayList<DirectAccessDeviceNode> myDisks = new SrFilteredArrayList();
    public static SrFilterSimpleRule<DirectAccessDeviceNode> myDisksBelongsToThisRaidRule = new SrFilterSimpleRule<DirectAccessDeviceNode>(){

        @Override
        public boolean isValid(DirectAccessDeviceNode newObject, Object ... params) {
            if (params == null) {
                throw new IllegalArgumentException("The first parameter should be a SrFilteredArrayList instance but it is null");
            }
            if (params.length == 0) {
                throw new IllegalArgumentException("The rule should get at least one parameter which is the filter");
            }
            assert (params[0] instanceof SrFilteredArrayList) : "The given param should be a SrFilteredArrayList instance.";
            SrFilteredArrayList srcFilter = (SrFilteredArrayList)params[0];
            if (newObject == null) {
                return false;
            }
            if (srcFilter.getAllOfMatched().isEmpty()) {
                return true;
            }
            return ((DirectAccessDeviceNode)srcFilter.getOfMatched(0)).getEntityName().equals(newObject.getEntityName());
        }
    };
    private SrFilterDynamicRule<DirectAccessDeviceNode> disksWithThisTypeRule = new SrFilterDynamicRule<DirectAccessDeviceNode>(){

        @Override
        public boolean isValid(DirectAccessDeviceNode newObject, Object ... params) {
            if (newObject == null) {
                return false;
            }
            List<Object> objs = this.getObjects();
            if (objs.isEmpty()) {
                return true;
            }
            PhysicalStorageDriveTypeConstant needType = (PhysicalStorageDriveTypeConstant)objs.get(0);
            if (needType == null) {
                return true;
            }
            if (!needType.equals(newObject.getDriveType())) {
                return false;
            }
            return !StorageManager.getInstance().isStorageNodeUsedByAPair(newObject);
        }
    };
    public static SrFilterSimpleRule<DirectAccessDeviceNode> disksWithSameBlockSizeRule = new SrFilterSimpleRule<DirectAccessDeviceNode>(){

        @Override
        public boolean isValid(DirectAccessDeviceNode newObject, Object ... params) {
            if (params == null) {
                throw new IllegalArgumentException("The first parameter should be a SrFilteredArrayList instance but it is null");
            }
            if (params.length == 0) {
                throw new IllegalArgumentException("The rule should get at least one parameter which is the filter");
            }
            assert (params[0] instanceof SrFilteredArrayList) : "The given param should be a SrFilteredArrayList instance.";
            SrFilteredArrayList srcFilter = (SrFilteredArrayList)params[0];
            if (newObject == null) {
                return false;
            }
            if (srcFilter.getAllOfMatched().isEmpty()) {
                return true;
            }
            return ((DirectAccessDeviceNode)srcFilter.getOfMatched(0)).getBlockSize().compareTo(newObject.getBlockSize()) == 0;
        }
    };
    private static Comparator<DirectAccessDeviceNode> theMaxDiskFreeSpaceComperator = new Comparator<DirectAccessDeviceNode>(){

        @Override
        public int compare(DirectAccessDeviceNode D1, DirectAccessDeviceNode D2) {
            return D2.getNonAllocatedSpace().compareTo(D1.getNonAllocatedSpace());
        }
    };

    public StorageRaidSelector() {
        this.myDisks.addRule(myDisksBelongsToThisRaidRule);
        this.myDisks.addRule(this.disksWithThisTypeRule);
    }

    public StorageRaidSelector(List<DirectAccessDeviceNode> aDisksList) {
        this();
        if (aDisksList == null) {
            return;
        }
        this.addAll(aDisksList);
        this.updateFields();
    }

    public StorageRaidSelector(StorageRaidSelector aRaid) {
        this(aRaid.getDisks());
        this.setFilteredDiskType(aRaid.getFilteredDiskType());
    }

    public StorageRaidSelector clone() {
        return new StorageRaidSelector(this);
    }

    private void updateFields() {
        assert (this.myHasChangedSinceLastAccessed) : "The updateFields() method of StorageRaidSelector instance " + this + " has been called " + "although the myHasChangedSinceLastAccessed is false";
        this.myCapacity = BigInteger.ZERO;
        this.myFreeSpace = BigInteger.ZERO;
        for (DirectAccessDeviceNode currentDisk : this.myDisks.getAllOfMatched()) {
            this.myCapacity = this.myCapacity.add(currentDisk.getTotalSpace());
            this.myFreeSpace = this.myFreeSpace.add(currentDisk.getNonAllocatedSpace());
        }
        this.myHasChangedSinceLastAccessed = false;
    }

    public boolean addDisk(DirectAccessDeviceNode aDisk) {
        if (aDisk == null) {
            return false;
        }
        boolean hasChanged = this.myDisks.add(aDisk);
        if (hasChanged) {
            this.myHasChangedSinceLastAccessed = true;
            this.myWWN = aDisk.getEntityName();
        }
        return hasChanged;
    }

    public boolean addAll(List<DirectAccessDeviceNode> aDisksList) {
        if (aDisksList == null) {
            return false;
        }
        boolean diskAdded = false;
        for (DirectAccessDeviceNode disk : aDisksList) {
            if (!this.addDisk(disk)) continue;
            diskAdded = true;
        }
        return diskAdded;
    }

    private void setWWN(String aWWN) {
        this.myWWN = aWWN;
    }

    public String getWWN() {
        return this.myWWN;
    }

    public boolean isEmpty() {
        return this.myDisks.getAllOfMatched().isEmpty();
    }

    public void setFilteredDiskType(PhysicalStorageDriveTypeConstant aType) {
        this.disksWithThisTypeRule.clearObjects();
        this.disksWithThisTypeRule.addObject(aType);
        this.myHasChangedSinceLastAccessed = true;
    }

    private PhysicalStorageDriveTypeConstant getFilteredDiskType() {
        List<Object> objs = this.disksWithThisTypeRule.getObjects();
        if (objs.isEmpty()) {
            return null;
        }
        return (PhysicalStorageDriveTypeConstant)objs.get(0);
    }

    public BigInteger getCapacity() {
        if (this.myHasChangedSinceLastAccessed) {
            this.updateFields();
        }
        return this.myCapacity;
    }

    public BigInteger getFreeSpace() {
        if (this.myHasChangedSinceLastAccessed) {
            this.updateFields();
        }
        return this.myFreeSpace;
    }

    public List<DirectAccessDeviceNode> getDisks() {
        return this.myDisks.getAllOfMatched();
    }

    private List<DirectAccessDeviceNode> getDisksSortedFromMaxFreeSpace() {
        List<DirectAccessDeviceNode> disks = this.myDisks.getAllOfMatched();
        Collections.sort(disks, theMaxDiskFreeSpaceComperator);
        return disks;
    }

    public BigInteger getMaxCapacityForMirrorVolume() {
        StorageRaidSelector R1 = new StorageRaidSelector();
        StorageRaidSelector R2 = new StorageRaidSelector();
        for (DirectAccessDeviceNode disk : this.getDisksSortedFromMaxFreeSpace()) {
            if (R1.getFreeSpace().compareTo(R2.getFreeSpace()) > 0) {
                R2.addDisk(disk);
                continue;
            }
            R1.addDisk(disk);
        }
        BigInteger freeSpace1 = R1.getFreeSpace();
        BigInteger freeSpace2 = R2.getFreeSpace();
        return freeSpace1.min(freeSpace2);
    }
}

