/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.storage;

import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.DRPairManager;
import com.sanrad.nms.client.data.raid.AttachedRaidManager;
import com.sanrad.nms.client.data.raid.RaidSystem;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.StorageManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.server.util.types.SrEntityNameFormat;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageDriveTypeConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageOperStatusConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageRaidLevelConstant;
import com.sanrad.util.Util;
import com.sanrad.util.filter.SortKeyProvider;
import com.sanrad.util.filter.SrFilterSimpleRule;
import com.sanrad.util.filter.SrFilteredArrayList;
import com.sanrad.util.filter.SrSortingMap;
import com.sanrad.util.virtualization.AllocableGroup;
import com.sanrad.util.virtualization.AllocationUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class StoragePoolSelector {
    private static SortKeyProvider<Object, DirectAccessDeviceNode> theBlockSizeSorter = new SortKeyProvider<Object, DirectAccessDeviceNode>(){

        @Override
        public Integer getSortBy(DirectAccessDeviceNode value) {
            return value.getBlockSize();
        }
    };
    private static SortKeyProvider<Object, DirectAccessDeviceNode> theEntityNameSorter = new SortKeyProvider<Object, DirectAccessDeviceNode>(){

        @Override
        public String getSortBy(DirectAccessDeviceNode value) {
            return value.getEntityName();
        }
    };

    private StoragePoolSelector() {
    }

    public static BigInteger getMaxVolumeSpace(ClusterNode aCluster, PhysicalStorageDriveTypeConstant aType, PhysicalStorageRaidLevelConstant aRaidLevel) {
        List<DirectAccessDeviceNode> disks = StoragePoolSelector.getClusterDisks(aCluster, aType, aRaidLevel);
        return StoragePoolSelector.getMaxVolumeSpace(disks);
    }

    public static List<DirectAccessDeviceNode> getClusterDisks(ClusterNode aCluster, PhysicalStorageDriveTypeConstant aType, PhysicalStorageRaidLevelConstant aRaidLevel) {
        return StoragePoolSelector.getClusterDisks(aCluster, aType, aRaidLevel, null);
    }

    public static List<DirectAccessDeviceNode> getClusterDisks(ClusterNode aCluster, PhysicalStorageDriveTypeConstant aType, PhysicalStorageRaidLevelConstant aRaidLevel, Integer aBlockSize) {
        return StoragePoolSelector.getClusterDisks(aCluster, aType, aRaidLevel, aBlockSize, false);
    }

    public static List<DirectAccessDeviceNode> getClusterDisks(ClusterNode aCluster, PhysicalStorageDriveTypeConstant aType, PhysicalStorageRaidLevelConstant aRaidLevel, Integer aBlockSize, boolean aIgnoreRaidAttachment) {
        List<DirectAccessDeviceNode> clusterDisks = StoragePoolSelector.getClusterDisks(aCluster, aIgnoreRaidAttachment);
        List<DirectAccessDeviceNode> disks = StoragePoolSelector.getFilteredDisks(clusterDisks, aType, aRaidLevel, aBlockSize);
        return disks;
    }

    public static List<DirectAccessDeviceNode> getClusterDisks(ClusterNode aCluster, boolean aIgnoreRaidAttachment) {
        SrFilteredArrayList<DirectAccessDeviceNode> filter = new SrFilteredArrayList<DirectAccessDeviceNode>(StorageManager.getInstance().getDisksOfCluster(aCluster));
        filter.addRule(new DisksFilter(aCluster, aIgnoreRaidAttachment));
        return filter.getAllOfMatched();
    }

    public static List<DirectAccessDeviceNode> getClusterDisks(ClusterNode aCluster) {
        return StoragePoolSelector.getClusterDisks(aCluster, false);
    }

    private static BigInteger getMaxVolumeSpace(List<DirectAccessDeviceNode> aDisks) {
        Map<Object, List<DirectAccessDeviceNode>> blockSizeSortedMap = SrSortingMap.sort(theBlockSizeSorter, aDisks);
        BigInteger maxVolumeSpace = BigInteger.ZERO;
        for (List<DirectAccessDeviceNode> disks : blockSizeSortedMap.values()) {
            BigInteger currMaxAlloc = AllocationUtil.getMaxSize(disks);
            maxVolumeSpace = maxVolumeSpace.max(currMaxAlloc);
        }
        return maxVolumeSpace;
    }

    public static BigInteger getMaxMirrorSpace(ClusterNode aCluster, PhysicalStorageDriveTypeConstant aType, PhysicalStorageRaidLevelConstant aRaidLevel) {
        List<DirectAccessDeviceNode> disks = StoragePoolSelector.getClusterDisks(aCluster, aType, aRaidLevel);
        return StoragePoolSelector.getMaxMirrorSpace(disks);
    }

    private static BigInteger getMaxMirrorSpace(List<DirectAccessDeviceNode> aDisks) {
        Map<Object, List<DirectAccessDeviceNode>> blockSizeSortedMap = SrSortingMap.sort(theBlockSizeSorter, aDisks);
        BigInteger maxVolumeSpace = BigInteger.ZERO;
        for (List<DirectAccessDeviceNode> disks : blockSizeSortedMap.values()) {
            Map<Object, List<DirectAccessDeviceNode>> raidSortedMap = SrSortingMap.sort(theEntityNameSorter, disks);
            List<AllocableGroup> raids = AllocableGroup.convertToGroupList(raidSortedMap.values());
            BigInteger currMaxAlloc = AllocationUtil.getMaxMirrorSize(raids);
            maxVolumeSpace = maxVolumeSpace.max(currMaxAlloc);
        }
        return maxVolumeSpace;
    }

    private static List<DirectAccessDeviceNode> getFilteredDisks(List<DirectAccessDeviceNode> aDisks, final PhysicalStorageDriveTypeConstant aType, final PhysicalStorageRaidLevelConstant aRaidLevel, final Integer aBlockSize) {
        SrFilteredArrayList<DirectAccessDeviceNode> filter = new SrFilteredArrayList<DirectAccessDeviceNode>();
        filter.addRule(new SrFilterSimpleRule<DirectAccessDeviceNode>(){

            @Override
            public boolean isValid(DirectAccessDeviceNode aNewObject, Object ... aParams) {
                boolean isSameType = Util.equalsWithNull(aType, aNewObject.getDriveType());
                boolean isSameRaidLevel = Util.equalsWithNull(aRaidLevel, aNewObject.getRaidLevel());
                boolean isSameBlockSize = aBlockSize == null || aBlockSize.equals(aNewObject.getBlockSize());
                return isSameType && isSameRaidLevel && isSameBlockSize;
            }
        });
        filter.addAll((Collection<DirectAccessDeviceNode>)aDisks);
        return filter.getAllOfMatched();
    }

    private static class DisksFilter
    extends SrFilterSimpleRule<DirectAccessDeviceNode> {
        private ClusterNode myCluster = null;
        private List<SrEntityNameFormat> myAttachedRaidsEntities = new ArrayList<SrEntityNameFormat>();
        private boolean myIgnoreRaidAttachment;

        public DisksFilter(ClusterNode aCluster, boolean aIgnoreRaidAttachment) {
            if (aCluster == null) {
                throw new IllegalArgumentException("The given cluster should not be null.");
            }
            this.myCluster = aCluster;
            this.setAttachRaidsEntities(this.myCluster);
            this.myIgnoreRaidAttachment = aIgnoreRaidAttachment;
        }

        private void setAttachRaidsEntities(ClusterNode aCluster) {
            for (VSwitchNode vs : aCluster.getVSwitches()) {
                for (RaidSystem raid : AttachedRaidManager.getInstance().getAttachedRaidSystems(vs)) {
                    this.myAttachedRaidsEntities.add(raid.getWWN());
                }
            }
        }

        @Override
        public boolean isValid(DirectAccessDeviceNode aDisk, Object ... aParams) {
            boolean usedByPair = DRPairManager.getPairContainingVolume(aDisk) != null;
            boolean isEnabled = PhysicalStorageOperStatusConstant.PHYS_STOR_OPER_STAT_ENABLE.equals(aDisk.getStorageOperStatus());
            boolean isDiskPartOfAttachedRaid = this.myAttachedRaidsEntities.contains(aDisk.getEntityNameFormat());
            return isEnabled && !usedByPair && (isDiskPartOfAttachedRaid || this.myIgnoreRaidAttachment);
        }
    }
}

