/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.storage;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.comm.Communication;
import com.sanrad.nms.client.data.Manager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.DRPairManager;
import com.sanrad.nms.client.data.raid.RaidManager;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceManager;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.SequentialAccessDeviceNode;
import com.sanrad.nms.client.data.storage.StorageDeviceNode;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceNode;
import com.sanrad.nms.client.event.storage.StorageManagerEvent;
import com.sanrad.nms.client.event.storage.StorageManagerListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDevice;
import com.sanrad.nms.server.logic.physstorage.SequentialAccessDevice;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDevice;
import com.sanrad.nms.server.logic.storage.Storage;
import com.sanrad.nms.server.util.types.SrEntityNameFormat;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageDriveTypeConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageOperStatusConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageRaidLevelConstant;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.Util;
import com.sanrad.util.concurrent.SrFuture;
import com.sanrad.util.filter.SrFilterSimpleRule;
import com.sanrad.util.filter.SrFilteredArrayList;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class StorageManager
extends Manager {
    private Map<ClusterNode, List<StorageDeviceNode>> theClusterToStoragesMap = new HashMap<ClusterNode, List<StorageDeviceNode>>();
    private static StorageManager theInstance = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer addStorageDataInformer = new SrEventListenerManager.Informer<StorageManagerListener, StorageManagerEvent>(){

        @Override
        public void inform(StorageManagerListener listener, StorageManagerEvent event) {
            listener.addStorageData(event);
        }
    };

    private StorageManager() {
    }

    public static synchronized StorageManager getInstance() {
        if (theInstance == null) {
            theInstance = new StorageManager();
        }
        return theInstance;
    }

    public Storage getStorageStub(ClusterNode clusterNode) {
        return Communication.getInstance().getStorageStub(clusterNode.getStub());
    }

    public void readAllStorageDataFromServer() {
        Enumeration<ClusterNode> e = SystemRootNode.getInstance().getClusterNodes().elements();
        while (e.hasMoreElements()) {
            ClusterNode clusterNode = e.nextElement();
            this.readStorageDataFromServer(clusterNode);
        }
    }

    public boolean readStorageDataFromServer(ClusterNode clusterNode) {
        block13: {
            try {
                List storageDevices;
                Storage storageStub = this.getStorageStub(clusterNode);
                if (storageStub == null || (storageDevices = storageStub.getStorageDevices()) == null) break block13;
                StorageDeviceNode[] disks = new StorageDeviceNode[storageDevices.size()];
                for (int i = 0; i < storageDevices.size(); ++i) {
                    GeneralSCSIDevice device = (GeneralSCSIDevice)storageDevices.get(i);
                    HashMap params = null;
                    try {
                        params = device.getClientParameterList();
                    }
                    catch (IllegalValueException e) {
                        theLogger.error(SrLogCategories.LEGACY, e, new Object[0]);
                    }
                    boolean deviceIsDirectAccessDevice = device instanceof DirectAccessDevice;
                    String alias = device.getAlias();
                    String transportType = device.getTransportType().toString();
                    boolean isExposed = device.isExposed();
                    PhysicalStorageDriveTypeConstant driveType = device.getDriveType();
                    SrTreeNode obj = SystemRootNode.getInstance().getRefByStub(device);
                    if (obj == null) {
                        if (deviceIsDirectAccessDevice) {
                            disks[i] = new DirectAccessDeviceNode<DirectAccessDevice>((DirectAccessDevice)device, alias, isExposed, transportType, driveType);
                            PhysicalStorageRaidLevelConstant raidLevel = (PhysicalStorageRaidLevelConstant)params.get(ClientParameterCode.PHYSICAL_STORAGE_RAID_LEVEL);
                            String raidSysName = (String)params.get(ClientParameterCode.PHYSICAL_STORAGE_RAID_SYSTEM_NAME);
                            String raidModelName = (String)params.get(ClientParameterCode.PHYSICAL_STORAGE_RAID_MODEL_NAME);
                            BigInteger raidCreationTime = (BigInteger)params.get(ClientParameterCode.PHYSICAL_STORAGE_RAID_CREATION_TIME);
                            String raidFwRev = (String)params.get(ClientParameterCode.PHYSICAL_STORAGE_RAID_FIRMWARE_REV);
                            SrBITSConstant raidStatus = (SrBITSConstant)params.get(ClientParameterCode.PHYSICAL_STORAGE_RAID_STATUS);
                            String raidUrl1 = (String)params.get(ClientParameterCode.PHYSICAL_STORAGE_RAID_CONTROLLER_URL1);
                            String raidUrl2 = (String)params.get(ClientParameterCode.PHYSICAL_STORAGE_RAID_CONTROLLER_URL2);
                            ((DirectAccessDeviceNode)disks[i]).setRaid(raidLevel, raidStatus, raidCreationTime, raidSysName, raidModelName, raidFwRev, raidUrl1, raidUrl2);
                        } else {
                            disks[i] = device instanceof SequentialAccessDevice ? new SequentialAccessDeviceNode((SequentialAccessDevice)device, alias, isExposed, transportType) : new StorageDeviceNode<GeneralSCSIDevice>(device, alias, isExposed, transportType);
                        }
                        SystemRootNode.getInstance().putRefAndStub(device, disks[i]);
                    } else {
                        disks[i] = (StorageDeviceNode)obj;
                    }
                    Vector splits = null;
                    if (deviceIsDirectAccessDevice) {
                        splits = ((DirectAccessDevice)device).getStorageSpaceStatus();
                        ((DirectAccessDeviceNode)disks[i]).setWriteCacheEnabled(((DirectAccessDevice)device).isWriteCacheEnabled());
                        ((DirectAccessDeviceNode)disks[i]).setWriteProtected(((DirectAccessDevice)device).isWriteProtected());
                        ((DirectAccessDeviceNode)disks[i]).setBlockSize(new Integer(device.getBlockSize()));
                        ((DirectAccessDeviceNode)disks[i]).setNonAllocatedSpace(device.getNonAllocatedSpace());
                        ((DirectAccessDeviceNode)disks[i]).setTotalSpace(device.getTotalSpace());
                        ((DirectAccessDeviceNode)disks[i]).setSplits(splits);
                        ((DirectAccessDeviceNode)disks[i]).setIsAllocable(((DirectAccessDevice)device).isAllocable());
                    } else {
                        disks[i].setBlockSize(new Integer(0));
                        disks[i].setTotalSpace(new BigInteger("0"));
                    }
                    disks[i].setStorageOperStatus((PhysicalStorageOperStatusConstant)params.get(ClientParameterCode.PHYSICAL_STORAGE_OPER_STATUS));
                    disks[i].setFree(device.isFree());
                    disks[i].setRemoteLU(device.getLUN());
                    disks[i].setGroup("");
                    disks[i].setEntityName(device.getEntityName());
                    byte[] entityNameValue = (byte[])params.get(ClientParameterCode.PHYSICAL_STORAGE_ENTITY_NAME);
                    disks[i].setEntityNameFormat(new SrEntityNameFormat(entityNameValue));
                    disks[i].setAllocatedSpace(device.getAllocatedSpace());
                    disks[i].setAccessibleSpace(device.getAccessibleSpace());
                    disks[i].setVendor(device.getVendor());
                    disks[i].setInfo(device.getInfo());
                    disks[i].setDeviceType(device.getType());
                    disks[i].setStatus(StorageManager.getSeverity(device.getPropagatedState()));
                    disks[i].setBlinking(device.isBlinking());
                    disks[i].setSerialNumber(device.getSerialNumber());
                    disks[i].setProductId(device.getProductID());
                    disks[i].setRevisionLevel(device.getRevisionLevel());
                    disks[i].setSCSIVersion(device.getSCSIVersion());
                    disks[i].setPositionInParent(device.getPositionInParent());
                    if (splits == null || splits.size() == 0 || deviceIsDirectAccessDevice && !((DirectAccessDeviceNode)disks[i]).hasSubdisks()) {
                        disks[i].setVolStateBits(device.getVolumeState());
                    }
                    if (deviceIsDirectAccessDevice) {
                        this.readAndCreateSubdisks(splits, (DirectAccessDeviceNode)disks[i]);
                    }
                    theLogger.trace(SrLogCategories.LEGACY, "StorageManager: read storage - ", disks[i].getAlias());
                }
                theLogger.trace(SrLogCategories.LEGACY, "StorageManager: storage elements were added.");
                this.addStorageData(disks);
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
                return false;
            }
        }
        return true;
    }

    private SubDirectAccessDeviceNode[] readAndCreateSubdisks(Vector aSubdisks, DirectAccessDeviceNode aDisk) {
        if (aSubdisks != null) {
            Vector<SubDirectAccessDeviceNode> subDisksList = new Vector<SubDirectAccessDeviceNode>();
            for (int j = 0; j < aSubdisks.size(); ++j) {
                if (!(aSubdisks.get(j) instanceof SubDirectAccessDevice)) continue;
                SubDirectAccessDevice stub = (SubDirectAccessDevice)aSubdisks.get(j);
                SrTreeNode obj = SystemRootNode.getInstance().getRefByStub(stub);
                try {
                    SubDirectAccessDeviceNode node = null;
                    if (obj == null) {
                        node = this.createSubDirectAccessDeviceNode(stub, aDisk);
                    } else {
                        theLogger.logAndAssert(SrLogCategories.ERROR, new Exception("Subdisk node exists although client is loading or initializing"));
                        node = (SubDirectAccessDeviceNode)obj;
                    }
                    subDisksList.add(node);
                    continue;
                }
                catch (RemoteException re) {
                    theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
                    StorageManager.onConnectionError(re.getMessage());
                }
            }
            SubDirectAccessDeviceNode[] subDiskArray = new SubDirectAccessDeviceNode[subDisksList.size()];
            subDisksList.toArray(subDiskArray);
            return subDiskArray;
        }
        return null;
    }

    public SubDirectAccessDeviceNode[] getSubdisksNodes(List aSubdiskStubs, DirectAccessDeviceNode disk) {
        if (aSubdiskStubs != null) {
            Vector<SubDirectAccessDeviceNode> subDisksList = new Vector<SubDirectAccessDeviceNode>();
            for (Object stubObj : aSubdiskStubs) {
                if (!(stubObj instanceof SubDirectAccessDevice)) continue;
                SubDirectAccessDevice stub = (SubDirectAccessDevice)stubObj;
                SrTreeNode obj = SystemRootNode.getInstance().getRefByStub(stub);
                try {
                    SubDirectAccessDeviceNode node = null;
                    if (obj == null) {
                        theLogger.logAndAssert(SrLogCategories.ERROR, new Exception("Subdisk node doesn't exist although loading is finished, client reads directly from the server"));
                        node = this.createSubDirectAccessDeviceNode(stub, disk);
                    } else {
                        node = (SubDirectAccessDeviceNode)obj;
                    }
                    subDisksList.add(node);
                }
                catch (RemoteException re) {
                    theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
                    StorageManager.onConnectionError(re.getMessage());
                }
            }
            SubDirectAccessDeviceNode[] subDiskArray = new SubDirectAccessDeviceNode[subDisksList.size()];
            subDisksList.toArray(subDiskArray);
            return subDiskArray;
        }
        return null;
    }

    private SubDirectAccessDeviceNode createSubDirectAccessDeviceNode(SubDirectAccessDevice aStub, DirectAccessDeviceNode aDisk) throws RemoteException {
        SubDirectAccessDeviceNode node = new SubDirectAccessDeviceNode(aStub, aStub.getAlias(), aStub.isExposed());
        SystemRootNode.getInstance().putRefAndStub(aStub, node);
        node.setTotalSpace(aStub.getSize());
        node.setBlockSize(new Integer(aStub.getBlockSize()));
        node.setEntityName(aStub.getEntityName());
        node.setFree(aStub.isFree());
        node.setTotalSpace(aStub.getSize());
        node.setDirectAccessDeviceParent(aDisk);
        node.setStartAddress(aStub.getStartAddress());
        node.setEndAddress(aStub.getEndAddress());
        node.setInfo(aStub.getInfo());
        node.setAllocatedSpace(aStub.getAllocatedSpace());
        node.setStatus(StorageManager.getSeverity(aStub.getPropagatedState()));
        node.setRemoteLU(aDisk.getRemoteLU());
        node.setNonAllocatedSpace(new BigInteger("0"));
        node.setVolStateBits(aStub.getVolumeState());
        node.setAccessibleSpace(aStub.getAccessibleSpace());
        node.setPositionInParent(aStub.getPositionInParent());
        node.setSubdiskOperStatus(aStub.getOperStatus());
        return node;
    }

    public void addStorageManagerListener(StorageManagerListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeStorageManagerListener(StorageManagerListener listener) {
        this.m_listeners.remove(listener);
    }

    public void addStorageData(StorageDeviceNode[] data) {
        if (data == null || data.length == 0) {
            return;
        }
        this.addStorages(Arrays.asList(data));
        for (StorageDeviceNode strg : data) {
            if (!(strg instanceof DirectAccessDeviceNode)) continue;
            RaidManager.getInstance().reactToDiskCreated((DirectAccessDeviceNode)strg);
        }
        StorageManagerEvent event = new StorageManagerEvent(this);
        event.setStorageData(data);
        this.m_listeners.fireEvent(StorageManagerListener.class, event, this.addStorageDataInformer);
    }

    private void addStorages(List<StorageDeviceNode> aStorages) {
        if (aStorages == null) {
            throw new IllegalArgumentException("Storage list is null");
        }
        for (StorageDeviceNode strg : aStorages) {
            this.addStorage(strg);
        }
    }

    private void addStorage(StorageDeviceNode aStrg) {
        ClusterNode strgCluster = SystemRootNode.getInstance().getClusterNodeOfSource(aStrg);
        if (strgCluster == null) {
            throw new IllegalStateException("Cluster node wasn't found for storage " + aStrg);
        }
        List<StorageDeviceNode> strgList = this.theClusterToStoragesMap.get(strgCluster);
        if (strgList == null) {
            strgList = new ArrayList<StorageDeviceNode>();
        }
        strgList.add(aStrg);
        this.theClusterToStoragesMap.put(strgCluster, strgList);
    }

    public void removeStorage(StorageDeviceNode aStrg) {
        ClusterNode strgCluster = SystemRootNode.getInstance().getClusterNodeOfSource(aStrg);
        if (strgCluster == null) {
            return;
        }
        List<StorageDeviceNode> strgList = this.theClusterToStoragesMap.get(strgCluster);
        if (strgList == null) {
            return;
        }
        strgList.remove(aStrg);
        this.theClusterToStoragesMap.put(strgCluster, strgList);
    }

    public List<StorageDeviceNode> getStorages(ClusterNode aCluster) {
        if (aCluster == null || this.theClusterToStoragesMap.get(aCluster) == null) {
            return Collections.EMPTY_LIST;
        }
        List<StorageDeviceNode> storages = this.theClusterToStoragesMap.get(aCluster);
        if (storages == null) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList<StorageDeviceNode>(storages);
    }

    public List<StorageDeviceNode> removeStorages(ClusterNode aCluster) {
        return this.theClusterToStoragesMap.remove(aCluster);
    }

    public List<DirectAccessDeviceNode> getDisksOfCluster(ClusterNode aCluster) {
        SrFilterSimpleRule<StorageDeviceNode> storageWithDiskTypeRule = new SrFilterSimpleRule<StorageDeviceNode>(){

            @Override
            public boolean isValid(StorageDeviceNode newObject, Object ... aParams) {
                if (newObject == null) {
                    return false;
                }
                return newObject.getStorageType() == StorageDeviceNode.STORAGE_TYPE_DISK;
            }
        };
        SrFilteredArrayList<StorageDeviceNode> disksFilterArrayList = new SrFilteredArrayList<StorageDeviceNode>(StorageManager.getInstance().getStorages(aCluster), storageWithDiskTypeRule);
        return Util.convertListType(disksFilterArrayList.getAllOfMatched());
    }

    public SrFuture<Void> deleteObjects(SrTreeNode[] nodes) {
        ArrayList<Object> ids = new ArrayList<Object>(nodes.length);
        for (SrTreeNode node : nodes) {
            ids.add(node.getIdentifier());
        }
        return ClientAOImpl.getInstance().deleteObjects(ids);
    }

    public boolean isStorageNodeUsedByAPair(StorageDeviceNode node) {
        return DRPairManager.getPairContainingVolume(node) != null;
    }

    public boolean hasSubdiskUsedByPair(DirectAccessDeviceNode diskNode) {
        List<RemoteObject> splits = diskNode.getSplits();
        if (splits != null) {
            for (int i = 0; i < splits.size(); ++i) {
                SubDirectAccessDeviceNode subdiskNode;
                RemoteObject obj = splits.get(i);
                if (!(obj instanceof SubDirectAccessDevice) || !this.isStorageNodeUsedByAPair(subdiskNode = (SubDirectAccessDeviceNode)SystemRootNode.getInstance().getRefByStub(obj))) continue;
                return true;
            }
        }
        return false;
    }

    public ClusterNode getClusterOfStorage(StorageDeviceNode aStorage) {
        theLogger.logAndAssert(SrLogCategories.ILLEGAL_ARGUMENT, aStorage != null, new Object[]{"The given storage should not be null."});
        return SystemRootNode.getInstance().getClusterNodeOfStub((RemoteObject)aStorage.getStub());
    }

    public List<DirectAccessDeviceNode> filterNotCapableVolumeCreationDisks(List<DirectAccessDeviceNode> aDisksList) {
        SrFilterSimpleRule<DirectAccessDeviceNode> diskSuitableForVolumeCreationRule = new SrFilterSimpleRule<DirectAccessDeviceNode>(){

            @Override
            public boolean isValid(DirectAccessDeviceNode newObject, Object ... params) {
                return newObject.canBeUsedToCreateVolume() == null;
            }
        };
        SrFilteredArrayList<DirectAccessDeviceNode> filteredDisks = new SrFilteredArrayList<DirectAccessDeviceNode>(aDisksList, diskSuitableForVolumeCreationRule);
        return filteredDisks.getAllOfMatched();
    }

    public List<List<DirectAccessDeviceNode>> filterNotCapableVolumeCreationDisksLists(List<List<DirectAccessDeviceNode>> aDisksLists) {
        ArrayList<List<DirectAccessDeviceNode>> retList = new ArrayList<List<DirectAccessDeviceNode>>();
        for (List<DirectAccessDeviceNode> curList : aDisksLists) {
            retList.add(this.filterNotCapableVolumeCreationDisks(curList));
        }
        return retList;
    }

    public void sortDisksFreeCapacityMaxToMin(List<DirectAccessDeviceNode> aDisksList) {
        Comparator<DirectAccessDeviceNode> freeCapacityComp = new Comparator<DirectAccessDeviceNode>(){

            @Override
            public int compare(DirectAccessDeviceNode o1, DirectAccessDeviceNode o2) {
                return o2.getNonAllocatedSpace().compareTo(o1.getNonAllocatedSpace());
            }
        };
        Collections.sort(aDisksList, freeCapacityComp);
    }

    public BigInteger getTotalSpaceFromDisksList(List<DirectAccessDeviceNode> aDisksList) {
        BigInteger totalSpace = BigInteger.ZERO;
        if (aDisksList == null) {
            return totalSpace;
        }
        for (DirectAccessDeviceNode currentDisk : aDisksList) {
            totalSpace = totalSpace.add(currentDisk.getTotalSpace());
        }
        return totalSpace;
    }

    public BigInteger getTotalSpaceFromDisksLists(List<List<DirectAccessDeviceNode>> aDisksLists) {
        BigInteger totalSpace = BigInteger.ZERO;
        if (aDisksLists == null) {
            return totalSpace;
        }
        for (List<DirectAccessDeviceNode> currentList : aDisksLists) {
            totalSpace = totalSpace.add(this.getTotalSpaceFromDisksList(currentList));
        }
        return totalSpace;
    }

    public BigInteger getTotalNonAllocatedSpaceFromDisksList(List<DirectAccessDeviceNode> aDisksList) {
        BigInteger nonAllocSpace = BigInteger.ZERO;
        if (aDisksList == null) {
            return nonAllocSpace;
        }
        for (DirectAccessDeviceNode currentDisk : aDisksList) {
            nonAllocSpace = nonAllocSpace.add(currentDisk.getNonAllocatedSpace());
        }
        return nonAllocSpace;
    }

    public BigInteger getTotalNonAllocatedSpaceFromDisksLists(List<List<DirectAccessDeviceNode>> aDisksLists) {
        BigInteger nonAllocSpace = BigInteger.ZERO;
        if (aDisksLists == null) {
            return nonAllocSpace;
        }
        for (List<DirectAccessDeviceNode> currentList : aDisksLists) {
            nonAllocSpace = nonAllocSpace.add(this.getTotalNonAllocatedSpaceFromDisksList(currentList));
        }
        return nonAllocSpace;
    }

    public static List<SubDirectAccessDeviceNode> getSubdisks(ClusterNode aCluster) {
        ArrayList<SubDirectAccessDeviceNode> retVal = new ArrayList<SubDirectAccessDeviceNode>();
        for (DirectAccessDeviceNode<DirectAccessDevice> disk : DirectAccessDeviceManager.getInstance().getAllDisks(aCluster)) {
            retVal.addAll(disk.getSubdisks());
        }
        return retVal;
    }

    public List<String> getAllAliases(ClusterNode aCluster) {
        ArrayList<String> allAliases = new ArrayList<String>();
        for (DirectAccessDeviceNode<DirectAccessDevice> disk : DirectAccessDeviceManager.getInstance().getAllDisks(aCluster)) {
            allAliases.add(disk.getAlias());
        }
        for (SubDirectAccessDeviceNode subdisk : StorageManager.getSubdisks(aCluster)) {
            allAliases.add(subdisk.getAlias());
        }
        return allAliases;
    }
}

