/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.storage;

import com.sanrad.util.StorageSize;
import java.math.BigInteger;

public class StorageDeviceSpace
implements Comparable {
    private BigInteger mySize;
    private String mySizeStr;
    private BigInteger percentage = null;

    public StorageDeviceSpace(BigInteger aSize) {
        this.mySize = aSize;
        this.mySizeStr = StorageSize.getSizeAsString(this.mySize);
    }

    public BigInteger getSize() {
        return this.mySize;
    }

    public BigInteger getSizeInUnit(StorageSize aUnit) {
        return StorageDeviceSpace.getSizeInUnit(this.mySize, aUnit);
    }

    public static BigInteger getSizeInUnit(BigInteger aSize, StorageSize aUnit) {
        if (aSize == null) {
            return BigInteger.ZERO;
        }
        if (StorageSize.MEGA.equals(aUnit)) {
            return aSize.divide(StorageSize.MEGA.getValue());
        }
        if (StorageSize.GIGA.equals(aUnit)) {
            return aSize.divide(StorageSize.GIGA.getValue());
        }
        if (StorageSize.TERA.equals(aUnit)) {
            return aSize.divide(StorageSize.TERA.getValue());
        }
        return BigInteger.ZERO;
    }

    public void setPercentageOf(StorageDeviceSpace source) {
        if (source.mySize != null && source.mySize.compareTo(BigInteger.ZERO) == 1) {
            BigInteger val;
            BigInteger perc = new BigInteger("100");
            this.percentage = val = this.mySize.multiply(perc).divide(source.mySize);
        }
    }

    public void setSize(BigInteger aSize) {
        this.mySize = aSize;
        this.mySizeStr = StorageSize.getSizeAsString(this.mySize);
    }

    public String toString() {
        if (this.mySizeStr != null) {
            if (this.percentage != null) {
                StringBuffer sb = new StringBuffer();
                sb.append(this.mySizeStr);
                sb.append('[');
                sb.append(this.percentage);
                sb.append('%');
                sb.append(']');
                return sb.toString();
            }
            return this.mySizeStr;
        }
        return "";
    }

    public int compareTo(Object o) {
        int answer = Integer.MIN_VALUE;
        if (o instanceof StorageDeviceSpace) {
            StorageDeviceSpace comp2 = (StorageDeviceSpace)o;
            BigInteger val1 = this.getSize();
            answer = val1.compareTo(comp2.getSize());
        }
        return answer;
    }
}

