/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.storage;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.alarm.AlarmsManager;
import com.sanrad.nms.client.data.volume.VolumeNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.util.types.SrEntityNameFormat;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageOperStatusConstant;
import java.math.BigInteger;
import java.rmi.RemoteException;
import javax.swing.tree.TreeNode;

public class StorageDeviceNode<T extends LogicObject>
extends VolumeTreeNode<T> {
    private static final String STORAGE_DEVICE_NODE_TYPE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.STORAGE_DEVICE_NODE_TYPE);
    public static int STORAGE_TYPE_PRCESSOR = 0;
    public static int STORAGE_TYPE_DISK = 1;
    public static int STORAGE_TYPE_SUB_DISK = 2;
    public static int STORAGE_TYPE_TAPE = 3;
    private boolean isBlinking = false;
    private int opDuration;
    private boolean isFree;
    private String remoteLU;
    private String deviceType;
    private String group;
    private String entityName;
    private SrEntityNameFormat entityNameFormat;
    private String info;
    private String vendor;
    private String productId;
    private String revisionLevel;
    private String serialNumber;
    private Integer blockSize;
    private BigInteger totalSize;
    private int scsiVersion;
    private String transportType;
    private int m_storageType = STORAGE_TYPE_PRCESSOR;
    private PhysicalStorageOperStatusConstant m_diskOperStatus;
    private boolean blinkingColor = false;

    public StorageDeviceNode(T stub, String alias, boolean exposed, String transportType) throws RemoteException {
        super(stub, alias, exposed);
        this.transportType = transportType;
        this.setNodeIcon(ClientImageObject.GENERAL_SCSI_DEVICE);
    }

    protected void setStorageType(int storageType) {
        this.m_storageType = storageType;
    }

    public int getStorageType() {
        return this.m_storageType;
    }

    public boolean isDisk() {
        return this.m_storageType == STORAGE_TYPE_DISK;
    }

    public boolean isSubDisk() {
        return this.m_storageType == STORAGE_TYPE_SUB_DISK;
    }

    public boolean isTape() {
        return this.m_storageType == STORAGE_TYPE_TAPE;
    }

    public boolean isProcessor() {
        return this.m_storageType == STORAGE_TYPE_PRCESSOR;
    }

    public boolean isBlinking() {
        return this.isBlinking;
    }

    public void setBlinkingColor() {
        this.blinkingColor = !this.blinkingColor;
    }

    public boolean isBlinkingColor() {
        return this.blinkingColor;
    }

    public void setBlinking(boolean isBlinking) {
        this.isBlinking = isBlinking;
    }

    public void setOpDuration(int duration) {
        this.opDuration = duration;
    }

    public int getOpDuration() {
        return this.opDuration;
    }

    public void setRemoteLU(String remoteLU) {
        this.remoteLU = remoteLU;
    }

    public String getRemoteLU() {
        return this.remoteLU;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getGroup() {
        return this.group;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public boolean hasVolumeParent() {
        return this.getParent() instanceof VolumeTreeNode;
    }

    public boolean hasVolumeOn() {
        TreeNode parent = this.getParent();
        return parent != null && parent instanceof VolumeNode;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public String getInfo() {
        return this.info;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setFree(boolean isFree) {
        this.isFree = isFree;
    }

    public boolean isFree() {
        return this.isFree;
    }

    public void setDeviceType(String type) {
        this.deviceType = type;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    @Override
    public Integer getBlockSize() {
        return this.blockSize;
    }

    public BigInteger getTotalSize() {
        return this.totalSize;
    }

    @Override
    public String type() {
        return STORAGE_DEVICE_NODE_TYPE;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getProductId() {
        return this.productId;
    }

    public void setRevisionLevel(String revisionLevel) {
        this.revisionLevel = revisionLevel;
    }

    public String getRevisionLevel() {
        return this.revisionLevel;
    }

    public void setSCSIVersion(Integer version) {
        this.scsiVersion = version;
    }

    public int getSCSIVersion() {
        return this.scsiVersion;
    }

    public boolean hasSubdisks() {
        return false;
    }

    @Override
    public int compareTo(Object o) {
        int answer = Integer.MIN_VALUE;
        if (o instanceof StorageDeviceNode) {
            StorageDeviceNode comp2 = (StorageDeviceNode)o;
            String val1 = this.getAlias();
            String comp2Alias = comp2.getAlias();
            answer = comp2Alias == null ? -1 : val1.compareToIgnoreCase(comp2Alias);
        } else if (o instanceof SrTreeNode) {
            SrTreeNode node = (SrTreeNode)o;
            String nodeToString = node.toString();
            answer = nodeToString == null ? -1 : this.toString().compareToIgnoreCase(nodeToString);
        }
        return answer;
    }

    public String getTransportType() {
        return this.transportType;
    }

    public void setBlockSize(Integer blockSize) {
        this.blockSize = blockSize;
    }

    public void setTotalSpace(BigInteger totalSize) {
        this.totalSize = totalSize;
    }

    @Override
    public boolean isConfigured() {
        return false;
    }

    public PhysicalStorageOperStatusConstant getStorageOperStatus() {
        return this.m_diskOperStatus;
    }

    public void setStorageOperStatus(PhysicalStorageOperStatusConstant operStatus) {
        this.m_diskOperStatus = operStatus;
    }

    @Override
    public boolean isDevice() {
        return true;
    }

    @Override
    public String getProblemOnDeletion() {
        if ((this.isDisk() || this.isTape()) && !AlarmsManager.getInstance().isRemovableDisk(this)) {
            if (PhysicalStorageOperStatusConstant.PHYS_STOR_OPER_STAT_PROVISIONED.equals(this.getStorageOperStatus())) {
                return super.getProblemOnDeletion();
            }
            return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_CANNOT_BE_DELETED_ITS_A_DISK_OR_TAPE);
        }
        return super.getProblemOnDeletion();
    }

    @Override
    public String canBeUsedToCreateVolume() {
        String msg = super.canBeUsedToCreateVolume();
        if (msg != null) {
            return msg;
        }
        if (AlarmsManager.getInstance().isMissingInvalidOrConfiguredDisk(this)) {
            return this.getCanBeUsedToCreateVolumeMessage(this, " is missing/invalid/configured");
        }
        return null;
    }

    public SrEntityNameFormat getEntityNameFormat() {
        return this.entityNameFormat;
    }

    public void setEntityNameFormat(SrEntityNameFormat entityNameFormat) {
        this.entityNameFormat = entityNameFormat;
    }
}

