/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.storage;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.AliasObject;
import com.sanrad.nms.client.data.LUManager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceManager;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.SrStorageTableModel;
import com.sanrad.nms.client.data.storage.SrVolOperStorageTableColumns;
import com.sanrad.nms.client.data.storage.StorageDeviceNode;
import com.sanrad.nms.client.data.storage.StorageDeviceSpace;
import com.sanrad.nms.client.data.storage.StorageManager;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceManager;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.event.DirectAccessDeviceListener;
import com.sanrad.nms.client.event.SubDirectAccessDeviceEvent;
import com.sanrad.nms.client.event.SubDirectAccessDeviceListener;
import com.sanrad.nms.client.event.lu.LUListener;
import com.sanrad.nms.client.event.storage.StorageManagerListener;
import com.sanrad.nms.client.event.volume.VolumeEvent;
import com.sanrad.nms.client.event.volume.VolumeListener;
import com.sanrad.nms.client.event.volume.copy.CopyOperationEvent;
import com.sanrad.nms.client.event.volume.copy.CopyOperationListener;
import com.sanrad.nms.client.gui.storage.VolOperStorageTableHeader;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDevice;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class SrVolOperStorageTableModel
extends SrStorageTableModel
implements StorageManagerListener,
SubDirectAccessDeviceListener,
VolumeListener,
DirectAccessDeviceListener,
CopyOperationListener,
LUListener {
    private ClusterNode m_workingCluster;
    private static SrLogger theLogger = SrLogger.getLogger();

    private SrVolOperStorageTableModel() {
        super(new SrVolOperStorageTableColumns());
    }

    public SrVolOperStorageTableModel(ClusterNode workingCluster) {
        this();
        this.m_workingCluster = workingCluster;
        this.init();
    }

    private void init() {
        if (this.m_workingCluster == null) {
            return;
        }
        List<StorageDeviceNode> storages = StorageManager.getInstance().getStorages(this.m_workingCluster);
        for (StorageDeviceNode data : storages) {
            this.addStorageData(data);
            SubDirectAccessDeviceNode[] subDisks = null;
            if (data instanceof DirectAccessDeviceNode) {
                subDisks = StorageManager.getInstance().getSubdisksNodes(((DirectAccessDeviceNode)data).getSplits(), (DirectAccessDeviceNode)data);
            }
            if (subDisks == null) continue;
            for (int j = 0; j < subDisks.length; ++j) {
                this.addStorageData(subDisks[j]);
            }
        }
        this.fireTableRowsInserted(0, this.getLastRowIndex());
    }

    @Override
    public void addListeners() {
        VolumeManager.getInstance().addVolumeListener(this);
        StorageManager.getInstance().addStorageManagerListener(this);
        SubDirectAccessDeviceManager.getInstance().addSubDirectDeviceListener(this);
        DirectAccessDeviceManager.getInstance().addDirectAccessDeviceListener(this);
        LUManager.getInstance().addLUListener(this);
    }

    @Override
    public void removeListeners() {
        VolumeManager.getInstance().removeVolumeListener(this);
        StorageManager.getInstance().removeStorageManagerListener(this);
        SubDirectAccessDeviceManager.getInstance().removeSubDirectDeviceListener(this);
        DirectAccessDeviceManager.getInstance().removeDirectAccessDeviceListener(this);
        LUManager.getInstance().removeLUListener(this);
    }

    @Override
    public void addStorageData(StorageDeviceNode data) {
        Vector<Object> rowData = new Vector<Object>();
        AliasObject diskAlias = null;
        AliasObject subDisk = null;
        Object totalSpace = null;
        Object freeSpace = null;
        Object blockSize = data.getBlockSize();
        if (data instanceof SubDirectAccessDeviceNode) {
            DirectAccessDeviceNode parent = ((SubDirectAccessDeviceNode)data).getDirectAccessDeviceParent();
            diskAlias = new AliasObject(parent, parent);
            subDisk = new AliasObject(data, data);
            totalSpace = new StorageDeviceSpace(((DirectAccessDeviceNode)data).getTotalSpace());
            freeSpace = null;
        } else if (data instanceof DirectAccessDeviceNode) {
            totalSpace = new StorageDeviceSpace(((DirectAccessDeviceNode)data).getTotalSpace());
            diskAlias = new AliasObject(data, data);
            subDisk = null;
            freeSpace = new StorageDeviceSpace(((DirectAccessDeviceNode)data).getNonAllocatedSpace());
            ((StorageDeviceSpace)freeSpace).setPercentageOf((StorageDeviceSpace)totalSpace);
        } else {
            diskAlias = new AliasObject(data, data);
            subDisk = null;
            freeSpace = NO_DATA;
            totalSpace = NO_DATA;
            blockSize = NO_DATA;
        }
        rowData.addElement(diskAlias);
        rowData.addElement(subDisk);
        rowData.addElement(totalSpace);
        rowData.addElement(freeSpace);
        rowData.addElement(blockSize);
        if (diskAlias != null) {
            this.addRow(rowData.toArray());
        }
    }

    @Override
    public boolean isCellEditable(int nRow, int nCol) {
        int subdiskAliasCol = this.getColumnIndex(VolOperStorageTableHeader.SUBDISK_ALIAS.getColumnName());
        boolean isSubdiskRow = this.getValueAt(nRow, subdiskAliasCol) instanceof AliasObject;
        if (nCol == subdiskAliasCol) {
            return isSubdiskRow;
        }
        int diskAliasCol = this.getColumnIndex(VolOperStorageTableHeader.DISK_ALIAS.getColumnName());
        if (nCol == diskAliasCol) {
            return !isSubdiskRow;
        }
        return super.isCellEditable(nRow, nCol);
    }

    @Override
    public void volumeCreate(VolumeEvent e) {
        Vector children = e.getChildrenStubs();
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            this.updateRow((RemoteObject)iter.next());
        }
    }

    @Override
    public void subDirecetAccessDeviceCreated(SubDirectAccessDeviceEvent event) {
        ClusterNode cluster = event.getClusterNode();
        if (cluster.equals(this.m_workingCluster)) {
            this.addStorageData((DirectAccessDeviceNode)SystemRootNode.getInstance().getRefByStub(event.getStub()));
            this.fireStorageElementsInserted(0, this.getRowCount() - 1);
            super.subDirecetAccessDeviceCreated(event);
        }
    }

    @Override
    public void subDirecetAccessDeviceAliasChanged(SubDirectAccessDeviceEvent event) {
        SubDirectAccessDeviceNode subdiskNode = (SubDirectAccessDeviceNode)SystemRootNode.getInstance().getRefByStub(event.getStub());
        int size = this.getRowCount();
        int col = this.getColumnIndex(VolOperStorageTableHeader.SUBDISK_ALIAS.getColumnName());
        List<Object> rowData = null;
        for (int i = 0; i < size; ++i) {
            AliasObject aliasObj;
            rowData = this.getRow(i);
            Object obj = rowData.get(col);
            if (obj == null || !(aliasObj = (AliasObject)obj).getAdditionalValue().equals(subdiskNode)) continue;
            this.fireTableCellUpdated(i, col);
            return;
        }
    }

    @Override
    public void subDirectAccessDeviceExposed(SubDirectAccessDeviceEvent event) {
    }

    @Override
    public void subDirectAccessDeviceDeExposed(SubDirectAccessDeviceEvent event) {
    }

    @Override
    public void subDirecetAccessDeviceStatusChanged(SubDirectAccessDeviceEvent event) {
    }

    @Override
    public void subDirecetAccessDeviceInfoChanged(SubDirectAccessDeviceEvent event) {
    }

    @Override
    public void subDirecetAccessDeviceRemoved(SubDirectAccessDeviceEvent event) {
        int subdiskRow = this.getStorageRow(event.getStub());
        if (subdiskRow >= 0) {
            this.removeRow(subdiskRow);
            super.subDirecetAccessDeviceRemoved(event);
        }
    }

    private int getStorageRow(RemoteObject storage) {
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(storage);
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!node.equals(this.getDisk(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected void updateRow(RemoteObject diskStub) {
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(diskStub);
        if (node instanceof DirectAccessDeviceNode) {
            int nonAllCol = this.getColumnIndex(VolOperStorageTableHeader.NON_ALLOCATED_SPACE.getColumnName());
            int deviceCol = this.getColumnIndex(VolOperStorageTableHeader.DISK_ALIAS.getColumnName());
            int subDiskCol = this.getColumnIndex(VolOperStorageTableHeader.SUBDISK_ALIAS.getColumnName());
            this.updateRow(diskStub, nonAllCol, deviceCol, subDiskCol);
        }
    }

    @Override
    public int[] getSelectedSubdiskSizes(int row) {
        int[] sizes = null;
        try {
            int col = this.getColumnIndex(VolOperStorageTableHeader.DISK_ALIAS.getColumnName());
            AliasObject obj = (AliasObject)this.getValueAt(row, col);
            DirectAccessDevice device = (DirectAccessDevice)obj.getAdditionalValue();
            Vector subDevices = device.getSubDirectAccessDevices();
            int len = subDevices.size();
            if (len == 0) {
                return null;
            }
            sizes = new int[len];
            for (int i = 0; i < len; ++i) {
                SubDirectAccessDevice subDevice = (SubDirectAccessDevice)subDevices.get(i);
                sizes[i] = subDevice.getSize().intValue();
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
        }
        return sizes;
    }

    @Override
    public boolean hasVolumeOn(int row) {
        int col = this.getColumnIndex(VolOperStorageTableHeader.DISK_ALIAS.getColumnName());
        List<Object> rowData = this.getRow(row);
        AliasObject node = (AliasObject)rowData.get(col);
        DirectAccessDeviceNode deviceNode = (DirectAccessDeviceNode)node.getValue();
        TreeNode parent = deviceNode.getParent();
        if (parent instanceof VolumeNode) {
            return true;
        }
        return deviceNode.isExposed();
    }

    @Override
    public StorageDeviceNode getDisk(int row) {
        return (StorageDeviceNode)this.getAlias(row).getValue();
    }

    public AliasObject getAlias(int row) {
        int diskCol = this.getColumnIndex(VolOperStorageTableHeader.DISK_ALIAS.getColumnName());
        int subdiskCol = this.getColumnIndex(VolOperStorageTableHeader.SUBDISK_ALIAS.getColumnName());
        Object alias = this.getValueAt(row, subdiskCol);
        if (alias == null || !(alias instanceof AliasObject)) {
            alias = (AliasObject)this.getValueAt(row, diskCol);
        }
        return (AliasObject)alias;
    }

    @Override
    public void volumeStateChanged(VolumeEvent e) {
    }

    @Override
    public void volumeParametersChanged(VolumeEvent e) {
    }

    @Override
    public void snapshotSourceChanged(VolumeEvent e) {
    }

    @Override
    public void volumeCapacityChanged(VolumeEvent e) {
    }

    @Override
    public void addVolumeNodeToParent(VolumeEvent event, VolumeTreeNode parentNode, VolumeTreeNode childNode) {
    }

    @Override
    public void removeVolumeNodeFromParent(VolumeEvent event, VolumeTreeNode childNode) {
    }

    @Override
    public void snapshotVolActiveStateChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolActivateOnVSwitchChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolActivityStateChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolDateAndTimeChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolPercentageThresholdChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolPercentageUtilizationChanged(VolumeEvent event) {
    }

    @Override
    public int compare(Object o1, Object o2) {
        Object col2;
        Object col1;
        block17: {
            Object obj2;
            block16: {
                boolean isTableSortByBlockSize;
                if (o1 == null && this.m_sortOrder == 0) {
                    return this.order(-1);
                }
                if (o2 == null) {
                    return this.order(1);
                }
                List vect1 = (List)o1;
                List vect2 = (List)o2;
                Object obj1 = vect1.get(this.m_sortColumn);
                obj2 = vect2.get(this.m_sortColumn);
                boolean isTableSortByTotalSpace = this.m_sortColumn == VolOperStorageTableHeader.getIndexOfColumnName(VolOperStorageTableHeader.TOTAL_SPACE);
                boolean isTableSortByNonAllocatedSpace = this.m_sortColumn == VolOperStorageTableHeader.getIndexOfColumnName(VolOperStorageTableHeader.NON_ALLOCATED_SPACE);
                boolean bl = isTableSortByBlockSize = this.m_sortColumn == VolOperStorageTableHeader.getIndexOfColumnName(VolOperStorageTableHeader.BLOCK_SIZE);
                if (isTableSortByTotalSpace || isTableSortByNonAllocatedSpace) {
                    if (obj1 != null && obj1 instanceof String) {
                        obj1 = new StorageDeviceSpace(BigInteger.valueOf(-1L));
                    }
                    if (obj2 != null && obj2 instanceof String) {
                        obj2 = new StorageDeviceSpace(BigInteger.valueOf(-1L));
                    }
                } else if (isTableSortByBlockSize) {
                    if (obj1 != null && obj1 instanceof String) {
                        obj1 = new Integer(Integer.MIN_VALUE);
                    }
                    if (obj2 != null && obj2 instanceof String) {
                        obj2 = new Integer(Integer.MIN_VALUE);
                    }
                }
                col1 = null;
                try {
                    col1 = (Comparable)obj1;
                }
                catch (ClassCastException cce) {
                    if (obj1 == null) break block16;
                    col1 = obj1.toString();
                }
            }
            col2 = null;
            try {
                col2 = (Comparable)obj2;
            }
            catch (ClassCastException cce) {
                if (obj2 == null) break block17;
                col2 = obj2.toString();
            }
        }
        if (col1 == null) {
            return this.order(-1);
        }
        if (col2 == null) {
            return this.order(1);
        }
        int result = this.order(col1.compareTo(col2));
        if (result == 0 && this.m_sortColVec.size() > this.m_runningIndex + 1) {
            ++this.m_runningIndex;
            int saveSortCol = this.m_sortColumn;
            int saveSortOrder = this.m_sortOrder;
            this.m_sortColumn = ((int[])this.m_sortColVec.get(this.m_runningIndex))[0];
            this.m_sortOrder = ((int[])this.m_sortColVec.get(this.m_runningIndex))[1];
            result = this.compare(o1, o2);
            this.m_sortColumn = saveSortCol;
            this.m_sortOrder = saveSortOrder;
            --this.m_runningIndex;
        }
        return result;
    }

    @Override
    public void copyOperationCreate(CopyOperationEvent aE) {
        this.fireAllRowsUpdated();
    }

    @Override
    public void copyOperationRemove(CopyOperationEvent aE) {
        this.fireAllRowsUpdated();
    }

    @Override
    public void copyOperationChange(CopyOperationEvent aE) {
        this.fireAllRowsUpdated();
    }

    @Override
    public void getAllCopyOperations(CopyOperationEvent aE) {
        this.fireAllRowsUpdated();
    }
}

