/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.storage;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.AliasObject;
import com.sanrad.nms.client.data.EntityName;
import com.sanrad.nms.client.data.Manager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.raid.RaidNode;
import com.sanrad.nms.client.data.raid.RaidSystem;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.SrStorageTableColumns;
import com.sanrad.nms.client.data.storage.SrVolOperStorageTableColumns;
import com.sanrad.nms.client.data.storage.StorageDeviceNode;
import com.sanrad.nms.client.data.storage.StorageDeviceSpace;
import com.sanrad.nms.client.data.storage.StorageManager;
import com.sanrad.nms.client.data.storage.StorageTableModelCollection;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceNode;
import com.sanrad.nms.client.data.volume.VolumeNode;
import com.sanrad.nms.client.event.DirectAccessDeviceEvent;
import com.sanrad.nms.client.event.SubDirectAccessDeviceEvent;
import com.sanrad.nms.client.event.lu.LUEvent;
import com.sanrad.nms.client.event.storage.StorageManagerEvent;
import com.sanrad.nms.client.event.storage.StorageTableModelEvent;
import com.sanrad.nms.client.event.storage.StorageTableModelListener;
import com.sanrad.nms.client.event.volume.VolumeEvent;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.storage.StorageTableHeader;
import com.sanrad.nms.client.gui.storage.VolOperStorageTableHeader;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDevice;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDevice;
import com.sanrad.swing.SrKeyObjectSelectionTableModel;
import com.sanrad.swing.SrTableColumns;
import com.sanrad.swing.table.KeyObject;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.Util;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class SrStorageTableModel
extends SrKeyObjectSelectionTableModel {
    protected static String NO_DATA = "-----";
    private static final String notAvailableValue = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_DIALOG_NOT_AVAILABLE_VALUE);
    private static SrLogger theLogger = SrLogger.getLogger();
    private SrTreeNode mySelectedNode = null;
    SrEventListenerManager.Informer<StorageTableModelListener, StorageTableModelEvent> storageElementsInsertedInformer = new SrEventListenerManager.Informer<StorageTableModelListener, StorageTableModelEvent>(){

        @Override
        public void inform(StorageTableModelListener listener, StorageTableModelEvent event) {
            listener.storageElementsInserted(event);
        }
    };
    SrEventListenerManager.Informer<StorageTableModelListener, StorageTableModelEvent> storageElementsBlinkingStateChangedInformer = new SrEventListenerManager.Informer<StorageTableModelListener, StorageTableModelEvent>(){

        @Override
        public void inform(StorageTableModelListener listener, StorageTableModelEvent event) {
            listener.storageElementsBlinkingStateChanged(event);
        }
    };

    public SrStorageTableModel(SrTableColumns cols) {
        super(cols);
    }

    public void addStorageTableModelListener(StorageTableModelListener l) {
        this.m_listeners.add(l);
    }

    public void removeStorageTableModelListener(StorageTableModelListener l) {
        this.m_listeners.remove(l);
    }

    public void addStorageData(StorageDeviceNode node) {
        this.addRow(this.buildStorageRowData(node));
    }

    private Object[] buildStorageRowData(StorageDeviceNode node) {
        Object[] row = new Object[StorageTableHeader.getColumnNames().size()];
        row[this.getColumnIndex((String)StorageTableHeader.DISK_ALIAS.getColumnName())] = new AliasObject(node, node);
        row[this.getColumnIndex((String)StorageTableHeader.ENTITY_NAME.getColumnName())] = new KeyObject(new EntityName(node.getEntityName()));
        row[this.getColumnIndex((String)StorageTableHeader.REMOTE_LU.getColumnName())] = new KeyObject(node.getRemoteLU());
        if (node instanceof DirectAccessDeviceNode) {
            String driveTypeStr = ((DirectAccessDeviceNode)node).getDriveAsString();
            row[this.getColumnIndex((String)StorageTableHeader.TYPE.getColumnName())] = driveTypeStr;
            StorageDeviceSpace totalSpace = new StorageDeviceSpace(((DirectAccessDeviceNode)node).getTotalSpace());
            row[this.getColumnIndex((String)StorageTableHeader.TOTAL_SPACE.getColumnName())] = totalSpace;
            if (!node.isConfigured()) {
                StorageDeviceSpace nonAllocatedSpace = new StorageDeviceSpace(((DirectAccessDeviceNode)node).getNonAllocatedSpace());
                nonAllocatedSpace.setPercentageOf(totalSpace);
                row[this.getColumnIndex((String)StorageTableHeader.NON_ALLOCATED_SPACE.getColumnName())] = nonAllocatedSpace;
            } else {
                row[this.getColumnIndex((String)StorageTableHeader.NON_ALLOCATED_SPACE.getColumnName())] = notAvailableValue;
            }
            row[this.getColumnIndex((String)StorageTableHeader.BLOCK_SIZE.getColumnName())] = node.getBlockSize();
        } else {
            row[this.getColumnIndex((String)StorageTableHeader.TOTAL_SPACE.getColumnName())] = NO_DATA;
            row[this.getColumnIndex((String)StorageTableHeader.NON_ALLOCATED_SPACE.getColumnName())] = NO_DATA;
            row[this.getColumnIndex((String)StorageTableHeader.BLOCK_SIZE.getColumnName())] = NO_DATA;
        }
        return row;
    }

    private Object[] buildStorageOperationRowData(DirectAccessDeviceNode node) {
        Object[] row = new Object[VolOperStorageTableHeader.getColumnNames().size()];
        row[this.getColumnIndex((String)VolOperStorageTableHeader.DISK_ALIAS.getColumnName())] = new AliasObject(node, node);
        row[this.getColumnIndex((String)VolOperStorageTableHeader.SUBDISK_ALIAS.getColumnName())] = null;
        StorageDeviceSpace totalSpace = new StorageDeviceSpace(node.getTotalSpace());
        row[this.getColumnIndex((String)VolOperStorageTableHeader.TOTAL_SPACE.getColumnName())] = totalSpace;
        if (!node.isConfigured()) {
            StorageDeviceSpace nonAllocatedSpace = new StorageDeviceSpace(node.getNonAllocatedSpace());
            nonAllocatedSpace.setPercentageOf(totalSpace);
            row[this.getColumnIndex((String)VolOperStorageTableHeader.NON_ALLOCATED_SPACE.getColumnName())] = nonAllocatedSpace;
        } else {
            row[this.getColumnIndex((String)VolOperStorageTableHeader.NON_ALLOCATED_SPACE.getColumnName())] = notAvailableValue;
        }
        row[this.getColumnIndex((String)VolOperStorageTableHeader.BLOCK_SIZE.getColumnName())] = node.getBlockSize();
        return row;
    }

    public Vector getSelectedSubdisks(int row) {
        try {
            int col = this.getColumnIndex(StorageTableHeader.DISK_ALIAS.getColumnName());
            AliasObject obj = (AliasObject)this.getValueAt(row, col);
            DirectAccessDevice device = (DirectAccessDevice)Manager.getStubByRef((DirectAccessDeviceNode)obj.getAdditionalValue());
            return device.getSubDirectAccessDevices();
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            return null;
        }
    }

    public int getNonAllocatedSpace() {
        return 0;
    }

    protected void fireStorageElementsInserted(int firstRow, int lastRow) {
        StorageTableModelEvent event = new StorageTableModelEvent(this, firstRow, lastRow);
        this.m_listeners.fireEvent(StorageTableModelListener.class, event, this.storageElementsInsertedInformer);
    }

    protected void fireStorageElementBlinkingStateChanged(StorageDeviceNode src) {
        StorageTableModelEvent event = new StorageTableModelEvent(src);
        this.m_listeners.fireEvent(StorageTableModelListener.class, event, this.storageElementsBlinkingStateChangedInformer);
    }

    public final void addStorageData(StorageManagerEvent e) {
        StorageDeviceNode[] data;
        if (this.mySelectedNode == null) {
            return;
        }
        for (StorageDeviceNode storageNode : data = (StorageDeviceNode[])e.getStorageData()) {
            this.addOrFilterStorageNode(storageNode);
        }
    }

    private void addOrFilterStorageNode(StorageDeviceNode aStorageNode) {
        if (this.acceptStorageNode(aStorageNode)) {
            this.addStorageData(aStorageNode);
        }
    }

    private boolean acceptStorageNode(StorageDeviceNode aStorageNode) {
        ClusterNode cluster;
        RaidSystem raidSys;
        return !(this.mySelectedNode instanceof RaidNode ? !(raidSys = ((RaidNode)this.mySelectedNode).getRaid()).getDisks().contains(aStorageNode) : (this.mySelectedNode != null ? !(cluster = (ClusterNode)this.mySelectedNode.getAncestorOfType(ClusterNode.class)).equals(StorageManager.getInstance().getClusterOfStorage(aStorageNode)) : this.mySelectedNode == null && this == StorageTableModelCollection.getModel()));
    }

    public void updateModelByStorageNode(SrTreeNode aNode) {
        if (Util.equalsWithNull(this.mySelectedNode, aNode)) {
            return;
        }
        this.mySelectedNode = aNode;
        this.removeAllRows();
        if (this.mySelectedNode == null) {
            return;
        }
        ClusterNode cluster = (ClusterNode)this.mySelectedNode.getAncestorOfType(ClusterNode.class);
        List<StorageDeviceNode> storages = StorageManager.getInstance().getStorages(cluster);
        for (StorageDeviceNode node : storages) {
            this.addOrFilterStorageNode(node);
        }
    }

    public ClusterNode getCluster() {
        if (this.mySelectedNode != null) {
            return (ClusterNode)this.mySelectedNode.getAncestorOfType(ClusterNode.class);
        }
        return null;
    }

    public void volumeCreate(VolumeEvent e) {
        Vector children = e.getChildrenStubs();
        Enumeration iter = children.elements();
        while (iter.hasMoreElements()) {
            this.updateRow((RemoteObject)iter.nextElement());
        }
    }

    public void volumeExposed(VolumeEvent e) {
        this.updateRow(e.getStub());
    }

    public void volumeDeExposed(VolumeEvent e) {
        this.updateRow(e.getStub());
    }

    public void volumeStatusChanged(VolumeEvent e) {
        this.fireAllRowsUpdated();
    }

    public void volumeRemove(VolumeEvent e) {
        this.fireAllRowsUpdated();
    }

    public void volumeAliasChanged(VolumeEvent e) {
    }

    public void volumeConfigChanged(VolumeEvent e) {
    }

    public void luRemoved(LUEvent event) {
        this.updateRow(event.getVolumeStub());
    }

    public void luStatusChanged(LUEvent event) {
        this.fireAllRowsUpdated();
    }

    public void luCreated(LUEvent event) {
        this.updateRow(event.getVolumeStub());
    }

    public void luChanged(LUEvent event) {
        this.fireAllRowsUpdated();
    }

    public void directAccessDeviceInfoChanged(DirectAccessDeviceEvent event) {
    }

    public void directAccessDeviceStatusChanged(DirectAccessDeviceEvent event) {
        this.fireAllRowsUpdated();
    }

    public void directAccessDeviceBlinkStateChange(DirectAccessDeviceEvent event) {
        StorageDeviceNode src = (StorageDeviceNode)SystemRootNode.getInstance().getRefByStub(event.getStub());
        this.fireStorageElementBlinkingStateChanged(src);
        this.fireAllRowsUpdated();
    }

    public void directAccessDeviceAliasChanged(DirectAccessDeviceEvent e) {
        int size = this.getRowCount();
        int col = this.getColumnIndex(StorageTableHeader.DISK_ALIAS.getColumnName());
        List<Object> rowData = null;
        for (int i = 0; i < size; ++i) {
            rowData = this.getRow(i);
            AliasObject aliasObj = (AliasObject)rowData.get(col);
            if (!aliasObj.getAdditionalValue().equals(SystemRootNode.getInstance().getRefByStub(e.getStub()))) continue;
            StorageDeviceNode node = (StorageDeviceNode)aliasObj.getValue();
            node.setAlias(e.getAlias());
            this.fireTableCellUpdated(i, col);
            return;
        }
    }

    public void directAccessDeviceChanged(DirectAccessDeviceEvent event) {
        int diskCol = this.getColumnIndex(StorageTableHeader.DISK_ALIAS.getColumnName());
        StorageDeviceNode storageNode = event.getStorageNode();
        boolean isStorageInTable = false;
        int i = this.getRowCount();
        while (i-- > 0) {
            AliasObject aliasObj = (AliasObject)this.getValueAt(i, diskCol);
            if (aliasObj == null) {
                theLogger.error(SrLogCategories.ILLEGAL_STATE, "The row :", this.getRow(i), ", contains null in column ", diskCol);
                continue;
            }
            if (!SystemRootNode.getInstance().getRefByStub(event.getStub()).equals(aliasObj.getAdditionalValue())) continue;
            isStorageInTable = true;
            if (!this.acceptStorageNode(storageNode)) {
                this.removeRow(i);
                return;
            }
            if (this.getTableColumnsObject() instanceof SrStorageTableColumns) {
                this.editRow(i, this.buildStorageRowData(storageNode));
                continue;
            }
            if (!(this.getTableColumnsObject() instanceof SrVolOperStorageTableColumns)) continue;
            this.editRow(i, this.buildStorageOperationRowData((DirectAccessDeviceNode)storageNode));
        }
        if (!isStorageInTable && this.acceptStorageNode(storageNode)) {
            this.addStorageData(storageNode);
        }
    }

    public void directAccessDeviceRemoved(DirectAccessDeviceEvent event) {
        int size = this.getRowCount();
        int col = this.getColumnIndex(StorageTableHeader.DISK_ALIAS.getColumnName());
        for (int i = 0; i < size; ++i) {
            List<Object> rowData = this.getRow(i);
            AliasObject aliasObj = (AliasObject)rowData.get(col);
            if (!aliasObj.getAdditionalValue().equals(SystemRootNode.getInstance().getRefByStub(event.getStub()))) continue;
            this.removeRow(i);
            break;
        }
    }

    public void directAccessDeviceCreated(DirectAccessDeviceEvent event) {
    }

    public void directAccessDeviceExposed(DirectAccessDeviceEvent event) {
    }

    public void directAccessDeviceDeExposed(DirectAccessDeviceEvent event) {
    }

    public void subDirecetAccessDeviceCreated(SubDirectAccessDeviceEvent event) {
        this.updateRow(event.getParentStub());
    }

    public void subDirecetAccessDeviceAliasChanged(SubDirectAccessDeviceEvent event) {
    }

    public void subDirectAccessDeviceExposed(SubDirectAccessDeviceEvent event) {
    }

    public void subDirectAccessDeviceDeExposed(SubDirectAccessDeviceEvent event) {
    }

    public void subDirecetAccessDeviceStatusChanged(SubDirectAccessDeviceEvent event) {
    }

    public void subDirecetAccessDeviceInfoChanged(SubDirectAccessDeviceEvent event) {
    }

    public void subDirecetAccessDeviceRemoved(SubDirectAccessDeviceEvent event) {
        this.updateRow(event.getParentStub());
    }

    protected void updateRow(RemoteObject diskStub) {
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(diskStub);
        if (node instanceof DirectAccessDeviceNode) {
            int nonAllCol = this.getColumnIndex(StorageTableHeader.NON_ALLOCATED_SPACE.toString());
            int deviceCol = this.getColumnIndex(StorageTableHeader.DISK_ALIAS.toString());
            this.updateRow(diskStub, nonAllCol, deviceCol, -1);
        }
    }

    protected final void updateRow(RemoteObject diskStub, int nonAllcatedColumn, int deviceColumn, int subDiscCol) {
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(diskStub);
        if (node instanceof DirectAccessDeviceNode) {
            DirectAccessDeviceNode diskNode = (DirectAccessDeviceNode)node;
            for (int i = 0; i < this.getRowCount(); ++i) {
                int deviceColumnForDebug = deviceColumn;
                List<Object> rowData = this.getRow(i);
                AliasObject diskAliasObj = (AliasObject)rowData.get(deviceColumn);
                boolean update = false;
                AliasObject subDiskAliasObj = null;
                if (subDiscCol == -1) {
                    update = true;
                } else {
                    deviceColumnForDebug = subDiscCol;
                    subDiskAliasObj = (AliasObject)rowData.get(subDiscCol);
                    if (subDiskAliasObj == null) {
                        update = true;
                    }
                }
                StorageDeviceNode storageNode = (StorageDeviceNode)SystemRootNode.getInstance().getRefByStub(diskStub);
                if (diskAliasObj == null) {
                    theLogger.error(SrLogCategories.ILLEGAL_STATE, "The row :", rowData, ", contains null in column ", deviceColumnForDebug);
                    continue;
                }
                if (!update || !diskAliasObj.getValue().equals(storageNode)) continue;
                StorageDeviceSpace totalSpace = new StorageDeviceSpace(diskNode.getTotalSpace());
                if (!diskNode.isConfigured()) {
                    StorageDeviceSpace nonAllocatedSpace = (StorageDeviceSpace)rowData.get(nonAllcatedColumn);
                    ((StorageDeviceSpace)rowData.get(nonAllcatedColumn)).setSize(diskNode.getNonAllocatedSpace());
                    nonAllocatedSpace.setPercentageOf(totalSpace);
                }
                this.fireTableRowsUpdated(i, i);
                return;
            }
        }
    }

    protected boolean isShownInGraphicsPanel(SubDirectAccessDeviceEvent event) {
        Integer[] selectedRows = this.getSelectedRowIndices();
        if (selectedRows == null || selectedRows.length == 0) {
            return false;
        }
        int row = selectedRows[0];
        if (row < 0) {
            return false;
        }
        int col = this.getColumnIndex(StorageTableHeader.DISK_ALIAS.toString());
        AliasObject obj = (AliasObject)this.getValueAt(row, col);
        DirectAccessDevice device = (DirectAccessDevice)Manager.getStubByRef((DirectAccessDeviceNode)obj.getAdditionalValue());
        return event.getParentStub().equals(device);
    }

    public boolean containsSubdisksWithVolumes(int row) {
        int col = this.getColumnIndex(StorageTableHeader.DISK_ALIAS.getColumnName());
        List<Object> rowData = this.getRow(row);
        AliasObject node = (AliasObject)rowData.get(col);
        DirectAccessDeviceNode deviceNode = (DirectAccessDeviceNode)node.getValue();
        List<RemoteObject> splits = deviceNode.getSplits();
        for (int i = 0; i < splits.size(); ++i) {
            SrTreeNode subdisk;
            RemoteObject obj = splits.get(i);
            if (!(obj instanceof SubDirectAccessDevice) || (subdisk = SystemRootNode.getInstance().getRefByStub(obj)) == null) continue;
            TreeNode parent = ((SubDirectAccessDeviceNode)subdisk).getParent();
            if (parent instanceof VolumeNode) {
                return true;
            }
            if (!((SubDirectAccessDeviceNode)subdisk).isExposed()) continue;
            return true;
        }
        return false;
    }

    public int[] getSelectedSubdiskSizes(int row) {
        int[] sizes = null;
        try {
            int col = this.getColumnIndex(StorageTableHeader.DISK_ALIAS.getColumnName());
            AliasObject obj = (AliasObject)this.getValueAt(row, col);
            DirectAccessDevice device = (DirectAccessDevice)Manager.getStubByRef((DirectAccessDeviceNode)obj.getAdditionalValue());
            Vector subDevices = device.getSubDirectAccessDevices();
            int len = subDevices.size();
            if (len == 0) {
                return null;
            }
            sizes = new int[len];
            for (int i = 0; i < len; ++i) {
                SubDirectAccessDevice subDevice = (SubDirectAccessDevice)subDevices.get(i);
                sizes[i] = subDevice.getSize().intValue();
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
        }
        return sizes;
    }

    public int[] getSelectedRows() {
        Integer[] selectedRows = this.getSelectedRowIndices();
        int[] sel = new int[selectedRows.length];
        for (int i = 0; i < selectedRows.length; ++i) {
            sel[i] = selectedRows[i];
        }
        return sel;
    }

    public List getDiskSplits(int row) {
        SrTreeNode node;
        int col = this.getColumnIndex(StorageTableHeader.DISK_ALIAS.getColumnName());
        AliasObject obj = (AliasObject)this.getValueAt(row, col);
        GeneralSCSIDevice device = (GeneralSCSIDevice)Manager.getStubByRef((StorageDeviceNode)obj.getAdditionalValue());
        if (device != null && (node = SystemRootNode.getInstance().getRefByStub(device)) != null && node instanceof DirectAccessDeviceNode) {
            return ((DirectAccessDeviceNode)node).getSplits();
        }
        return null;
    }

    public StorageDeviceNode getDisk(int row) {
        int col = this.getColumnIndex(StorageTableHeader.DISK_ALIAS.getColumnName());
        AliasObject obj = (AliasObject)this.getValueAt(row, col);
        StorageDeviceNode device = (StorageDeviceNode)obj.getValue();
        return device;
    }

    public List<DirectAccessDeviceNode<DirectAccessDevice>> getAllDisks() {
        ArrayList<DirectAccessDeviceNode<DirectAccessDevice>> disks = new ArrayList<DirectAccessDeviceNode<DirectAccessDevice>>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            StorageDeviceNode stor = this.getDisk(i);
            if (!stor.isDisk()) continue;
            disks.add((DirectAccessDeviceNode)stor);
        }
        return disks;
    }

    public boolean hasSubdisks(int row) {
        int col = this.getColumnIndex(StorageTableHeader.DISK_ALIAS.getColumnName());
        List<Object> rowData = this.getRow(row);
        AliasObject node = (AliasObject)rowData.get(col);
        DirectAccessDeviceNode deviceNode = (DirectAccessDeviceNode)node.getValue();
        List<RemoteObject> splits = deviceNode.getSplits();
        for (int i = 0; i < splits.size(); ++i) {
            if (!(splits.get(i) instanceof SubDirectAccessDevice)) continue;
            return true;
        }
        return false;
    }

    public boolean hasVolumeOn(int row) {
        int col = this.getColumnIndex(StorageTableHeader.DISK_ALIAS.getColumnName());
        List<Object> rowData = this.getRow(row);
        AliasObject node = (AliasObject)rowData.get(col);
        DirectAccessDeviceNode deviceNode = (DirectAccessDeviceNode)node.getValue();
        TreeNode parent = deviceNode.getParent();
        if (parent instanceof VolumeNode) {
            return true;
        }
        return deviceNode.isExposed();
    }

    public ArrayList getBlinkingStorageDevices() {
        int col = this.getColumnIndex(StorageTableHeader.DISK_ALIAS.getColumnName());
        List<Object> rowData = null;
        ArrayList<Integer> nodes = new ArrayList<Integer>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            rowData = this.getRow(i);
            AliasObject aliasObj = (AliasObject)rowData.get(col);
            StorageDeviceNode node = (StorageDeviceNode)aliasObj.getValue();
            if (!node.isBlinking()) continue;
            nodes.add(new Integer(i));
        }
        return nodes;
    }

    public int getStorageDeviceNodeRow(StorageDeviceNode src) {
        int col = this.getColumnIndex(StorageTableHeader.DISK_ALIAS.getColumnName());
        List<Object> rowData = null;
        for (int i = 0; i < this.getRowCount(); ++i) {
            rowData = this.getRow(i);
            AliasObject aliasObj = (AliasObject)rowData.get(col);
            StorageDeviceNode node = (StorageDeviceNode)aliasObj.getValue();
            if (src != node) continue;
            return i;
        }
        return -1;
    }

    public final void fireAllRowsUpdated() {
        this.fireTableRowsUpdated(0, this.getLastRowIndex());
    }

    @Override
    public int compare(Object o1, Object o2) {
        Object col2;
        Object col1;
        block17: {
            Object obj2;
            block16: {
                boolean isTableSortByBlockSize;
                if (o1 == null && this.m_sortOrder == 0) {
                    return this.order(-1);
                }
                if (o2 == null) {
                    return this.order(1);
                }
                List vect1 = (List)o1;
                List vect2 = (List)o2;
                Object obj1 = vect1.get(this.m_sortColumn);
                obj2 = vect2.get(this.m_sortColumn);
                boolean isTableSortByTotalSpace = this.m_sortColumn == StorageTableHeader.getIndexOfColumnName(StorageTableHeader.TOTAL_SPACE);
                boolean isTableSortByNonAllocatedSpace = this.m_sortColumn == StorageTableHeader.getIndexOfColumnName(StorageTableHeader.NON_ALLOCATED_SPACE);
                boolean bl = isTableSortByBlockSize = this.m_sortColumn == StorageTableHeader.getIndexOfColumnName(StorageTableHeader.BLOCK_SIZE);
                if (isTableSortByTotalSpace || isTableSortByNonAllocatedSpace) {
                    if (obj1 != null && obj1 instanceof String) {
                        obj1 = new StorageDeviceSpace(BigInteger.valueOf(-1L));
                    }
                    if (obj2 != null && obj2 instanceof String) {
                        obj2 = new StorageDeviceSpace(BigInteger.valueOf(-1L));
                    }
                } else if (isTableSortByBlockSize) {
                    if (obj1 != null && obj1 instanceof String) {
                        obj1 = new Integer(Integer.MIN_VALUE);
                    }
                    if (obj2 != null && obj2 instanceof String) {
                        obj2 = new Integer(Integer.MIN_VALUE);
                    }
                }
                col1 = null;
                try {
                    col1 = (Comparable)obj1;
                }
                catch (ClassCastException cce) {
                    if (obj1 == null) break block16;
                    col1 = obj1.toString();
                }
            }
            col2 = null;
            try {
                col2 = (Comparable)obj2;
            }
            catch (ClassCastException cce) {
                if (obj2 == null) break block17;
                col2 = obj2.toString();
            }
        }
        if (col1 == null) {
            return this.order(-1);
        }
        if (col2 == null) {
            return this.order(1);
        }
        int result = this.order(col1.compareTo(col2));
        if (result == 0 && this.m_sortColVec.size() > this.m_runningIndex + 1) {
            ++this.m_runningIndex;
            int saveSortCol = this.m_sortColumn;
            int saveSortOrder = this.m_sortOrder;
            this.m_sortColumn = ((int[])this.m_sortColVec.get(this.m_runningIndex))[0];
            this.m_sortOrder = ((int[])this.m_sortColVec.get(this.m_runningIndex))[1];
            result = this.compare(o1, o2);
            this.m_sortColumn = saveSortCol;
            this.m_sortOrder = saveSortOrder;
            --this.m_runningIndex;
        }
        return result;
    }

    @Override
    public void removeListeners() {
    }

    @Override
    public void addListeners() {
    }
}

